/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AcuteAngleFill
extends Job {
    private Cell cell;
    private List<NodeInst> addedPolygons;
    private static final Variable.Key ACUTE_FILL_KEY = Variable.newKey("NODE_ACUTE_FILL");

    public AcuteAngleFill(Cell cell) {
        super("Acute Angle Fill", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.cell = cell;
        this.addedPolygons = new ArrayList<NodeInst>();
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        ArrayList<NodeInst> killThese = new ArrayList<NodeInst>();
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar(ACUTE_FILL_KEY);
            if (var == null) continue;
            killThese.add(ni);
        }
        for (NodeInst ni : killThese) {
            ni.kill();
        }
        if (killThese.size() > 0) {
            System.out.println("Removing " + killThese.size() + " previous acute angle fill polygons");
        }
        ArrayList<ArcPair> acutePairs = new ArrayList<ArcPair>();
        Iterator<NodeInst> it2 = this.cell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = it2.next();
            if (!ni.getFunction().isPin()) continue;
            boolean allManhattan = true;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                if (con.getArc().getAngle() % 900 == 0) continue;
                allManhattan = false;
            }
            if (allManhattan) continue;
            ArrayList<ArcInst> arcsOnNode = new ArrayList<ArcInst>();
            Iterator<Connection> cIt2 = ni.getConnections();
            while (cIt2.hasNext()) {
                Connection con = cIt2.next();
                arcsOnNode.add(con.getArc());
            }
            for (ArcInst ai : arcsOnNode) {
                if (ai.getAngle() % 900 == 0) continue;
                for (ArcInst aiOther : arcsOnNode) {
                    int angle2;
                    if (ai == aiOther || ai.getProto() != aiOther.getProto()) continue;
                    EPoint e1 = null;
                    EPoint e2 = null;
                    if (ai.getHeadLocation().equals(ni.getAnchorCenter())) {
                        e1 = ai.getTailLocation();
                    } else if (ai.getTailLocation().equals(ni.getAnchorCenter())) {
                        e1 = ai.getHeadLocation();
                    }
                    if (aiOther.getHeadLocation().equals(ni.getAnchorCenter())) {
                        e2 = aiOther.getTailLocation();
                    } else if (aiOther.getTailLocation().equals(ni.getAnchorCenter())) {
                        e2 = aiOther.getHeadLocation();
                    }
                    if (e1 == null || e2 == null) {
                        System.out.println("WARNING: Arcs " + ai.describe(false) + " and " + aiOther.describe(false) + " do not meet at the pin center (" + ni.getAnchorCenterX() + "," + ni.getAnchorCenterY() + ")");
                        continue;
                    }
                    int angle1 = GenMath.figureAngle(ni.getAnchorCenter(), e1);
                    int angleDiff = Math.abs(angle1 - (angle2 = GenMath.figureAngle(ni.getAnchorCenter(), e2)));
                    if ((angleDiff <= 0 || angleDiff >= 900) && (angleDiff <= 2700 || angleDiff >= 3600)) continue;
                    ArcPair apNew = new ArcPair(ai, aiOther, ni);
                    for (ArcPair ap : acutePairs) {
                        if (!ap.equals(apNew)) continue;
                        apNew = null;
                        break;
                    }
                    if (apNew == null) continue;
                    acutePairs.add(apNew);
                }
            }
        }
        for (ArcPair ap : acutePairs) {
            double distB;
            int centerAngle;
            int angle2;
            NodeInst ni = ap.getNode();
            EPoint ctr = ni.getAnchorCenter();
            EPoint e1 = ap.getArc1().getHeadPortInst().getNodeInst() == ni ? ap.getArc1().getTailLocation() : ap.getArc1().getHeadLocation();
            EPoint e2 = ap.getArc2().getHeadPortInst().getNodeInst() == ni ? ap.getArc2().getTailLocation() : ap.getArc2().getHeadLocation();
            int angle1 = GenMath.figureAngle(ctr, e1);
            int angleDiff = Math.abs(angle1 - (angle2 = GenMath.figureAngle(ctr, e2)));
            if (angleDiff > 2700 && angleDiff < 3600) {
                angleDiff = 3600 - angleDiff;
            }
            if (Math.abs((centerAngle = (angle1 + angle2) / 2 % 3600) - angle1) >= 900 && Math.abs(centerAngle - angle2) >= 900) {
                centerAngle = (centerAngle + 1800) % 3600;
            }
            double a2 = (double)angleDiff / 1800.0 * Math.PI;
            double distanceOut = ap.getArc1().getLambdaBaseWidth() / Math.sin(a2 / 2.0);
            double centerDistance = distanceOut * 40.0;
            double optimalPointX = ctr.getX() + centerDistance * GenMath.cos(centerAngle);
            double optimalPointY = ctr.getY() + centerDistance * GenMath.sin(centerAngle);
            Point2D.Double optimal = new Point2D.Double(optimalPointX, optimalPointY);
            double halfWidth1 = ap.getArc1().getLambdaBaseWidth() / 2.0;
            double halfWidth2 = ap.getArc2().getLambdaBaseWidth() / 2.0;
            int rightAngle1 = (angle1 + 900) % 3600;
            int leftAngle1 = (angle1 + 2700) % 3600;
            int rightAngle2 = (angle2 + 900) % 3600;
            int leftAngle2 = (angle2 + 2700) % 3600;
            double right1X = ctr.getX() + halfWidth1 * GenMath.cos(rightAngle1);
            double right1Y = ctr.getY() + halfWidth1 * GenMath.sin(rightAngle1);
            Point2D.Double right1 = new Point2D.Double(right1X, right1Y);
            double left1X = ctr.getX() + halfWidth1 * GenMath.cos(leftAngle1);
            double left1Y = ctr.getY() + halfWidth1 * GenMath.sin(leftAngle1);
            Point2D.Double left1 = new Point2D.Double(left1X, left1Y);
            double right2X = ctr.getX() + halfWidth2 * GenMath.cos(rightAngle2);
            double right2Y = ctr.getY() + halfWidth2 * GenMath.sin(rightAngle2);
            Point2D.Double right2 = new Point2D.Double(right2X, right2Y);
            double left2X = ctr.getX() + halfWidth2 * GenMath.cos(leftAngle2);
            double left2Y = ctr.getY() + halfWidth2 * GenMath.sin(leftAngle2);
            Point2D.Double left2 = new Point2D.Double(left2X, left2Y);
            Point2D interA = GenMath.intersect(right1, angle1, left2, angle2);
            Point2D interB = GenMath.intersect(right2, angle2, left1, angle1);
            double distA = interA.distance(optimal);
            Point2D acuteVertex = distA < (distB = interB.distance(optimal)) ? interA : interB;
            double vert1X = acuteVertex.getX() + distanceOut * GenMath.cos(angle1);
            double vert1Y = acuteVertex.getY() + distanceOut * GenMath.sin(angle1);
            Point2D.Double vert1 = new Point2D.Double(vert1X, vert1Y);
            double vert2X = acuteVertex.getX() + distanceOut * GenMath.cos(angle2);
            double vert2Y = acuteVertex.getY() + distanceOut * GenMath.sin(angle2);
            Point2D.Double vert2 = new Point2D.Double(vert2X, vert2Y);
            Point2D apex = GenMath.intersect(vert2, rightAngle1, vert1, rightAngle2);
            Layer arcLayer = ap.getArc1().getProto().getLayer(0);
            PrimitiveNode pnp = arcLayer.getPureLayerNode();
            EPoint[] points = new EPoint[]{EPoint.fromLambda(acuteVertex.getX(), acuteVertex.getY()), EPoint.fromLambda(((Point2D)vert1).getX(), ((Point2D)vert1).getY()), EPoint.fromLambda(apex.getX(), apex.getY()), EPoint.fromLambda(((Point2D)vert2).getX(), ((Point2D)vert2).getY())};
            double lX = points[0].getX();
            double hX = points[0].getX();
            double lY = points[0].getY();
            double hY = points[0].getY();
            for (int i2 = 1; i2 < 4; ++i2) {
                if (points[i2].getX() < lX) {
                    lX = points[i2].getX();
                }
                if (points[i2].getX() > hX) {
                    hX = points[i2].getX();
                }
                if (points[i2].getY() < lY) {
                    lY = points[i2].getY();
                }
                if (!(points[i2].getY() > hY)) continue;
                hY = points[i2].getY();
            }
            EPoint fillCenter = EPoint.fromLambda((lX + hX) / 2.0, (lY + hY) / 2.0);
            NodeInst fillNi = NodeInst.makeInstance(pnp, this.getEditingPreferences(), fillCenter, hX - lX, hY - lY, this.cell);
            fillNi.setTrace(points);
            fillNi.newVar(ACUTE_FILL_KEY, (Object)Boolean.TRUE, this.getEditingPreferences());
            this.addedPolygons.add(fillNi);
        }
        this.fieldVariableChanged("addedPolygons");
        return true;
    }

    @Override
    public void terminateOK() {
        if (this.addedPolygons.size() > 0) {
            System.out.println("Added " + this.addedPolygons.size() + " acute angle fill polygons");
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                for (NodeInst ni : this.addedPolygons) {
                    highlighter.addElectricObject(ni, this.cell);
                }
                highlighter.finished();
            }
        }
    }

    private static class ArcPair {
        private ArcInst ai1;
        private ArcInst ai2;
        private NodeInst ni;

        public ArcPair(ArcInst ai1, ArcInst ai2, NodeInst ni) {
            this.ai1 = ai1;
            this.ai2 = ai2;
            this.ni = ni;
        }

        public ArcInst getArc1() {
            return this.ai1;
        }

        public ArcInst getArc2() {
            return this.ai2;
        }

        public NodeInst getNode() {
            return this.ni;
        }

        public boolean equals(ArcPair other) {
            if (this.ai1 == other.ai1 && this.ai2 == other.ai2) {
                return true;
            }
            return this.ai1 == other.ai2 && this.ai2 == other.ai1;
        }
    }
}

