/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.api.minarea.ErrorLogger;
import com.sun.electric.api.minarea.LayoutCell;
import com.sun.electric.api.minarea.ManhattanOrientation;
import com.sun.electric.api.minarea.MinAreaChecker;
import com.sun.electric.api.minarea.launcher.DefaultLayoutCell;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.bool.VectorCache;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;

public class MinArea {
    public static void writeMinareaLay() {
        Cell topCell = Job.getUserInterface().needCurrentCell();
        String filePrefix = "";
        new ConvertCellToVectorCacheJob(topCell, filePrefix).startJob();
    }

    public static void checkMinareaLay() {
        Cell topCell = Job.getUserInterface().needCurrentCell();
        String jarPath = OpenFile.chooseInputFile(FileType.JAR, "Electric build", false, null, false, null);
        if (jarPath == null) {
            return;
        }
        new CheckMinAreaJob(jarPath, topCell).startJob();
    }

    public static void readMinareaLay() {
        String layoutFileName = OpenFile.chooseInputFile(null, ".lay file", null);
        Layer layer = Technology.getMocmosTechnology().findLayer("Metal-1");
        long scale = 4L;
        new ConvertVectorCacheToCellJob(layoutFileName, layer, scale).startJob();
    }

    private static class ConvertCellToVectorCacheJob
    extends Job {
        private Cell topCell;
        private int scale;
        private String filePrefix;
        private transient VectorCache vce;
        private long divisor;
        private int[] result = new int[4];
        private Map<Orientation, ManhattanOrientation> ors = new IdentityHashMap<Orientation, ManhattanOrientation>();

        protected ConvertCellToVectorCacheJob(Cell topCell, String filePrefix) {
            super("try vector cache", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.topCell = topCell;
            this.filePrefix = filePrefix;
            this.initOrientations();
        }

        @Override
        public boolean doIt() {
            this.vce = new VectorCache(this.getDatabase().backup());
            CellId topCellId = this.topCell.getId();
            this.vce.scanLayers(topCellId);
            this.divisor = 0L;
            System.out.println(this.countInsts(topCellId, new IdentityHashMap<CellId, Long>()) + "  insts");
            for (Layer layer : this.vce.getLayers()) {
                System.out.print(layer.getFullName());
                if (this.vce.isBadLayer(layer)) {
                    System.out.println("  NONMANHATTAN  !");
                    continue;
                }
                System.out.println("  " + this.countLayer(this.topCell.getId(), layer, new IdentityHashMap<CellId, Long>()) + " rects");
            }
            this.scale = (int)this.divisor;
            HashMap<Layer, Object> msgs = new HashMap<Layer, Object>();
            for (Layer layer : this.vce.getLayers()) {
                if (this.vce.isBadLayer(layer)) continue;
                LayoutCell lTop = this.makeLayoutCell(this.topCell.getId(), layer, new IdentityHashMap<CellId, LayoutCell>());
                String fileName = this.filePrefix + layer.getName() + ".lay";
                try {
                    ObjectOutputStream os2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                    os2.writeObject(lTop);
                    os2.close();
                    msgs.put(layer, "Exported layer '" + layer.getName() + "' in filename '" + fileName);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    msgs.put(layer, e2.getMessage());
                }
            }
            System.out.println("Layers summary");
            for (Layer layer : this.vce.getLayers()) {
                System.out.print(layer.getFullName());
                if (this.vce.isBadLayer(layer)) {
                    System.out.println("  NONMANHATTAN  !");
                    continue;
                }
                System.out.println("  " + (String)msgs.get(layer));
            }
            System.out.println("divisor=" + this.divisor);
            return true;
        }

        private long countInsts(CellId cellId, Map<CellId, Long> counted) {
            Long cachedCount = counted.get(cellId);
            if (cachedCount != null) {
                return cachedCount;
            }
            long count = 1L;
            for (ImmutableNodeInst n2 : this.vce.getSubcells(cellId)) {
                count += this.countInsts((CellId)n2.protoId, counted);
                this.adjustDivisor(n2.anchor.getGridX());
                this.adjustDivisor(n2.anchor.getGridY());
            }
            counted.put(cellId, count);
            return count;
        }

        private long countLayer(CellId cellId, Layer layer, Map<CellId, Long> counted) {
            Long cachedCount = counted.get(cellId);
            if (cachedCount != null) {
                return cachedCount;
            }
            long count = this.vce.getNumBoxes(cellId, layer);
            int i2 = 0;
            while ((long)i2 < count) {
                this.vce.getBoxes(cellId, layer, i2, 1, this.result);
                this.adjustDivisor(this.result[0]);
                this.adjustDivisor(this.result[1]);
                this.adjustDivisor(this.result[2]);
                this.adjustDivisor(this.result[3]);
                ++i2;
            }
            for (ImmutableNodeInst n2 : this.vce.getSubcells(cellId)) {
                count += this.countLayer((CellId)n2.protoId, layer, counted);
            }
            counted.put(cellId, count);
            return count;
        }

        private LayoutCell makeLayoutCell(CellId eTop, Layer layer, Map<CellId, LayoutCell> made) {
            LayoutCell lc = made.get(eTop);
            if (lc != null) {
                return lc;
            }
            for (ImmutableNodeInst n2 : this.vce.getSubcells(eTop)) {
                if (!(n2.protoId instanceof CellId)) continue;
                this.makeLayoutCell((CellId)n2.protoId, layer, made);
            }
            DefaultLayoutCell lTop = new DefaultLayoutCell(eTop.toString());
            made.put(eTop, lTop);
            lTop.setName(eTop.toString());
            int count = this.vce.getNumBoxes(eTop, layer);
            for (int i2 = 0; i2 < count; ++i2) {
                this.vce.getBoxes(eTop, layer, i2, 1, this.result);
                lTop.addRectangle(this.result[0] / this.scale, this.result[1] / this.scale, this.result[2] / this.scale, this.result[3] / this.scale);
            }
            for (ImmutableNodeInst n3 : this.vce.getSubcells(eTop)) {
                CellId subCellId = (CellId)n3.protoId;
                LayoutCell subCell = made.get(subCellId);
                if (subCell.getNumRectangles() == 0 && subCell.getNumSubcells() == 0) continue;
                int anchorX = (int)n3.anchor.getGridX() / this.scale;
                int anchorY = (int)n3.anchor.getGridY() / this.scale;
                ManhattanOrientation mor = this.ors.get(n3.orient.canonic());
                assert (mor != null);
                lTop.addSubCell(subCell, anchorX, anchorY, mor);
            }
            return lTop;
        }

        private void adjustDivisor(long v) {
            if (v == 0L) {
                return;
            }
            if (v < 0L) {
                v = -v;
            }
            if (this.divisor == 0L) {
                this.divisor = v;
                return;
            }
            while (v % this.divisor != 0L) {
                long t = v % this.divisor;
                v = this.divisor;
                this.divisor = t;
            }
        }

        private void initOrientations() {
            this.putOrs(ManhattanOrientation.R0, Orientation.IDENT);
            this.putOrs(ManhattanOrientation.R90, Orientation.R);
            this.putOrs(ManhattanOrientation.R180, Orientation.RR);
            this.putOrs(ManhattanOrientation.R270, Orientation.RRR);
            this.putOrs(ManhattanOrientation.MY, Orientation.YRR);
            this.putOrs(ManhattanOrientation.MYR90, Orientation.YR);
            this.putOrs(ManhattanOrientation.MX, Orientation.Y);
            this.putOrs(ManhattanOrientation.MXR90, Orientation.YRRR);
        }

        private void putOrs(ManhattanOrientation mor, Orientation eor) {
            assert (eor.canonic() == eor);
            assert (mor.affineTransform().equals(eor.pureRotate()));
            this.ors.put(eor, mor);
        }
    }

    private static class CheckMinAreaJob
    extends Job {
        private String jarPath;
        private Cell topCell;
        private transient VectorCache vce;
        private int[] result = new int[4];
        private Map<Orientation, ManhattanOrientation> ors = new IdentityHashMap<Orientation, ManhattanOrientation>();

        protected CheckMinAreaJob(String jarPath, Cell topCell) {
            super("try vector cache", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.jarPath = jarPath;
            this.topCell = topCell;
            this.initOrientations();
        }

        @Override
        public boolean doIt() {
            URL url = TextUtils.makeURLToFile(this.jarPath);
            URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
            String[] knownImplementations = new String[]{"com.sun.electric.plugins.minarea.deltamerge0.SimpleChecker", "com.sun.electric.plugins.minarea.deltamerge1.SimpleChecker", "com.sun.electric.plugins.minarea.bitmapjava.BitMapMinAreaChecker", "com.sun.electric.plugins.minarea.bitmapscala.BitMapMinAreaChecker", "com.sun.electric.plugins.minarea.parallelbitmapscala.BitMapMinAreaChecker"};
            MinAreaChecker engine = null;
            for (String impl : knownImplementations) {
                try {
                    Class<?> cls = classLoader.loadClass(impl);
                    engine = (MinAreaChecker)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    classLoader.close();
                    break;
                }
                catch (ClassNotFoundException | NoSuchMethodException | InvocationTargetException cls) {
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (engine == null) {
                System.out.println("Engine not found");
                return false;
            }
            Properties parameters = engine.getDefaultParameters();
            System.out.println("Engine " + engine.getAlgorithmName() + " " + String.valueOf(parameters));
            this.vce = new VectorCache(this.getDatabase().backup());
            CellId topCellId = this.topCell.getId();
            this.vce.scanLayers(topCellId);
            MyErrorLogger errorLogger = new MyErrorLogger();
            for (Layer layer : this.vce.getLayers()) {
                if (this.vce.isBadLayer(layer)) {
                    System.out.println(String.valueOf(layer) + " is not manhattan. Skipped");
                    continue;
                }
                DRCTemplate minAreaRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.MINAREA);
                if (minAreaRule == null) continue;
                double minVal = minAreaRule.getValue(0);
                long minArea = DBMath.lambdaToGrid(minVal * 400.0);
                errorLogger.ruleName = minAreaRule.ruleName;
                LayoutCell lTop = this.makeLayoutCell(this.topCell.getId(), layer, new IdentityHashMap<CellId, LayoutCell>());
                engine.check(lTop, minArea, engine.getDefaultParameters(), errorLogger);
            }
            errorLogger.printReports();
            return true;
        }

        private LayoutCell makeLayoutCell(CellId eTop, Layer layer, Map<CellId, LayoutCell> made) {
            LayoutCell lc = made.get(eTop);
            if (lc != null) {
                return lc;
            }
            for (ImmutableNodeInst n2 : this.vce.getSubcells(eTop)) {
                if (!(n2.protoId instanceof CellId)) continue;
                this.makeLayoutCell((CellId)n2.protoId, layer, made);
            }
            DefaultLayoutCell lTop = new DefaultLayoutCell(eTop.toString());
            made.put(eTop, lTop);
            lTop.setName(eTop.toString());
            int count = this.vce.getNumBoxes(eTop, layer);
            for (int i2 = 0; i2 < count; ++i2) {
                this.vce.getBoxes(eTop, layer, i2, 1, this.result);
                lTop.addRectangle(this.result[0], this.result[1], this.result[2], this.result[3]);
            }
            for (ImmutableNodeInst n3 : this.vce.getSubcells(eTop)) {
                CellId subCellId = (CellId)n3.protoId;
                LayoutCell subCell = made.get(subCellId);
                if (subCell.getNumRectangles() == 0 && subCell.getNumSubcells() == 0) continue;
                int anchorX = (int)n3.anchor.getGridX();
                int anchorY = (int)n3.anchor.getGridY();
                ManhattanOrientation mor = this.ors.get(n3.orient.canonic());
                assert (mor != null);
                lTop.addSubCell(subCell, anchorX, anchorY, mor);
            }
            return lTop;
        }

        private void initOrientations() {
            this.putOrs(ManhattanOrientation.R0, Orientation.IDENT);
            this.putOrs(ManhattanOrientation.R90, Orientation.R);
            this.putOrs(ManhattanOrientation.R180, Orientation.RR);
            this.putOrs(ManhattanOrientation.R270, Orientation.RRR);
            this.putOrs(ManhattanOrientation.MY, Orientation.YRR);
            this.putOrs(ManhattanOrientation.MYR90, Orientation.YR);
            this.putOrs(ManhattanOrientation.MX, Orientation.Y);
            this.putOrs(ManhattanOrientation.MXR90, Orientation.YRRR);
        }

        private void putOrs(ManhattanOrientation mor, Orientation eor) {
            assert (eor.canonic() == eor);
            assert (mor.affineTransform().equals(eor.pureRotate()));
            this.ors.put(eor, mor);
        }

        private class MyErrorLogger
        implements ErrorLogger {
            private com.sun.electric.tool.user.ErrorLogger errorLogger = com.sun.electric.tool.user.ErrorLogger.newInst("minarea");
            private String ruleName;
            private int sortKey = 1;

            private MyErrorLogger() {
            }

            @Override
            public void reportMinAreaViolation(long area, int x, int y, Shape shape) {
                if (shape == null) {
                    this.errorLogger.logError(this.ruleName, EPoint.fromGrid(x, y), CheckMinAreaJob.this.topCell, this.sortKey);
                } else {
                    ArrayList<EPoint> lines = new ArrayList<EPoint>();
                    PathIterator pit = shape.getPathIterator(null);
                    double[] coords = new double[6];
                    EPoint move = null;
                    EPoint last = null;
                    while (!pit.isDone()) {
                        switch (pit.currentSegment(coords)) {
                            case 0: {
                                move = last = EPoint.fromGrid((long)coords[0], (long)coords[1]);
                                break;
                            }
                            case 1: {
                                lines.add(last);
                                last = EPoint.fromGrid((long)coords[0], (long)coords[1]);
                                lines.add(last);
                                break;
                            }
                            case 4: {
                                lines.add(last);
                                lines.add(move);
                                last = null;
                                move = null;
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        pit.next();
                    }
                    this.errorLogger.logMessageWithLines(this.ruleName, null, lines, CheckMinAreaJob.this.topCell, this.sortKey, true);
                }
            }

            public void printReports() {
                this.errorLogger.termLogging(true);
            }
        }
    }

    private static class ConvertVectorCacheToCellJob
    extends Job {
        private String layoutFileName;
        private PrimitiveNodeId protoId;
        private Technology tech;
        private long scale;
        private TextDescriptor nameDescriptor;
        private TextDescriptor protoDescriptor;
        private Map<ManhattanOrientation, Orientation> ors = new EnumMap<ManhattanOrientation, Orientation>(ManhattanOrientation.class);
        private Cell topElectricCell;

        protected ConvertVectorCacheToCellJob(String layoutFileName, Layer layer, long scale) {
            super("ConvertLayoutCell", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.layoutFileName = layoutFileName;
            this.protoId = layer.getPureLayerNode().getId();
            this.tech = layer.getTechnology();
            this.scale = scale;
            this.initOrientations();
        }

        @Override
        public boolean doIt() {
            EditingPreferences ep = this.getEditingPreferences();
            this.nameDescriptor = ep.getNodeTextDescriptor();
            this.protoDescriptor = ep.getInstanceTextDescriptor();
            try {
                if (this.layoutFileName == null) {
                    return false;
                }
                System.out.print("Reading .lay file '" + this.layoutFileName);
                FileInputStream is = new FileInputStream(this.layoutFileName);
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(is));
                LayoutCell topCell = (LayoutCell)in.readObject();
                in.close();
                HashMap<LayoutCell, Cell> allCells = new HashMap<LayoutCell, Cell>();
                this.convertLayoutCell(topCell, allCells);
                this.topElectricCell = allCells.get(topCell);
                this.fieldVariableChanged("topElectricCell");
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (ClassNotFoundException e3) {
                e3.printStackTrace();
            }
            return false;
        }

        @Override
        public void terminateOK() {
            Job.getUserInterface().displayCell(this.topElectricCell);
        }

        private void convertLayoutCell(LayoutCell topCell, final Map<LayoutCell, Cell> converted) {
            Library lib;
            Object cellName;
            String libName;
            if (converted.containsKey(topCell)) {
                return;
            }
            topCell.traverseSubcellInstances(new LayoutCell.SubcellHandler(){
                final /* synthetic */ ConvertVectorCacheToCellJob this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void apply(LayoutCell cell, int anchorX, int anchorY, ManhattanOrientation orient) {
                    this.this$0.convertLayoutCell(cell, converted);
                }
            });
            String name = topCell.getName();
            int indexOfColon = name.indexOf(58);
            if (indexOfColon >= 0) {
                libName = name.substring(0, indexOfColon);
                cellName = name.substring(indexOfColon + 1);
            } else {
                libName = "noname";
                cellName = name;
            }
            if (((String)cellName).indexOf(123) < 0 && ((String)cellName).indexOf(125) < 0) {
                cellName = (String)cellName + "{lay}";
            }
            if ((lib = Library.findLibrary(libName)) == null) {
                lib = Library.newInst(libName, null);
            }
            final Cell eCell = Cell.newInst(lib, (String)cellName);
            assert (eCell.getNumNodes() == 0);
            eCell.setTechnology(this.tech);
            converted.put(topCell, eCell);
            topCell.traverseRectangles(new LayoutCell.RectangleHandler(){
                final /* synthetic */ ConvertVectorCacheToCellJob this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void apply(int minX, int minY, int maxX, int maxY) {
                    long minXL = (long)minX * this.this$0.scale;
                    long minYL = (long)minY * this.this$0.scale;
                    long maxXL = (long)maxX * this.this$0.scale;
                    long maxYL = (long)maxY * this.this$0.scale;
                    long w = maxXL - minXL;
                    long h2 = maxYL - minYL;
                    EPoint anchor = EPoint.fromGrid((minXL + maxXL) / 2L, (minYL + maxYL) / 2L);
                    EPoint size = EPoint.fromGrid(w, h2);
                    int nodeId = eCell.getNumNodes();
                    Name name = Name.findName("r@" + nodeId);
                    ImmutableNodeInst n2 = ImmutableNodeInst.newInst(nodeId, this.this$0.protoId, name, this.this$0.nameDescriptor, Orientation.IDENT, anchor, size, 0, 0, this.this$0.protoDescriptor);
                    eCell.addNode(n2);
                }
            });
            topCell.traverseSubcellInstances(new LayoutCell.SubcellHandler(){
                final /* synthetic */ ConvertVectorCacheToCellJob this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void apply(LayoutCell cell, int anchorX, int anchorY, ManhattanOrientation orient) {
                    EPoint anchor = EPoint.fromGrid((long)anchorX * this.this$0.scale, (long)anchorY * this.this$0.scale);
                    int nodeId = eCell.getNumNodes();
                    Name name = Name.findName("s@" + nodeId);
                    CellId subCellId = ((Cell)converted.get(cell)).getId();
                    ImmutableNodeInst n2 = ImmutableNodeInst.newInst(nodeId, subCellId, name, this.this$0.nameDescriptor, this.this$0.ors.get((Object)orient), anchor, EPoint.ORIGIN, 0, 0, this.this$0.protoDescriptor);
                    eCell.addNode(n2);
                }
            });
        }

        private void initOrientations() {
            this.putOrs(ManhattanOrientation.R0, Orientation.IDENT);
            this.putOrs(ManhattanOrientation.R90, Orientation.R);
            this.putOrs(ManhattanOrientation.R180, Orientation.RR);
            this.putOrs(ManhattanOrientation.R270, Orientation.RRR);
            this.putOrs(ManhattanOrientation.MY, Orientation.YRR);
            this.putOrs(ManhattanOrientation.MYR90, Orientation.YR);
            this.putOrs(ManhattanOrientation.MX, Orientation.Y);
            this.putOrs(ManhattanOrientation.MXR90, Orientation.YRRR);
        }

        private void putOrs(ManhattanOrientation mor, Orientation eor) {
            assert (eor.canonic() == eor);
            assert (mor.affineTransform().equals(eor.pureRotate()));
            this.ors.put(mor, eor);
        }
    }
}

