/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.CVSLog;
import com.sun.electric.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Log {
    private HashMap<String, String> versionsToTags;
    private List<LogEntry> entries;
    private ElectricObject obj;
    private String headVersion;

    public static void showLog(Cell cell) {
        String cvsProgram = CVS.getCVSProgram();
        String repository = CVS.getRepository();
        if (!CVS.isDELIB(cell.getLibrary())) {
            System.out.println("Cannot show log file for non-DELIB library");
            return;
        }
        if (!CVS.isFileInCVS(CVS.getCellFile(cell))) {
            System.out.println("Cell " + cell.describe(false) + " is not in CVS");
            return;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell);
        String useDir = CVS.getUseDir(null, cells);
        StringBuffer cellsBuf = CVS.getCellFiles(cells, useDir);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CVS.runCVSCommand(cvsProgram, repository, "status " + String.valueOf(cellsBuf), "Show CVS Status", useDir, out);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        String workingVersion = Log.getWorkingRevision(reader);
        out = new ByteArrayOutputStream();
        CVS.runCVSCommand(cvsProgram, repository, "log " + String.valueOf(cellsBuf), "Show CVS Log", useDir, out);
        reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        System.out.println("Show CVS Log complete.");
        Log log = new Log(cell);
        log.parseLogOutput(reader);
        CVSLog dialog = new CVSLog(log.entries, "CVS Log for " + cell.libDescribe(), workingVersion);
        dialog.setVisible(true);
    }

    public static void showLog(Library lib) {
        StringBuffer libsBuf;
        if (!CVS.isFileInCVS(TextUtils.getFile(lib.getLibFile()))) {
            System.out.println("Library " + lib.getName() + " is not in CVS");
            return;
        }
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        String useDir = CVS.getUseDir(libs, null);
        String cvsProgram = CVS.getCVSProgram();
        String repository = CVS.getRepository();
        if (CVS.isDELIB(lib)) {
            libsBuf = new StringBuffer();
            File libFile = TextUtils.getFile(lib.getLibFile());
            if (libFile == null) {
                return;
            }
            String file = libFile.getPath();
            if (file.startsWith(useDir)) {
                file = file.substring(useDir.length() + 1, file.length());
            }
            libsBuf.append(file + File.separator + DELIB.getHeaderFile() + " ");
        } else {
            libsBuf = CVS.getLibraryFiles(libs, useDir);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CVS.runCVSCommand(cvsProgram, repository, "status " + String.valueOf(libsBuf), "Show CVS Status", useDir, out);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        String workingVersion = Log.getWorkingRevision(reader);
        out = new ByteArrayOutputStream();
        CVS.runCVSCommand(cvsProgram, repository, "log " + String.valueOf(libsBuf), "Show CVS Log", useDir, out);
        reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        System.out.println("Show CVS Log complete.");
        Log log = new Log(lib);
        log.parseLogOutput(reader);
        CVSLog dialog = new CVSLog(log.entries, "CVS Log for " + lib.getName(), workingVersion);
        dialog.setVisible(true);
    }

    public static void compareWithLocal(LogEntry entry) {
        StringBuffer args;
        String useDir;
        if (entry.obj instanceof Cell) {
            ArrayList<Cell> cells = new ArrayList<Cell>();
            cells.add((Cell)entry.obj);
            useDir = CVS.getUseDir(null, cells);
            args = CVS.getCellFiles(cells, useDir);
        } else if (entry.obj instanceof Library) {
            ArrayList<Library> libs = new ArrayList<Library>();
            libs.add((Library)entry.obj);
            useDir = CVS.getUseDir(libs, null);
            args = CVS.getLibraryFiles(libs, useDir);
        } else {
            System.out.println("Cannot compare Electric Object " + String.valueOf(entry.obj));
            return;
        }
        String version = entry.version;
        CVS.runCVSCommand(CVS.getCVSProgram(), CVS.getRepository(), "diff -r " + version + " " + String.valueOf(args), "Compare with Local", useDir, System.out);
        System.out.println("Compare with Local complete.");
    }

    public static void compare(LogEntry entry1, LogEntry entry2) {
        StringBuffer args;
        String useDir;
        if (entry1.obj instanceof Cell) {
            ArrayList<Cell> cells = new ArrayList<Cell>();
            cells.add((Cell)entry1.obj);
            useDir = CVS.getUseDir(null, cells);
            args = CVS.getCellFiles(cells, useDir);
        } else if (entry1.obj instanceof Library) {
            ArrayList<Library> libs = new ArrayList<Library>();
            libs.add((Library)entry1.obj);
            useDir = CVS.getUseDir(libs, null);
            args = CVS.getLibraryFiles(libs, useDir);
        } else {
            System.out.println("Cannot compare Electric Object " + String.valueOf(entry1.obj));
            return;
        }
        String version1 = entry1.version;
        String version2 = entry2.version;
        CVS.runCVSCommand(CVS.getCVSProgram(), CVS.getRepository(), "diff -r " + version1 + " -r " + version2 + " " + String.valueOf(args), "Compare Versions", useDir, System.out);
        System.out.println("Compare Versions complete.");
    }

    public static void getVersion(LogEntry entry) {
        new RevertToVersion(entry).startJob();
    }

    private Log(ElectricObject obj) {
        this.obj = obj;
        this.versionsToTags = new HashMap();
        this.entries = new ArrayList<LogEntry>();
        this.headVersion = "";
    }

    private void parseLogOutput(LineNumberReader reader) {
        try {
            this.parseLog(reader);
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
            return;
        }
    }

    private void parseLog(LineNumberReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            LogEntry entry;
            if (line.equals("")) continue;
            if (line.startsWith("head:")) {
                this.headVersion = line.substring(5).trim();
            }
            if (line.startsWith("symbolic names:")) {
                this.parseSymbolicNames(reader);
            }
            if (!line.startsWith("revision") || (entry = this.parseLogEntry(line, reader)) == null) continue;
            this.entries.add(entry);
        }
        return;
    }

    private void parseSymbolicNames(LineNumberReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.equals("")) continue;
            if (line.startsWith("keyword substitution")) {
                return;
            }
            String[] parts = line.trim().split(":\\s+");
            if (parts.length != 2) {
                System.out.println("Bad format for symbolic name: " + line);
                continue;
            }
            this.versionsToTags.put(parts[1], parts[0]);
        }
        return;
    }

    private LogEntry parseLogEntry(String line, LineNumberReader reader) throws IOException {
        String[] parts = line.trim().split("\\s+");
        if (parts.length != 2) {
            System.out.println("Bad revision line format: " + line);
            return null;
        }
        String version = parts[1];
        String tag = this.versionsToTags.get(version);
        if (tag == null) {
            tag = "";
        }
        if ((line = reader.readLine()) == null) {
            System.out.println("Unexpected end of file");
            return null;
        }
        parts = line.trim().split(";\\s+");
        String branch = "";
        String date = "";
        String author = "";
        String state = "";
        StringBuffer commitMessage = new StringBuffer();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            if (parts[i2].startsWith("date: ")) {
                date = parts[i2].substring(6);
                continue;
            }
            if (parts[i2].startsWith("author: ")) {
                author = parts[i2].substring(7).trim();
                continue;
            }
            if (!parts[i2].startsWith("state: ")) continue;
            state = parts[i2].substring(6).trim();
        }
        line = reader.readLine();
        while (!line.startsWith("-----------------------") && !line.startsWith("==========================")) {
            if (line.startsWith("branches: ")) {
                branch = line.substring(9).trim();
                line = reader.readLine();
                continue;
            }
            commitMessage.append(line + "\n");
            line = reader.readLine();
        }
        return new LogEntry(this.obj, version, branch, date, author, commitMessage.toString(), state, tag, this.headVersion);
    }

    private static String getWorkingRevision(LineNumberReader reader) {
        try {
            String[] parts;
            String line;
            do {
                if ((line = reader.readLine()) != null) continue;
                return "";
            } while (line.equals("") || !(line = line.trim()).startsWith("Working revision:") || (parts = line.trim().split("\t")).length < 2);
            return parts[1].trim();
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
            return "";
        }
    }

    public static class LogEntry
    implements Serializable {
        public final ElectricObject obj;
        public final String version;
        public final String branch;
        public final String date;
        public final String author;
        public final String commitMessage;
        public final String state;
        public final String tag;
        public final String headVersion;

        private LogEntry(ElectricObject obj, String version, String branch, String date, String author, String commitMessage, String state, String tag, String headVersion) {
            this.obj = obj;
            this.version = version;
            this.branch = branch;
            this.date = date;
            this.author = author;
            this.commitMessage = commitMessage;
            this.state = state;
            this.tag = tag;
            this.headVersion = headVersion;
        }

        public void print() {
            System.out.println(this.version + "\t" + this.branch + "\t" + this.date + "\t" + this.author + "\t" + this.commitMessage.replaceAll("\\n", " ") + this.state + "\t" + this.tag);
        }
    }

    public static class RevertToVersion
    extends Job {
        private LogEntry entry;
        private String cvsProgram = CVS.getCVSProgram();
        private String repository = CVS.getRepository();

        public RevertToVersion(LogEntry entry) {
            super("Revert to CVS Version", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.entry = entry;
        }

        @Override
        public boolean doIt() {
            StringBuffer args;
            String useDir;
            String version = this.entry.version;
            if (this.entry.obj instanceof Cell) {
                ArrayList<Cell> cells = new ArrayList<Cell>();
                cells.add((Cell)this.entry.obj);
                useDir = CVS.getUseDir(null, cells);
                args = CVS.getCellFiles(cells, useDir);
            } else if (this.entry.obj instanceof Library) {
                ArrayList<Library> libs = new ArrayList<Library>();
                libs.add((Library)this.entry.obj);
                useDir = CVS.getUseDir(libs, null);
                args = CVS.getLibraryFiles(libs, useDir);
            } else {
                System.out.println("Cannot compare Electric Object " + String.valueOf(this.entry.obj));
                return false;
            }
            File aFile = new File(useDir, args.toString().trim());
            File aFileBackup = new File(useDir, args.toString().trim() + "___version" + version);
            String aFilePath = aFile.getPath();
            if (!aFile.exists()) {
                System.out.println("Error: File does not exist: " + aFile.getPath());
                return false;
            }
            CVS.runCVSCommand(this.cvsProgram, this.repository, "update -r " + version + " " + String.valueOf(args), "Get Version", useDir, System.out);
            if (aFileBackup.exists() && !aFileBackup.delete()) {
                System.out.println("Error: Could not delete backup file: " + aFileBackup.getPath());
                return false;
            }
            if (!aFile.renameTo(aFileBackup)) {
                System.out.println("Error: Could not rename file " + aFile.getPath() + " to " + aFileBackup.getPath());
                return false;
            }
            CVS.runCVSCommand(this.cvsProgram, this.repository, "update -A " + String.valueOf(args), "Remove Sticky Tag", useDir, System.out);
            File oldCellFile = new File(aFilePath);
            if (!oldCellFile.delete()) {
                System.out.println("Error: Could not delete file: " + aFile.getPath());
                return false;
            }
            if (!aFileBackup.renameTo(new File(aFilePath))) {
                System.out.println("Error: Could not rename file " + aFileBackup.getPath() + " to " + aFilePath);
                return false;
            }
            if (this.entry.obj instanceof Cell) {
                LibraryFiles.reloadLibrary(this.getEditingPreferences(), ((Cell)this.entry.obj).getLibrary());
            } else if (this.entry.obj instanceof Library) {
                LibraryFiles.reloadLibrary(this.getEditingPreferences(), (Library)this.entry.obj);
            }
            System.out.println("Get Version complete.");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.entry.obj instanceof Cell) {
                Cell cell = (Cell)this.entry.obj;
                Library newLib = Library.findLibrary(cell.getLibrary().getName());
                if (newLib == null) {
                    return;
                }
                Cell newCell = newLib.findNodeProto(cell.noLibDescribe());
                if (newCell == null) {
                    return;
                }
                Log.showLog(newCell);
                CVS.fixStaleCellReferences(cell.getLibrary());
            } else if (this.entry.obj instanceof Library) {
                Library lib = (Library)this.entry.obj;
                Library newLib = Library.findLibrary(lib.getName());
                if (newLib == null) {
                    return;
                }
                Log.showLog(newLib);
                CVS.fixStaleCellReferences(lib);
            }
        }
    }
}

