/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.UserInterfaceInitial;
import com.sun.electric.tool.lang.EvalJavaBsh;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;

public class Regression {
    public static boolean runScript(Process process, String script) {
        Pref.forbidPreferences();
        IdReader reader = null;
        Snapshot currentSnapshot = IdManager.stdIdManager.getInitialSnapshot();
        System.out.println("Running " + script);
        try {
            InputStream inStream = process.getInputStream();
            OutputStream outStream = process.getOutputStream();
            InputStream errStream = process.getErrorStream();
            new ExecProcessReader(errStream).start();
            reader = new IdReader(new DataInputStream(new BufferedInputStream(inStream)), IdManager.stdIdManager);
            int protocolVersion = reader.readInt();
            if (protocolVersion != 20) {
                System.out.println("Client's protocol version 20 is incompatible with Server's protocol version " + protocolVersion);
                for (int i2 = 0; i2 < 100; ++i2) {
                    System.out.print((char)reader.readByte());
                }
                System.out.println();
                return false;
            }
            int connectionId = reader.readInt();
            System.out.format("%1$tT.%1$tL ", Calendar.getInstance());
            System.out.println("Connected id=" + connectionId);
            DataOutputStream clientOutputStream = new DataOutputStream(new BufferedOutputStream(outStream));
            Regression.writeServerJobs(clientOutputStream, connectionId, script);
            clientOutputStream.close();
            int curJobId = -1;
            Main.UserInterfaceDummy ui = new Main.UserInterfaceDummy();
            ui.patchConnectionId(connectionId);
            boolean passed = true;
            while (true) {
                byte tag = reader.readByte();
                long timeStamp = reader.readLong();
                if (tag == 1) {
                    currentSnapshot = Snapshot.readSnapshot(reader, currentSnapshot);
                    System.out.println("Snapshot received " + currentSnapshot.snapshotId);
                    continue;
                }
                Client.ServerEvent serverEvent = Client.read(reader, tag, timeStamp, ui, currentSnapshot);
                if (serverEvent instanceof Client.EJobEvent) {
                    Client.EJobEvent e2 = (Client.EJobEvent)serverEvent;
                    int jobId = e2.jobKey.jobId;
                    assert (e2.newState == EJob.State.SERVER_DONE);
                    if (jobId > 0) {
                        if (e2.doItOk) continue;
                        System.out.println("Job " + e2.jobName + " failed");
                        passed = false;
                        continue;
                    }
                    assert (jobId == curJobId);
                    if (!e2.doItOk) {
                        System.out.println("Job " + e2.jobName + " exception");
                        passed = false;
                    } else {
                        System.out.println("Job " + jobId + " ok");
                    }
                    switch (jobId) {
                        case -1: {
                            curJobId = -2;
                            break;
                        }
                        case -2: {
                            curJobId = -3;
                            break;
                        }
                    }
                    continue;
                }
                serverEvent.show(ui);
                if (serverEvent instanceof Client.ShutdownEvent) break;
            }
            assert (curJobId == -3);
            ui.saveMessages(null);
            return passed;
        }
        catch (IOException e3) {
            reader = null;
            System.out.println("END OF FILE reading from server");
            try {
                Thread.sleep(1000L);
                System.out.println("Server exit code=" + process.exitValue());
                process.getOutputStream().close();
            }
            catch (Exception e1) {
                e1.printStackTrace(System.out);
            }
            return false;
        }
    }

    private static void writeServerJobs(DataOutputStream clientOutputStream, int connectionId, String script) throws IOException {
        EDatabase database = new EDatabase(IdManager.stdIdManager.getInitialEnvironment());
        Job.setUserInterface(new UserInterfaceInitial(database));
        InitJob job1 = new InitJob();
        job1.ejob.jobKey = new Job.Key(connectionId, -1, true);
        Job job2 = EvalJavaBsh.runScriptJob(script);
        job2.ejob.jobKey = new Job.Key(connectionId, -2, true);
        QuitJob job3 = new QuitJob();
        job3.ejob.jobKey = new Job.Key(connectionId, -3, true);
        Regression.writeEditingPreferences(clientOutputStream, database);
        Regression.writeJob(clientOutputStream, job1);
        Regression.writeJob(clientOutputStream, job2);
        Regression.writeJob(clientOutputStream, job3);
    }

    private static void writeEditingPreferences(DataOutputStream clientOutputStream, EDatabase database) throws IOException {
        byte[] serializedEp;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            EditingPreferences ep = new EditingPreferences(true, database.getTechPool());
            out.writeObject(ep);
            out.flush();
            serializedEp = byteStream.toByteArray();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return;
        }
        clientOutputStream.writeByte(2);
        clientOutputStream.writeInt(serializedEp.length);
        clientOutputStream.write(serializedEp);
    }

    private static void writeJob(DataOutputStream clientOutputStream, Job job) throws IOException {
        EJob ejob = job.ejob;
        ejob.serialize(EDatabase.clientDatabase());
        clientOutputStream.writeByte(1);
        clientOutputStream.writeInt(ejob.jobKey.jobId);
        clientOutputStream.writeUTF(ejob.jobType.toString());
        clientOutputStream.writeUTF(ejob.jobName);
        clientOutputStream.writeInt(ejob.serializedJob.length);
        clientOutputStream.write(ejob.serializedJob);
        clientOutputStream.flush();
    }

    public static class ExecProcessReader
    extends Thread {
        private InputStream in;
        private char[] buf;

        public ExecProcessReader(InputStream in) {
            this.in = in;
            this.buf = new char[256];
            this.setName("ExecProcessReader");
        }

        @Override
        public void run() {
            try {
                InputStreamReader reader = new InputStreamReader(this.in);
                int read = 0;
                while ((read = reader.read(this.buf)) >= 0) {
                    String s = new String(this.buf, 0, read);
                    Calendar c2 = Calendar.getInstance();
                    System.err.print(s);
                    System.out.format("%1$tT.%1$tL <err> %2$s </err>\n", c2, s);
                }
                reader.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                e2.printStackTrace(System.out);
            }
        }
    }

    private static class InitJob
    extends Job {
        private InitJob() {
            super("InitJob", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        @Override
        public boolean doIt() throws JobException {
            this.database.setToolSettings((Setting.RootGroup)ToolSettings.getToolSettings(""));
            assert (this.database.getGeneric() == null);
            Generic generic = Generic.newInst(this.database.getIdManager());
            this.database.addTech(generic);
            for (TechFactory techFactory : TechFactory.getKnownTechs().values()) {
                Map<TechFactory.Param, Object> paramValues;
                Technology tech = techFactory.newInst(generic, paramValues = Collections.emptyMap());
                if (tech == null) continue;
                this.database.addTech(tech);
            }
            return true;
        }
    }

    private static class QuitJob
    extends Job {
        private QuitJob() {
            super("QuitJob", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        @Override
        public boolean doIt() throws JobException {
            Client.fireServerEvent(new Client.ShutdownEvent());
            return true;
        }
    }
}

