/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.util.ElapseTimer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class EJob {
    static final String WAITING_NOW = "waiting now";
    static final String ABORTING = "aborting";
    Client client;
    Job.Key jobKey;
    public final Job.Type jobType;
    public final String jobName;
    public Snapshot oldSnapshot;
    public Snapshot newSnapshot;
    EditingPreferences editingPreferences;
    String progress = null;
    byte[] serializedJob;
    public byte[] serializedResult;
    boolean doItOk;
    Job serverJob;
    public Job clientJob;
    State state;
    int savedHighlights = -1;
    ArrayList<Field> changedFields;

    public EJob(Client connection, int jobId, Job.Type jobType, String jobName, byte[] bytes) {
        this.client = connection;
        this.jobKey = new Job.Key(connection, jobId, jobType != Job.Type.CLIENT_EXAMINE);
        this.jobType = jobType;
        this.jobName = jobName;
        this.state = State.WAITING;
        this.serializedJob = bytes;
    }

    EJob(Job job, Job.Type jobType, String jobName, EditingPreferences editingPreferences) {
        this.jobType = jobType;
        this.jobName = jobName;
        this.state = State.CLIENT_WAITING;
        this.serverJob = this.clientJob = job;
        this.editingPreferences = editingPreferences;
    }

    public Job getJob() {
        return this.clientJob != null ? this.clientJob : this.serverJob;
    }

    private ClassLoader getClassLoader() {
        Job theJob = this.getJob();
        return (theJob == null ? EJob.class : theJob.getClass()).getClassLoader();
    }

    public Job.Inform getInform() {
        boolean isChange = this.jobType == Job.Type.CHANGE || this.jobType == Job.Type.UNDO;
        String toString = this.jobName + " (waiting)";
        int finished = -1;
        return new Job.Inform(this.jobKey, isChange, toString, ElapseTimer.createInstance(), finished);
    }

    public boolean isExamine() {
        return this.jobType.isExamine();
    }

    public boolean startedByServer() {
        return this.jobKey.startedByServer();
    }

    Throwable serialize(EDatabase database) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            out.writeObject(this.clientJob);
            out.flush();
            this.serializedJob = byteStream.toByteArray();
            return null;
        }
        catch (Throwable e2) {
            System.out.println("ERROR: Job '" + this.jobName + "' cannot serialize parameter: " + e2.getMessage());
            System.out.println("------------- Begin serialize() Exception stack trace --------------\n");
            e2.printStackTrace();
            System.out.println("------------- End serialize() Exception stack trace ----------------\n");
            return e2;
        }
    }

    public Throwable deserializeToServer() {
        try {
            final ClassLoader classLoader = this.getClassLoader();
            EDatabase database = EDatabase.serverDatabase();
            EObjectInputStream in = new EObjectInputStream(this, new ByteArrayInputStream(this.serializedJob), database){
                final /* synthetic */ EJob this$0;
                {
                    this.this$0 = this$0;
                    super(in, database);
                }

                public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return Class.forName(desc.getName(), false, classLoader);
                }
            };
            Job job = (Job)in.readObject();
            in.close();
            job.ejob = this;
            job.database = database;
            this.serverJob = job;
            return null;
        }
        catch (Throwable e2) {
            return e2;
        }
    }

    public Throwable deserializeToClient() {
        try {
            final ClassLoader classLoader = this.getClassLoader();
            EDatabase database = EDatabase.clientDatabase();
            EObjectInputStream in = new EObjectInputStream(this, new ByteArrayInputStream(this.serializedJob), database){
                final /* synthetic */ EJob this$0;
                {
                    this.this$0 = this$0;
                    super(in, database);
                }

                public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return Class.forName(desc.getName(), false, classLoader);
                }
            };
            Job job = (Job)in.readObject();
            in.close();
            job.ejob = this;
            job.database = database;
            this.clientJob = job;
            return null;
        }
        catch (Throwable e2) {
            return e2;
        }
    }

    void serializeResult(EDatabase database) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            this.doItOk = true;
            out.writeObject(null);
            out.writeInt(this.changedFields.size());
            Job job = this.jobType == Job.Type.CLIENT_EXAMINE ? this.clientJob : this.serverJob;
            for (Field f2 : this.changedFields) {
                String fieldName = f2.getName();
                Object value = f2.get(job);
                out.writeUTF(fieldName);
                try {
                    out.writeObject(value);
                }
                catch (NotSerializableException e2) {
                    System.out.println("ERROR: Job '" + this.jobName + "' cannot serialize returned field " + fieldName + " = " + String.valueOf(value) + " : " + e2.getMessage());
                    throw e2;
                }
            }
            out.close();
            this.serializedResult = byteStream.toByteArray();
        }
        catch (Throwable e3) {
            Job.logger.warn("serializeResult failure", e3);
            this.serializeExceptionResult(e3, database);
        }
    }

    void serializeExceptionResult(Throwable jobException, EDatabase database) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            jobException.getStackTrace();
            out.writeObject(jobException);
            out.writeInt(0);
            out.close();
            this.serializedResult = byteStream.toByteArray();
        }
        catch (Throwable e2) {
            Job.logger.warn("serializeExceptionResul failure", e2);
            this.serializedResult = new byte[0];
        }
    }

    public Throwable deserializeResult() {
        try {
            EObjectInputStream in = new EObjectInputStream(new ByteArrayInputStream(this.serializedResult), EDatabase.clientDatabase());
            Throwable jobException = (Throwable)in.readObject();
            int numFields = in.readInt();
            for (int i2 = 0; i2 < numFields; ++i2) {
                String fieldName = in.readUTF();
                Object value = in.readObject();
                Field f2 = this.findField(fieldName);
                f2.setAccessible(true);
                f2.set(this.clientJob, value);
            }
            in.close();
            return jobException;
        }
        catch (Throwable e2) {
            Job.logger.warn("deserializeResult failure", e2);
            return e2;
        }
    }

    protected void fieldVariableChanged(String fieldName) {
        Field fld = this.findField(fieldName);
        fld.setAccessible(true);
        this.changedFields.add(fld);
    }

    private Field findField(String fieldName) {
        for (Class<?> jobClass = this.getJob().getClass(); jobClass != Job.class; jobClass = jobClass.getSuperclass()) {
            try {
                return jobClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                continue;
            }
        }
        return null;
    }

    public static enum State {
        CLIENT_WAITING,
        WAITING,
        RUNNING,
        SERVER_DONE,
        CLIENT_DONE;

    }
}

