/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import java.awt.geom.Point2D;

public class Artwork
extends Technology {
    public static final Variable.Key ART_DEGREES = Variable.newKey("ART_degrees");
    public static final Variable.Key ART_MESSAGE = Variable.newKey("ART_message");
    public static final Variable.Key ART_COLOR = Variable.newKey("ART_color");
    public static final Variable.Key ART_PATTERN = Variable.newKey("ART_pattern");
    private static final int ELLIPSEPOINTS = 30;
    private static final int SPLINEGRAIN = 20;
    public final PrimitiveNode pinNode;
    public final PrimitiveNode boxNode;
    public final PrimitiveNode crossedBoxNode;
    public final PrimitiveNode filledBoxNode;
    public final PrimitiveNode circleNode;
    public final PrimitiveNode filledCircleNode;
    public final PrimitiveNode splineNode;
    public final PrimitiveNode triangleNode;
    public final PrimitiveNode filledTriangleNode;
    public final PrimitiveNode arrowNode;
    public final PrimitiveNode openedPolygonNode;
    public final PrimitiveNode openedDottedPolygonNode;
    public final PrimitiveNode openedDashedPolygonNode;
    public final PrimitiveNode openedThickerPolygonNode;
    public final PrimitiveNode closedPolygonNode;
    public final PrimitiveNode filledPolygonNode;
    public final PrimitiveNode thickCircleNode;
    public final ArcProto solidArc;
    public final ArcProto dottedArc;
    public final ArcProto dashedArc;
    public final ArcProto thickerArc;
    public final Layer defaultLayer;

    public static Artwork tech() {
        return TechPool.getThreadTechPool().getArtwork();
    }

    public Artwork(Generic generic, TechFactory techFactory) {
        super(generic, techFactory);
        this.setTechShortName("Artwork");
        this.setTechDesc("General-purpose artwork components");
        this.setFactoryScale(2000.0, false);
        this.setNonStandard();
        this.setNonElectrical();
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.defaultLayer = Layer.newInst(this, "Graphics", new EGraphics(false, false, null, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535}));
        this.defaultLayer.setFunction(Layer.Function.ART, 8192);
        this.defaultLayer.setFactoryDXFLayer("OBJECT");
        this.solidArc = new ArtworkArcProto("Solid", Poly.Type.FILLED);
        this.dottedArc = new ArtworkArcProto("Dotted", Poly.Type.OPENEDT1);
        this.dashedArc = new ArtworkArcProto("Dashed", Poly.Type.OPENEDT2);
        this.thickerArc = new ArtworkArcProto("Thicker", Poly.Type.OPENEDT3);
        Technology.TechPoint[] box_1 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.t(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.b(0.0))};
        Technology.TechPoint[] box_2 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(new EdgeH(-0.125, 0.0), EdgeV.t(0.0)), new Technology.TechPoint(new EdgeH(0.125, 0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))};
        Technology.TechPoint[] box_4 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.t(0.0))};
        Technology.TechPoint[] box_6 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.c(0.0))};
        this.pinNode = new ArtworkNode("Pin", 1.0, 1.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.DISC, 0, box_6));
        this.pinNode.addPrimitivePorts(new ArtworkPrimitivePort(this.pinNode, "site", 0, 180, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0)));
        this.pinNode.setFunction(PrimitiveNode.Function.PIN);
        this.pinNode.setArcsWipe();
        this.pinNode.setArcsShrink();
        this.boxNode = new ArtworkNode("Box", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CLOSED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))}));
        this.boxNode.addPrimitivePorts(new NodeShapedPort(this.boxNode, "box", 0, 180));
        this.boxNode.setFunction(PrimitiveNode.Function.ART);
        this.boxNode.setEdgeSelect();
        this.crossedBoxNode = new ArtworkNode("Crossed-Box", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CROSSED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))}));
        this.crossedBoxNode.addPrimitivePorts(new NodeShapedPort(this.crossedBoxNode, "fbox", 0, 180));
        this.crossedBoxNode.setFunction(PrimitiveNode.Function.ART);
        this.filledBoxNode = new ArtworkNode("Filled-Box", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))}));
        this.filledBoxNode.addPrimitivePorts(new NodeShapedPort(this.filledBoxNode, "fbox", 0, 180));
        this.filledBoxNode.setFunction(PrimitiveNode.Function.ART);
        this.filledBoxNode.setEdgeSelect();
        this.circleNode = new ArtworkNode("Circle", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CIRCLE, 0, box_6));
        this.circleNode.addPrimitivePorts(new ArtworkPrimitivePort(this.circleNode, "site", 0, 180, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0)));
        this.circleNode.setFunction(PrimitiveNode.Function.ART);
        this.circleNode.setEdgeSelect();
        this.circleNode.setPartialCircle();
        this.filledCircleNode = new ArtworkNode("Filled-Circle", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.DISC, 0, box_6));
        this.filledCircleNode.addPrimitivePorts(new ArtworkPrimitivePort(this.filledCircleNode, "site", 0, 180, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0)));
        this.filledCircleNode.setFunction(PrimitiveNode.Function.ART);
        this.filledCircleNode.setSquare();
        this.filledCircleNode.setEdgeSelect();
        this.splineNode = new ArtworkNode("Spline", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENED, 0, box_2));
        NodeShapedPort splinePort = new NodeShapedPort(this.splineNode, "site", 0, 180){

            @Override
            protected void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
                EPoint[] tracePoints = n2.getTrace();
                if (tracePoints != null) {
                    PolyBase.Point[] pointList;
                    for (PolyBase.Point p : pointList = Artwork.this.fillSpline(EPoint.ORIGIN, tracePoints)) {
                        b2.pushPoint(p.getFixpX(), p.getFixpY());
                    }
                    b2.pushPoly(Poly.Type.OPENED, null, null, null);
                    return;
                }
                super.genShape(b2, n2);
            }
        };
        this.splineNode.addPrimitivePorts(splinePort);
        this.splineNode.setFunction(PrimitiveNode.Function.ART);
        this.splineNode.setHoldsOutline();
        this.splineNode.setEdgeSelect();
        this.triangleNode = new ArtworkNode("Triangle", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CLOSED, 0, box_4));
        this.triangleNode.addPrimitivePorts(new NodeShapedPort(this.triangleNode, "triangle", 0, 180));
        this.triangleNode.setFunction(PrimitiveNode.Function.ART);
        this.triangleNode.setEdgeSelect();
        this.filledTriangleNode = new ArtworkNode("Filled-Triangle", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, box_4));
        this.filledTriangleNode.addPrimitivePorts(new NodeShapedPort(this.filledTriangleNode, "ftriangle", 0, 180));
        this.filledTriangleNode.setFunction(PrimitiveNode.Function.ART);
        this.filledTriangleNode.setEdgeSelect();
        this.arrowNode = new ArtworkNode("Arrow", 2.0, 2.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.t(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(0.0))}), new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(0.0))}));
        this.arrowNode.addPrimitivePorts(new ArtworkPrimitivePort(this.arrowNode, "arrow", 0, 180, EdgeH.r(0.0), EdgeV.c(0.0), EdgeH.r(0.0), EdgeV.c(0.0)));
        this.arrowNode.setFunction(PrimitiveNode.Function.ART);
        this.arrowNode.setEdgeSelect();
        this.openedPolygonNode = new ArtworkNode("Opened-Polygon", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENED, 0, box_2));
        this.openedPolygonNode.addPrimitivePorts(new NodeShapedPort(this.openedPolygonNode, "site", 0, 180));
        this.openedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedPolygonNode.setHoldsOutline();
        this.openedPolygonNode.setEdgeSelect();
        this.openedDottedPolygonNode = new ArtworkNode("Opened-Dotted-Polygon", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENEDT1, 0, box_2));
        this.openedDottedPolygonNode.addPrimitivePorts(new NodeShapedPort(this.openedDottedPolygonNode, "site", 0, 180));
        this.openedDottedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedDottedPolygonNode.setHoldsOutline();
        this.openedDottedPolygonNode.setEdgeSelect();
        this.openedDashedPolygonNode = new ArtworkNode("Opened-Dashed-Polygon", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENEDT2, 0, box_2));
        this.openedDashedPolygonNode.addPrimitivePorts(new NodeShapedPort(this.openedDashedPolygonNode, "site", 0, 180));
        this.openedDashedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedDashedPolygonNode.setHoldsOutline();
        this.openedDashedPolygonNode.setEdgeSelect();
        this.openedThickerPolygonNode = new ArtworkNode("Opened-Thicker-Polygon", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENEDT3, 0, box_2));
        this.openedThickerPolygonNode.addPrimitivePorts(new NodeShapedPort(this.openedThickerPolygonNode, "site", 0, 180));
        this.openedThickerPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedThickerPolygonNode.setHoldsOutline();
        this.openedThickerPolygonNode.setEdgeSelect();
        this.closedPolygonNode = new ArtworkNode("Closed-Polygon", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CLOSED, 0, box_1));
        this.closedPolygonNode.addPrimitivePorts(new NodeShapedPort(this.closedPolygonNode, "site", 0, 180));
        this.closedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.closedPolygonNode.setHoldsOutline();
        this.closedPolygonNode.setEdgeSelect();
        this.filledPolygonNode = new ArtworkNode("Filled-Polygon", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, box_1));
        this.filledPolygonNode.addPrimitivePorts(new NodeShapedPort(this.filledPolygonNode, "site", 0, 180));
        this.filledPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.filledPolygonNode.setHoldsOutline();
        this.filledPolygonNode.setEdgeSelect();
        this.thickCircleNode = new ArtworkNode("Thick-Circle", 6.0, 6.0, new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.THICKCIRCLE, 0, box_6));
        this.thickCircleNode.addPrimitivePorts(new ArtworkPrimitivePort(this.thickCircleNode, "site", 0, 180, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0)));
        this.thickCircleNode.setFunction(PrimitiveNode.Function.ART);
        this.thickCircleNode.setEdgeSelect();
        this.thickCircleNode.setPartialCircle();
        this.newFoundry(Foundry.Type.NONE, null, "Graphics 1");
        this.oldArcNames.put("Dash-1", this.dottedArc);
        this.oldArcNames.put("Dash-2", this.dashedArc);
        this.oldArcNames.put("Dash-3", this.thickerArc);
        this.oldNodeNames.put("Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Centered-Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Left-Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Right-Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Opened-FarDotted-Polygon", this.openedThickerPolygonNode);
        this.loadFactoryMenuPalette(Artwork.class.getResource("artworkMenu.xml"));
    }

    public static PolyBase.Point[] fillEllipse(Point2D center, double sX, double sY, double startoffset, double endangle) {
        boolean closed = true;
        if (startoffset == 0.0 && endangle == 0.0) {
            endangle = Math.PI * 2;
        } else {
            closed = false;
        }
        int pts = (int)(endangle * 30.0 / (Math.PI * 2));
        if (pts < 3) {
            pts = 3;
        }
        if (closed) {
            ++pts;
        }
        PolyBase.Point[] points = new PolyBase.Point[pts];
        double a2 = sX / 2.0;
        double b2 = sY / 2.0;
        if (closed) {
            double p = 0.21666156231653746;
            double c2 = Math.cos(p);
            double s2 = Math.sin(p);
            double c3 = 1.0;
            double s3 = 0.0;
            for (int m2 = 0; m2 < 30; ++m2) {
                points[m2] = Poly.fromLambda(center.getX() + a2 * c3, center.getY() + b2 * s3);
                double t1 = c3 * c2 - s3 * s2;
                s3 = s3 * c2 + c3 * s2;
                c3 = t1;
            }
        } else {
            for (int m3 = 0; m3 < pts; ++m3) {
                double p = startoffset + (double)m3 * endangle / (double)(pts - 1);
                double c2 = Math.cos(p);
                double s2 = Math.sin(p);
                points[m3] = Poly.fromLambda(center.getX() + a2 * c2, center.getY() + b2 * s2);
            }
        }
        return points;
    }

    private double getTracePointX(Point2D[] tracePoints, int index, double cX) {
        double v = tracePoints[index].getX();
        return v + cX;
    }

    private double getTracePointY(Point2D[] tracePoints, int index, double cY) {
        double v = tracePoints[index].getY();
        return v + cY;
    }

    @Override
    public void setDefaultOutline(NodeInst ni) {
        Point2D[] outline;
        if (ni.isCellInstance()) {
            return;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        double x = ni.getAnchorCenterX();
        double y = ni.getAnchorCenterY();
        if (np == this.openedPolygonNode || np == this.openedDottedPolygonNode || np == this.openedDashedPolygonNode || np == this.openedThickerPolygonNode || np == this.splineNode) {
            outline = new EPoint[]{EPoint.fromLambda(x - 3.0, y - 3.0), EPoint.fromLambda(x - 1.0, y + 3.0), EPoint.fromLambda(x + 1.0, y - 3.0), EPoint.fromLambda(x + 3.0, y + 3.0)};
            ni.setTrace((EPoint[])outline);
        }
        if (np == this.closedPolygonNode || np == this.filledPolygonNode) {
            outline = new EPoint[]{EPoint.fromLambda(x + 0.0, y - 3.0), EPoint.fromLambda(x - 3.0, y + 0.0), EPoint.fromLambda(x + 0.0, y + 3.0), EPoint.fromLambda(x + 3.0, y - 3.0)};
            ni.setTrace(outline);
        }
    }

    public PolyBase.Point[] fillSpline(EPoint c2, EPoint[] tracePoints) {
        double cX = c2.getLambdaX();
        double cY = c2.getLambdaY();
        int steps = 20;
        int count = tracePoints.length;
        int outPoints = (count - 1) * steps + 1;
        PolyBase.Point[] points = new PolyBase.Point[outPoints];
        int out = 0;
        double splineStep = 1.0 / (double)steps;
        double x2 = this.getTracePointX(tracePoints, 0, cX) * 2.0 - this.getTracePointX(tracePoints, 1, cX);
        double y2 = this.getTracePointY(tracePoints, 0, cY) * 2.0 - this.getTracePointY(tracePoints, 1, cY);
        double x3 = this.getTracePointX(tracePoints, 0, cX);
        double y3 = this.getTracePointY(tracePoints, 0, cY);
        double x4 = this.getTracePointX(tracePoints, 1, cX);
        double y4 = this.getTracePointY(tracePoints, 1, cY);
        for (int k2 = 2; k2 <= count; ++k2) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            double y1 = y2;
            y2 = y3;
            y3 = y4;
            if (k2 == count) {
                x4 = this.getTracePointX(tracePoints, k2 - 1, cX) * 2.0 - this.getTracePointX(tracePoints, k2 - 2, cX);
                y4 = this.getTracePointY(tracePoints, k2 - 1, cY) * 2.0 - this.getTracePointY(tracePoints, k2 - 2, cY);
            } else {
                x4 = this.getTracePointX(tracePoints, k2, cX);
                y4 = this.getTracePointY(tracePoints, k2, cY);
            }
            int i2 = 0;
            double t = 0.0;
            while (i2 < steps) {
                double tsq = t * t;
                double t4 = tsq * t;
                double t3 = -3.0 * t4 + 3.0 * tsq + 3.0 * t + 1.0;
                double t2 = 3.0 * t4 - 6.0 * tsq + 4.0;
                double t1 = -t4 + 3.0 * tsq - 3.0 * t + 1.0;
                double x = (x1 * t1 + x2 * t2 + x3 * t3 + x4 * t4) / 6.0;
                double y = (y1 * t1 + y2 * t2 + y3 * t3 + y4 * t4) / 6.0;
                points[out++] = Poly.fromLambda(x, y);
                ++i2;
                t += splineStep;
            }
        }
        points[out++] = Poly.fromLambda(this.getTracePointX(tracePoints, count - 1, cX), this.getTracePointY(tracePoints, count - 1, cY));
        return points;
    }

    public EGraphics makeGraphics(ElectricObject eObj) {
        return this.makeGraphics(eObj.getD());
    }

    private EGraphics makeGraphics(ImmutableElectricObject d2) {
        Integer color = (Integer)d2.getVarValue(ART_COLOR, Integer.class);
        Variable patternVar = d2.getVar(ART_PATTERN);
        if (color == null && patternVar == null) {
            return null;
        }
        EGraphics graphics = this.defaultLayer.getFactoryGraphics();
        if (color != null) {
            graphics = graphics.withColorIndex(color);
        }
        if (patternVar != null) {
            int len = patternVar.getLength();
            if (len != 8 && len != 16 && len != 17) {
                System.out.println("'ART_pattern' length is incorrect");
                return null;
            }
            graphics = graphics.withPatternedOnDisplay(true);
            graphics = graphics.withPatternedOnPrinter(true);
            graphics = graphics.withOutlined(null);
            int[] pattern = new int[16];
            Object obj = patternVar.getObject();
            if (obj instanceof Integer[]) {
                pat = (Integer[])obj;
                if (len == 17) {
                    int outlineIndex = (Integer)pat[16];
                    graphics = graphics.withOutlined(EGraphics.Outline.findOutline(outlineIndex));
                    len = 16;
                }
                for (i = 0; i < len; ++i) {
                    pattern[i] = (Integer)pat[i];
                }
            } else if (obj instanceof Short[]) {
                pat = (Short[])obj;
                for (i = 0; i < len; ++i) {
                    pattern[i] = ((Short)pat[i]).shortValue();
                }
                graphics = graphics.withOutlined(EGraphics.Outline.PAT_S);
            }
            if (len == 8) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    pattern[i2 + 8] = pattern[i2];
                }
            }
            graphics = graphics.withPattern(pattern);
        }
        return graphics;
    }

    public static boolean isArtworkArc(ArcProto p) {
        return p == Artwork.tech().solidArc || p == Artwork.tech().dottedArc || p == Artwork.tech().dashedArc || p == Artwork.tech().thickerArc;
    }

    private class ArtworkArcProto
    extends ArcProto.Curvable {
        private ArtworkArcProto(String protoName, Poly.Type type) {
            super(Artwork.this, protoName, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer[]{new Technology.ArcLayer(Artwork.this.defaultLayer, 0.0, type)}, Artwork.this.getNumArcs());
            this.setFactoryFixedAngle(false);
            this.setWipable();
            this.setFactoryAngleIncrement(0);
            Artwork.this.addArcProto(this);
        }

        @Override
        public boolean isEasyShape(ImmutableArcInst a2, boolean explain) {
            if (a2.getVar(ART_COLOR) != null) {
                if (explain) {
                    System.out.println("ART_COLOR");
                }
                return false;
            }
            if (a2.getVar(ART_PATTERN) != null) {
                if (explain) {
                    System.out.println("ART_PATTERN");
                }
                return false;
            }
            return super.isEasyShape(a2, explain);
        }

        @Override
        protected void getShapeOfArc(AbstractShapeBuilder b2, ImmutableArcInst a2) {
            this.getShapeOfArc(b2, a2, Artwork.this.makeGraphics(a2));
        }
    }

    private class ArtworkNode
    extends PrimitiveNode {
        private ArtworkNode(String protoName, double width, double height, Technology.NodeLayer ... layers) {
            super(protoName, Artwork.this, EPoint.ORIGIN, width, height, ERectangle.ORIGIN, layers);
        }

        @Override
        public void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
            assert (n2.protoId == this.getId());
            if (b2.isWipePins()) {
                if (this.isArcsWipe() && b2.isWiped(n2)) {
                    return;
                }
                assert (!this.isWipeOn1or2());
            }
            if (b2.skipLayer(Artwork.this.defaultLayer)) {
                return;
            }
            this.genShape(b2, n2, Artwork.this.makeGraphics(n2));
        }

        private void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2, EGraphics graphicsOverride) {
            EPoint[] outline;
            EPoint[] tracePoints;
            Technology.NodeLayer[] primLayers = this.getNodeLayers();
            if (this.isPartialCircle()) {
                double[] angles = n2.getArcDegrees();
                if (n2.size.getGridX() != n2.size.getGridY()) {
                    PolyBase.Point[] pointList = Artwork.fillEllipse(EPoint.ORIGIN, n2.size.getLambdaX(), n2.size.getLambdaY(), angles[0], angles[1]);
                    b2.setCurNode(n2);
                    for (PolyBase.Point p : pointList) {
                        b2.pushPoint(p.getFixpX(), p.getFixpY());
                    }
                    Poly.Type style = this == Artwork.this.circleNode ? Poly.Type.OPENED : Poly.Type.OPENEDT3;
                    b2.pushPoly(style, Artwork.this.defaultLayer, graphicsOverride, null);
                    return;
                }
                if (angles[0] != 0.0 || angles[1] != 0.0) {
                    double dist = (double)n2.size.getFixpX() * 0.5;
                    b2.setCurNode(n2);
                    b2.pushPoint(EPoint.ORIGIN);
                    b2.pushPoint(Math.cos(angles[0] + angles[1]) * dist, Math.sin(angles[0] + angles[1]) * dist);
                    b2.pushPoint(Math.cos(angles[0]) * dist, Math.sin(angles[0]) * dist);
                    Poly.Type style = this == Artwork.this.circleNode ? Poly.Type.CIRCLEARC : Poly.Type.THICKCIRCLEARC;
                    b2.pushPoly(style, Artwork.this.defaultLayer, graphicsOverride, null);
                    return;
                }
            } else if (this == Artwork.this.splineNode && (tracePoints = n2.getTrace()) != null) {
                PolyBase.Point[] pointList = Artwork.this.fillSpline(EPoint.ORIGIN, tracePoints);
                b2.setCurNode(n2);
                for (PolyBase.Point p : pointList) {
                    b2.pushPoint(p.getFixpX(), p.getFixpY());
                }
                b2.pushPoly(Poly.Type.OPENED, Artwork.this.defaultLayer, graphicsOverride, null);
                return;
            }
            if (this.isHoldsOutline() && (outline = n2.getTrace()) != null) {
                boolean removeSameStartEnd;
                boolean removeCoincidentPoints;
                assert (primLayers.length == 1);
                Technology.NodeLayer primLayer = primLayers[0];
                Layer layer = primLayer.getLayer();
                if (b2.skipLayer(layer)) {
                    return;
                }
                Poly.Type style = primLayer.getStyle();
                switch (style) {
                    case FILLED: 
                    case CLOSED: {
                        removeCoincidentPoints = true;
                        removeSameStartEnd = true;
                        break;
                    }
                    case OPENED: 
                    case OPENEDT1: 
                    case OPENEDT2: 
                    case OPENEDT3: {
                        removeCoincidentPoints = true;
                        removeSameStartEnd = false;
                    }
                    default: {
                        removeCoincidentPoints = false;
                        removeSameStartEnd = false;
                    }
                }
                PrimitivePort pp = primLayer.getPort(this);
                b2.setCurNode(n2);
                int startPoint = 0;
                for (int i2 = 1; i2 < outline.length; ++i2) {
                    boolean breakPoint;
                    boolean bl = breakPoint = i2 == outline.length - 1 || outline[i2] == null;
                    if (!breakPoint) continue;
                    if (i2 == outline.length - 1) {
                        ++i2;
                    }
                    b2.pushOutlineSegment(outline, startPoint, i2 - startPoint, removeCoincidentPoints, removeSameStartEnd);
                    b2.pushPoly(style, layer, graphicsOverride, pp);
                    startPoint = i2 + 1;
                }
                return;
            }
            b2.genShapeOfNode(n2, this, primLayers, graphicsOverride);
        }

        @Override
        public void genBounds(ImmutableNodeInst n2, long[] gridCoords) {
            double[] angles;
            if (this.isPartialCircle() && ((angles = n2.getArcDegrees())[0] != 0.0 || angles[1] != 0.0)) {
                this.genBoundsHard(null, n2, gridCoords);
                return;
            }
            if (n2.getTrace() != null) {
                this.genBoundsHard(null, n2, gridCoords);
                return;
            }
            super.genBounds(n2, gridCoords);
        }

        @Override
        public void genElibBounds(CellBackup cellBackup, ImmutableNodeInst n2, long[] gridCoords) {
            double[] angles;
            if (this.isPartialCircle() && ((angles = n2.getArcDegrees())[0] != 0.0 || angles[1] != 0.0)) {
                this.genBoundsHard(cellBackup, n2, gridCoords);
                return;
            }
            if (n2.getTrace() != null) {
                this.genBoundsHard(cellBackup, n2, gridCoords);
                return;
            }
            super.genBounds(n2, gridCoords);
        }

        private void genBoundsHard(CellBackup cellBackup, ImmutableNodeInst n2, long[] gridCoords) {
            BoundsBuilder b2 = cellBackup != null ? new BoundsBuilder(cellBackup) : new BoundsBuilder((TechPool)null);
            this.genShape(b2, n2);
            ERectangle bounds = b2.makeBounds();
            gridCoords[0] = bounds.getGridMinX();
            gridCoords[1] = bounds.getGridMinY();
            gridCoords[2] = bounds.getGridMaxX();
            gridCoords[3] = bounds.getGridMaxY();
        }
    }

    private class ArtworkPrimitivePort
    extends PrimitivePort {
        private ArtworkPrimitivePort(PrimitiveNode parent, String protoName, int portAngle, int portRange, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
            super(parent, new ArcProto[]{Artwork.this.solidArc, Artwork.this.dottedArc, Artwork.this.dashedArc, Artwork.this.thickerArc}, protoName, true, portAngle, portRange, 0, PortCharacteristic.UNKNOWN, false, false, left, bottom, right, top);
        }
    }

    private class NodeShapedPort
    extends ArtworkPrimitivePort {
        private NodeShapedPort(PrimitiveNode parent, String protoName, int portAngle, int portRange) {
            super(parent, protoName, portAngle, portRange, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0));
        }

        @Override
        protected void genShape(AbstractShapeBuilder b2, ImmutableNodeInst n2) {
            ((ArtworkNode)this.getParent()).genShape(b2, n2, null);
        }
    }
}

