/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ArcProto
implements Comparable<ArcProto>,
Serializable {
    private final ArcProtoId protoId;
    private final Technology tech;
    private final double lambdaElibWidthOffset;
    private ECoord baseExtend;
    private ECoord minLayerExtend;
    private ECoord maxLayerExtend;
    private int userBits;
    final Function function;
    final Technology.ArcLayer[] layers;
    PrimitiveNode arcPin;
    final int primArcIndex;
    ImmutableArcInst factoryDefaultInst;
    private int factoryAngleIncrement = 90;
    private double factoryAntennaRatio = Double.NaN;
    private static final int CANWIPE = 64;
    private static final int CANCURVE = 128;
    private static final int ARCSPECIAL = 0x200000;
    private static final int AEDGESELECT = 0x400000;
    private static final int ANOTUSED = Integer.MIN_VALUE;
    private static final int SKIPSIZEINPALETTE = 256;
    private static Map<ArcProto, Integer> maskLayers = new HashMap<ArcProto, Integer>();

    protected ArcProto(Technology tech, String protoName, double lambdaElibWidthOffset, Function function, Technology.ArcLayer[] layers, int primArcIndex) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("ArcProto name " + protoName + " is not safe to write into JELIB");
        }
        this.protoId = tech.getId().newArcProtoId(protoName);
        this.tech = tech;
        this.userBits = 0;
        this.function = function;
        this.layers = (Technology.ArcLayer[])layers.clone();
        this.primArcIndex = primArcIndex;
        this.lambdaElibWidthOffset = lambdaElibWidthOffset;
        this.baseExtend = layers[0].getExtend();
        assert (-268435455L < this.baseExtend.getGrid() && this.baseExtend.getGrid() < 0xFFFFFFFL);
        this.computeLayerGridExtendRange();
        PrimitivePortId ppId = this.protoId.techId.idManager.newTechId("generic").newPrimitiveNodeId("Universal-Pin").newPortId("");
        this.factoryDefaultInst = ImmutableArcInst.newInst(0, this.protoId, ImmutableArcInst.BASENAME, null, 0, ppId, EPoint.ORIGIN, 0, ppId, EPoint.ORIGIN, 0L, 0, ImmutableArcInst.FACTORY_DEFAULT_FLAGS);
    }

    private void computeLayerGridExtendRange() {
        ECoord min = ECoord.MAX_ECOORD;
        ECoord max = ECoord.MIN_ECOORD;
        for (int i2 = 0; i2 < this.layers.length; ++i2) {
            Technology.ArcLayer primLayer = this.layers[i2];
            assert (this.indexOf(primLayer.getLayer()) == i2);
            min = min.min(this.getLayerExtend(i2));
            max = max.max(this.getLayerExtend(i2));
        }
        assert (-268435455L < min.getGrid());
        assert (max.getGrid() < 0xFFFFFFFL && min.compareTo(max) <= 0);
        this.minLayerExtend = min;
        this.maxLayerExtend = max;
    }

    protected Object writeReplace() {
        return new ArcProtoKey(this);
    }

    public ArcProtoId getId() {
        return this.protoId;
    }

    public String getName() {
        return this.protoId.name;
    }

    public String getFullName() {
        return this.protoId.fullName;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public double getDefaultLambdaBaseWidth(EditingPreferences ep) {
        return DBMath.gridToLambda(this.getDefaultGridBaseWidth(ep));
    }

    public double getFactoryDefaultLambdaBaseWidth() {
        return DBMath.gridToLambda(this.getFactoryDefaultGridBaseWidth());
    }

    public long getDefaultGridBaseWidth(EditingPreferences ep) {
        return 2L * (this.getDefaultInst(ep).getGridExtendOverMin() + this.baseExtend.getGrid());
    }

    public long getFactoryDefaultGridBaseWidth() {
        return 2L * (this.factoryDefaultInst.getGridExtendOverMin() + this.baseExtend.getGrid());
    }

    public ImmutableArcInst getDefaultInst(EditingPreferences ep) {
        ImmutableArcInst defaultInst = ep.getDefaultArc(this.protoId);
        return defaultInst != null ? defaultInst : this.factoryDefaultInst;
    }

    public ImmutableArcInst getFactoryDefaultInst() {
        return this.factoryDefaultInst;
    }

    public ECoord getBaseExtend() {
        return this.baseExtend;
    }

    public double getLambdaElibWidthOffset() {
        return this.lambdaElibWidthOffset;
    }

    public ECoord getMinLayerExtend() {
        return this.minLayerExtend;
    }

    public ECoord getMaxLayerExtend() {
        return this.maxLayerExtend;
    }

    public void setFactoryAntennaRatio(double ratio) {
        assert (Double.isNaN(this.factoryAntennaRatio));
        this.factoryAntennaRatio = ratio;
    }

    public double getFactoryAntennaRatio() {
        return this.factoryAntennaRatio;
    }

    public void setFactoryRigid(boolean rigid) {
        this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.RIGID, rigid);
    }

    public void setFactoryFixedAngle(boolean fixed) {
        this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.FIXED_ANGLE, fixed);
    }

    public void setFactorySlidable(boolean slidable) {
        this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.SLIDABLE, slidable);
    }

    public void setFactoryExtended(boolean extended) {
        this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.TAIL_EXTENDED, extended).withFlag(ImmutableArcInst.HEAD_EXTENDED, extended);
    }

    public void setFactoryDirectional(int defaultDir) {
        if ((defaultDir & 1) != 0) {
            this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.HEAD_ARROWED, true);
        }
        if ((defaultDir & 2) != 0) {
            this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.TAIL_ARROWED, true);
        }
        if ((defaultDir & 4) != 0) {
            this.factoryDefaultInst = this.factoryDefaultInst.withFlag(ImmutableArcInst.BODY_ARROWED, true);
        }
    }

    public void setNotUsed(boolean set) {
        this.userBits = set ? (this.userBits |= Integer.MIN_VALUE) : (this.userBits &= Integer.MAX_VALUE);
        if (this.arcPin != null) {
            this.arcPin.setNotUsed(set);
        }
    }

    public boolean isNotUsed() {
        return (this.userBits & Integer.MIN_VALUE) != 0;
    }

    public void setSkipSizeInPalette() {
        this.userBits |= 0x100;
    }

    public boolean isSkipSizeInPalette() {
        return (this.userBits & 0x100) != 0;
    }

    public void setWipable() {
        this.userBits |= 0x40;
    }

    public void clearWipable() {
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isWipable() {
        return (this.userBits & 0x40) != 0;
    }

    void setCurvable() {
        this.userBits |= 0x80;
    }

    public boolean isCurvable() {
        return (this.userBits & 0x80) != 0;
    }

    public void setEdgeSelect() {
        this.userBits |= 0x400000;
    }

    public void clearEdgeSelect() {
        this.userBits &= 0xFFBFFFFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setSpecialArc() {
        this.userBits |= 0x200000;
    }

    public boolean isSpecialArc() {
        return (this.userBits & 0x200000) != 0;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFactoryAngleIncrement(int angle) {
        this.factoryAngleIncrement = angle;
    }

    public int getAngleIncrement(EditingPreferences ep) {
        Integer angleIncrement = ep.getDefaultAngleIncrement(this.protoId);
        return angleIncrement != null ? angleIncrement : this.factoryAngleIncrement;
    }

    public int getFactoryAngleIncrement() {
        return this.factoryAngleIncrement;
    }

    public PrimitiveNode findOverridablePinProto(EditingPreferences ep) {
        PrimitiveNode np;
        PrimitiveNodeId pinId = ep.getDefaultArcPinId(this.protoId);
        if (pinId != null && (np = this.tech.getPrimitiveNode(pinId)) != null) {
            return np;
        }
        return this.findPinProto();
    }

    public PrimitiveNode findPinProto() {
        if (this.arcPin != null) {
            return this.arcPin;
        }
        Iterator<PrimitiveNode> it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitivePort pp;
            PrimitiveNode pn = it.next();
            if (!pn.isPin()) continue;
            if (pn.getNumPorts() != 1) {
                System.out.println("Missing cases in ArcProto:findPinProto - " + pn.getName());
            }
            if (pn.getNumPorts() != 1 || !(pp = (PrimitivePort)pn.getPorts().next()).connectsTo(this)) continue;
            return pn;
        }
        return null;
    }

    public int getMaskLayer() {
        Integer maskLayer = maskLayers.get(this);
        if (maskLayer == null) {
            for (Technology.ArcLayer al : this.getArcLayers()) {
                Layer lay = al.getLayer();
                if (!lay.getFunction().isMetal()) continue;
                maskLayer = lay.getFunction().getMaskColor();
            }
            if (maskLayer == null) {
                maskLayer = 0;
            }
            maskLayers.put(this, maskLayer);
        }
        return maskLayer;
    }

    public static ArcProto findArcProto(String line) {
        Technology tech = Technology.getCurrent();
        return ArcProto.findArcProto(line, tech);
    }

    public static ArcProto findArcProto(String line, Technology tech) {
        String withoutPrefix;
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        ArcProto ap = tech.findArcProto(withoutPrefix);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public int getNumArcLayers() {
        return this.layers.length;
    }

    public Technology.ArcLayer[] getArcLayers() {
        return this.layers;
    }

    public Layer getLayer(int arcLayerIndex) {
        return this.layers[arcLayerIndex].getLayer();
    }

    public ECoord getLayerExtend(int arcLayerIndex) {
        return this.layers[arcLayerIndex].getExtend();
    }

    public Poly.Type getLayerStyle(int arcLayerIndex) {
        return this.layers[arcLayerIndex].getStyle();
    }

    public ECoord getLayerExtend(Layer layer) {
        return this.getLayerExtend(this.indexOf(layer));
    }

    public Poly.Type getLayerStyle(Layer layer) {
        return this.getLayerStyle(this.indexOf(layer));
    }

    Technology.ArcLayer getArcLayer(int i2) {
        return this.layers[i2];
    }

    public Iterator<Layer> getLayerIterator() {
        return new LayerIterator(this.layers);
    }

    public int indexOf(Layer layer) {
        for (int arcLayerIndex = 0; arcLayerIndex < this.layers.length; ++arcLayerIndex) {
            if (this.layers[arcLayerIndex].getLayer() != layer) continue;
            return arcLayerIndex;
        }
        return -1;
    }

    public boolean getZValues(double[] array) {
        for (int j2 = 0; j2 < this.layers.length; ++j2) {
            Layer layer = this.layers[j2].getLayer();
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
        return true;
    }

    public boolean isEasyShape(ImmutableArcInst a2, boolean explain) {
        assert (a2.protoId == this.getId());
        if (a2.isBodyArrowed() || a2.isTailArrowed() || a2.isHeadArrowed()) {
            if (explain) {
                System.out.println("ARROWED");
            }
            return false;
        }
        if (a2.isTailNegated() || a2.isHeadNegated()) {
            if (explain) {
                System.out.println("NEGATED");
            }
            return false;
        }
        long minLayerExtend = a2.getFixpExtendOverMin() + this.getMinLayerExtend().getFixp();
        if (minLayerExtend <= 0L) {
            if (minLayerExtend != 0L || this.getNumArcLayers() != 1) {
                if (explain) {
                    System.out.println(String.valueOf(this) + " many zero-width layers");
                }
                return false;
            }
            return true;
        }
        int numArcLayers = this.getNumArcLayers();
        for (int i2 = 0; i2 < numArcLayers; ++i2) {
            if (this.getLayerStyle(i2) == Poly.Type.FILLED) continue;
            if (explain) {
                System.out.println("Wide should be filled");
            }
            return false;
        }
        if (!a2.isManhattan()) {
            if (explain) {
                System.out.println("NON-MANHATTAN");
            }
            return false;
        }
        return true;
    }

    protected void getShapeOfArc(AbstractShapeBuilder b2, ImmutableArcInst a2) {
        this.getShapeOfArc(b2, a2, null);
    }

    protected void getShapeOfArc(AbstractShapeBuilder b2, ImmutableArcInst a2, EGraphics graphicsOverride) {
        int angle;
        assert (a2.protoId == this.getId());
        int numArcLayers = this.getNumArcLayers();
        if (!this.tech.isNoNegatedArcs() && (a2.isHeadNegated() || a2.isTailNegated())) {
            for (int i2 = 0; i2 < numArcLayers; ++i2) {
                Layer node_lay;
                Technology.ArcLayer primLayer = this.getArcLayer(i2);
                layer = primLayer.getLayer();
                angle = a2.getDefinedAngle();
                double fixpBubbleSize = Schematics.tech().getNegatingBubbleSize() * 4.194304E8;
                double cosDist = DBMath.cos(angle) * fixpBubbleSize;
                double sinDist = DBMath.sin(angle) * fixpBubbleSize;
                if (!b2.skipLayer(layer)) {
                    if (a2.isTailNegated()) {
                        b2.pushPoint(a2.tailLocation, cosDist, sinDist);
                    } else {
                        b2.pushPoint(a2.tailLocation);
                    }
                    if (a2.isHeadNegated()) {
                        b2.pushPoint(a2.headLocation, -cosDist, -sinDist);
                    } else {
                        b2.pushPoint(a2.headLocation);
                    }
                    b2.pushPoly(Poly.Type.OPENED, layer, graphicsOverride, null);
                }
                if (b2.skipLayer(node_lay = Schematics.tech().node_lay)) continue;
                if (a2.isTailNegated()) {
                    b2.pushPoint(a2.tailLocation, 0.5 * cosDist, 0.5 * sinDist);
                    b2.pushPoint(a2.tailLocation);
                    b2.pushPoly(Poly.Type.CIRCLE, node_lay, null, null);
                }
                if (!a2.isHeadNegated()) continue;
                b2.pushPoint(a2.headLocation, -0.5 * cosDist, -0.5 * sinDist);
                b2.pushPoint(a2.headLocation);
                b2.pushPoly(Poly.Type.CIRCLE, node_lay, null, null);
            }
        } else {
            for (int i3 = 0; i3 < numArcLayers; ++i3) {
                Technology.ArcLayer primLayer = this.getArcLayer(i3);
                layer = primLayer.getLayer();
                if (b2.skipLayer(layer)) continue;
                this.makeGridPoly(b2, a2, 2L * (a2.getGridExtendOverMin() + this.getLayerExtend(i3).getGrid()), primLayer.getStyle(), layer, graphicsOverride);
            }
        }
        if (!this.tech.isNoDirectionalArcs() && !b2.skipLayer(this.tech.generic.glyphLay)) {
            int backAngle1;
            double fixpArrowSize = 4.194304E8;
            Generic generic = this.tech.generic;
            angle = a2.getDefinedAngle();
            if (a2.isBodyArrowed()) {
                b2.pushPoint(a2.headLocation);
                b2.pushPoint(a2.tailLocation);
                b2.pushPoly(Poly.Type.VECTORS, generic.glyphLay, null, null);
            }
            if (a2.isTailArrowed()) {
                int angleOfArrow = 3300;
                backAngle1 = angle - angleOfArrow;
                int backAngle2 = angle + angleOfArrow;
                b2.pushPoint(a2.tailLocation);
                b2.pushPoint(a2.tailLocation, DBMath.cos(backAngle1) * 4.194304E8, DBMath.sin(backAngle1) * 4.194304E8);
                b2.pushPoint(a2.tailLocation);
                b2.pushPoint(a2.tailLocation, DBMath.cos(backAngle2) * 4.194304E8, DBMath.sin(backAngle2) * 4.194304E8);
                b2.pushPoly(Poly.Type.VECTORS, generic.glyphLay, null, null);
            }
            if (a2.isHeadArrowed()) {
                angle = (angle + 1800) % 3600;
                int angleOfArrow = 300;
                backAngle1 = angle - angleOfArrow;
                int backAngle2 = angle + angleOfArrow;
                b2.pushPoint(a2.headLocation);
                b2.pushPoint(a2.headLocation, DBMath.cos(backAngle1) * 4.194304E8, DBMath.sin(backAngle1) * 4.194304E8);
                b2.pushPoint(a2.headLocation);
                b2.pushPoint(a2.headLocation, DBMath.cos(backAngle2) * 4.194304E8, DBMath.sin(backAngle2) * 4.194304E8);
                b2.pushPoly(Poly.Type.VECTORS, generic.glyphLay, graphicsOverride, null);
            }
        }
    }

    public void makeGridPoly(AbstractShapeBuilder b2, ImmutableArcInst a2, long gridWidth, Poly.Type style, Layer layer, EGraphics graphicsOverride) {
        b2.makeGridPoly(a2, gridWidth, style, layer, graphicsOverride);
    }

    public Poly[] getShapeOfDummyArc(EditingPreferences ep, double lambdaLength) {
        long l2 = DBMath.lambdaToGrid(lambdaLength / 2.0);
        Poly[] polys = new Poly[this.layers.length];
        long defaultGridExtendOverMin = this.getDefaultInst(ep).getGridExtendOverMin();
        for (int i2 = 0; i2 < this.layers.length; ++i2) {
            PolyBase.Point[] points;
            long gridWidth = 2L * (defaultGridExtendOverMin + this.getLayerExtend(i2).getGrid());
            Poly.Type style = this.getLayerStyle(i2);
            if (gridWidth == 0L) {
                points = new PolyBase.Point[]{Poly.fromGrid(-l2, 0L), Poly.fromGrid(l2, 0L)};
                if (style == Poly.Type.FILLED) {
                    style = Poly.Type.OPENED;
                }
            } else {
                long w2 = gridWidth / 2L;
                assert (w2 > 0L);
                points = new PolyBase.Point[]{Poly.fromGrid(-l2 - w2, w2), Poly.fromGrid(-l2 - w2, -w2), Poly.fromGrid(l2 + w2, -w2), Poly.fromGrid(l2 + w2, w2)};
                if (style.isOpened()) {
                    points = new PolyBase.Point[]{points[0], points[1], points[2], points[3], (PolyBase.Point)points[0].clone()};
                }
            }
            Poly poly = new Poly(points);
            poly.setStyle(style);
            poly.setLayer(this.getLayer(i2));
            polys[i2] = poly;
        }
        return polys;
    }

    public String describe() {
        Object description = "";
        Technology tech = this.getTechnology();
        if (Technology.getCurrent() != tech) {
            description = (String)description + tech.getTechName() + ":";
        }
        description = (String)description + this.getName();
        return description;
    }

    @Override
    public int compareTo(ArcProto that) {
        int cmp;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.primArcIndex - that.primArcIndex;
    }

    void finish() {
        if (Double.isNaN(this.factoryAntennaRatio)) {
            double ratio = 200.0;
            if (this.function.isMetal()) {
                ratio = 400.0;
            }
            this.setFactoryAntennaRatio(ratio);
        }
        assert (this.factoryDefaultInst.isTailExtended() == this.factoryDefaultInst.isHeadExtended());
        assert (!this.factoryDefaultInst.isTailNegated() && !this.factoryDefaultInst.isHeadNegated());
        assert (!this.factoryDefaultInst.isHardSelect());
    }

    public String toString() {
        return "arc " + this.describe();
    }

    void dump(PrintWriter out) {
        out.println("ArcProto " + this.getName() + " " + String.valueOf((Object)this.getFunction()));
        out.println("\tisWipable=" + this.isWipable());
        out.println("\tisCurvable=" + this.isCurvable());
        out.println("\tisSpecialArc=" + this.isSpecialArc());
        out.println("\tisEdgeSelect=" + this.isEdgeSelect());
        out.println("\tisNotUsed=" + this.isNotUsed());
        out.println("\tisSkipSizeInPalette=" + this.isSkipSizeInPalette());
        Technology.printlnPref(out, 1, "DefaultExtendFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.getLambdaExtendOverMin());
        out.println("\tbaseExtend=" + String.valueOf(this.getBaseExtend()));
        out.println("\tdefaultLambdaBaseWidth=" + this.getFactoryDefaultLambdaBaseWidth());
        out.println("\tdiskOffset1=" + DBMath.round(this.getBaseExtend().getLambda() + 0.5 * this.getLambdaElibWidthOffset()));
        out.println("\tdiskOffset2=" + String.valueOf(this.getBaseExtend()));
        Technology.printlnPref(out, 1, "DefaultAngleFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryAngleIncrement);
        Technology.printlnPref(out, 1, "DefaultRigidFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.isRigid());
        Technology.printlnPref(out, 1, "DefaultFixedAngleFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.isFixedAngle());
        Technology.printlnPref(out, 1, "DefaultExtendedFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.isTailExtended());
        Technology.printlnPref(out, 1, "DefaultDirectionalFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.isHeadArrowed());
        for (Technology.ArcLayer arcLayer : this.layers) {
            arcLayer.dump(out);
        }
    }

    Xml.ArcProto makeXml() {
        Xml.ArcProto a2 = new Xml.ArcProto();
        a2.name = this.getName();
        for (Map.Entry<String, ArcProto> e2 : this.tech.getOldArcNames().entrySet()) {
            if (e2.getValue() != this) continue;
            assert (a2.oldName == null);
            a2.oldName = e2.getKey();
        }
        a2.function = this.getFunction();
        a2.wipable = this.isWipable();
        a2.curvable = this.isCurvable();
        a2.special = this.isSpecialArc();
        a2.notUsed = this.isNotUsed();
        a2.skipSizeInPalette = this.isSkipSizeInPalette();
        double correction2 = this.getBaseExtend().getLambda();
        double correction1 = DBMath.round(correction2 + 0.5 * this.getLambdaElibWidthOffset());
        if (correction1 != correction2) {
            a2.diskOffset.put(1, correction1);
        }
        if (correction2 != 0.0) {
            a2.diskOffset.put(2, correction2);
        }
        a2.extended = this.factoryDefaultInst.isTailExtended();
        a2.fixedAngle = this.factoryDefaultInst.isFixedAngle();
        a2.angleIncrement = this.getFactoryAngleIncrement();
        a2.antennaRatio = this.getFactoryAntennaRatio();
        for (Technology.ArcLayer arcLayer : this.layers) {
            a2.arcLayers.add(arcLayer.makeXml());
        }
        return a2;
    }

    void check() {
        assert (this.protoId.techId == this.tech.getId());
        for (Technology.ArcLayer primLayer : this.layers) {
            ECoord extend = this.getLayerExtend(primLayer.getLayer());
            assert (this.minLayerExtend.compareTo(extend) <= 0 && extend.compareTo(this.maxLayerExtend) <= 0);
        }
        assert (this.lambdaElibWidthOffset >= 0.0);
        assert (this.baseExtend.signum() >= 0 && this.baseExtend.compareTo(this.maxLayerExtend) <= 0);
        assert (this.baseExtend == this.getLayerExtend(0));
    }

    public static final class Function
    extends Enum<Function> {
        public static final /* enum */ Function UNKNOWN = new Function("unknown", 0, 0);
        public static final /* enum */ Function METAL1 = new Function("metal-1", 1, 0);
        public static final /* enum */ Function METAL2 = new Function("metal-2", 2, 0);
        public static final /* enum */ Function METAL3 = new Function("metal-3", 3, 0);
        public static final /* enum */ Function METAL4 = new Function("metal-4", 4, 0);
        public static final /* enum */ Function METAL5 = new Function("metal-5", 5, 0);
        public static final /* enum */ Function METAL6 = new Function("metal-6", 6, 0);
        public static final /* enum */ Function METAL7 = new Function("metal-7", 7, 0);
        public static final /* enum */ Function METAL8 = new Function("metal-8", 8, 0);
        public static final /* enum */ Function METAL9 = new Function("metal-9", 9, 0);
        public static final /* enum */ Function METAL10 = new Function("metal-10", 10, 0);
        public static final /* enum */ Function METAL11 = new Function("metal-11", 11, 0);
        public static final /* enum */ Function METAL12 = new Function("metal-12", 12, 0);
        public static final /* enum */ Function METAL13 = new Function("metal-13", 13, 0);
        public static final /* enum */ Function METAL14 = new Function("metal-14", 14, 0);
        public static final /* enum */ Function POLY1 = new Function("poly-1", 0, 1);
        public static final /* enum */ Function POLY2 = new Function("poly-2", 0, 2);
        public static final /* enum */ Function POLY3 = new Function("poly-3", 0, 3);
        public static final /* enum */ Function DMYPOLY1 = new Function("dmy-poly-1", 0, 0);
        public static final /* enum */ Function DIFF = new Function("diffusion", 0, 0);
        public static final /* enum */ Function DIFFP = new Function("p-diffusion", 0, 0);
        public static final /* enum */ Function DIFFN = new Function("n-diffusion", 0, 0);
        public static final /* enum */ Function DIFFS = new Function("substrate-diffusion", 0, 0);
        public static final /* enum */ Function DIFFW = new Function("well-diffusion", 0, 0);
        public static final /* enum */ Function WELL = new Function("well", 0, 0);
        public static final /* enum */ Function BUS = new Function("bus", 0, 0);
        public static final /* enum */ Function UNROUTED = new Function("unrouted", 0, 0);
        public static final /* enum */ Function NONELEC = new Function("nonelectrical", 0, 0);
        private final String printName;
        private final int level;
        private final boolean isMetal;
        private final boolean isPoly;
        private final boolean isDiffusion;
        private static final Function[] metalLayers;
        private static final Function[] polyLayers;
        private static final /* synthetic */ Function[] $VALUES;

        public static Function[] values() {
            return (Function[])$VALUES.clone();
        }

        public static Function valueOf(String name) {
            return Enum.valueOf(Function.class, name);
        }

        private Function(String printName, int metalLevel, int polyLevel) {
            this.printName = printName;
            this.isMetal = metalLevel != 0;
            this.isPoly = polyLevel != 0;
            this.isDiffusion = this.name().startsWith("DIFF");
            this.level = this.isMetal ? metalLevel : (this.isPoly ? polyLevel : 0);
        }

        public String toString() {
            return this.printName;
        }

        public String getConstantName() {
            return this.name();
        }

        public static List<Function> getFunctions() {
            return Arrays.asList((Function[])Function.class.getEnumConstants());
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            return level < metalLayers.length ? metalLayers[level] : null;
        }

        public static Function getPoly(int level) {
            return level < polyLayers.length ? polyLayers[level] : null;
        }

        public static Function getContact(int level) {
            return metalLayers[level];
        }

        public boolean isMetal() {
            return this.isMetal;
        }

        public boolean isPoly() {
            return this.isPoly;
        }

        public boolean isDiffusion() {
            return this.isDiffusion;
        }

        public static Function findByPrintName(String name) {
            List<Function> allFuncs = Function.getFunctions();
            for (Function fun : allFuncs) {
                if (!fun.printName.equalsIgnoreCase(name)) continue;
                return fun;
            }
            return null;
        }

        private static Function[] initMetalLayers(Function[] allFunctions) {
            int maxLevel = -1;
            for (Function fun : Function.getFunctions()) {
                if (!fun.isMetal()) continue;
                maxLevel = Math.max(maxLevel, fun.level);
            }
            Function[] layers = new Function[maxLevel + 1];
            for (Function fun : Function.getFunctions()) {
                if (!fun.isMetal()) continue;
                assert (layers[fun.level] == null);
                layers[fun.level] = fun;
            }
            return layers;
        }

        private static Function[] initPolyLayers(Function[] allFunctions) {
            int maxLevel = -1;
            for (Function fun : Function.getFunctions()) {
                if (!fun.isPoly()) continue;
                maxLevel = Math.max(maxLevel, fun.level);
            }
            Function[] layers = new Function[maxLevel + 1];
            for (Function fun : Function.getFunctions()) {
                if (!fun.isPoly()) continue;
                assert (layers[fun.level] == null);
                layers[fun.level] = fun;
            }
            return layers;
        }

        private static /* synthetic */ Function[] $values() {
            return new Function[]{UNKNOWN, METAL1, METAL2, METAL3, METAL4, METAL5, METAL6, METAL7, METAL8, METAL9, METAL10, METAL11, METAL12, METAL13, METAL14, POLY1, POLY2, POLY3, DMYPOLY1, DIFF, DIFFP, DIFFN, DIFFS, DIFFW, WELL, BUS, UNROUTED, NONELEC};
        }

        static {
            $VALUES = Function.$values();
            metalLayers = Function.initMetalLayers((Function[])Function.class.getEnumConstants());
            polyLayers = Function.initPolyLayers((Function[])Function.class.getEnumConstants());
        }
    }

    private static class ArcProtoKey
    extends EObjectInputStream.Key<ArcProto> {
        public ArcProtoKey() {
        }

        private ArcProtoKey(ArcProto ap) {
            super(ap);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, ArcProto ap) throws IOException {
            out.writeObject(ap.getTechnology());
            out.writeInt(ap.getId().chronIndex);
        }

        @Override
        public ArcProto readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            Technology tech = (Technology)in.readObject();
            ArcProto ap = tech.getArcProtoByChronIndex(chronIndex = in.readInt());
            if (ap == null) {
                throw new InvalidObjectException("arc proto not found");
            }
            return ap;
        }
    }

    private static class LayerIterator
    implements Iterator<Layer> {
        Technology.ArcLayer[] array;
        int pos;

        public LayerIterator(Technology.ArcLayer[] a2) {
            this.array = a2;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Layer next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    public static class Curvable
    extends ArcProto {
        private static final int MAXARCPIECES = 16;

        protected Curvable(Technology tech, String protoName, double lambdaElibWidthOffset, Function function, Technology.ArcLayer[] layers, int primArcIndex) {
            super(tech, protoName, lambdaElibWidthOffset, function, layers, primArcIndex);
            this.setCurvable();
        }

        @Override
        public boolean isEasyShape(ImmutableArcInst a2, boolean explain) {
            if (a2.getVar(ImmutableArcInst.ARC_RADIUS) != null) {
                if (explain) {
                    System.out.println("CURVABLE");
                }
                return false;
            }
            return super.isEasyShape(a2, explain);
        }

        @Override
        public void makeGridPoly(AbstractShapeBuilder b2, ImmutableArcInst a2, long gridWidth, Poly.Type style, Layer layer, EGraphics graphicsOverride) {
            Double radiusDouble = a2.getRadius();
            if (radiusDouble != null && this.curvedArcGridOutline(b2, a2, gridWidth, DBMath.lambdaToGrid(radiusDouble))) {
                b2.pushPoly(style, layer, graphicsOverride, null);
                return;
            }
            super.makeGridPoly(b2, a2, gridWidth, style, layer, graphicsOverride);
        }

        private boolean curvedArcGridOutline(AbstractShapeBuilder b2, ImmutableArcInst a2, long gridWidth, long gridRadius) {
            int angle;
            int i2;
            int pieces;
            double gridLength;
            long pureGridRadius = Math.abs(gridRadius);
            if ((double)(pureGridRadius * 2L) < (gridLength = a2.getGridLength())) {
                return false;
            }
            Point2D[] centers = DBMath.findCenters(pureGridRadius, a2.headLocation.gridMutable(), a2.tailLocation.gridMutable());
            if (centers == null) {
                return false;
            }
            Point2D centerPt = gridRadius >= 0L ? centers[1] : centers[0];
            double centerX = centerPt.getX();
            double centerY = centerPt.getY();
            int angleBase = DBMath.figureAngle((double)a2.headLocation.getGridX() - centerX, (double)a2.headLocation.getGridY() - centerY);
            int angleRange = DBMath.figureAngle((double)a2.tailLocation.getGridX() - centerX, (double)a2.tailLocation.getGridY() - centerY);
            if ((angleRange -= angleBase) < 0) {
                angleRange += 3600;
            }
            if (angleRange > 1800) {
                if ((angleBase += angleRange) < 0) {
                    angleBase += 3600;
                }
                angleRange = 3600 - angleRange;
            }
            for (pieces = angleRange; pieces > 16; pieces /= 2) {
            }
            if (pieces == 0) {
                return false;
            }
            double outerRadius = pureGridRadius + gridWidth / 2L;
            double innerRadius = outerRadius - (double)gridWidth;
            for (i2 = 0; i2 <= pieces; ++i2) {
                angle = (angleBase + i2 * angleRange / pieces) % 3600;
                b2.pushPoint((DBMath.cos(angle) * innerRadius + centerX) * 1048576.0, (DBMath.sin(angle) * innerRadius + centerY) * 1048576.0);
            }
            for (i2 = pieces; i2 >= 0; --i2) {
                angle = (angleBase + i2 * angleRange / pieces) % 3600;
                b2.pushPoint((DBMath.cos(angle) * outerRadius + centerX) * 1048576.0, (DBMath.sin(angle) * outerRadius + centerY) * 1048576.0);
            }
            return true;
        }
    }
}

