/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.minarea.bitmapjava;

import com.sun.electric.api.minarea.ErrorLogger;
import com.sun.electric.api.minarea.LayoutCell;
import com.sun.electric.api.minarea.ManhattanOrientation;
import com.sun.electric.api.minarea.MinAreaChecker;
import com.sun.electric.api.minarea.geometry.Point;
import com.sun.electric.api.minarea.geometry.Shapes;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeSet;

public class BitMapMinAreaChecker
implements MinAreaChecker {
    @Override
    public String getAlgorithmName() {
        return "BitMapJava";
    }

    @Override
    public Properties getDefaultParameters() {
        Properties parameters = new Properties();
        parameters.put("ReportTiles", Boolean.TRUE);
        return parameters;
    }

    @Override
    public void check(LayoutCell topCell, long minArea, Properties parameters, ErrorLogger errorLogger) {
        new Task(topCell, minArea, parameters, errorLogger);
    }

    private static class Task {
        private final int DEBUG = 0;
        private long totalArea;
        private long polyArea;
        private Stack<Point> stack = new Stack();
        private ArrayList<Point> curPolyBB = new ArrayList();
        private boolean reportTiles;
        int[] xa;
        int[] ya;
        BitSet[] bitMap;

        private static void flattenRects(LayoutCell top, LayoutCell.RectangleHandler proc) {
            Task.flatten(top, 0, 0, ManhattanOrientation.R0, proc);
        }

        private static void flatten(LayoutCell t, final int x, final int y, final ManhattanOrientation orient, final LayoutCell.RectangleHandler proc) {
            final int[] a2 = new int[4];
            t.traverseRectangles(new LayoutCell.RectangleHandler(){

                @Override
                public void apply(int minX, int minY, int maxX, int maxY) {
                    a2[0] = minX;
                    a2[1] = minY;
                    a2[2] = maxX;
                    a2[3] = maxY;
                    orient.transformRects(a2, 0, 1);
                    proc.apply(a2[0] + x, a2[1] + y, a2[2] + x, a2[3] + y);
                }
            });
            t.traverseSubcellInstances(new LayoutCell.SubcellHandler(){

                @Override
                public void apply(LayoutCell subCell, int anchorX, int anchorY, ManhattanOrientation subOrient) {
                    a2[0] = anchorX;
                    a2[1] = anchorY;
                    orient.transformPoints(a2, 0, 1);
                    Task.flatten(subCell, a2[0] + x, a2[1] + y, orient.concatenate(subOrient), proc);
                }
            });
        }

        private Task(LayoutCell topCell, long minArea, Properties parameters, ErrorLogger errorLogger) {
            this.reportTiles = Boolean.parseBoolean(parameters.get("ReportTiles").toString());
            final TreeSet xcoords = new TreeSet();
            final TreeSet ycoords = new TreeSet();
            Task.flattenRects(topCell, new LayoutCell.RectangleHandler(){
                final /* synthetic */ Task this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void apply(int minX, int minY, int maxX, int maxY) {
                    xcoords.add(minX);
                    xcoords.add(maxX);
                    ycoords.add(minY);
                    ycoords.add(maxY);
                }
            });
            int xsize = xcoords.size() - 1;
            int ysize = ycoords.size() - 1;
            this.xa = new int[xsize + 1];
            this.ya = new int[ysize + 1];
            final HashMap<Integer, Integer> xm = new HashMap<Integer, Integer>();
            final HashMap<Integer, Integer> ym = new HashMap<Integer, Integer>();
            for (Integer x : xcoords) {
                this.xa[xm.size()] = x;
                xm.put(x, xm.size());
            }
            for (Integer y : ycoords) {
                this.ya[ym.size()] = y;
                ym.put(y, ym.size());
            }
            this.bitMap = new BitSet[xsize];
            for (int i2 = 0; i2 < this.bitMap.length; ++i2) {
                this.bitMap[i2] = new BitSet();
            }
            Task.flattenRects(topCell, new LayoutCell.RectangleHandler(){
                final /* synthetic */ Task this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void apply(int minX, int minY, int maxX, int maxY) {
                    int ymin = (Integer)ym.get(minY);
                    int ymax = (Integer)ym.get(maxY);
                    int xmax = (Integer)xm.get(maxX);
                    for (int x = ((Integer)xm.get(minX)).intValue(); x < xmax; ++x) {
                        this.this$0.bitMap[x].set(ymin, ymax);
                    }
                }
            });
            this.totalArea = 0L;
            for (int x = xsize - 1; x >= 0; --x) {
                for (int y = ysize - 1; y >= 0; --y) {
                    if (!this.bitMap[x].get(y)) continue;
                    this.polyArea = 0L;
                    assert (this.curPolyBB.isEmpty());
                    this.pushTile(x, y);
                    while (!this.stack.isEmpty()) {
                        Point p = this.stack.peek();
                        if (p.getX() - 1 >= 0 && this.bitMap[p.getX() - 1].get(p.getY())) {
                            this.pushTile(p.getX() - 1, p.getY());
                            continue;
                        }
                        if (p.getX() + 1 < xsize && this.bitMap[p.getX() + 1].get(p.getY())) {
                            this.pushTile(p.getX() + 1, p.getY());
                            continue;
                        }
                        if (p.getY() - 1 >= 0 && this.bitMap[p.getX()].get(p.getY() - 1)) {
                            this.pushTile(p.getX(), p.getY() - 1);
                            continue;
                        }
                        if (p.getY() + 1 < ysize && this.bitMap[p.getX()].get(p.getY() + 1)) {
                            this.pushTile(p.getX(), p.getY() + 1);
                            continue;
                        }
                        this.stack.pop();
                    }
                    this.totalArea += this.polyArea;
                    if (this.polyArea < minArea) {
                        Shape shape = null;
                        if (this.reportTiles) {
                            int[] tiles = new int[this.curPolyBB.size() * 4];
                            for (int i3 = 0; i3 < this.curPolyBB.size(); ++i3) {
                                Point p = this.curPolyBB.get(i3);
                                int xi = p.getX();
                                int yi = p.getY();
                                tiles[i3 * 4 + 0] = this.xa[xi];
                                tiles[i3 * 4 + 1] = this.ya[yi];
                                tiles[i3 * 4 + 2] = this.xa[xi + 1];
                                tiles[i3 * 4 + 3] = this.ya[yi + 1];
                            }
                            shape = Shapes.fromTiles(tiles);
                        }
                        errorLogger.reportMinAreaViolation(this.polyArea, this.xa[x + 1], this.ya[y + 1], shape);
                    }
                    this.curPolyBB.clear();
                }
            }
        }

        private static void printBitMap(BitSet[] bitMap, int xsize, int ysize) {
            for (int y = ysize - 1; y >= 0; --y) {
                for (int x = 0; x < xsize; ++x) {
                    System.out.print(bitMap[x].get(y) ? (char)'X' : ' ');
                }
                System.out.println();
            }
        }

        private void pushTile(int x, int y) {
            long w = this.xa[x + 1] - this.xa[x];
            long h2 = this.ya[y + 1] - this.ya[y];
            this.polyArea += w * h2;
            this.bitMap[x].clear(y);
            Point p = new Point(x, y);
            if (this.reportTiles) {
                this.curPolyBB.add(p);
            }
            this.stack.push(p);
        }
    }
}

