/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.irsim;

import com.sun.electric.plugins.irsim.Sim;
import com.sun.electric.plugins.irsim.SimAPI;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class Config {
    private static final double CM_M = 100.0;
    private static final int CNTPULLUP = 2;
    private static final int DIFFPERIM = 4;
    private static final int SUBPAREA = 8;
    private static final int DIFFEXTF = 16;
    private static final int TDIFFCAP = 1;
    private static final int RES_TAB_SIZE = 67;
    public double CM2A = 0.0;
    public double CM2P = 0.0;
    public double CMA = 3.0E-5;
    public double CMP = 0.0;
    public double CPA = 4.0E-5;
    public double CPP = 0.0;
    public double CDA = 1.0E-4;
    public double CDP = 6.0E-4;
    public double CPDA = 1.0E-4;
    public double CPDP = 6.0E-4;
    private double CGA = 4.0E-4;
    public double lambda = 2.5;
    public double lambdaSquared = 6.25;
    public long lambdaCM = 250L;
    public double lowThresh = 0.3;
    public double highThresh = 0.8;
    public double CTGA;
    private List<Sim.Resists>[][] resHTab = new List[4][];
    private int configFlags;
    private String[] tTypeDrop;
    private Width[][] resistances;

    public Config() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.resHTab[i2] = null;
        }
        this.configFlags = 0;
        this.resistances = new Width[3][4];
        for (int t = 0; t < 4; ++t) {
            for (int c2 = 0; c2 < 3; ++c2) {
                this.resistances[c2][t] = null;
            }
        }
    }

    public boolean loadConfig(URL configURL, SimAPI.Analyzer analyzer) {
        this.tTypeDrop = new String[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.tTypeDrop[i2] = Sim.transistorType[i2] + "-with-drop";
        }
        String fileName = configURL.getFile();
        InputStream inputStream = null;
        try {
            String line;
            URLConnection urlCon = configURL.openConnection();
            inputStream = urlCon.getInputStream();
            InputStreamReader is = new InputStreamReader(inputStream);
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((line = lineReader.readLine()) != null) {
                String[] targ;
                if (line.startsWith(";") || (targ = Sim.parseLine(line, false, analyzer)).length == 0) continue;
                if (targ[0].equals("resistance")) {
                    if (targ.length >= 6) {
                        this.insert(fileName, lineReader.getLineNumber(), targ[1], targ[2], targ[3], targ[4], targ[5], analyzer);
                        continue;
                    }
                    Sim.reportError(fileName, lineReader.getLineNumber(), "syntax error in resistance spec");
                    continue;
                }
                if (targ[0].equals("capm2a")) {
                    this.CM2A = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("capm2p")) {
                    this.CM2P = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("capma")) {
                    this.CMA = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("capmp")) {
                    this.CMP = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("cappa")) {
                    this.CPA = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("cappp")) {
                    this.CPP = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("capda")) {
                    this.CDA = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("capdp")) {
                    this.CDP = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("cappda")) {
                    this.CPDA = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("cappdp")) {
                    this.CPDP = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("capga")) {
                    this.CGA = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("lambda")) {
                    this.lambda = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("lowthresh")) {
                    this.lowThresh = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("highthresh")) {
                    this.highThresh = analyzer.atof(targ[1]);
                    continue;
                }
                if (targ[0].equals("diffperim")) {
                    if (analyzer.atof(targ[1]) == 0.0) continue;
                    this.configFlags |= 4;
                    continue;
                }
                if (targ[0].equals("cntpullup")) {
                    if (analyzer.atof(targ[1]) == 0.0) continue;
                    this.configFlags |= 2;
                    continue;
                }
                if (targ[0].equals("subparea")) {
                    if (analyzer.atof(targ[1]) == 0.0) continue;
                    this.configFlags |= 8;
                    continue;
                }
                if (targ[0].equals("diffext")) {
                    if (analyzer.atof(targ[1]) == 0.0) continue;
                    this.configFlags |= 0x10;
                    continue;
                }
                Sim.reportError(fileName, lineReader.getLineNumber(), "unknown electrical parameter: (" + targ[0] + ")");
            }
            inputStream.close();
        }
        catch (IOException e2) {
            System.out.println("Error reading electrical parameters file");
        }
        this.lambdaSquared = this.lambda * this.lambda;
        this.lambdaCM = (long)(this.lambda * 100.0);
        this.CTGA = ((this.configFlags & 8) != 0 ? this.CGA - this.CPA : this.CGA) / 10000.0;
        switch (this.configFlags & 0x14) {
            case 4: {
                this.configFlags |= 1;
                break;
            }
            case 16: {
                this.configFlags |= 1;
                break;
            }
            case 20: {
                this.configFlags |= 1;
            }
        }
        if ((this.configFlags & 2) != 0) {
            System.out.println("warning: cntpullup is not supported");
        }
        return false;
    }

    public Sim.Resists rEquiv(int type, long width, long length) {
        int n2;
        List<Sim.Resists>[] rTab = this.resHTab[type = Sim.baseType(type)];
        if (rTab == null) {
            rTab = new List[67];
            for (n2 = 0; n2 < 67; ++n2) {
                rTab[n2] = null;
            }
            this.resHTab[type] = rTab;
        }
        if (rTab[n2 = (int)(Math.abs(length * 110133L + width) % 67L)] != null) {
            for (Sim.Resists rr : rTab[n2]) {
                if (rr.length != length || rr.width != width) continue;
                return rr;
            }
        }
        Sim.Resists rr = new Sim.Resists();
        if (rTab[n2] == null) {
            rTab[n2] = new ArrayList<Sim.Resists>();
        }
        rTab[n2].add(rr);
        rr.length = length;
        rr.width = width;
        if (type == 3) {
            rr.dynRes[1] = rr.rStatic = (float)length / (float)this.lambdaCM;
            rr.dynRes[0] = rr.rStatic;
        } else {
            rr.rStatic = (float)this.wResist(this.resistances[0][type], width, length);
            rr.dynRes[0] = (float)this.wResist(this.resistances[2][type], width, length);
            rr.dynRes[1] = (float)this.wResist(this.resistances[1][type], width, length);
        }
        return rr;
    }

    private double interp(double x, double x1, double y1, double x2, double y2) {
        return (x - x1) / (x2 - x1) * (y2 - y1) + y1;
    }

    private double lResist(Length list, long l2, double size) {
        Length q = null;
        Length p = list;
        while (p != null) {
            if (p.l == l2 || p.l > l2 && q == null) {
                return p.r * size;
            }
            if (p.l > l2) {
                return size * this.interp(l2, q.l, q.r, p.l, p.r);
            }
            q = p;
            p = p.next;
        }
        if (q != null) {
            return q.r * size;
        }
        return 10000.0 * size;
    }

    private double wResist(Width list, long w, long l2) {
        double size = (double)l2 / (double)w;
        Width q = null;
        Width p = list;
        while (p != null) {
            if (p.w == w || p.w > w && q == null) {
                return this.lResist(p.list, l2, size);
            }
            if (p.w > w) {
                double temp = this.lResist(q.list, l2, size);
                return this.interp(w, q.w, temp, p.w, this.lResist(p.list, l2, size));
            }
            q = p;
            p = p.next;
        }
        if (q != null) {
            return this.lResist(q.list, l2, size);
        }
        return 10000.0 * size;
    }

    private Length lInsert(Length list, long l2, double resist) {
        Length ret = list;
        Length p = list;
        Length q = null;
        while (p != null) {
            if (p.l == l2) {
                p.r = resist;
                return ret;
            }
            if (p.l > l2) break;
            q = p;
            p = p.next;
        }
        Length lNew = new Length();
        lNew.next = p;
        lNew.l = l2;
        lNew.r = resist;
        if (q == null) {
            ret = lNew;
        } else {
            q.next = lNew;
        }
        return ret;
    }

    private void wInsert(int c2, int t, long w, long l2, double resist) {
        Width list;
        Width p = list = this.resistances[c2][t];
        Width q = null;
        while (p != null) {
            if (p.w == w) {
                p.list = this.lInsert(p.list, l2, resist);
                return;
            }
            if (p.w > w) break;
            q = p;
            p = p.next;
        }
        Width wNew = new Width();
        Length lNew = new Length();
        wNew.next = p;
        wNew.list = lNew;
        wNew.w = w;
        if (q == null) {
            this.resistances[c2][t] = wNew;
        } else {
            q.next = wNew;
        }
        lNew.next = null;
        lNew.l = l2;
        lNew.r = resist;
    }

    private void insert(String fileName, int lineNo, String type, String context, String w, String l2, String r, SimAPI.Analyzer analyzer) {
        long width = (long)(analyzer.atof(w) * 100.0);
        long length = (long)(analyzer.atof(l2) * 100.0);
        double resist = analyzer.atof(r);
        if (width <= 0L || length <= 0L || resist <= 0.0) {
            Sim.reportError(fileName, lineNo, "bad w, l, or r in config file");
            return;
        }
        int c2 = 0;
        if (context.equalsIgnoreCase("static")) {
            c2 = 0;
        } else if (context.equalsIgnoreCase("dynamic-high")) {
            c2 = 1;
        } else if (context.equalsIgnoreCase("dynamic-low")) {
            c2 = 2;
        } else if (context.equalsIgnoreCase("power")) {
            c2 = 3;
        } else {
            Sim.reportError(fileName, lineNo, "bad resistance context in config file");
            return;
        }
        for (int t = 0; t < 4; ++t) {
            if (Sim.transistorType[t].equalsIgnoreCase(type)) {
                if (c2 != 3) {
                    this.wInsert(c2, t, width, length, resist * (double)width / (double)length);
                }
                return;
            }
            if (!this.tTypeDrop[t].equalsIgnoreCase(type)) continue;
            return;
        }
        Sim.reportError(fileName, lineNo, "bad resistance transistor type");
    }

    private static class Width {
        Width next;
        long w;
        Length list;

        private Width() {
        }
    }

    private static class Length {
        Length next;
        long l;
        double r;

        private Length() {
        }
    }
}

