/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.irsim;

import com.sun.electric.api.irsim.IAnalyzer;
import com.sun.electric.plugins.irsim.Electric;
import com.sun.electric.plugins.irsim.SimAPI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Analyzer
implements IAnalyzer.EngineIRSIM,
SimAPI.Analyzer {
    static final String simVersion = "9.5j";
    private static final int VECTORCOMMENT = 1;
    private static final int VECTOREXCL = 2;
    private static final int VECTORQUESTION = 3;
    private static final int VECTORACTIVITY = 4;
    private static final int VECTORALIAS = 5;
    private static final int VECTORANALYZER = 6;
    private static final int VECTORASSERT = 7;
    private static final int VECTORASSERTWHEN = 8;
    private static final int VECTORBACK = 9;
    private static final int VECTORC = 10;
    private static final int VECTORCHANGES = 11;
    private static final int VECTORCLOCK = 12;
    private static final int VECTORDEBUG = 13;
    private static final int VECTORDECAY = 14;
    private static final int VECTORH = 15;
    private static final int VECTORINPUTS = 16;
    private static final int VECTORL = 17;
    private static final int VECTORMODEL = 18;
    private static final int VECTORP = 19;
    private static final int VECTORPATH = 20;
    private static final int VECTORPRINT = 21;
    private static final int VECTORPRINTX = 22;
    private static final int VECTORR = 23;
    private static final int VECTORREPORT = 24;
    private static final int VECTORS = 25;
    private static final int VECTORSET = 26;
    private static final int VECTORSTATS = 27;
    private static final int VECTORSTEPSIZE = 28;
    private static final int VECTORSTOP = 29;
    private static final int VECTORT = 30;
    private static final int VECTORTCAP = 31;
    private static final int VECTORU = 32;
    private static final int VECTORUNITDELAY = 33;
    private static final int VECTORUNTIL = 34;
    private static final int VECTORV = 35;
    private static final int VECTORVECTOR = 36;
    private static final int VECTORX = 37;
    private static final int DEF_STEPS = 4;
    private static final int NBUCKETS = 20;
    private static final int MAXCOL = 80;
    private static final String potChars = "luxh.";
    private static final double cmdFileUnits = 1.0E-9;
    private SimVector firstVector = null;
    private SimVector lastVector = null;
    private long stepSize = 50000L;
    private long firstTime;
    private long lastTime;
    private long startTime;
    private long stepsTime;
    private long endTime;
    private long lastStart;
    private double[] traceTime;
    private IAnalyzer.LogicState[] traceState;
    private int traceTotal = 0;
    private List<Sequence> xClock;
    private List<Sequence> sList;
    private int maxClock = 0;
    private int column = 0;
    private List<SimAPI.Node>[] listTbl = new List[5];
    public List<SimAPI.Node> hInputs = new ArrayList<SimAPI.Node>();
    public List<SimAPI.Node> lIinputs = new ArrayList<SimAPI.Node>();
    public List<SimAPI.Node> uInputs = new ArrayList<SimAPI.Node>();
    public List<SimAPI.Node> xInputs = new ArrayList<SimAPI.Node>();
    public boolean analyzerON;
    public int irDebug;
    public boolean showCommands;
    private final SimAPI theSim;
    private final IAnalyzer.GUI gui;
    private HashMap<IAnalyzer.GuiSignal, SimAPI.Node> nodeMap;
    private HashMap<SimAPI.Node, IAnalyzer.GuiSignal> signalMap = new HashMap();
    private int tranCntNSD = 0;
    private int tranCntNG = 0;
    private SimAPI.Node awTrig;
    private AssertWhen awP;
    private int whichPhase = 0;
    static long pTime;

    Analyzer(IAnalyzer.GUI gui, SimAPI sim, int irDebug, boolean showCommands) {
        this.gui = gui;
        this.irDebug = irDebug;
        this.showCommands = showCommands;
        this.theSim = sim;
        this.theSim.setDebug(irDebug);
        this.theSim.setAnalyzer(this);
    }

    @Override
    public void putTransistor(String gateName, String sourceName, String drainName, double gateLength, double gateWidth, double activeArea, double activePerim, double centerX, double centerY, boolean isNTypeTransistor) {
        this.theSim.putTransistor(gateName, sourceName, drainName, gateLength, gateWidth, activeArea, activePerim, centerX, centerY, isNTypeTransistor);
    }

    @Override
    public void putResistor(String net1, String net2, double resistance) {
        this.theSim.putResistor(net1, net2, resistance);
    }

    @Override
    public void putCapacitor(String net1, String net2, double capacitance) {
        this.theSim.putCapacitor(net1, net2, capacitance);
    }

    @Override
    public int inputSim(Reader simReader, String fileName) throws IOException {
        return this.theSim.inputSim(simReader, fileName);
    }

    @Override
    public void finishNetwork() {
        this.theSim.finishNetwork();
    }

    @Override
    public double getLambda() {
        return this.theSim.getLambda();
    }

    @Override
    public void init() {
        this.initTimes(0L, 50000L, this.theSim.getCurDelta());
        for (SimAPI.Node n2 : this.theSim.getNodes()) {
            while (n2.getFlags(4L) != 0L) {
                n2 = n2.getLink();
            }
            if (n2.getFlags(1024L) != 0L) {
                System.out.println("can't watch node " + n2.getName());
            }
            n2.setCursor(n2.getHead());
            n2.setWind(n2.getHead());
        }
        this.updateWindow(0L);
        this.lastStart = this.theSim.getMaxTime();
        this.analyzerON = true;
        this.updateWindow(this.theSim.getCurDelta());
    }

    @Override
    public void convertStimuli() {
        this.nodeMap = new HashMap();
        ArrayList<IAnalyzer.GuiSignal> sigList = new ArrayList<IAnalyzer.GuiSignal>();
        for (SimAPI.Node n2 : this.theSim.getNodes()) {
            if (n2.getName().equalsIgnoreCase("vdd") || n2.getName().equalsIgnoreCase("gnd")) continue;
            IAnalyzer.GuiSignal sig = this.gui.makeSignal(n2.getName());
            this.signalMap.put(n2, sig);
            sigList.add(sig);
            this.nodeMap.put(sig, n2);
            sig.addSample(0.0, IAnalyzer.LogicState.LOGIC_0);
        }
        this.gui.makeBusSignals(sigList);
    }

    @Override
    public void newContolPoint(String signalName, double insertTime, IAnalyzer.LogicState value) {
        this.newVector(switch (value) {
            case IAnalyzer.LogicState.LOGIC_1 -> 15;
            case IAnalyzer.LogicState.LOGIC_0 -> 17;
            default -> 37;
        }, new String[]{signalName}, insertTime, false);
    }

    @Override
    public void showSignalInfo(IAnalyzer.GuiSignal sig) {
        SimVector excl = new SimVector();
        excl.command = 2;
        excl.sigs = new ArrayList<IAnalyzer.GuiSignal>();
        excl.sigs.add(sig);
        this.issueCommand(excl);
        excl.command = 3;
        this.issueCommand(excl);
    }

    @Override
    public void clearControlPoints(IAnalyzer.GuiSignal sig) {
        SimVector lastSV = null;
        SimVector sv = this.firstVector;
        while (sv != null) {
            if ((sv.command == 17 || sv.command == 15 || sv.command == 37 || sv.command == 7 || sv.command == 26) && sv.sigs.contains(sig)) {
                if (lastSV == null) {
                    this.firstVector = sv.next;
                } else {
                    lastSV.next = sv.next;
                }
            } else {
                lastSV = sv;
            }
            sv = sv.next;
        }
        this.lastVector = lastSV;
    }

    @Override
    public void playVectors() {
        SimVector back = new SimVector();
        back.command = 9;
        back.value = 0.0;
        this.issueCommand(back);
        double curTime = 0.0;
        this.analyzerON = false;
        SimVector sv = this.firstVector;
        while (sv != null) {
            if (sv.command != 1) {
                this.issueCommand(sv);
            }
            sv = sv.next;
        }
        SimVector step = new SimVector();
        step.command = 25;
        step.value = Analyzer.deltaToNS(this.stepSize);
        this.issueCommand(step);
        this.analyzerON = true;
        this.updateWindow(this.theSim.getCurDelta());
        this.gui.setMainXPositionCursor(curTime);
    }

    @Override
    public void clearAllVectors() {
        this.firstVector = null;
        this.lastVector = null;
    }

    @Override
    public void restoreStimuli(Reader reader) throws IOException {
        String buf;
        LineNumberReader lineReader = new LineNumberReader(reader);
        double currentTime = 0.0;
        boolean anyAnalyzerCommands = false;
        while ((buf = lineReader.readLine()) != null) {
            ArrayList<IAnalyzer.GuiSignal> sigs;
            int command;
            if (buf.startsWith("|")) {
                String[] par = new String[]{buf.substring(1)};
                this.newVector(1, par, currentTime, true);
                continue;
            }
            String[] targ = this.theSim.parseLine(buf);
            if (targ == null || targ.length <= 0) continue;
            if (targ[0].equals("!")) {
                command = 2;
            } else if (targ[0].equals("?")) {
                command = 3;
            } else if (targ[0].equals("activity")) {
                command = 4;
            } else if (targ[0].equals("alias")) {
                command = 5;
            } else if (targ[0].equals("ana") || targ[0].equals("analyzer")) {
                command = 6;
            } else if (targ[0].equals("assert")) {
                command = 7;
            } else if (targ[0].equals("assertwhen")) {
                command = 8;
            } else if (targ[0].equals("back")) {
                command = 9;
            } else if (targ[0].equals("c")) {
                command = 10;
            } else if (targ[0].equals("changes")) {
                command = 11;
            } else if (targ[0].equals("clock")) {
                command = 12;
            } else if (targ[0].equals("debug")) {
                command = 13;
            } else if (targ[0].equals("decay")) {
                command = 14;
            } else if (targ[0].equals("h")) {
                command = 15;
            } else if (targ[0].equals("inputs")) {
                command = 16;
            } else if (targ[0].equals("l")) {
                command = 17;
            } else if (targ[0].equals("model")) {
                command = 18;
            } else if (targ[0].equals("p")) {
                command = 19;
            } else if (targ[0].equals("path")) {
                command = 20;
            } else if (targ[0].equals("print")) {
                command = 21;
            } else if (targ[0].equals("printx")) {
                command = 22;
            } else if (targ[0].equals("R")) {
                command = 23;
            } else if (targ[0].equals("report")) {
                command = 24;
            } else if (targ[0].equals("s")) {
                command = 25;
            } else if (targ[0].equals("set")) {
                command = 26;
            } else if (targ[0].equals("stats")) {
                command = 27;
            } else if (targ[0].equals("stepsize")) {
                command = 28;
            } else if (targ[0].equals("stop")) {
                command = 29;
            } else if (targ[0].equals("t")) {
                command = 30;
            } else if (targ[0].equals("tcap")) {
                command = 31;
            } else if (targ[0].equals("u")) {
                command = 32;
            } else if (targ[0].equals("unitdelay")) {
                command = 33;
            } else if (targ[0].equals("until")) {
                command = 34;
            } else if (targ[0].equals("V")) {
                command = 35;
            } else if (targ[0].equals("vector")) {
                command = 36;
            } else if (targ[0].equals("x")) {
                command = 37;
            } else {
                System.out.println("Unknown command: " + targ[0]);
                continue;
            }
            String[] params = new String[targ.length - 1];
            for (int i2 = 1; i2 < targ.length; ++i2) {
                params[i2 - 1] = targ[i2];
            }
            SimVector sv = this.newVector(command, params, currentTime, true);
            if (command == 25) {
                if (sv == null) continue;
                currentTime += sv.value * 1.0E-9;
                continue;
            }
            if (command == 6) {
                if (!anyAnalyzerCommands) {
                    anyAnalyzerCommands = true;
                    this.gui.closePanels();
                }
                sigs = new ArrayList<IAnalyzer.GuiSignal>();
                this.getTargetNodes(targ, 1, sigs, null);
                this.gui.openPanel(sigs);
                continue;
            }
            if (command != 36) continue;
            sigs = new ArrayList();
            this.getTargetNodes(targ, 2, sigs, null);
            IAnalyzer.GuiSignal[] subsigs = new IAnalyzer.GuiSignal[sigs.size()];
            for (int i3 = 0; i3 < sigs.size(); ++i3) {
                subsigs[i3] = (IAnalyzer.GuiSignal)sigs.get(i3);
            }
            this.gui.createBus(targ[1], subsigs);
        }
        this.playVectors();
        this.updateWindow(this.theSim.getCurDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStimuli(File stimuliFile) throws IOException {
        if (stimuliFile == null) {
            throw new NullPointerException();
        }
        try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(stimuliFile)));){
            SimVector sv = this.firstVector;
            while (sv != null) {
                Object infstr = this.commandName(sv.command);
                for (int i2 = 0; i2 < sv.parameters.length; ++i2) {
                    infstr = (String)infstr + " " + sv.parameters[i2];
                }
                printWriter.println((String)infstr);
                sv = sv.next;
            }
        }
    }

    private void issueCommand(SimVector sv) {
        if (this.showCommands) {
            System.out.print("> " + this.commandName(sv.command));
            if (sv.parameters != null) {
                for (int i2 = 0; i2 < sv.parameters.length; ++i2) {
                    System.out.print(" " + sv.parameters[i2]);
                }
            }
            System.out.println();
        }
        switch (sv.command) {
            case 2: {
                this.doInfo(sv);
                break;
            }
            case 3: {
                this.doInfo(sv);
                break;
            }
            case 4: {
                this.doActivity(sv);
                break;
            }
            case 5: {
                this.doPrintAlias();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.doAssert(sv);
                break;
            }
            case 8: {
                this.doAssertWhen(sv);
                break;
            }
            case 9: {
                this.doBack(sv);
                break;
            }
            case 10: {
                this.doClock(sv);
                break;
            }
            case 11: {
                this.doChanges(sv);
                break;
            }
            case 12: {
                this.setAClock(sv);
                break;
            }
            case 13: {
                this.doDebug(sv);
                break;
            }
            case 14: {
                this.doDecay(sv);
                break;
            }
            case 15: {
                this.doSetValue(sv);
                break;
            }
            case 16: {
                this.doInputs();
                break;
            }
            case 17: {
                this.doSetValue(sv);
                break;
            }
            case 18: {
                this.doModel(sv);
                break;
            }
            case 19: {
                this.doPhase();
                break;
            }
            case 20: {
                this.doPath(sv);
                break;
            }
            case 21: {
                this.doPrint(sv);
                break;
            }
            case 22: {
                this.doPrintX();
                break;
            }
            case 23: {
                this.doRunSeq(sv);
                break;
            }
            case 24: {
                this.doReport(sv);
                break;
            }
            case 25: {
                this.doStep(sv);
                break;
            }
            case 26: {
                this.doSet(sv);
                break;
            }
            case 27: {
                this.doStats(sv);
                break;
            }
            case 28: {
                this.doStepSize(sv);
                break;
            }
            case 29: {
                this.doStop(sv);
                break;
            }
            case 30: {
                this.doTrace(sv);
                break;
            }
            case 31: {
                this.doTCap();
                break;
            }
            case 32: {
                this.doSetValue(sv);
                break;
            }
            case 33: {
                this.doUnitDelay(sv);
                break;
            }
            case 34: {
                this.doUntil(sv);
                break;
            }
            case 35: {
                this.doV(sv);
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                this.doSetValue(sv);
            }
        }
    }

    private String commandName(int command) {
        switch (command) {
            case 1: {
                return "|";
            }
            case 2: {
                return "!";
            }
            case 3: {
                return "?";
            }
            case 4: {
                return "activity";
            }
            case 5: {
                return "alias";
            }
            case 6: {
                return "ana";
            }
            case 7: {
                return "assert";
            }
            case 8: {
                return "assertWhen";
            }
            case 9: {
                return "back";
            }
            case 10: {
                return "c";
            }
            case 11: {
                return "changes";
            }
            case 12: {
                return "clock";
            }
            case 13: {
                return "debug";
            }
            case 14: {
                return "decay";
            }
            case 15: {
                return "h";
            }
            case 16: {
                return "inputs";
            }
            case 17: {
                return "l";
            }
            case 18: {
                return "model";
            }
            case 19: {
                return "p";
            }
            case 20: {
                return "path";
            }
            case 21: {
                return "print";
            }
            case 22: {
                return "printx";
            }
            case 23: {
                return "R";
            }
            case 24: {
                return "report";
            }
            case 25: {
                return "s";
            }
            case 26: {
                return "set";
            }
            case 27: {
                return "stats";
            }
            case 28: {
                return "stepsize";
            }
            case 29: {
                return "stop";
            }
            case 30: {
                return "t";
            }
            case 31: {
                return "tcap";
            }
            case 32: {
                return "u";
            }
            case 33: {
                return "unitdelay";
            }
            case 34: {
                return "until";
            }
            case 35: {
                return "V";
            }
            case 36: {
                return "vector";
            }
            case 37: {
                return "x";
            }
        }
        return "";
    }

    private SimVector newVector(int command, String[] params, double insertTime, boolean justAppend) {
        SimVector newsv = new SimVector();
        newsv.command = command;
        newsv.parameters = params;
        switch (command) {
            case 25: {
                long lNewSize;
                double newSize = Analyzer.deltaToNS(this.stepSize);
                if (params.length > 0 && (lNewSize = Analyzer.nsToDelta(newSize = this.atof(params[0]))) <= 0L) {
                    System.out.println("Bad step size: " + this.formatDouble(newSize * 1000.0) + "psec (must be 10 psec or larger), ignoring");
                    return null;
                }
                newsv.value = newSize;
                break;
            }
            case 28: {
                if (params.length <= 0) break;
                this.stepSize = Analyzer.nsToDelta(this.atof(params[0]));
                break;
            }
            case 9: {
                newsv.value = 0.0;
                if (params.length <= 0) break;
                newsv.value = this.atof(params[0]);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 17: 
            case 20: 
            case 29: 
            case 30: 
            case 37: {
                newsv.sigs = new ArrayList<IAnalyzer.GuiSignal>();
                newsv.sigsNegated = null;
                if (command == 30) {
                    newsv.sigsNegated = new ArrayList<IAnalyzer.GuiSignal>();
                }
                this.getTargetNodes(params, 0, newsv.sigs, newsv.sigsNegated);
                if (command != 17 && command != 15 && command != 37) break;
                for (IAnalyzer.GuiSignal sig : newsv.sigs) {
                    sig.addControlPoint(insertTime);
                }
                break;
            }
        }
        SimVector lastSV = null;
        if (justAppend || insertTime < 0.0) {
            lastSV = this.lastVector;
        } else {
            double thisStep;
            double defaultStepSize = 1.0E-8;
            double curTime = 0.0;
            int clockPhases = 0;
            SimVector sv = this.firstVector;
            while (sv != null) {
                switch (sv.command) {
                    case 25: {
                        double stepSze = sv.value * 1.0E-9;
                        long ss = Analyzer.nsToDelta((curTime + stepSze - insertTime) / 1.0E-9);
                        if (ss != 0L && Electric.doublesLessThan(insertTime, curTime + stepSze)) {
                            sv.parameters = new String[1];
                            sv.value = (insertTime - curTime) / 1.0E-9;
                            sv.parameters[0] = this.formatDouble(sv.value);
                            SimVector afterSV = new SimVector();
                            afterSV.command = 25;
                            afterSV.parameters = new String[1];
                            afterSV.value = (curTime + stepSze - insertTime) / 1.0E-9;
                            afterSV.parameters[0] = this.formatDouble(afterSV.value);
                            afterSV.next = sv.next;
                            sv.next = afterSV;
                        }
                        curTime += stepSze;
                        break;
                    }
                    case 28: {
                        if (sv.parameters.length <= 0) break;
                        defaultStepSize = this.atof(sv.parameters[0]) * 1.0E-9;
                        break;
                    }
                    case 12: {
                        clockPhases = sv.parameters.length - 1;
                        break;
                    }
                    case 10: {
                        int mult = 1;
                        if (sv.parameters.length > 0) {
                            mult = this.atoi(sv.parameters[0]);
                        }
                        curTime += defaultStepSize * (double)clockPhases * (double)mult;
                        break;
                    }
                    case 19: {
                        curTime += defaultStepSize;
                    }
                }
                lastSV = sv;
                if (!Electric.doublesLessThan(curTime, insertTime)) break;
                sv = sv.next;
            }
            if (Electric.doublesLessThan(curTime, insertTime) && (thisStep = (insertTime - curTime) / 1.0E-9) > 0.005) {
                SimVector afterSV = new SimVector();
                afterSV.command = 25;
                afterSV.parameters = new String[1];
                afterSV.parameters[0] = this.formatDouble(thisStep);
                afterSV.value = thisStep;
                if (lastSV == null) {
                    afterSV.next = this.firstVector;
                    this.firstVector = afterSV;
                } else {
                    afterSV.next = lastSV.next;
                    lastSV.next = afterSV;
                }
                lastSV = afterSV;
            }
        }
        if (lastSV == null) {
            newsv.next = this.firstVector;
            this.firstVector = newsv;
        } else {
            newsv.next = lastSV.next;
            lastSV.next = newsv;
        }
        if (newsv.next == null) {
            this.lastVector = newsv;
        }
        return newsv;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean clearControlPoint(IAnalyzer.GuiSignal sig, double insertTime) {
        double defaultStepSize = 1.0E-8;
        double curTime = 0.0;
        int clockPhases = 0;
        SimVector lastSV = null;
        boolean cleared = false;
        SimVector sv = this.firstVector;
        while (sv != null) {
            block15: {
                switch (sv.command) {
                    case 25: {
                        double stepSze = defaultStepSize;
                        if (sv.value != 0.0) {
                            stepSze = sv.value * 1.0E-9;
                        }
                        curTime += stepSze;
                        break;
                    }
                    case 28: {
                        if (sv.parameters.length <= 0) break;
                        defaultStepSize = this.atof(sv.parameters[0]) * 1.0E-9;
                        break;
                    }
                    case 12: {
                        clockPhases = sv.parameters.length - 1;
                        break;
                    }
                    case 10: {
                        int mult = 1;
                        if (sv.parameters.length > 0) {
                            mult = this.atoi(sv.parameters[0]);
                        }
                        curTime += defaultStepSize * (double)clockPhases * (double)mult;
                        break;
                    }
                    case 19: {
                        curTime += defaultStepSize;
                        break;
                    }
                    case 15: 
                    case 17: 
                    case 37: {
                        if (!Electric.doublesEqual(insertTime, curTime)) break;
                        boolean found = false;
                        for (IAnalyzer.GuiSignal s : sv.sigs) {
                            if (s != sig) continue;
                            found = true;
                            sig.removeControlPoint(insertTime);
                            break;
                        }
                        if (!found) break;
                        cleared = true;
                        if (lastSV == null) {
                            this.firstVector = sv.next;
                            break block15;
                        } else {
                            lastSV.next = sv.next;
                        }
                        break block15;
                    }
                }
                lastSV = sv;
                if (Electric.doublesLessThan(insertTime, curTime)) {
                    return cleared;
                }
            }
            sv = sv.next;
        }
        return cleared;
    }

    private void getTargetNodes(String[] params, int low, List<IAnalyzer.GuiSignal> normalList, List<IAnalyzer.GuiSignal> negatedList) {
        int size = params.length - low;
        for (int i2 = 0; i2 < size; ++i2) {
            String name = params[i2 + low];
            boolean negated = false;
            if (name.startsWith("-")) {
                name = name.substring(1);
                if (negatedList != null) {
                    negated = true;
                }
            }
            if (name.indexOf(42) >= 0) {
                for (IAnalyzer.GuiSignal sig : this.gui.getSignals()) {
                    if (!this.strMatch(name, sig.getFullName())) continue;
                    if (negated) {
                        negatedList.add(sig);
                        continue;
                    }
                    normalList.add(sig);
                }
                continue;
            }
            IAnalyzer.GuiSignal sig = this.findName(name);
            if (sig == null) {
                System.out.println("Cannot find node named '" + name + "'");
                continue;
            }
            if (negated) {
                negatedList.add(sig);
                continue;
            }
            normalList.add(sig);
        }
    }

    private double getEndTime() {
        double defaultStepSize = 1.0E-8;
        double curTime = 0.0;
        int clockPhases = 0;
        SimVector sv = this.firstVector;
        while (sv != null) {
            switch (sv.command) {
                case 25: {
                    double stepSze = defaultStepSize;
                    if (sv.value != 0.0) {
                        stepSze = sv.value * 1.0E-9;
                    }
                    curTime += stepSze;
                    break;
                }
                case 28: {
                    if (sv.parameters.length <= 0) break;
                    defaultStepSize = this.atof(sv.parameters[0]) * 1.0E-9;
                    break;
                }
                case 12: {
                    clockPhases = sv.parameters.length - 1;
                    break;
                }
                case 10: {
                    int mult = 1;
                    if (sv.parameters.length > 0) {
                        mult = this.atoi(sv.parameters[0]);
                    }
                    curTime += defaultStepSize * (double)clockPhases * (double)mult;
                    break;
                }
                case 19: {
                    curTime += defaultStepSize;
                }
            }
            sv = sv.next;
        }
        return curTime;
    }

    private void doInfo(SimVector sv) {
        if (sv.sigs == null) {
            return;
        }
        for (IAnalyzer.GuiSignal sig : sv.sigs) {
            SimAPI.Node n2 = this.nodeMap.get(sig);
            if (n2 == null) continue;
            String name = n2.getName();
            while (n2.getFlags(4L) != 0L) {
                n2 = n2.getLink();
            }
            if (n2.getFlags(1024L) != 0L) {
                System.out.println(name + " => node is inside a transistor stack");
                return;
            }
            Object infstr = "";
            infstr = (String)infstr + this.pValue(name, n2);
            infstr = (String)infstr + n2.describeDelay();
            System.out.println();
            infstr = "";
            if (sv.command == 2) {
                infstr = (String)infstr + "is computed from:";
                for (SimAPI.Trans t : n2.getTerms()) {
                    infstr = (String)infstr + "  ";
                    if (this.irDebug == 0) {
                        SimAPI.Node rail;
                        String drive = null;
                        SimAPI.Node node = rail = t.getDrain().getFlags(2L) != 0L ? t.getDrain() : t.getSource();
                        if (t.getBaseType() == 0 && rail == this.theSim.getGroundNode()) {
                            drive = "pulled down by ";
                        } else if (t.getBaseType() == 1 && rail == this.theSim.getPowerNode()) {
                            drive = "pulled up by ";
                        } else if (t.getBaseType() == 2 && rail == this.theSim.getPowerNode() && t.getOtherNode(rail) == t.getGate()) {
                            drive = "pullup ";
                        } else {
                            infstr = (String)infstr + this.pTrans(t);
                        }
                        if (drive == null) continue;
                        infstr = (String)infstr + drive;
                        infstr = (String)infstr + this.pGValue(t);
                        infstr = (String)infstr + this.prTRes(t);
                        if (t.getLink() == t || (this.theSim.getReport() & 8) == 0) continue;
                        infstr = (String)infstr + " <" + t.getX() + "," + t.getY() + ">";
                        continue;
                    }
                    infstr = (String)infstr + this.pTrans(t);
                }
            } else {
                infstr = (String)infstr + "affects:";
                for (SimAPI.Trans t : n2.getGates()) {
                    infstr = (String)infstr + this.pTrans(t);
                }
            }
            System.out.println((String)infstr);
            String[] pendingEvents = n2.describePendingEvents();
            if (pendingEvents == null) continue;
            System.out.println("Pending events:");
            for (String s : pendingEvents) {
                System.out.println(s);
            }
        }
    }

    private void doActivity(SimVector sv) {
        long begin = Analyzer.nsToDelta(this.atof(sv.parameters[0]));
        long end = this.theSim.getCurDelta();
        if (sv.parameters.length > 1) {
            end = Analyzer.nsToDelta(this.atof(sv.parameters[1]));
        }
        if (end < begin) {
            long swp = end;
            end = begin;
            begin = swp;
        }
        long[] table = new long[20];
        int i2 = 0;
        while (i2 < 20) {
            table[i2++] = 0L;
        }
        long size = (end - begin + 1L) / 20L;
        if (size <= 0L) {
            size = 1L;
        }
        for (SimAPI.Node n2 : this.theSim.getNodes()) {
            if (n2.getFlags(1030L) != 0L || n2.getTime() < begin || n2.getTime() > end) continue;
            int n3 = (int)((n2.getTime() - begin) / size);
            table[n3] = table[n3] + 1L;
        }
        System.out.println("Histogram of circuit activity: " + Analyzer.deltaToNS(begin) + " . " + Analyzer.deltaToNS(end) + "ns (bucket size = " + Analyzer.deltaToNS(size) + ")");
        for (int i3 = 0; i3 < 20; ++i3) {
            System.out.println(" " + Analyzer.deltaToNS(begin + (long)i3 * size) + " -" + Analyzer.deltaToNS(begin + (long)(i3 + 1) * size) + table[i3]);
        }
    }

    private void doPrintAlias() {
        if (this.theSim.getNumAliases() == 0) {
            System.out.println("there are no aliases");
        } else {
            System.out.println("there are " + this.theSim.getNumAliases() + " aliases:");
            for (SimAPI.Node n2 : this.theSim.getNodes()) {
                if (n2.getFlags(4L) == 0L) continue;
                String is_merge = (n2 = this.unAlias(n2)).getFlags(1024L) != 0L ? " (part of a stack)" : "";
                System.out.println("  " + n2.getName() + " . " + n2.getName() + is_merge);
            }
        }
    }

    private void doBack(SimVector sv) {
        long newT = Analyzer.nsToDelta(sv.value);
        if (newT < 0L || newT > this.theSim.getCurDelta()) {
            System.out.println(sv.value + ": invalid time in BACK command");
            return;
        }
        this.theSim.setCurDelta(newT);
        this.clearInputs();
        this.theSim.backSimTime(this.theSim.getCurDelta(), 0);
        this.theSim.clearCurNode();
        for (SimAPI.Node n2 : this.theSim.getNodes()) {
            this.theSim.backToTime(n2);
        }
        if (this.theSim.getCurDelta() == 0L) {
            this.theSim.reInit();
        }
        if (this.analyzerON) {
            for (SimAPI.Node n2 : this.theSim.getNodes()) {
                n2.setCursor(n2.getHead());
                n2.setWind(n2.getHead());
            }
            this.initTimes(0L, this.stepsTime / 4L, this.theSim.getCurDelta());
            this.updateTraceCache();
        }
        this.pnWatchList();
    }

    private void doClock(SimVector sv) {
        int n2 = 1;
        if (sv.parameters.length == 1 && (n2 = this.atoi(sv.parameters[0])) <= 0) {
            n2 = 1;
        }
        this.clockIt(n2);
    }

    private void doChanges(SimVector sv) {
        long begin = Analyzer.nsToDelta(this.atof(sv.parameters[0]));
        long end = this.theSim.getCurDelta();
        if (sv.parameters.length > 1) {
            end = Analyzer.nsToDelta(this.atof(sv.parameters[1]));
        }
        this.column = 0;
        System.out.print("Nodes with last transition in interval " + Analyzer.deltaToNS(begin) + " . " + Analyzer.deltaToNS(end) + "ns:");
        for (SimAPI.Node n2 : this.theSim.getNodes()) {
            if ((n2 = this.unAlias(n2)).getFlags(1028L) != 0L) {
                return;
            }
            if (n2.getTime() < begin || n2.getTime() > end) continue;
            int i2 = n2.getName().length() + 2;
            if (this.column + i2 >= 80) {
                this.column = 0;
            }
            this.column += i2;
            System.out.print("  " + n2.getName());
        }
        System.out.println();
    }

    private void setAClock(SimVector sv) {
        this.defSequence(sv.parameters, this.xClock);
        this.maxClock = 0;
        for (Sequence t : this.xClock) {
            if (t.values.length <= this.maxClock) continue;
            this.maxClock = t.values.length;
        }
    }

    private void doDebug(SimVector sv) {
        if (sv.parameters.length <= 0) {
            this.irDebug = 0;
        } else {
            for (int i2 = 0; i2 < sv.parameters.length; ++i2) {
                if (sv.parameters[i2].equalsIgnoreCase("ev")) {
                    this.irDebug |= 1;
                    continue;
                }
                if (sv.parameters[i2].equalsIgnoreCase("dc")) {
                    this.irDebug |= 2;
                    continue;
                }
                if (sv.parameters[i2].equalsIgnoreCase("tau")) {
                    this.irDebug |= 4;
                    continue;
                }
                if (sv.parameters[i2].equalsIgnoreCase("taup")) {
                    this.irDebug |= 8;
                    continue;
                }
                if (sv.parameters[i2].equalsIgnoreCase("spk")) {
                    this.irDebug |= 0x10;
                    continue;
                }
                if (sv.parameters[i2].equalsIgnoreCase("tw")) {
                    this.irDebug |= 0x20;
                    continue;
                }
                if (sv.parameters[i2].equalsIgnoreCase("all")) {
                    this.irDebug = 63;
                    continue;
                }
                if (!sv.parameters[i2].equalsIgnoreCase("off")) continue;
                this.irDebug = 0;
            }
        }
        this.theSim.setDebug(this.irDebug);
        System.out.print("Debugging");
        if (this.irDebug == 0) {
            System.out.println(" OFF");
        } else {
            if ((this.irDebug & 1) != 0) {
                System.out.print(" event-scheduling");
            }
            if ((this.irDebug & 2) != 0) {
                System.out.print(" final-value-computation");
            }
            if ((this.irDebug & 4) != 0) {
                System.out.print(" tau/delay-computation");
            }
            if ((this.irDebug & 8) != 0) {
                System.out.print(" tauP-computation");
            }
            if ((this.irDebug & 0x10) != 0) {
                System.out.print(" spike-analysis");
            }
            if ((this.irDebug & 0x20) != 0) {
                System.out.print(" tree-walk");
            }
            System.out.println();
        }
    }

    private void doDecay(SimVector sv) {
        if (sv.parameters.length == 0) {
            if (this.theSim.getDecay() == 0L) {
                System.out.println("decay = No decay");
            } else {
                System.out.println("decay = " + Analyzer.deltaToNS(this.theSim.getDecay()) + "ns");
            }
        } else {
            this.theSim.setDecay(Analyzer.nsToDelta(this.atof(sv.parameters[0])));
            if (this.theSim.getDecay() < 0L) {
                this.theSim.setDecay(0L);
            }
        }
    }

    private void doSetValue(SimVector sv) {
        if (sv.sigs == null) {
            return;
        }
        for (IAnalyzer.GuiSignal sig : sv.sigs) {
            SimAPI.Node n2 = this.nodeMap.get(sig);
            this.setIn(n2, this.commandName(sv.command).charAt(0));
        }
    }

    private void doInputs() {
        Object n2;
        SimAPI.Node n32;
        SimAPI.Node[] inpTbl = new SimAPI.Node[4];
        inpTbl[1] = null;
        inpTbl[0] = null;
        inpTbl[3] = null;
        for (SimAPI.Node n32 : this.theSim.getNodes()) {
            if (n32.getFlags(29206L) != 16L) continue;
            n32.setNext(inpTbl[n32.getPot()]);
            inpTbl[n32.getPot()] = n32;
            n32.setFlags(512L);
        }
        System.out.print("h inputs:");
        for (SimAPI.Node n32 : this.hInputs) {
            System.out.print(" " + n32.getName());
        }
        for (n2 = inpTbl[3]; n2 != null; n2 = n2.getNext()) {
            System.out.print(" " + n2.getName());
            n2.clearFlags(512L);
        }
        System.out.println();
        System.out.print("l inputs:");
        n2 = this.lIinputs.iterator();
        while (n2.hasNext()) {
            n32 = (SimAPI.Node)n2.next();
            System.out.print(" " + n32.getName());
        }
        for (n2 = inpTbl[0]; n2 != null; n2 = n2.getNext()) {
            System.out.print(" " + n2.getName());
            n2.clearFlags(512L);
        }
        System.out.println();
        System.out.println("u inputs:");
        n2 = this.uInputs.iterator();
        while (n2.hasNext()) {
            n32 = (SimAPI.Node)n2.next();
            System.out.println(" " + n32.getName());
        }
        for (n2 = inpTbl[1]; n2 != null; n2 = n2.getNext()) {
            System.out.println(" " + n2.getName());
            n2.clearFlags(512L);
        }
        System.out.println();
    }

    private void doModel(SimVector sv) {
        if (sv.parameters.length < 1) {
            return;
        }
        if (sv.parameters[0].equals("switch")) {
            this.theSim.setModel(false);
        } else if (sv.parameters[0].equals("linear")) {
            this.theSim.setModel(true);
        } else {
            System.out.println("Unknown model: " + sv.parameters[0] + " (want either switch or linear)");
        }
    }

    private void doPhase() {
        this.stepPhase();
        this.pnWatchList();
    }

    private void doPath(SimVector sv) {
        if (sv.sigs == null) {
            return;
        }
        for (IAnalyzer.GuiSignal sig : sv.sigs) {
            SimAPI.Node n2 = this.nodeMap.get(sig);
            System.out.println("Critical path for last transition of " + n2.getName() + ":");
            n2 = this.unAlias(n2);
            this.cPath(n2, 0);
        }
    }

    private void doPrint(SimVector sv) {
        Object infstr = "";
        for (int n2 = 0; n2 < sv.parameters.length; ++n2) {
            if (n2 != 0) {
                infstr = (String)infstr + " ";
            }
            infstr = (String)infstr + sv.parameters[n2];
        }
        System.out.println((String)infstr);
    }

    private void doPrintX() {
        System.out.print("Nodes with undefined potential:");
        this.column = 0;
        for (SimAPI.Node n2 : this.theSim.getNodes()) {
            if ((n2 = this.unAlias(n2)).getFlags(1028L) != 0L || n2.getPot() != 1) continue;
            int i2 = n2.getName().length() + 2;
            if (this.column + i2 >= 80) {
                this.column = 0;
            }
            this.column += i2;
            System.out.print("  " + n2.getName());
        }
        System.out.println();
    }

    private void doRunSeq(SimVector sv) {
        int n2 = 1;
        if (sv.parameters.length == 1 && (n2 = this.atoi(sv.parameters[0])) <= 0) {
            n2 = 1;
        }
        if (this.sList.size() == 0) {
            System.out.println("no input vectors defined!");
            return;
        }
        int maxSeq = 0;
        for (Sequence cs : this.sList) {
            if (cs.values.length <= maxSeq) continue;
            maxSeq = cs.values.length;
        }
        for (int cycle = 0; cycle < n2; ++cycle) {
            for (int i2 = 0; i2 < maxSeq; ++i2) {
                this.vecValue(i2);
                if (this.clockIt(1)) {
                    return;
                }
                this.pnWatchList();
            }
        }
    }

    private void doReport(SimVector sv) {
        if (sv.parameters[0].equalsIgnoreCase("decay")) {
            this.theSim.setReport(1);
        } else if (sv.parameters[0].equalsIgnoreCase("delay")) {
            this.theSim.setReport(2);
        } else if (sv.parameters[0].equalsIgnoreCase("tau")) {
            this.theSim.setReport(4);
        } else if (sv.parameters[0].equalsIgnoreCase("tcoord")) {
            this.theSim.setReport(8);
        } else if (sv.parameters[0].equalsIgnoreCase("none")) {
            this.theSim.clearReport();
        }
        System.out.print("Report");
        if (this.theSim.getReport() == 0) {
            System.out.println(" NONE");
        } else {
            if ((this.theSim.getReport() & 1) != 0) {
                System.out.print(" decay");
            }
            if ((this.theSim.getReport() & 2) != 0) {
                System.out.print(" delay");
            }
            if ((this.theSim.getReport() & 4) != 0) {
                System.out.print(" tau");
            }
            if ((this.theSim.getReport() & 8) != 0) {
                System.out.print(" tauP");
            }
            if ((this.theSim.getReport() & 8) != 0) {
                System.out.print(" tcoord");
            }
            System.out.println();
        }
    }

    private void doStep(SimVector sv) {
        double newSize = sv.value;
        long lNewSize = Analyzer.nsToDelta(newSize);
        if (lNewSize <= 0L) {
            return;
        }
        this.relax(this.theSim.getCurDelta() + lNewSize);
        this.pnWatchList();
    }

    private void doSet(SimVector sv) {
        IAnalyzer.GuiSignal sig = this.findName(sv.parameters[0]);
        if (sig == null) {
            System.out.println("Cannot find signal: " + sv.parameters[0]);
            return;
        }
        IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
        if (sigsOnBus == null) {
            System.out.println("Signal: " + sv.parameters[0] + " is not a bus");
            return;
        }
        if (sigsOnBus.length != sv.parameters[1].length()) {
            System.out.println("Wrong number of bits for this vector");
            return;
        }
        for (int i2 = 0; i2 < sigsOnBus.length; ++i2) {
            SimAPI.Node n2 = this.nodeMap.get(sigsOnBus[i2]);
            this.setIn(n2, sv.parameters[1].charAt(i2));
        }
    }

    private void doStats(SimVector sv) {
        if (sv.parameters.length == 1 && this.tranCntNG == 0 && this.tranCntNSD == 0) {
            for (SimAPI.Node n2 : this.theSim.getNodes()) {
                if (n2.getFlags(6L) != 0L) continue;
                this.tranCntNG += n2.getGates().size();
                this.tranCntNSD += n2.getTerms().size();
            }
            System.out.println("avg: # gates/node = " + this.formatDouble(this.tranCntNG / this.theSim.getNumNodes()) + ",  # src-drn/node = " + this.formatDouble(this.tranCntNSD / this.theSim.getNumNodes()));
        }
        System.out.println("changes = " + this.theSim.getNumEdges());
        System.out.println("punts (cns) = " + this.theSim.getNumPunted() + " (" + this.theSim.getNumConsPunted() + ")");
        String n1 = "0.0";
        String n2 = "0.0";
        if (this.theSim.getNumPunted() != 0) {
            n1 = this.formatDouble(100.0 / ((double)(this.theSim.getNumEdges() / this.theSim.getNumPunted()) + 1.0));
            n2 = this.formatDouble((double)this.theSim.getNumConsPunted() * 100.0 / (double)this.theSim.getNumPunted());
        }
        System.out.println("punts = " + n1 + "%, cons_punted = " + n2 + "%");
        System.out.println("nevents = " + this.theSim.getNumEvents());
    }

    private void doStepSize(SimVector sv) {
        if (sv.parameters.length < 1) {
            System.out.println("stepsize = " + Analyzer.deltaToNS(this.stepSize));
            return;
        }
        double timeNS = this.atof(sv.parameters[0]);
        long newSize = Analyzer.nsToDelta(timeNS);
        if (newSize <= 0L) {
            System.out.println("Bad step size: " + this.formatDouble(timeNS * 1000.0) + "psec (must be 10 psec or larger)");
            return;
        }
        this.stepSize = newSize;
    }

    private void doStop(SimVector sv) {
        if (sv.sigs != null) {
            for (IAnalyzer.GuiSignal sig : sv.sigs) {
                SimAPI.Node n2 = this.nodeMap.get(sig);
                if ((n2 = this.unAlias(n2)).getFlags(1024L) != 0L) continue;
                n2.clearFlags(128L);
            }
        }
        this.setVecNodes(64);
        this.setVecNodes(256);
    }

    private void doTrace(SimVector sv) {
        SimAPI.Node n2;
        if (sv.sigs != null) {
            for (IAnalyzer.GuiSignal sig : sv.sigs) {
                n2 = this.nodeMap.get(sig);
                if ((n2 = this.unAlias(n2)).getFlags(1024L) != 0L) {
                    System.out.println("can't trace " + n2.getName());
                    continue;
                }
                n2.setFlags(32L);
            }
        }
        if (sv.sigsNegated != null) {
            for (IAnalyzer.GuiSignal sig : sv.sigsNegated) {
                n2 = this.nodeMap.get(sig);
                if ((n2 = this.unAlias(n2)).getFlags(1024L) != 0L) {
                    System.out.println("can't trace " + n2.getName());
                    continue;
                }
                if (n2.getFlags(32L) == 0L) continue;
                System.out.println(n2.getName() + " was watched; not any more");
                n2.clearFlags(32L);
            }
        }
        this.setVecNodes(64);
    }

    private void doTCap() {
        List<SimAPI.Trans> shortedTransistors = this.theSim.getShortedTransistors();
        if (shortedTransistors.isEmpty()) {
            System.out.println("there are no shorted transistors");
        } else {
            System.out.println("shorted transistors:");
        }
        for (SimAPI.Trans t : shortedTransistors) {
            System.out.println(" " + t.describeBaseType() + " g=" + t.getGate().getName() + " s=" + t.getSource().getName() + " d=" + t.getDrain().getName() + " (" + t.getLength() / this.theSim.getLambdaCM() + "x" + t.getWidth() / this.theSim.getLambdaCM() + ")");
        }
    }

    private void doUnitDelay(SimVector sv) {
        if (sv.parameters.length == 0) {
            if (this.theSim.getUnitDelay() == 0) {
                System.out.println("unitdelay = OFF");
            } else {
                System.out.println("unitdelay = " + Analyzer.deltaToNS(this.theSim.getUnitDelay()));
            }
            return;
        }
        this.theSim.setUnitDelay((int)Analyzer.nsToDelta(this.atof(sv.parameters[0])));
        if (this.theSim.getUnitDelay() < 0) {
            this.theSim.setUnitDelay(0);
        }
    }

    private void doUntil(SimVector sv) {
        String mask = null;
        StringBuffer value = null;
        int cCount = 0;
        if (sv.parameters.length == 4) {
            mask = sv.parameters[1];
            value = new StringBuffer(sv.parameters[2]);
            cCount = this.atoi(sv.parameters[3]);
        } else {
            mask = null;
            value = new StringBuffer(sv.parameters[1]);
            cCount = this.atoi(sv.parameters[2]);
        }
        IAnalyzer.GuiSignal sig = this.findName(sv.parameters[0]);
        if (sig == null) {
            System.out.println("UNTIL statement cannot find signal: " + sv.parameters[0]);
            return;
        }
        String name = null;
        int comp = 0;
        int nBits = 1;
        SimAPI.Node[] nodes = null;
        IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
        if (sigsOnBus == null) {
            SimAPI.Node n2 = this.nodeMap.get(sig);
            name = sig.getFullName();
            n2 = this.unAlias(n2);
            SimAPI.Node[] nodeList = new SimAPI.Node[]{n2};
            for (int cnt = 0; cnt <= cCount && (comp = this.compareVector(nodeList, name, 1, mask, value.toString())) != 0; ++cnt) {
                this.clockIt(1);
            }
            nodes = new SimAPI.Node[]{n2};
        } else {
            SimAPI.Node[] nodeList = new SimAPI.Node[sigsOnBus.length];
            for (int i2 = 0; i2 < sigsOnBus.length; ++i2) {
                nodeList[i2] = this.nodeMap.get(sigsOnBus[i2]);
            }
            for (int cnt = 0; cnt <= cCount && (comp = this.compareVector(nodeList, sig.getFullName(), sigsOnBus.length, mask, value.toString())) != 0; ++cnt) {
                this.clockIt(1);
            }
            name = sig.getFullName();
            nBits = sigsOnBus.length;
            nodes = nodeList;
        }
        if (comp != 0) {
            Object infstr = "";
            for (int i3 = 0; i3 < nBits; ++i3) {
                if (mask != null && mask.charAt(i3) != '0') {
                    infstr = (String)infstr + "-";
                    value.setCharAt(i3, '-');
                    continue;
                }
                infstr = (String)infstr + nodes[i3].getPotChar();
            }
            System.out.println("Assertion failed on '" + name + ": want (" + String.valueOf(value) + ") but got (" + (String)infstr + ")");
        }
    }

    private void doV(SimVector sv) {
        this.defSequence(sv.parameters, this.sList);
    }

    private void doAssert(SimVector sv) {
        String mask = null;
        StringBuffer value = null;
        if (sv.parameters.length == 3) {
            mask = sv.parameters[1];
            value = new StringBuffer(sv.parameters[2]);
        } else {
            value = new StringBuffer(sv.parameters[1]);
        }
        IAnalyzer.GuiSignal sig = this.findName(sv.parameters[0]);
        if (sig == null) {
            System.out.println("ASSERT statement cannot find signal: " + sv.parameters[0]);
            return;
        }
        int comp = 0;
        String name = null;
        SimAPI.Node[] nodes = null;
        IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
        if (sigsOnBus == null) {
            SimAPI.Node n2 = this.nodeMap.get(sig);
            name = n2.getName();
            n2 = this.unAlias(n2);
            SimAPI.Node[] nodeList = new SimAPI.Node[]{n2};
            comp = this.compareVector(nodeList, name, 1, mask, value.toString());
            nodes = nodeList;
        } else {
            SimAPI.Node[] nodeList = new SimAPI.Node[sigsOnBus.length];
            for (int i2 = 0; i2 < sigsOnBus.length; ++i2) {
                nodeList[i2] = this.nodeMap.get(sigsOnBus[i2]);
            }
            comp = this.compareVector(nodeList, sig.getSignalName(), sigsOnBus.length, mask, value.toString());
            name = sig.getSignalName();
            nodes = nodeList;
        }
        if (comp != 0) {
            Object infstr = "";
            for (int i3 = 0; i3 < nodes.length; ++i3) {
                if (mask != null && i3 < mask.length() && mask.charAt(i3) != '0') {
                    infstr = (String)infstr + "-";
                    value.setCharAt(i3, '-');
                    continue;
                }
                infstr = (String)infstr + nodes[i3].getPotChar();
            }
            System.out.println("Assertion failed on '" + name + "': want (" + String.valueOf(value) + ") but got (" + (String)infstr + ")");
        }
    }

    private void doAssertWhen(SimVector sv) {
        IAnalyzer.GuiSignal sig = this.findName(sv.parameters[0]);
        if (sig == null) {
            System.out.println("ASSERTWHEN statement cannot find signal: " + sv.parameters[0]);
            return;
        }
        if (sig.getBusMembers() == null) {
            SimAPI.Node n2 = this.nodeMap.get(sig);
            this.awTrig = n2 = this.unAlias(n2);
            this.awTrig.setAssertWhenPot((short)this.chToPot(sv.parameters[1].charAt(0)));
            IAnalyzer.GuiSignal oSig = this.findName(sv.parameters[2]);
            if (oSig == null) {
                System.out.println("ASSERTWHEN statement cannot find other signal: " + sv.parameters[2]);
                return;
            }
            SimAPI.Node wN = this.nodeMap.get(oSig);
            this.setupAssertWhen(wN, this.commandName(sv.command));
        } else {
            System.out.println("trigger to assertWhen " + sv.parameters[0] + " can't be a vector");
        }
    }

    private void setupAssertWhen(SimAPI.Node n2, String val) {
        AssertWhen p = new AssertWhen();
        p.node = n2;
        p.val = val.charAt(0);
        p.nxt = null;
        if (this.awTrig.getAssertWhen() == null) {
            this.awTrig.setAssertWhen(p);
            this.awP = p;
        } else {
            this.awP.nxt = p;
            this.awP = p;
        }
    }

    public void evalAssertWhen(SimAPI.Node n2) {
        AssertWhen p = (AssertWhen)n2.getAssertWhen();
        while (p != null) {
            String name = p.node.getName();
            StringBuffer sb = new StringBuffer();
            sb.append(p.val);
            SimAPI.Node[] nodes = new SimAPI.Node[]{p.node};
            int comp = this.compareVector(nodes, name, 1, null, sb.toString());
            if (comp != 0) {
                System.out.println("Assertion failed on '" + name + "'");
            }
            p = p.nxt;
        }
        n2.setAssertWhen(null);
    }

    @Override
    public void updateWindowIfAnalyzerOn(long endT) {
        if (this.analyzerON) {
            this.updateWindow(endT);
        }
    }

    public void updateWindow(long endT) {
        long lastT = this.lastTime;
        this.lastTime = endT;
        if (endT <= this.endTime) {
            if (lastT >= this.startTime) {
                this.drawTraces(lastT, endT);
            } else if (endT > this.startTime) {
                this.drawTraces(this.startTime, endT);
            }
        } else if (lastT < this.endTime) {
            this.drawTraces(lastT, this.endTime);
        }
    }

    @Override
    public void dispWatchVec(long which) {
        which &= 0x140L;
        String temp = " @ " + Analyzer.deltaToNS(this.theSim.getCurDelta()) + "ns ";
        System.out.println(temp);
        this.column = temp.length();
        Collection<IAnalyzer.GuiSignal> sigs = this.gui.getSignals();
        for (IAnalyzer.GuiSignal sig : sigs) {
            SimAPI.Node b2;
            IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
            if (sigsOnBus == null || (b2 = this.nodeMap.get(sig)).getFlags(which) == 0L) continue;
            boolean found = false;
            for (IAnalyzer.GuiSignal bSig : sigsOnBus) {
                SimAPI.Node bN = this.nodeMap.get(bSig);
                if (bN.getTime() != this.theSim.getCurDelta()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            this.dVec(sig);
        }
    }

    void initRSim() {
        this.xClock = new ArrayList<Sequence>();
        this.maxClock = 0;
        this.column = 0;
        this.analyzerON = false;
        this.firstVector = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            this.listTbl[i2] = null;
        }
        this.listTbl[Analyzer.inputNumber((int)4096)] = this.hInputs;
        this.listTbl[Analyzer.inputNumber((int)8192)] = this.lIinputs;
        this.listTbl[Analyzer.inputNumber((int)12288)] = this.uInputs;
        this.listTbl[Analyzer.inputNumber((int)16384)] = this.xInputs;
    }

    private void initTimes(long firstT, long stepSze, long lastT) {
        this.firstTime = firstT;
        this.lastTime = lastT;
        this.stepsTime = 4L * stepSze;
        if (this.startTime <= this.firstTime) {
            if (lastT < this.stepsTime) {
                double max;
                long endT;
                this.startTime = this.firstTime;
                this.endTime = this.startTime + this.stepsTime;
                double maxTime = this.gui.getMaxPanelTime();
                long endtime = Analyzer.nsToDelta(maxTime * 1.0E9);
                if (endtime > this.endTime) {
                    this.endTime = endtime;
                }
                if ((endT = Analyzer.nsToDelta((max = this.getEndTime()) * 1.0E9)) > this.endTime) {
                    this.endTime = endT;
                }
            } else {
                this.endTime = lastT + 2L * stepSze;
                this.startTime = this.endTime - this.stepsTime;
                if (this.startTime < this.firstTime) {
                    stepSze = this.firstTime - this.startTime;
                    this.startTime += stepSze;
                    this.endTime += stepSze;
                }
            }
        }
    }

    protected static long getResolutionScale() {
        return 1000L;
    }

    private void updateTraceCache() {
        long startT = this.startTime;
        long cursT = this.firstTime;
        for (SimAPI.Node nd : this.theSim.getNodes()) {
            SimAPI.HistEnt p = nd.getWind();
            SimAPI.HistEnt h2 = nd.getCursor();
            SimAPI.HistEnt nextH = h2.getNextHist();
            if (h2.getTime() > cursT || nextH.getTime() <= cursT) {
                if (p.getTime() <= cursT) {
                    nd.setCursor(p);
                } else {
                    nd.setCursor(nd.getHead());
                }
            }
            if (startT <= p.getTime()) {
                p = nd.getHead();
            }
            h2 = p.getNextHist();
            while (h2.getTime() < startT) {
                p = h2;
                h2 = h2.getNextHist();
            }
            nd.setWind(p);
            p = nd.getCursor();
            h2 = p.getNextHist();
            while (h2.getTime() <= cursT) {
                p = h2;
                h2 = h2.getNextHist();
            }
            nd.setCursor(p);
        }
    }

    private void drawTraces(long t1, long t2) {
        if (this.startTime != this.lastStart) {
            long startT = this.startTime;
            boolean begin = startT < this.lastStart;
            for (SimAPI.Node nd : this.theSim.getNodes()) {
                SimAPI.HistEnt p = begin ? nd.getHead() : nd.getWind();
                SimAPI.HistEnt h2 = p.getNextHist();
                while (h2.getTime() < startT) {
                    p = h2;
                    h2 = h2.getNextHist();
                }
                nd.setWind(p);
            }
            this.lastStart = this.startTime;
        }
        for (Map.Entry<SimAPI.Node, IAnalyzer.GuiSignal> e2 : this.signalMap.entrySet()) {
            SimAPI.HistEnt h3;
            SimAPI.Node nd = e2.getKey();
            IAnalyzer.GuiSignal sig = e2.getValue();
            if (sig == null || t1 >= this.lastTime || (h3 = nd.getWind()) == null) continue;
            int count = 0;
            long curT = 0L;
            long endT = t2;
            while (curT < endT) {
                byte val = h3.getVal();
                while (h3.getTime() < endT && h3.getVal() == val) {
                    h3 = h3.getNextHist();
                }
                long nextT = h3.getTime() > endT ? endT : h3.getTime();
                if (count >= this.traceTotal) {
                    int newTotal = this.traceTotal * 2;
                    if (newTotal <= count) {
                        newTotal = count + 50;
                    }
                    double[] newTime = new double[newTotal];
                    IAnalyzer.LogicState[] newState = new IAnalyzer.LogicState[newTotal];
                    for (int i2 = 0; i2 < count; ++i2) {
                        newTime[i2] = this.traceTime[i2];
                        newState[i2] = this.traceState[i2];
                    }
                    this.traceTime = newTime;
                    this.traceState = newState;
                    this.traceTotal = newTotal;
                }
                this.traceTime[count] = Analyzer.deltaToNS(curT) / 1.0E9;
                switch (val) {
                    case 0: {
                        this.traceState[count] = IAnalyzer.LogicState.LOGIC_0;
                        break;
                    }
                    case 3: {
                        this.traceState[count] = IAnalyzer.LogicState.LOGIC_1;
                        break;
                    }
                    default: {
                        this.traceState[count] = IAnalyzer.LogicState.LOGIC_X;
                    }
                }
                curT = nextT;
                ++count;
            }
            for (int i3 = 0; i3 < count; ++i3) {
                sig.addSample(this.traceTime[i3], this.traceState[i3]);
            }
        }
        this.gui.repaint();
    }

    private void setIn(SimAPI.Node n2, char wChar) {
        while (n2.getFlags(4L) != 0L) {
            n2 = n2.getLink();
        }
        if (n2.getFlags(1026L) != 0L) {
            String pots = "lxuh";
            if (n2.getFlags(1024L) != 0L || pots.charAt(n2.getPot()) != wChar) {
                System.out.println("Can't drive `" + n2.getName() + "' to `" + wChar + "'");
            }
        } else {
            List<SimAPI.Node> list = this.listTbl[Analyzer.inputNumber((int)n2.getFlags())];
            switch (wChar) {
                case '1': 
                case 'h': {
                    if (list != null && list != this.hInputs) {
                        n2.clearFlags(28672L);
                        list.remove(n2);
                    }
                    if (list == this.hInputs || this.wasInP(n2, 3)) break;
                    n2.clearFlags(28672L);
                    n2.setFlags(4096L);
                    this.hInputs.add(n2);
                    break;
                }
                case '0': 
                case 'l': {
                    if (list != null && list != this.lIinputs) {
                        n2.clearFlags(28672L);
                        list.remove(n2);
                    }
                    if (list == this.lIinputs || this.wasInP(n2, 0)) break;
                    n2.clearFlags(28672L);
                    n2.setFlags(8192L);
                    this.lIinputs.add(n2);
                    break;
                }
                case 'u': {
                    if (list != null && list != this.uInputs) {
                        n2.clearFlags(28672L);
                        list.remove(n2);
                    }
                    if (list == this.uInputs || this.wasInP(n2, 1)) break;
                    n2.clearFlags(28672L);
                    n2.setFlags(12288L);
                    this.uInputs.add(n2);
                    break;
                }
                case 'x': {
                    if (list == this.xInputs) break;
                    if (list != null) {
                        n2.clearFlags(28672L);
                        list.remove(n2);
                    }
                    if (n2.getFlags(16L) == 0L) break;
                    n2.clearFlags(28672L);
                    n2.setFlags(16384L);
                    this.xInputs.add(n2);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private boolean wasInP(SimAPI.Node n2, int p) {
        return n2.getFlags(16L) != 0L && n2.getPot() == p;
    }

    private String pValue(String node_name, SimAPI.Node node) {
        char pot = '\u0000';
        switch (node.getPot()) {
            case 0: {
                pot = '0';
                break;
            }
            case 1: {
                pot = 'X';
                break;
            }
            case 2: {
                pot = 'X';
                break;
            }
            case 3: {
                pot = '1';
            }
        }
        return node_name + "=" + pot + " ";
    }

    private String pGValue(SimAPI.Trans t) {
        Collection<SimAPI.Trans> gateList;
        Object infstr = "";
        if (this.irDebug != 0) {
            infstr = (String)infstr + "[" + t.describeState() + "] ";
        }
        if ((gateList = t.getGateList()) != null) {
            infstr = (String)infstr + "(";
            for (SimAPI.Trans tg : gateList) {
                SimAPI.Node n2 = tg.getGate();
                infstr = (String)infstr + this.pValue(n2.getName(), n2);
            }
            infstr = (String)infstr + ") ";
        } else {
            SimAPI.Node n3 = t.getGate();
            infstr = (String)infstr + this.pValue(n3.getName(), n3);
        }
        return infstr;
    }

    private String prOneRes(double r) {
        Object ret = this.formatDouble(r);
        if (r < 1.0E-9 || r > 1.0E11) {
            return ret;
        }
        int e2 = 3;
        if (r >= 1000.0) {
            do {
                ++e2;
            } while ((r *= 0.001) >= 1000.0);
        } else if (r < 1.0 && r > 0.0) {
            do {
                --e2;
            } while ((r *= 1000.0) < 1.0);
        }
        switch (e2) {
            case 0: {
                ret = (String)ret + "n";
                break;
            }
            case 1: {
                ret = (String)ret + "u";
                break;
            }
            case 2: {
                ret = (String)ret + "m";
                break;
            }
            case 4: {
                ret = (String)ret + "K";
                break;
            }
            case 5: {
                ret = (String)ret + "M";
                break;
            }
            case 6: {
                ret = (String)ret + "G";
            }
        }
        return ret;
    }

    private String prTRes(SimAPI.Trans t) {
        double[] resists = t.getResists();
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < resists.length; ++i2) {
            b2.append(i2 == 0 ? "[" : ",").append(this.prOneRes(resists[i2]));
        }
        return b2.append("]").toString();
    }

    private String pTrans(SimAPI.Trans t) {
        String infstr = t.describeBaseType() + " ";
        if (t.getBaseType() != 3) {
            infstr = infstr + this.pGValue(t);
        }
        infstr = infstr + this.pValue(t.getSource().getName(), t.getSource());
        infstr = infstr + this.pValue(t.getDrain().getName(), t.getDrain());
        infstr = infstr + this.prTRes(t);
        if (t.getLink() != t && (this.theSim.getReport() & 8) != 0) {
            infstr = infstr + " <" + t.getX() + "," + t.getY() + ">";
        }
        return infstr;
    }

    private boolean strMatch(String pStr, String sStr) {
        int p = 0;
        int s = 0;
        do {
            if (this.getCh(pStr, p) == 42) {
                while (this.getCh(pStr, ++p) == 42) {
                }
                if (p >= pStr.length()) {
                    return true;
                }
                while (s < sStr.length()) {
                    while (this.getCh(sStr, s) != this.getCh(pStr, p)) {
                        if (++s < sStr.length()) continue;
                        return false;
                    }
                    if (!this.strMatch(pStr.substring(p + 1), sStr.substring(++s))) continue;
                    return true;
                }
                return false;
            }
            if (p < pStr.length()) continue;
            return s >= sStr.length();
        } while (this.getCh(pStr, p++) == this.getCh(sStr, s++));
        return false;
    }

    private int getCh(String s, int index) {
        if (index >= s.length()) {
            return 0;
        }
        return this.gui.canonicChar(s.charAt(index));
    }

    private int chToPot(char ch) {
        String s = "0ux1lUXhLUXH";
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (s.charAt(i2) != ch) continue;
            return i2 & 3;
        }
        System.out.println(ch + ": unknown node value");
        return 4;
    }

    private SimAPI.Node unAlias(SimAPI.Node n2) {
        while (n2.getFlags(4L) != 0L) {
            n2 = n2.getLink();
        }
        return n2;
    }

    private void pnWatchList() {
        this.theSim.printPendingEvents();
    }

    private void setVecNodes(int flag) {
        Collection<IAnalyzer.GuiSignal> sigs = this.gui.getSignals();
        for (IAnalyzer.GuiSignal sig : sigs) {
            SimAPI.Node b2;
            IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
            if (sigsOnBus == null || (b2 = this.nodeMap.get(sig)).getFlags(flag) == 0L) continue;
            for (IAnalyzer.GuiSignal bSig : sigsOnBus) {
                SimAPI.Node bN = this.nodeMap.get(bSig);
                bN.setFlags(flag);
            }
        }
    }

    private int compareVector(SimAPI.Node[] np, String name, int nBits, String mask, String value) {
        if (value.length() != nBits) {
            System.out.println("wrong number of bits for value");
            return 0;
        }
        if (mask != null && mask.length() != nBits) {
            System.out.println("wrong number of bits for mask");
            return 0;
        }
        for (int i2 = 0; i2 < nBits; ++i2) {
            if (mask != null && mask.charAt(i2) != '0') continue;
            SimAPI.Node n2 = np[i2];
            int val = this.chToPot(value.charAt(i2));
            if (val >= 4) {
                return 0;
            }
            if (val == 2) {
                val = 1;
            }
            if (n2.getPot() == val) continue;
            return 1;
        }
        return 0;
    }

    private IAnalyzer.GuiSignal findName(String name) {
        for (IAnalyzer.GuiSignal sig : this.gui.getSignals()) {
            if (!sig.getFullName().equals(name)) continue;
            return sig;
        }
        return null;
    }

    private void dVec(IAnalyzer.GuiSignal sig) {
        IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
        int i2 = sig.getSignalName().length() + 2 + sigsOnBus.length;
        if (this.column + i2 >= 80) {
            this.column = 0;
        }
        this.column += i2;
        Object bits = "";
        for (IAnalyzer.GuiSignal bSig : sigsOnBus) {
            SimAPI.Node n2 = this.nodeMap.get(bSig);
            bits = (String)bits + n2.getPotChar();
        }
        System.out.println(sig.getSignalName() + "=" + (String)bits + " ");
    }

    private long relax(long stopTime) {
        boolean repeat;
        while (repeat = this.theSim.step(stopTime, this.xInputs, this.hInputs, this.lIinputs, this.uInputs)) {
        }
        return this.theSim.getCurDelta() - stopTime;
    }

    private void vecValue(int index) {
        for (Sequence cs : this.xClock) {
            String v = cs.values[index % cs.values.length];
            IAnalyzer.GuiSignal[] sigsOnBus = cs.sig.getBusMembers();
            if (sigsOnBus == null) {
                SimAPI.Node n2 = this.nodeMap.get(cs.sig);
                this.setIn(n2, v.charAt(0));
                continue;
            }
            for (int i2 = 0; i2 < sigsOnBus.length; ++i2) {
                SimAPI.Node n3 = this.nodeMap.get(sigsOnBus[i2]);
                this.setIn(n3, v.charAt(i2));
            }
        }
    }

    private void defSequence(String[] args, List<Sequence> list) {
        if (args.length == 0) {
            list.clear();
            return;
        }
        IAnalyzer.GuiSignal sig = this.findName(args[0]);
        if (sig == null) {
            System.out.println(args[0] + ": No such node or vector");
            return;
        }
        int len = 1;
        IAnalyzer.GuiSignal[] sigsOnBus = sig.getBusMembers();
        if (sigsOnBus != null) {
            len = sigsOnBus.length;
        }
        SimAPI.Node n2 = this.nodeMap.get(sig);
        if (sigsOnBus == null && (n2 = this.unAlias(n2)).getFlags(1024L) != 0L) {
            System.out.println(n2.getName() + " can't be part of a sequence");
            return;
        }
        if (args.length == 1) {
            list.remove(sig);
            return;
        }
        for (int i2 = 1; i2 < args.length; ++i2) {
            if (args[i2].length() == len) continue;
            System.out.println("value \"" + args[i2] + "\" is not compatible with size of " + args[0] + " (" + len + ")");
            return;
        }
        Sequence s = new Sequence();
        s.values = new String[args.length - 1];
        s.sig = sig;
        this.nodeMap.put(sig, n2);
        for (int i3 = 1; i3 < args.length; ++i3) {
            StringBuffer sb = new StringBuffer();
            for (int p = 0; p < args[i3].length(); ++p) {
                sb.append(potChars.charAt(this.chToPot(args[i3].charAt(p))));
            }
            s.values[i3 - 1] = sb.toString();
        }
        list.remove(sig);
        list.add(s);
    }

    private boolean stepPhase() {
        this.vecValue(this.whichPhase++);
        return this.relax(this.theSim.getCurDelta() + this.stepSize) != 0L;
    }

    private boolean clockIt(int n2) {
        int i2 = 0;
        if (this.xClock.size() == 0) {
            System.out.println("no clock nodes defined!");
            return false;
        }
        boolean interrupted = false;
        for (int cycle = 0; cycle < n2; ++cycle) {
            for (i2 = 0; i2 < this.maxClock; ++i2) {
                if (!this.stepPhase()) continue;
                interrupted = true;
                break;
            }
            if (interrupted) break;
        }
        this.pnWatchList();
        return interrupted;
    }

    private void cPath(SimAPI.Node n2, int level) {
        if (n2.getFlags(1024L) != 0L || n2.getCause() == null) {
            System.out.println("  there is no previous transition!");
        } else if (level != 0 && n2.getTime() > pTime) {
            System.out.println("  transition of " + n2.getName() + ", which has since changed again");
        } else if (n2.getCause() == n2) {
            System.out.println("  " + n2.getName() + " . " + n2.getPotChar() + " @ " + Analyzer.deltaToNS(n2.getTime()) + "ns , node was an input");
        } else if (n2.getCause().getFlags(512L) != 0L) {
            System.out.println("  ... loop in traceback");
        } else {
            long deltaT = n2.getTime() - n2.getCause().getTime();
            n2.setFlags(512L);
            pTime = n2.getTime();
            this.cPath(n2.getCause(), level + 1);
            n2.clearFlags(512L);
            if (deltaT < 0L) {
                System.out.println("  " + n2.getName() + " . " + n2.getPotChar() + " @ " + Analyzer.deltaToNS(n2.getTime()) + "ns   (??)");
            } else {
                System.out.println("  " + n2.getName() + " . " + n2.getPotChar() + " @ " + Analyzer.deltaToNS(n2.getTime()) + "ns   (" + Analyzer.deltaToNS(deltaT) + "ns)");
            }
        }
    }

    private void clearInputs() {
        for (int i2 = 0; i2 < 5; ++i2) {
            if (this.listTbl[i2] == null) continue;
            for (SimAPI.Node n2 : this.listTbl[i2]) {
                if (n2.getFlags(2L) != 0L) continue;
                n2.clearFlags(28688L);
            }
            this.listTbl[i2].clear();
        }
        for (SimAPI.Node n3 : this.theSim.getNodes()) {
            if (n3.getFlags(2L) != 0L) continue;
            n3.clearFlags(16L);
        }
    }

    @Override
    public String canonicString(String s) {
        return this.gui.canonicString(s);
    }

    @Override
    public double atof(String text) {
        return this.gui.atof(text);
    }

    @Override
    public int atoi(String text) {
        return this.gui.atoi(text);
    }

    @Override
    public String formatDouble(double v) {
        return this.gui.formatDouble(v);
    }

    private static double deltaToNS(long d2) {
        return (double)d2 / 1000.0;
    }

    private static long nsToDelta(double d2) {
        return (long)(d2 * 1000.0);
    }

    private static int inputNumber(int flg) {
        return (flg & 0x7000) >> 12;
    }

    private static class SimVector {
        int command;
        String[] parameters;
        List<IAnalyzer.GuiSignal> sigs;
        List<IAnalyzer.GuiSignal> sigsNegated;
        double value;
        SimVector next;

        private SimVector() {
        }
    }

    private static class Sequence {
        IAnalyzer.GuiSignal sig;
        String[] values;

        private Sequence() {
        }
    }

    public class AssertWhen
    implements Runnable {
        SimAPI.Node node;
        char val;
        AssertWhen nxt;

        @Override
        public void run() {
            Analyzer.this.evalAssertWhen(this.node);
        }
    }
}

