/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.JMF;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;

class JMFImageToMovie
implements ControllerListener,
DataSinkListener {
    MediaLocator outML;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public JMFImageToMovie(String movieName) {
        this.outML = JMFImageToMovie.createMediaLocator(movieName);
        if (this.outML == null) {
            System.err.println("Cannot build media locator from: " + movieName);
            System.exit(0);
        }
    }

    public boolean doIt(int width, int height, int frameRate, List inFiles) {
        Processor p;
        ImageDataSource ids = new ImageDataSource(width, height, frameRate, inFiles);
        try {
            System.err.println("- create processor for the image datasource ...");
            p = Manager.createProcessor(ids);
        }
        catch (Exception e2) {
            System.err.println("Yikes!  Cannot create a processor from the data source.");
            return false;
        }
        p.addControllerListener(this);
        p.configure();
        if (!this.waitForState(p, 180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        p.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] tcs = p.getTrackControls();
        Format[] f2 = tcs[0].getSupportedFormats();
        if (f2 == null || f2.length <= 0) {
            System.err.println("The mux does not support the input format: " + String.valueOf(tcs[0].getFormat()));
            return false;
        }
        tcs[0].setFormat(f2[0]);
        System.err.println("Setting the track format to: " + String.valueOf(f2[0]));
        p.realize();
        if (!this.waitForState(p, 300)) {
            System.err.println("Failed to realize the processor.");
            return false;
        }
        DataSink dsink = this.createDataSink(p, this.outML);
        if (dsink == null) {
            System.err.println("Failed to create a DataSink for the given output MediaLocator: " + String.valueOf(this.outML));
            return false;
        }
        dsink.addDataSinkListener(this);
        this.fileDone = false;
        System.err.println("start processing...");
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e3) {
            System.err.println("IO error during processing");
            return false;
        }
        this.waitForFileDone();
        try {
            dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.removeControllerListener(this);
        System.err.println("...done processing.");
        return true;
    }

    public static void createMovie(String filename, Dimension dim, List inputFiles) {
        JMFImageToMovie imageToMovie = new JMFImageToMovie(filename);
        imageToMovie.doIt(dim.width, dim.height, 1, inputFiles);
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println("Something is really wrong: the processor does not have an output DataSource");
            return null;
        }
        try {
            System.err.println("- create DataSink for: " + String.valueOf(outML));
            dsink = Manager.createDataSink(ds, outML);
            dsink.open();
        }
        catch (Exception e2) {
            System.err.println("Cannot create the DataSink: " + String.valueOf(e2));
            return null;
        }
        return dsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JMFImageToMovie.prUsage();
        }
        int width = -1;
        int height = -1;
        int frameRate = 1;
        Vector<String> inputFiles = new Vector<String>();
        String outputURL = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-w")) {
                if (++i2 >= args.length) {
                    JMFImageToMovie.prUsage();
                }
                width = Integer.parseInt(args[i2]);
                continue;
            }
            if (args[i2].equals("-h")) {
                if (++i2 >= args.length) {
                    JMFImageToMovie.prUsage();
                }
                height = Integer.parseInt(args[i2]);
                continue;
            }
            if (args[i2].equals("-f")) {
                if (++i2 >= args.length) {
                    JMFImageToMovie.prUsage();
                }
                frameRate = Integer.parseInt(args[i2]);
                continue;
            }
            if (args[i2].equals("-o")) {
                if (++i2 >= args.length) {
                    JMFImageToMovie.prUsage();
                }
                outputURL = args[i2];
                continue;
            }
            inputFiles.addElement(args[i2]);
        }
        if (outputURL == null || inputFiles.size() == 0) {
            JMFImageToMovie.prUsage();
        }
        if (!outputURL.endsWith(".mov") && !outputURL.endsWith(".MOV")) {
            System.err.println("The output file extension should end with a .mov extension");
            JMFImageToMovie.prUsage();
        }
        if (width < 0 || height < 0) {
            System.err.println("Please specify the correct image size.");
            JMFImageToMovie.prUsage();
        }
        if (frameRate < 1) {
            frameRate = 1;
        }
        if (JMFImageToMovie.createMediaLocator(outputURL) == null) {
            System.err.println("Cannot build media locator from: " + outputURL);
            System.exit(0);
        }
        JMFImageToMovie imageToMovie = new JMFImageToMovie(null);
        imageToMovie.doIt(width, height, frameRate, inputFiles);
        System.exit(0);
    }

    static void prUsage() {
        System.err.println("Usage: java JpegImagesToMovie -w <width> -h <height> -f <frame rate> -o <output URL> <input JPEG file 1> <input JPEG file 2> ...");
        System.exit(-1);
    }

    static MediaLocator createMediaLocator(String url) {
        String file;
        MediaLocator ml;
        if (url.indexOf(":") > 0 && (ml = new MediaLocator(url)) != null) {
            return ml;
        }
        if (url.startsWith(File.separator) ? (ml = new MediaLocator("file:" + url)) != null : (ml = new MediaLocator(file = "file:" + System.getProperty("user.dir") + File.separator + url)) != null) {
            return ml;
        }
        return null;
    }

    class ImageDataSource
    extends PullBufferDataSource {
        ImageSourceStream[] streams = new ImageSourceStream[1];

        ImageDataSource(int width, int height, int frameRate, List images) {
            this.streams[0] = new ImageSourceStream(width, height, frameRate, images);
        }

        @Override
        public void setLocator(MediaLocator source) {
        }

        @Override
        public MediaLocator getLocator() {
            return null;
        }

        @Override
        public String getContentType() {
            return "raw";
        }

        @Override
        public void connect() {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public PullBufferStream[] getStreams() {
            return this.streams;
        }

        @Override
        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        @Override
        public Object[] getControls() {
            return new Object[0];
        }

        @Override
        public Object getControl(String type) {
            return null;
        }
    }

    class ImageSourceStream
    implements PullBufferStream {
        List images;
        int width;
        int height;
        VideoFormat format;
        int nextImage = 0;
        boolean ended = false;

        public ImageSourceStream(int width, int height, int frameRate, List images) {
            this.width = width;
            this.height = height;
            this.images = images;
            this.format = new VideoFormat("jpeg", new Dimension(width, height), -1, Format.byteArray, frameRate);
        }

        @Override
        public boolean willReadBlock() {
            return false;
        }

        @Override
        public void read(Buffer buf) throws IOException {
            if (this.nextImage >= this.images.size()) {
                System.err.println("Done reading all images.");
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.ended = true;
                return;
            }
            String imageFileName = (String)this.images.get(this.nextImage);
            ++this.nextImage;
            System.err.println("  - reading image file: " + imageFileName);
            File file = new File(imageFileName);
            RandomAccessFile raFile = new RandomAccessFile(file, "r");
            byte[] data = null;
            if (buf.getData() instanceof byte[]) {
                data = (byte[])buf.getData();
            }
            if (data == null || (long)data.length < raFile.length()) {
                data = new byte[(int)raFile.length()];
                buf.setData(data);
            }
            raFile.readFully(data, 0, (int)raFile.length());
            System.out.println("    read " + raFile.length() + " bytes.");
            buf.setOffset(0);
            buf.setLength((int)raFile.length());
            buf.setFormat(this.format);
            buf.setFlags(buf.getFlags() | 0x10);
            raFile.close();
            file.delete();
        }

        @Override
        public Format getFormat() {
            return this.format;
        }

        @Override
        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        @Override
        public long getContentLength() {
            return 0L;
        }

        @Override
        public boolean endOfStream() {
            return this.ended;
        }

        @Override
        public Object[] getControls() {
            return new Object[0];
        }

        @Override
        public Object getControl(String type) {
            return null;
        }
    }
}

