/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.lang.EvalSpice;
import com.sun.electric.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VarContext
implements Serializable {
    private static final Object FAST_EVAL_FAILED = new Object();
    private final VarContext prev;
    private final Cell cell;
    private final int nodeId;
    private Nodable ni;
    private transient ValueCache cache;
    public static final VarContext globalContext = new VarContext();
    private static final Pattern pPat = Pattern.compile("P\\(\"(\\w+)\"\\)");

    private VarContext() {
        this.cell = null;
        this.nodeId = -1;
        this.prev = this;
        this.cache = null;
    }

    private VarContext(Nodable ni, VarContext prev, boolean caching) {
        this.cell = ni.getParent();
        this.nodeId = ni instanceof NodeInst ? ((NodeInst)ni).getNodeId() : -1;
        this.ni = ni;
        this.prev = prev;
        this.cache = caching ? new ValueCache() : null;
    }

    private VarContext(Cell cell, ImmutableNodeInst n2, VarContext prev) {
        if (cell == null) {
            throw new NullPointerException();
        }
        if (n2 == null) {
            throw new NullPointerException();
        }
        this.cell = cell;
        this.nodeId = n2.nodeId;
        this.prev = prev;
        this.cache = null;
    }

    private Object readResolve() {
        return this.prev != this ? this : globalContext;
    }

    private void throwNotFound(String name) throws EvalException {
        throw new EvalException(name.replaceFirst("ATTR_", "") + " not found");
    }

    private Object ifNotNumberTryToConvertToNumber(Object val) {
        if (val == null) {
            return val;
        }
        if (val instanceof Number) {
            return val;
        }
        try {
            Number d2 = TextUtils.parsePostFixNumber(val.toString(), null);
            val = d2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    private String getSimpleVarRef(String expr2) {
        String pOpen = "P(\"";
        int pOpenLen = "P(\"".length();
        String pClose = "\")";
        int pCloseLen = "\")".length();
        if (expr2.startsWith("P(\"") && expr2.endsWith("\")")) {
            String varNm = expr2.substring(pOpenLen, expr2.length() - pCloseLen);
            return this.isValidIdentifier(varNm) ? varNm : null;
        }
        if (expr2.startsWith("@")) {
            String varNm = expr2.substring(1);
            return this.isValidIdentifier(varNm) ? varNm : null;
        }
        return null;
    }

    private boolean isValidIdentifier(String identifier) {
        int len = identifier.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (TextUtils.isLetterOrDigit(identifier.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fastJavaVarEval(CodeExpression ce, Object info) throws EvalException {
        VarContext varContext = this;
        synchronized (varContext) {
            if (this.cache != null && this.cache.containsKey(ce, info)) {
                return this.cache.get(ce, info);
            }
        }
        String expr2 = ce.getExpr();
        String varNm = this.getSimpleVarRef(expr2);
        if (varNm == null) {
            return FAST_EVAL_FAILED;
        }
        return this.lookupVarEval("ATTR_" + varNm);
    }

    public VarContext push(Nodable ni) {
        return new VarContext(ni, this, false);
    }

    public VarContext pushCaching(Nodable ni) {
        return new VarContext(ni, this, true);
    }

    public VarContext push(Cell cell, ImmutableNodeInst n2) {
        return new VarContext(cell, n2, this);
    }

    public VarContext pop() {
        return this.prev;
    }

    public Nodable getNodable() {
        if (this.ni == null && this.nodeId >= 0) {
            this.ni = this.cell.getNodeById(this.nodeId);
        }
        return this.ni;
    }

    public Nodable getNodableOptional() {
        return this.ni;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof VarContext)) {
            return false;
        }
        VarContext c2 = (VarContext)o2;
        if (this == c2) {
            return true;
        }
        Cell c1 = this.cell;
        Cell c22 = c2.cell;
        if (c1 == null || c22 == null) {
            return c1 == c22;
        }
        String name1 = this.getNodable().getName();
        String name2 = c2.getNodable().getName();
        if (c1 != c22 || !name1.equals(name2)) {
            return false;
        }
        return this.prev.equals(c2.pop());
    }

    public Iterator<Nodable> getPathIterator() {
        Stack<Nodable> stack = new Stack<Nodable>();
        for (VarContext context = this; context != globalContext; context = context.pop()) {
            Nodable no = context.getNodable();
            stack.push(no);
        }
        ArrayList<Nodable> path = new ArrayList<Nodable>();
        while (!stack.isEmpty()) {
            path.add((Nodable)stack.pop());
        }
        return path.iterator();
    }

    public VarContext removeParentContext(int levels) {
        VarContext acontext;
        Stack<Nodable> nodes = new Stack<Nodable>();
        for (acontext = this; acontext != globalContext; acontext = acontext.pop()) {
            nodes.push(acontext.getNodable());
        }
        for (int i2 = 0; i2 < levels; ++i2) {
            nodes.pop();
        }
        acontext = globalContext;
        int size = nodes.size();
        for (int i3 = 0; i3 < size; ++i3) {
            Nodable no = (Nodable)nodes.pop();
            acontext = acontext.push(no);
        }
        return acontext;
    }

    public int getNumLevels() {
        int i2 = 0;
        for (VarContext acontext = this; acontext != globalContext; acontext = acontext.pop()) {
            ++i2;
        }
        return i2;
    }

    public synchronized void deleteVariableCache() {
        this.cache = null;
    }

    public Object evalVar(Variable var) {
        return this.evalVar(var, null);
    }

    public Object evalVar(Variable var, Object info) {
        if (var == null) {
            return null;
        }
        try {
            return this.evalVarRecurse(var, info);
        }
        catch (EvalException e2) {
            VarContext.printException(e2, var, this, info);
            return null;
        }
    }

    public static void printException(EvalException e2, Variable var, VarContext context, Object info) {
        if (e2.getCause() == null) {
            return;
        }
        String msg = "Exception caught evaluating " + String.valueOf((Object)var.getCode()) + " var " + var.getTrueName() + (String)(e2.getMessage() == null ? "" : ": " + e2.getMessage());
        if (info instanceof Nodable) {
            NodeInst ni = ((Nodable)info).getNodeInst();
            System.out.println("In Cell " + ni.getParent().describe(false) + ", on Node " + ni.describe(false) + ": " + msg);
        } else {
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalVarRecurse(Variable var, Object info) throws EvalException {
        CodeExpression ce = var.getCodeExpression();
        if (ce == null) {
            return this.ifNotNumberTryToConvertToNumber(var.getObject());
        }
        switch (ce.getCode()) {
            case JAVA: {
                Object value = this.fastJavaVarEval(ce, info);
                if (value == FAST_EVAL_FAILED) {
                    value = EvalJavaBsh.evalJavaBsh.evalVarObject(ce, this, info);
                    VarContext varContext = this;
                    synchronized (varContext) {
                        if (this.cache != null) {
                            this.cache.put(ce, info, value);
                        }
                    }
                }
                return this.ifNotNumberTryToConvertToNumber(value);
            }
            case SPICE: {
                Number n2;
                Object obj = this.evalSpice_(ce, true);
                if (obj instanceof Number && (n2 = (Number)obj).doubleValue() < 0.001) {
                    return TextUtils.formatDoublePostFix(n2.doubleValue());
                }
                if (obj instanceof EvalSpice.SimpleEq) {
                    return ce.getExpr();
                }
                return obj;
            }
            case TCL: {
                return this.ifNotNumberTryToConvertToNumber(ce.getExpr());
            }
        }
        throw new AssertionError();
    }

    public Object evalSpice(Variable var, boolean recurse) {
        try {
            return this.evalSpice_(var.getCodeExpression(), recurse);
        }
        catch (EvalException e2) {
            return null;
        }
    }

    private Object evalSpice_(CodeExpression ce, boolean recurse) throws EvalException {
        assert (ce.getCode() == CodeExpression.Code.SPICE);
        String expr2 = EvalJavaBsh.replace(ce.getExpr());
        Matcher pMat = pPat.matcher(expr2);
        StringBuffer sb = new StringBuffer();
        while (pMat.find()) {
            Object value = pMat.group(1).substring(5);
            Variable parentVar = null;
            Nodable no = this.getNodable();
            if (no != null) {
                parentVar = no.getParameter(Variable.findKey(pMat.group(1)));
            }
            if (parentVar != null) {
                boolean isSpiceCode;
                boolean bl = isSpiceCode = parentVar.getCode() == CodeExpression.Code.SPICE;
                if ((recurse || !isSpiceCode) && (value = this.pop().evalVarRecurse(parentVar, this.getNodable())) == null) {
                    value = "";
                }
            }
            pMat.appendReplacement(sb, value.toString());
        }
        pMat.appendTail(sb);
        EvalSpice sp = new EvalSpice(sb.toString());
        return sp.evaluate();
    }

    public Object lookupVarEval(String name) throws EvalException {
        Object val;
        Variable var;
        Variable.Key key;
        Nodable ni = this.getNodable();
        if (ni == null) {
            this.throwNotFound(name);
        }
        if ((key = Variable.findKey(name)) == null) {
            this.throwNotFound(name);
        }
        if ((var = ni.getParameter(key)) == null) {
            this.throwNotFound(name);
        }
        if ((val = this.pop().evalVarRecurse(var, ni)) == null) {
            this.throwNotFound(name);
        }
        if ((val = this.ifNotNumberTryToConvertToNumber(val)) == null) {
            this.throwNotFound(name);
        }
        return val;
    }

    public String getInstPath(String sep) {
        if (this == globalContext) {
            return "";
        }
        String prefix = this.pop() == globalContext ? "" : this.pop().getInstPath(sep);
        Nodable no = this.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        String me = no.getName();
        if (no instanceof NodeInst) {
            Name name = no.getNameKey();
            me = name.subname(0).toString();
        }
        if (prefix.equals("")) {
            return me;
        }
        return prefix + sep + me;
    }

    public static float objectToFloat(Object obj, float def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        try {
            Number n2 = TextUtils.parsePostFixNumber(obj.toString(), null);
            return n2.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static int objectToInt(Object obj, int def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            Number n2 = TextUtils.parsePostFixNumber(obj.toString(), null);
            return n2.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static short objectToShort(Object obj, short def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        try {
            Number n2 = TextUtils.parsePostFixNumber(obj.toString(), null);
            return n2.shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static double objectToDouble(Object obj, double def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            Number n2 = TextUtils.parsePostFixNumber(obj.toString(), null);
            return n2.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private static class ValueCache {
        private final Map<EvalPair, Object> cache = new HashMap<EvalPair, Object>();

        private ValueCache() {
        }

        public synchronized boolean containsKey(CodeExpression ce, Object info) {
            return this.cache.containsKey(new EvalPair(ce, info));
        }

        public synchronized Object get(CodeExpression ce, Object info) {
            return this.cache.get(new EvalPair(ce, info));
        }

        public synchronized void put(CodeExpression ce, Object info, Object value) {
            EvalPair key = new EvalPair(ce, info);
            Job.error(this.cache.containsKey(key), "duplicate keys in ValueCache?");
            this.cache.put(key, value);
        }

        private static class EvalPair {
            private final CodeExpression ce;
            private final Object info;

            public EvalPair(CodeExpression e2, Object i2) {
                this.ce = e2;
                this.info = i2;
            }

            public int hashCode() {
                return this.ce.hashCode() * this.info.hashCode();
            }

            public boolean equals(Object o2) {
                if (!(o2 instanceof EvalPair)) {
                    return false;
                }
                EvalPair ep = (EvalPair)o2;
                return this.ce == ep.ce && this.info == ep.info;
            }
        }
    }

    public static class EvalException
    extends Exception {
        public EvalException() {
        }

        public EvalException(String message) {
            super(message);
        }

        public EvalException(String message, Throwable cause) {
            super(message, cause);
        }

        public EvalException(Throwable cause) {
            super(cause);
        }
    }
}

