/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.util.collections.ArrayIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class IconNodeInst
extends NodeInst {
    private IconNodable[] nodables;

    IconNodeInst(ImmutableNodeInst d2, Topology topology) {
        super(d2, topology);
    }

    @Override
    public ImmutableIconInst getD() {
        return (ImmutableIconInst)super.getD();
    }

    @Override
    public boolean setD(ImmutableNodeInst newD, boolean notify) {
        ImmutableIconInst oldD = this.getD();
        if (newD.name != oldD.name) {
            this.nodables = null;
        }
        return super.setD(newD, notify);
    }

    @Override
    public void setDInUndo(ImmutableNodeInst newD) {
        ImmutableIconInst oldD = this.getD();
        if (newD.name != oldD.name) {
            this.nodables = null;
        }
        super.setDInUndo(newD);
    }

    @Override
    public Cell getProto() {
        return (Cell)super.getProto();
    }

    @Override
    public void addVar(Variable var) {
        if (this.isParam(var.getKey())) {
            throw new IllegalArgumentException(String.valueOf(this) + " already has a variable with name " + String.valueOf(var));
        }
        super.addVar(var.withParam(false).withInherit(false));
    }

    @Override
    public Variable getVar(Variable.Key key) {
        Variable param;
        this.checkExamine();
        if (key.isAttribute() && (param = this.getParameter((Variable.AttrKey)key)) != null) {
            return param;
        }
        return this.getD().getVar(key);
    }

    @Override
    public Variable getParameterOrVariable(Variable.Key key) {
        Variable param;
        this.checkExamine();
        if (key.isAttribute() && (param = this.getParameter((Variable.AttrKey)key)) != null) {
            return param;
        }
        return this.getD().getVar(key);
    }

    @Override
    public Iterator<Variable> getParametersAndVariables() {
        if (this.getD().getNumDefinedParameters() == 0) {
            return this.getVariables();
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Iterator<Variable> it = this.getDefinedParameters();
        while (it.hasNext()) {
            vars.add(it.next());
        }
        it = this.getVariables();
        while (it.hasNext()) {
            vars.add(it.next());
        }
        return vars.iterator();
    }

    @Override
    public Variable getParameter(Variable.Key key) {
        if (!(key instanceof Variable.AttrKey)) {
            return null;
        }
        Variable instParam = this.getD().getDefinedParameter((Variable.AttrKey)key);
        if (instParam != null) {
            return instParam;
        }
        Cell icon = this.getProto();
        Variable iconParam = icon.getParameter(key);
        return iconParam != null ? IconNodeInst.composeInstParam(iconParam, null) : null;
    }

    @Override
    public boolean isDefinedParameter(Variable.Key key) {
        if (!(key instanceof Variable.AttrKey)) {
            return false;
        }
        return this.getD().getDefinedParameter((Variable.AttrKey)key) != null;
    }

    @Override
    public Iterator<Variable> getParameters() {
        Cell icon = this.getProto();
        if (!icon.hasParameters()) {
            return ArrayIterator.emptyIterator();
        }
        ArrayList<Variable> params = new ArrayList<Variable>();
        Iterator<Variable> it = icon.getParameters();
        while (it.hasNext()) {
            Variable iconParam = it.next();
            Variable instVar = this.getD().getDefinedParameter((Variable.AttrKey)iconParam.getKey());
            params.add(IconNodeInst.composeInstParam(iconParam, instVar));
        }
        return params.iterator();
    }

    @Override
    public Iterator<Variable> getDefinedParameters() {
        return this.getD().getDefinedParameters();
    }

    @Override
    public void addParameter(Variable param) {
        if (!this.isParam(param.getKey())) {
            throw new IllegalArgumentException("Parameter " + String.valueOf(param) + " is not defined on " + String.valueOf(this.getProto()));
        }
        Cell icon = this.getProto();
        Variable iconParam = icon.getParameter(param.getKey());
        param = IconNodeInst.composeInstParam(iconParam, param);
        if (this.setD(this.getD().withParam(param), true)) {
            this.checkPossibleVariableEffects(param.getKey());
        }
    }

    @Override
    public void delParameter(Variable.Key key) {
        if (key instanceof Variable.AttrKey && this.setD(this.getD().withoutParam((Variable.AttrKey)key), true)) {
            this.checkPossibleVariableEffects(key);
        }
    }

    @Override
    public boolean isParam(Variable.Key varKey) {
        Cell icon = this.getProto();
        return icon.isParam(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        Variable param = this.getParameter(varKey);
        if (param != null) {
            td = td.withParam(true).withInherit(false).withUnit(param.getUnit());
            this.addParameter(param.withTextDescriptor(td));
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public Variable newVar(Variable.Key key, Object value, TextDescriptor td) {
        if (this.isParam(key)) {
            this.addParameter(this.getParameter(key).withObject(value).withTextDescriptor(td));
            return this.getParameter(key);
        }
        return super.newVar(key, value, td);
    }

    @Override
    public Variable updateVar(Variable.Key key, Object value, EditingPreferences ep) {
        if (this.isParam(key)) {
            this.getParameter(key);
            this.addParameter(this.getParameter(key).withObject(value));
            return this.getParameter(key);
        }
        return super.updateVar(key, value, ep);
    }

    @Override
    public Variable updateParam(Variable.Key key, Object value, EditingPreferences ep) {
        if (this.isParam(key)) {
            this.getParameter(key);
            this.addParameter(this.getParameter(key).withObject(value));
            return this.getParameter(key);
        }
        return super.updateVar(key, value, ep);
    }

    @Override
    public Variable updateVarText(Variable.Key key, String text, EditingPreferences ep) {
        if (this.isParam(key)) {
            this.getParameter(key);
            this.addParameter(this.getParameter(key).withText(text));
            return this.getParameter(key);
        }
        return super.updateVarText(key, text, ep);
    }

    @Override
    public Variable updateVarCode(Variable.Key key, CodeExpression.Code code) {
        if (this.isParam(key)) {
            this.getParameter(key);
            this.addParameter(this.getParameter(key).withCode(code));
            return this.getParameter(key);
        }
        return super.updateVarCode(key, code);
    }

    @Override
    public void copyVarsFrom(NodeInst other) {
        this.checkChanging();
        Iterator<Variable> it = other.getParametersAndVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (this.isParam(var.getKey())) {
                this.addParameter(var.withParam(true));
                continue;
            }
            this.addVar(var.withParam(false));
        }
    }

    private static Variable composeInstParam(Variable iconParam, Variable instVar) {
        boolean display;
        boolean bl = display = !iconParam.isInterior();
        if (instVar != null) {
            return instVar.withParam(true).withInherit(false).withInterior(false).withDisplay(display).withUnit(iconParam.getUnit());
        }
        return iconParam.withInherit(false).withInterior(false).withDisplay(display);
    }

    @Override
    public Nodable[] getNodables() {
        if (this.nodables == null) {
            Cell parent = this.getParent();
            if (parent != null && !parent.isIcon() && !parent.isSchematic()) {
                return new Nodable[]{this};
            }
            if (this.isIconOfParent()) {
                return new Nodable[0];
            }
            this.nodables = new IconNodable[this.getNameKey().busWidth()];
            for (int i2 = 0; i2 < this.nodables.length; ++i2) {
                this.nodables[i2] = new IconNodable(i2);
            }
        }
        return (Nodable[])this.nodables.clone();
    }

    @Override
    public int getNumNodables() {
        if (this.nodables == null) {
            Cell parent = this.getParent();
            if (parent != null && !this.getParent().isIcon() && !this.getParent().isSchematic()) {
                return 1;
            }
            if (this.isIconOfParent()) {
                return 0;
            }
            this.nodables = new IconNodable[this.getNameKey().busWidth()];
            for (int i2 = 0; i2 < this.nodables.length; ++i2) {
                this.nodables[i2] = new IconNodable(i2);
            }
        }
        return this.nodables.length;
    }

    @Override
    public Nodable getNodable(int arrayIndex) {
        if (this.nodables == null) {
            Cell parent = this.getParent();
            if (parent != null && !this.getParent().isIcon() && !this.getParent().isSchematic()) {
                if (arrayIndex != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this;
            }
            if (this.isIconOfParent()) {
                throw new IndexOutOfBoundsException();
            }
            this.nodables = new IconNodable[this.getNameKey().busWidth()];
            for (int i2 = 0; i2 < this.nodables.length; ++i2) {
                this.nodables[i2] = new IconNodable(i2);
            }
        }
        return this.nodables[arrayIndex];
    }

    private class IconNodable
    implements Nodable {
        int arrayIndex;

        IconNodable(int arrayIndex) {
            this.arrayIndex = arrayIndex;
        }

        @Override
        public NodeProto getProto() {
            Cell iconCell = IconNodeInst.this.getProto();
            Cell mainSchematics = iconCell.getMainSchematicInGroup();
            return mainSchematics != null ? mainSchematics : iconCell;
        }

        @Override
        public boolean isCellInstance() {
            return true;
        }

        @Override
        public Cell getParent() {
            return IconNodeInst.this.getParent();
        }

        @Override
        public String getName() {
            return this.getNameKey().toString();
        }

        @Override
        public Name getNameKey() {
            return IconNodeInst.this.getNameKey().subname(this.arrayIndex);
        }

        @Override
        public Variable getVar(Variable.Key key) {
            return IconNodeInst.this.getVar(key);
        }

        @Override
        public Variable getParameter(Variable.Key key) {
            return IconNodeInst.this.getParameter(key);
        }

        @Override
        public Variable getParameterOrVariable(Variable.Key key) {
            return IconNodeInst.this.getParameterOrVariable(key);
        }

        @Override
        public boolean isDefinedParameter(Variable.Key key) {
            return IconNodeInst.this.isDefinedParameter(key);
        }

        @Override
        public Iterator<Variable> getParameters() {
            return IconNodeInst.this.getParameters();
        }

        @Override
        public Iterator<Variable> getDefinedParameters() {
            return IconNodeInst.this.getDefinedParameters();
        }

        @Override
        public String toString() {
            return "IconNodable " + this.getName();
        }

        @Override
        public boolean contains(NodeInst ni, int arrayIndex) {
            return IconNodeInst.this == ni && this.arrayIndex == arrayIndex;
        }

        @Override
        public NodeInst getNodeInst() {
            return IconNodeInst.this;
        }

        @Override
        public int getNodableArrayIndex() {
            return this.arrayIndex;
        }
    }
}

