/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.ElectricObject;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public abstract class Geometric
extends ElectricObject
implements RTBounds {
    protected Geometric() {
    }

    public abstract String describe(boolean var1);

    public int whichMultiPage() {
        int pageNo = 0;
        if (this.getParent().isMultiPage()) {
            double cY = this.getBounds().getCenterY();
            pageNo = (int)((cY + 500.0) / 1000.0);
        }
        return pageNo;
    }

    @Override
    public void getInfo() {
        ERectangle visBounds = this.getBounds();
        System.out.println(" Bounds: (" + ((RectangularShape)visBounds).getCenterX() + "," + ((RectangularShape)visBounds).getCenterY() + "), size: " + ((RectangularShape)visBounds).getWidth() + "x" + ((RectangularShape)visBounds).getHeight());
        System.out.println(" Parent: " + String.valueOf(this.getParent()));
        super.getInfo();
    }

    public Cell getParent() {
        Topology topology = this.getTopology();
        return topology != null ? topology.cell : null;
    }

    public abstract Topology getTopology();

    public abstract Iterator<Poly> getShape(Poly.Builder var1);

    @Override
    public abstract ERectangle getBounds();

    public double getTrueCenterX() {
        return this.getBounds().getCenterX();
    }

    public double getTrueCenterY() {
        return this.getBounds().getCenterY();
    }

    public Point2D getTrueCenter() {
        return new Point2D.Double(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public abstract boolean isConnected(Geometric var1);
}

