/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.Main;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.EmptyPreferencesFactory;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.util.ClientOS;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXParseException;

public class Pref {
    public static final boolean FROM_THREAD_ENVIRONMENT = false;
    private static boolean forbidPreferences;
    private final String name;
    private final Group group;
    private final boolean serverAccessible;
    private Object cachedObj;
    private Object factoryObj;
    private static final ArrayList<Group> allGroups;
    private static boolean doFlushing;
    private static Set<Preferences> queueForFlushing;
    private static boolean lockCreation;
    private static final HashSet<Pref> reportedAccess;
    private static Map<String, String> keyNameAbbreviation;

    public static Group groupForPackage(Class classFromPackage) {
        String mainClassName;
        String className = classFromPackage.getName();
        if (!className.startsWith(mainClassName = "com.sun.electric.")) {
            throw new IllegalArgumentException("Class is not in Electric tree");
        }
        className = className.substring(mainClassName.length());
        int pkgEndIndex = className.lastIndexOf(46);
        String packageName = className.substring(0, pkgEndIndex);
        return Pref.groupForPackage(packageName.replace('.', '/'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group groupForPackage(String relativePath) {
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                if (!group.relativePath.equals(relativePath)) continue;
                return group;
            }
            Group newGroup = new Group(relativePath);
            allGroups.add(newGroup);
            return newGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pref(Group group, String name, boolean serverAccessible, Object factoryObj) {
        if (lockCreation && serverAccessible) {
            throw new IllegalStateException("Pref " + group.relativePath() + "/" + name + " is created from improper place");
        }
        this.name = name;
        this.group = group;
        this.serverAccessible = serverAccessible;
        this.factoryObj = factoryObj;
        TreeMap<String, Pref> treeMap = group.prefs;
        synchronized (treeMap) {
            if (Job.getDebug() && group.prefs.containsKey(name)) {
                System.out.println("Repeated Preference '" + name + "'");
            }
            assert (!group.prefs.containsKey(name));
            group.prefs.put(name, this);
        }
    }

    public static void lockCreation() {
        lockCreation = true;
    }

    public static void lockCreation(Map<String, Object> initMap) {
        Pref.setCachedObjsFromMap(initMap);
        lockCreation = true;
    }

    public static void forbidPreferences() {
        System.setProperty("java.util.prefs.PreferencesFactory", "com.sun.electric.database.text.EmptyPreferencesFactory");
        forbidPreferences = true;
    }

    public static void allowPreferences() {
        forbidPreferences = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCachedObjsFromPreferences() {
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                group.setCachedObjsFromPreferences();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCachedObjsFromMap(Map<String, Object> initMap) {
        ArrayList<Group> arrayList = allGroups;
        synchronized (arrayList) {
            for (Group group : allGroups) {
                group.setCachedObjFromMap(initMap);
            }
        }
    }

    public static void importPrefs(URL fileURL) {
        try {
            URLConnection urlCon = fileURL.openConnection();
            InputStream inputStream = urlCon.getInputStream();
            try {
                Pref.clearPrefs(Pref.getPrefRoot());
            }
            catch (BackingStoreException e2) {
                System.out.println("Error resetting Electric preferences");
                e2.printStackTrace();
            }
            Preferences.importPreferences(inputStream);
            inputStream.close();
        }
        catch (InvalidPreferencesFormatException e3) {
            Object message = "Invalid preferences format";
            if (e3.getCause() instanceof SAXParseException) {
                SAXParseException se = (SAXParseException)e3.getCause();
                message = (String)message + " (line " + se.getLineNumber() + ")";
            }
            System.out.println((String)message + ": " + e3.getMessage());
            return;
        }
        catch (IOException e4) {
            System.out.println("Error reading preferences file");
            e4.printStackTrace();
            return;
        }
    }

    private static void clearPrefs(Preferences topNode) throws BackingStoreException {
        topNode.clear();
        for (String child : topNode.childrenNames()) {
            Pref.clearPrefs(topNode.node(Pref.getValidKey(child)));
        }
    }

    public static void exportPrefs(String fileName) {
        Pref.exportPrefs(fileName, Pref.getPrefRoot());
    }

    public static void exportPrefs(String fileName, Preferences prefRoot) {
        if (fileName == null) {
            return;
        }
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            prefRoot.exportSubtree(bs);
            Object xmlDump = bs.toString();
            int sunPos = ((String)xmlDump).indexOf("java.sun.com");
            String insertDTD = "";
            if (sunPos >= 0) {
                int openPos = ((String)xmlDump).lastIndexOf(60, sunPos);
                int closePos = ((String)xmlDump).indexOf(62, sunPos);
                if (openPos >= 0 && closePos >= 0) {
                    insertDTD = ((String)xmlDump).substring(openPos, closePos + 1);
                    xmlDump = ((String)xmlDump).substring(0, openPos) + ((String)xmlDump).substring(closePos + 1);
                }
            }
            StreamSource source = new StreamSource(new StringReader((String)xmlDump));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", 2);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter outSW = ClientOS.isOSMac() ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, "utf-8");
            StreamResult result = new StreamResult(outSW);
            transformer.transform(source, result);
            Object xmlFormatted = bos.toString();
            int closePos = ((String)xmlFormatted).indexOf(62);
            if (closePos >= 0) {
                xmlFormatted = ((String)xmlFormatted).substring(0, closePos + 1) + "\n" + insertDTD + ((String)xmlFormatted).substring(closePos + 1);
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            printWriter.print((String)xmlFormatted);
            printWriter.close();
        }
        catch (Exception e2) {
            if (Job.getDebug()) {
                e2.printStackTrace();
            }
            System.out.println("Error exporting Preferences");
            return;
        }
        System.out.println("Preferences saved to " + fileName);
    }

    public static Pref makeBooleanPref(String name, Group group, boolean factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeIntPref(String name, Group group, int factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeLongPref(String name, Group group, long factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeDoublePref(String name, Group group, double factory) {
        return new Pref(group, name, false, factory);
    }

    public static Pref makeStringPref(String name, Group group, String factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        return new Pref(group, name, false, factory);
    }

    public static Pref makeBooleanServerPref(String name, Group group, boolean factory) {
        return new Pref(group, name, true, factory);
    }

    public static Pref makeIntServerPref(String name, Group group, int factory) {
        return new Pref(group, name, true, factory);
    }

    public static Pref makeStringServerPref(String name, Group group, String factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        return new Pref(group, name, true, factory);
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public int getInt() {
        return (Integer)this.getValue();
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return ((Number)this.getValue()).doubleValue();
    }

    public String getString() {
        return (String)this.getValue();
    }

    public boolean getBoolean(Preferences prefRoot) {
        return (Boolean)this.getValue(prefRoot);
    }

    public int getInt(Preferences prefRoot) {
        return (Integer)this.getValue(prefRoot);
    }

    public long getLong(Preferences prefRoot) {
        return (Long)this.getValue(prefRoot);
    }

    public double getDouble(Preferences prefRoot) {
        return (Double)this.getValue(prefRoot);
    }

    public String getString(Preferences prefRoot) {
        return (String)this.getValue(prefRoot);
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public boolean getBooleanFactoryValue() {
        return (Boolean)this.factoryObj;
    }

    public int getIntFactoryValue() {
        return (Integer)this.factoryObj;
    }

    public long getLongFactoryValue() {
        return (Long)this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public String getStringFactoryValue() {
        return (String)this.factoryObj;
    }

    public String getPrefName() {
        return this.name;
    }

    public String getPrefPath() {
        return this.group.relativePath() + "/" + this.name;
    }

    public Object getValue() {
        if (!(Job.isClientThread() || this.serverAccessible || reportedAccess.contains(this))) {
            String msg = this.getPrefName() + " is accessed from " + String.valueOf(Job.getRunningJob());
            if (Job.getDebug()) {
                ActivityLogger.logMessage(msg);
                System.out.println(msg);
            }
            reportedAccess.add(this);
        }
        if (this.cachedObj == null) {
            this.setCachedObjFromPreferences();
        }
        return this.cachedObj;
    }

    public Object getValue(Preferences prefRoot) {
        return Pref.getValueImpl(prefRoot.node(Pref.getValidKey(this.group.relativePath)), this.name, this.factoryObj);
    }

    private static Object getValueImpl(Preferences preferences, String key, Object def) {
        Object value = def;
        if (def instanceof Boolean) {
            boolean defV = (Boolean)def;
            boolean v = preferences.getBoolean(key, defV);
            if (v != defV) {
                value = v;
            }
        } else if (def instanceof Integer) {
            int defV = (Integer)def;
            int v = preferences.getInt(key, defV);
            if (v != defV) {
                value = v;
            }
        } else if (def instanceof Long) {
            long defV = (Long)def;
            long v = preferences.getLong(key, defV);
            if (v != defV) {
                value = v;
            }
        } else if (def instanceof Double) {
            double defV = (Double)def;
            double v = preferences.getDouble(key, defV);
            if (v != defV) {
                value = v;
            }
        } else {
            assert (def instanceof String);
            value = preferences.get(key, (String)def);
        }
        return value;
    }

    private void setValue(Object value) {
        assert (value.getClass() == this.factoryObj.getClass());
        this.cachedObj = value.equals(this.factoryObj) ? this.factoryObj : value;
        this.group.putValue(this.name, this.cachedObj);
    }

    private void setCachedObjFromPreferences() {
        this.cachedObj = this.group.getValue(this.name, this.factoryObj);
    }

    private void setCachedObjFromMap(Map<String, Object> initMap) {
        Object val = initMap.get(this.group.relativePath() + "/" + this.name);
        if (val != null) {
            if (val.getClass() != this.factoryObj.getClass()) {
                throw new IllegalArgumentException(this.group.relativePath() + this.name);
            }
            if (this.factoryObj.equals(val)) {
                val = null;
            }
        }
        this.cachedObj = val != null ? val : this.factoryObj;
    }

    public static void delayPrefFlushing() {
        doFlushing = false;
        queueForFlushing = new HashSet<Preferences>();
    }

    public static void resumePrefFlushing() {
        doFlushing = true;
        for (Preferences p : queueForFlushing) {
            Pref.flushOptions(p);
        }
        Pref.flushAll();
    }

    public static Preferences getPrefRoot() {
        if (forbidPreferences) {
            return Pref.getFactoryPrefRoot();
        }
        return Preferences.userNodeForPackage(Main.class);
    }

    public static Preferences getLibraryPreferences(LibId libId) {
        return Pref.getPrefRoot().node(Pref.getValidKey("database/hierarchy/" + libId.libName));
    }

    public static Preferences getFactoryPrefRoot() {
        return EmptyPreferencesFactory.factoryPrefRoot;
    }

    public static void flushAll() {
        Pref.flushOptions(Pref.getPrefRoot());
    }

    public void setBoolean(boolean v) {
        this.checkModify();
        boolean cachedBool = this.getBoolean();
        if (v != cachedBool) {
            this.setValue(v);
        }
    }

    public void setInt(int v) {
        this.checkModify();
        int cachedInt = this.getInt();
        if (v != cachedInt) {
            this.setValue(v);
        }
    }

    public void setLong(long v) {
        this.checkModify();
        long cachedLong = this.getLong();
        if (v != cachedLong) {
            this.setValue(v);
        }
    }

    public void setDouble(double v) {
        this.checkModify();
        double cachedDouble = this.getDouble();
        if (v != cachedDouble) {
            this.setValue(v);
        }
    }

    public void setString(String str) {
        this.checkModify();
        String cachedString = this.getString();
        if (!str.equals(cachedString)) {
            this.setValue(str);
        }
    }

    public void putBoolean(Preferences prefRoot, boolean removeDefaults, boolean v) {
        Preferences prefs = prefRoot.node(Pref.getValidKey(this.group.relativePath));
        if (removeDefaults && v == (Boolean)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putBoolean(this.name, v);
        }
    }

    public void putInt(Preferences prefRoot, boolean removeDefaults, int v) {
        Preferences prefs = prefRoot.node(Pref.getValidKey(this.group.relativePath));
        if (removeDefaults && v == (Integer)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putInt(this.name, v);
        }
    }

    public void putLong(Preferences prefRoot, boolean removeDefaults, long v) {
        Preferences prefs = prefRoot.node(Pref.getValidKey(this.group.relativePath));
        if (removeDefaults && v == (Long)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putLong(this.name, v);
        }
    }

    public void putDouble(Preferences prefRoot, boolean removeDefaults, double v) {
        Preferences prefs = prefRoot.node(Pref.getValidKey(this.group.relativePath));
        if (removeDefaults && v == (Double)this.factoryObj) {
            prefs.remove(this.name);
        } else {
            prefs.putDouble(this.name, v);
        }
    }

    public void putString(Preferences prefRoot, boolean removeDefaults, String str) {
        Preferences prefs = prefRoot.node(Pref.getValidKey(this.group.relativePath));
        if (removeDefaults && str.equals(this.factoryObj)) {
            prefs.remove(this.name);
        } else {
            prefs.put(this.name, str);
        }
    }

    public void factoryReset() {
        if (!Job.isClientThread()) {
            throw new IllegalStateException();
        }
        this.cachedObj = this.factoryObj;
        this.group.remove(this.name);
    }

    private void checkModify() {
        if (!Job.isClientThread() && !this.serverAccessible) {
            String msg = this.getPrefName() + " is modified in " + String.valueOf(Job.getRunningJob());
            if (Job.getDebug()) {
                ActivityLogger.logMessage(msg);
                System.out.println(msg);
            }
        }
    }

    public static Collection<Group> getAllGroups() {
        return Collections.unmodifiableCollection(allGroups);
    }

    private static String getValidKey(String key) {
        if (key.length() <= 80) {
            return key;
        }
        String validKey = keyNameAbbreviation.get(key);
        if (validKey == null) {
            validKey = key.substring(0, 80);
            keyNameAbbreviation.put(key, validKey);
            System.out.println("WARNING: Key '" + key + "' is too long for Java Preferences (limit is 80). Shortening the name.");
        }
        return validKey;
    }

    private static void flushOptions(Preferences p) {
        block2: {
            try {
                p.flush();
            }
            catch (Exception e2) {
                System.out.println("Failed to save preferences (are there two copies of Electric running?)");
                if (!ClientOS.isOSLinux()) break block2;
                System.out.println("   You may need to delete lock files in ~/.java/.userPrefs");
            }
        }
    }

    static {
        allGroups = new ArrayList();
        doFlushing = true;
        reportedAccess = new HashSet();
        keyNameAbbreviation = new HashMap<String, String>();
    }

    public static class Group {
        private final String relativePath;
        Preferences preferences;
        private final TreeMap<String, Pref> prefs = new TreeMap();

        private Group(String relativePath) {
            this.relativePath = relativePath;
        }

        public String relativePath() {
            return this.relativePath;
        }

        public Collection<Pref> getPrefs() {
            return Collections.unmodifiableCollection(this.prefs.values());
        }

        public void lockCreation() {
        }

        public void setCachedObjsFromPreferences() {
            for (Pref pref : this.prefs.values()) {
                pref.setCachedObjFromPreferences();
            }
        }

        private void setCachedObjFromMap(Map<String, Object> map) {
            for (Pref pref : this.prefs.values()) {
                pref.setCachedObjFromMap(map);
            }
        }

        private void putValue(String key, Object value) {
            if (this.preferences == null) {
                this.preferences = Pref.getPrefRoot().node(Pref.getValidKey(this.relativePath));
            }
            this.putValue(this.preferences, key, value);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private void putValue(Preferences preferences, String key, Object value) {
            if (value instanceof Boolean) {
                preferences.putBoolean(key, (Boolean)value);
            } else if (value instanceof Integer) {
                preferences.putInt(key, (Integer)value);
            } else if (value instanceof Long) {
                preferences.putLong(key, (Long)value);
            } else if (value instanceof Double) {
                preferences.putDouble(key, (Double)value);
            } else {
                assert (value instanceof String);
                preferences.put(key, (String)value);
            }
        }

        private Object getValue(String key, Object def) {
            if (this.preferences == null) {
                this.preferences = Pref.getPrefRoot().node(Pref.getValidKey(this.relativePath));
            }
            return Pref.getValueImpl(this.preferences, key, def);
        }

        private void remove(String key) {
            if (this.preferences == null) {
                this.preferences = Pref.getPrefRoot().node(Pref.getValidKey(this.relativePath));
            }
            this.remove(this.preferences, key);
            if (doFlushing) {
                Pref.flushOptions(this.preferences);
            } else {
                queueForFlushing.add(this.preferences);
            }
        }

        private void remove(Preferences preferences, String key) {
            preferences.remove(key);
        }
    }
}

