/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.Name;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

public class NetlistImpl
extends Netlist {
    private static final String[] NULL_STRING_ARRAY = new String[0];
    private String[][] names;
    private BitSet isUsernamed = new BitSet();
    private int[] exportedNamesCount;
    private int[] equivPortIndexByNetIndex;

    NetlistImpl(NetCell netCell, int numExternals, int[] map) {
        super(netCell, Netlist.ShortResistors.NO, numExternals, map);
        if (netCell instanceof NetSchem) {
            this.expectedSnapshot = new WeakReference<Snapshot>(netCell.database.backup());
        } else {
            this.expectedCellTree = new WeakReference<CellTree>(netCell.cell.tree());
        }
        this.exportedNamesCount = new int[this.numExternalNets];
        this.equivPortIndexByNetIndex = new int[this.numExternalNets];
        Arrays.fill(this.equivPortIndexByNetIndex, -1);
        this.names = new String[this.getNumNetworks()][];
        Arrays.fill((Object[])this.names, NULL_STRING_ARRAY);
    }

    void setEquivPortIndexByNetIndex(int equivIndex, int netIndex) {
        this.equivPortIndexByNetIndex[netIndex] = equivIndex;
    }

    @Override
    Iterator<String> getNames(int netIndex) {
        return ArrayIterator.iterator(this.names[netIndex]);
    }

    @Override
    Iterator<String> getExportedNames(int netIndex) {
        int exportedNamesCount = netIndex < this.numExternalNets ? this.exportedNamesCount[netIndex] : 0;
        return ArrayIterator.iterator(this.names[netIndex], 0, exportedNamesCount);
    }

    @Override
    String getName(int netIndex) {
        return this.names[netIndex][0];
    }

    @Override
    boolean hasName(int netIndex, String nm) {
        String[] theseNames = this.names[netIndex];
        for (int i2 = 0; i2 < theseNames.length; ++i2) {
            if (!theseNames[i2].equals(nm)) continue;
            return true;
        }
        return false;
    }

    @Override
    void fillNames(int netIndex, Collection<String> exportedNames, Collection<String> privateNames) {
        int i2;
        if (!this.isUsernamed(netIndex)) {
            return;
        }
        String[] names = this.names[netIndex];
        int exportedNamesCount = netIndex < this.numExternalNets ? this.exportedNamesCount[netIndex] : 0;
        for (i2 = 0; i2 < exportedNamesCount; ++i2) {
            exportedNames.add(names[i2]);
        }
        if (privateNames != null) {
            for (i2 = exportedNamesCount; i2 < names.length; ++i2) {
                privateNames.add(names[i2]);
            }
        }
    }

    @Override
    boolean isUsernamed(int netIndex) {
        return this.isUsernamed.get(netIndex);
    }

    boolean hasNames(int netIndex) {
        return this.names[netIndex].length > 0;
    }

    @Override
    int getEquivPortIndexByNetIndex(int netIndex) {
        return this.equivPortIndexByNetIndex[netIndex];
    }

    void addUserName(int netIndex, Name nameKey, boolean exported) {
        int i2;
        int exportedCount;
        assert (!nameKey.isTempname());
        String name = nameKey.toString();
        String[] theseNames = this.names[netIndex];
        int n2 = exportedCount = netIndex < this.numExternalNets ? this.exportedNamesCount[netIndex] : 0;
        if (exported) assert (exportedCount == theseNames.length);
        for (i2 = 0; i2 < theseNames.length; ++i2) {
            String n3 = this.names[netIndex][i2];
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(name, n3);
            if (cmp == 0) {
                return;
            }
            if (cmp < 0 && (exported || i2 >= exportedCount)) break;
        }
        if (theseNames.length == 0) {
            this.names[netIndex] = new String[]{name};
        } else {
            String[] newNames = new String[theseNames.length + 1];
            System.arraycopy(theseNames, 0, newNames, 0, i2);
            newNames[i2] = name;
            System.arraycopy(theseNames, i2, newNames, i2 + 1, theseNames.length - i2);
            this.names[netIndex] = newNames;
        }
        if (exported) {
            int n4 = netIndex;
            this.exportedNamesCount[n4] = this.exportedNamesCount[n4] + 1;
        }
        this.isUsernamed.set(netIndex);
    }

    void addTempName(int netIndex, String name) {
        assert (this.names[netIndex].length == 0);
        this.names[netIndex] = new String[]{name};
    }
}

