/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import com.sun.electric.util.TextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Global {
    private Name name;
    private int index;
    private static Global[] allGlobals = new Global[0];
    private static Map<String, Global> globalsByName = new HashMap<String, Global>();
    private static Map<String, Global> globalsByCanonicName = new HashMap<String, Global>();
    public static final Global ground = Global.newGlobal("gnd");
    public static final Global power = Global.newGlobal("vdd");

    private Global(Name name) {
        this.name = name;
        this.index = allGlobals.length;
        Global[] newGlobals = new Global[this.index + 1];
        for (int i2 = 0; i2 < this.index; ++i2) {
            newGlobals[i2] = allGlobals[i2];
        }
        newGlobals[this.index] = this;
        allGlobals = newGlobals;
        globalsByName.put(name.toString(), this);
        String canonicString = TextUtils.canonicString(name.toString());
        if (globalsByCanonicName.containsKey(canonicString)) {
            System.out.println("!!! " + String.valueOf(globalsByCanonicName.get(canonicString)) + " and " + String.valueOf(this) + " are not connected now !!!");
        }
        globalsByCanonicName.put(canonicString, this);
    }

    public String getName() {
        return this.name.toString();
    }

    public Name getNameKey() {
        return this.name;
    }

    public String toString() {
        return "Global " + String.valueOf(this.name);
    }

    public static Global newGlobal(String name) {
        Name nameKey = Name.findName(name);
        Global g2 = globalsByName.get(nameKey.toString());
        if (g2 == null) {
            g2 = new Global(nameKey);
        }
        return g2;
    }

    public static class Buf {
        private PortCharacteristic[] buf = new PortCharacteristic[allGlobals.length];

        public Buf() {
        }

        Buf(Set set) {
            this.buf = (PortCharacteristic[])set.elemMap.clone();
        }

        public String addToBuf(Global g2, PortCharacteristic characteristic) {
            PortCharacteristic oldCharacteristic;
            String errorMsg = null;
            if (this.buf.length <= g2.index) {
                PortCharacteristic[] newBuf = new PortCharacteristic[g2.index + 1];
                System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
                this.buf = newBuf;
            }
            if ((oldCharacteristic = this.buf[g2.index]) == null) {
                this.buf[g2.index] = characteristic;
            } else if (oldCharacteristic != characteristic) {
                errorMsg = g2.getName() + "(" + oldCharacteristic.getName() + "->" + characteristic.getName() + ")";
            }
            return errorMsg;
        }

        public String addToBuf(Set set) {
            String errorMsg = null;
            for (int i2 = 0; i2 < set.elems.length; ++i2) {
                int index = set.elems[i2].index;
                String msg = this.addToBuf(allGlobals[index], set.elemMap[index]);
                if (msg == null) continue;
                if (errorMsg != null) {
                    errorMsg = errorMsg + " ";
                }
                errorMsg = errorMsg + msg;
            }
            return errorMsg;
        }

        public Set getBuf() {
            return Set.newSet(this.buf);
        }
    }

    public static class Set
    implements Comparable<Set> {
        private PortCharacteristic[] elemMap;
        private Global[] elems;
        private int[] indexOf;
        private static Map<Set, Set> allSets = new TreeMap<Set, Set>();
        private static Set fakeSet = new Set(new PortCharacteristic[0]);
        public static final Set empty = Set.newSet(new PortCharacteristic[0]);

        private Set(PortCharacteristic[] elemMap) {
            int maxElem = -1;
            int numElem = 0;
            for (int i2 = 0; i2 < elemMap.length; ++i2) {
                if (elemMap[i2] == null) continue;
                maxElem = i2;
                ++numElem;
            }
            this.elemMap = new PortCharacteristic[maxElem + 1];
            this.elems = new Global[numElem];
            this.indexOf = new int[maxElem + 1];
            Arrays.fill(this.indexOf, -1);
            int local = 0;
            for (int i3 = 0; i3 < elemMap.length; ++i3) {
                if (elemMap[i3] == null) continue;
                this.elemMap[i3] = elemMap[i3];
                this.elems[local] = allGlobals[i3];
                this.indexOf[i3] = local++;
            }
        }

        public final boolean contains(Global global) {
            return global.index < this.elemMap.length && this.elemMap[global.index] != null;
        }

        public PortCharacteristic getCharacteristic(Global global) {
            return global.index < this.elemMap.length ? this.elemMap[global.index] : null;
        }

        public final int size() {
            return this.elems.length;
        }

        public final Global get(int i2) {
            return this.elems[i2];
        }

        public final int indexOf(Global g2) {
            return g2.index < this.indexOf.length ? this.indexOf[g2.index] : -1;
        }

        public final int maxElement() {
            return this.elemMap.length - 1;
        }

        @Override
        public int compareTo(Set set) {
            int i2;
            int minLen = Math.min(this.elemMap.length, set.elemMap.length);
            for (i2 = 0; i2 < minLen && this.elemMap[i2] == set.elemMap[i2]; ++i2) {
            }
            if (i2 < minLen) {
                if (this.elemMap[i2] == null) {
                    return -1;
                }
                if (set.elemMap[i2] == null) {
                    return 1;
                }
                return this.elemMap[i2].getOrder() - set.elemMap[i2].getOrder();
            }
            while (i2 < this.elemMap.length) {
                if (this.elemMap[i2] != null) {
                    return 1;
                }
                ++i2;
            }
            while (i2 < set.elemMap.length) {
                if (set.elemMap[i2] != null) {
                    return -1;
                }
                ++i2;
            }
            return 0;
        }

        public String toString() {
            Object s = "Global.Set {";
            for (int i2 = 0; i2 < this.elemMap.length; ++i2) {
                if (this.elemMap[i2] == null) continue;
                s = (String)s + " " + String.valueOf(allGlobals[i2]) + ":" + this.elemMap[i2].getName();
            }
            s = (String)s + "}";
            return s;
        }

        public Set remove(Iterator<Global> gs) {
            Buf buf = new Buf(this);
            while (gs.hasNext()) {
                Global g2 = gs.next();
                if (g2.index >= buf.buf.length) continue;
                buf.buf[g2.index] = null;
            }
            return buf.getBuf();
        }

        private static Set newSet(PortCharacteristic[] elemMap) {
            Set.fakeSet.elemMap = elemMap;
            Set set = allSets.get(fakeSet);
            Set.fakeSet.elemMap = null;
            if (set == null) {
                set = new Set(elemMap);
                allSets.put(set, set);
            }
            return set;
        }
    }
}

