/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.Environment;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.technology.TechPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IdManager {
    public static final IdManager stdIdManager = new IdManager();
    final ArrayList<TechId> techIds = new ArrayList();
    private final HashMap<String, TechId> techIdsByName = new HashMap();
    final ArrayList<LibId> libIds = new ArrayList();
    private final HashMap<String, LibId> libIdsByName = new HashMap();
    final ArrayList<CellId> cellIds = new ArrayList();
    private final AtomicInteger snapshotCount = new AtomicInteger();
    private final TechPool initialTechPool = new TechPool(this);
    private final Environment initialEnvironment = new Environment(this);
    private final Snapshot initialSnapshot = new Snapshot(this);
    volatile boolean readOnly;

    public void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized TechId newTechId(String techName) {
        TechId techId = this.techIdsByName.get(techName);
        if (techId != null) {
            return techId;
        }
        assert (!this.readOnly);
        return this.newTechIdInternal(techName);
    }

    public synchronized TechId getTechId(int techIndex) {
        return this.techIds.get(techIndex);
    }

    TechId newTechIdInternal(String techName) {
        int techIndex = this.techIds.size();
        TechId techId = new TechId(this, techName, techIndex);
        this.techIds.add(techId);
        this.techIdsByName.put(techName, techId);
        assert (this.techIds.size() == this.techIdsByName.size());
        return techId;
    }

    public synchronized LibId newLibId(String libName) {
        assert (!this.readOnly);
        LibId libId = this.libIdsByName.get(libName);
        return libId != null ? libId : this.newLibIdInternal(libName);
    }

    public synchronized LibId getLibId(int libIndex) {
        return this.libIds.get(libIndex);
    }

    LibId newLibIdInternal(String libName) {
        int libIndex = this.libIds.size();
        LibId libId = new LibId(this, libName, libIndex);
        this.libIds.add(libId);
        this.libIdsByName.put(libName, libId);
        assert (this.libIds.size() == this.libIdsByName.size());
        return libId;
    }

    synchronized CellId newCellId(LibId libId, CellName cellName) {
        assert (!this.readOnly);
        assert (libId.idManager == this);
        CellId cellId = libId.getCellId(cellName);
        return cellId != null ? cellId : this.newCellIdInternal(libId, cellName);
    }

    public synchronized CellId getCellId(int cellIndex) {
        return this.cellIds.get(cellIndex);
    }

    CellId newCellIdInternal(LibId libId, CellName cellName) {
        int cellIndex = this.cellIds.size();
        CellId cellId = new CellId(libId, cellName, cellIndex);
        this.cellIds.add(cellId);
        libId.putCellId(cellId);
        return cellId;
    }

    public TechPool getInitialTechPool() {
        return this.initialTechPool;
    }

    public Environment getInitialEnvironment() {
        return this.initialEnvironment;
    }

    public Snapshot getInitialSnapshot() {
        return this.initialSnapshot;
    }

    public int newSnapshotId() {
        return this.snapshotCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInvariants() {
        int numCellIds;
        IdManager idManager = this;
        synchronized (idManager) {
            int numTechIds = this.techIds.size();
            assert (numTechIds == this.techIdsByName.size());
            for (int techIndex = 0; techIndex < numTechIds; ++techIndex) {
                TechId techId = this.getTechId(techIndex);
                assert (techId.idManager == this);
                assert (techId.techIndex == techIndex);
                techId.check();
                assert (this.techIdsByName.get(techId.techName) == techId);
            }
            int numLibIds = this.libIds.size();
            assert (numLibIds == this.libIdsByName.size());
            for (int libIndex = 0; libIndex < numLibIds; ++libIndex) {
                LibId libId = this.getLibId(libIndex);
                assert (libId.idManager == this);
                assert (libId.libIndex == libIndex);
                libId.check();
                assert (this.libIdsByName.get(libId.libName) == libId);
            }
            for (Map.Entry<String, LibId> e2 : this.libIdsByName.entrySet()) {
                LibId libId = e2.getValue();
                assert (libId.idManager == this);
                assert (libId.libName == e2.getKey());
                assert (this.getLibId(libId.libIndex) == libId);
            }
            numCellIds = this.cellIds.size();
        }
        for (int cellIndex = 0; cellIndex < numCellIds; ++cellIndex) {
            CellId cellId = this.getCellId(cellIndex);
            assert (cellId.idManager == this);
            assert (cellId.cellIndex == cellIndex);
            assert (cellId.libId.getCellId(cellId.cellName) == cellId);
            cellId.check();
        }
    }

    public void dump() {
        System.out.println(this.techIds.size() + " TechIds:");
        for (TechId techId : new TreeMap<String, TechId>(this.techIdsByName).values()) {
            System.out.println("TechId " + String.valueOf(techId) + " " + techId.primitiveNodeIds.size() + " " + techId.arcProtoIds.size());
        }
        System.out.println(this.libIds.size() + " LibIds:");
        for (LibId libId : new TreeMap<String, LibId>(this.libIdsByName).values()) {
            System.out.println("LibId " + String.valueOf(libId));
            for (CellId cellId : this.cellIds) {
                if (cellId.libId != libId) continue;
                System.out.println(String.valueOf(cellId) + " " + cellId.numUsagesIn() + " " + cellId.numUsagesOf() + " " + cellId.numExportIds());
            }
        }
    }
}

