/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.TechId;
import com.sun.electric.technology.ArcProto;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;

public class ArcProtoId
implements Serializable {
    public final TechId techId;
    public final String name;
    public final String fullName;
    public final int chronIndex;

    ArcProtoId(TechId techId, String name, int chronIndex) {
        assert (techId != null);
        if (name.length() == 0 || !TechId.jelibSafeName(name)) {
            throw new IllegalArgumentException("ArcProtoId.name");
        }
        this.techId = techId;
        this.name = name;
        this.fullName = techId.techName + ":" + name;
        this.chronIndex = chronIndex;
    }

    private Object writeReplace() {
        return new ArcProtoIdKey(this);
    }

    public ArcProto inDatabase(EDatabase database) {
        return database.getTechPool().getArcProto(this);
    }

    public String toString() {
        return this.fullName;
    }

    void check() {
        assert (this == this.techId.getArcProtoId(this.chronIndex));
        assert (this.name.length() > 0 && TechId.jelibSafeName(this.name));
    }

    private static class ArcProtoIdKey
    extends EObjectInputStream.Key<ArcProtoId> {
        public ArcProtoIdKey() {
        }

        private ArcProtoIdKey(ArcProtoId arcProtoId) {
            super(arcProtoId);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, ArcProtoId arcProtoId) throws IOException {
            TechId techId = arcProtoId.techId;
            if (techId.idManager != out.getIdManager()) {
                throw new NotSerializableException(String.valueOf(arcProtoId) + " from other IdManager");
            }
            out.writeInt(techId.techIndex);
            out.writeInt(arcProtoId.chronIndex);
        }

        @Override
        public ArcProtoId readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int techIndex = in.readInt();
            int chronIndex = in.readInt();
            return in.getIdManager().getTechId(techIndex).getArcProtoId(chronIndex);
        }
    }
}

