/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class HierarchyEnumerator {
    private Visitor visitor;
    private boolean caching;
    private int curNetId = 0;
    private Map<Integer, NetDescription> netIdToNetDesc = new HashMap<Integer, NetDescription>();
    private HashMap<Cell, int[]> cellExternalIds = new HashMap();

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private HierarchyEnumerator() {
    }

    private int[] getExternalIds(Cell cell, Netlist netlist) {
        int[] externalIds = this.cellExternalIds.get(cell);
        if (externalIds != null) {
            return externalIds;
        }
        externalIds = new int[netlist.getNumExternalNetworks()];
        this.cellExternalIds.put(cell, externalIds);
        return externalIds;
    }

    private int[] numberNets(Cell cell, Netlist netlist, int[][] portNdxToNetIDs, CellInfo info) {
        int numNets = netlist.getNumNetworks();
        int[] externalIds = this.getExternalIds(cell, netlist);
        int[] netNdxToNetID = new int[numNets];
        int baseId = this.curNetId;
        Arrays.fill(externalIds, -1);
        if (portNdxToNetIDs != null) {
            int i2;
            assert (portNdxToNetIDs.length == cell.getNumPorts() + 1);
            Global.Set globals = netlist.getGlobals();
            assert (portNdxToNetIDs[0].length == globals.size());
            for (i2 = 0; i2 < globals.size(); ++i2) {
                Global global = globals.get(i2);
                int netIndex = netlist.getNetwork(global).getNetIndex();
                externalIds[netIndex] = portNdxToNetIDs[0][i2];
            }
            int numPorts = cell.getNumPorts();
            for (i2 = 0; i2 < numPorts; ++i2) {
                Export export = cell.getPort(i2);
                int[] ids = portNdxToNetIDs[i2 + 1];
                assert (ids.length == export.getNameKey().busWidth());
                for (int j2 = 0; j2 < ids.length; ++j2) {
                    int netIndex = netlist.getNetwork(export, j2).getNetIndex();
                    externalIds[netIndex] = ids[j2];
                }
            }
            for (i2 = 0; i2 < externalIds.length; ++i2) {
                assert (externalIds[i2] >= 0);
            }
            baseId -= externalIds.length;
        }
        for (int i3 = 0; i3 < numNets; ++i3) {
            int id;
            Network net = netlist.getNetwork(i3);
            int localId = i3;
            assert (baseId + localId <= this.curNetId);
            if (baseId + localId == this.curNetId) {
                if (portNdxToNetIDs == null && localId < externalIds.length) {
                    externalIds[localId] = localId;
                }
                assert (this.curNetId == baseId + localId);
                this.netIdToNetDesc.put(this.curNetId++, new NetDescription(net, info));
            } else if (localId >= externalIds.length || portNdxToNetIDs == null) {
                int cmp;
                NetDescription nd = this.netIdToNetDesc.get(baseId + localId);
                int n2 = !net.isUsernamed() ? 1 : (cmp = nd.net.isUsernamed() ? 0 : -1);
                if (cmp == 0 && net.isExported() != nd.net.isExported()) {
                    int n3 = cmp = net.isExported() ? -1 : 1;
                }
                if (cmp == 0) {
                    cmp = TextUtils.STRING_NUMBER_ORDER.compare(net.getName(), nd.net.getName());
                }
                if (cmp < 0) {
                    nd.net = net;
                }
            }
            netNdxToNetID[i3] = id = localId < externalIds.length ? externalIds[localId] : baseId + localId;
        }
        return netNdxToNetID;
    }

    private static int[] getGlobalNetIDs(Nodable no, Netlist netlist, int[] netNdxToNetID) {
        Global.Set gs = netlist.getNetlist(no).getGlobals();
        int[] netIDs = new int[gs.size()];
        for (int i2 = 0; i2 < gs.size(); ++i2) {
            int netIndex = netlist.getNetwork(no, gs.get(i2)).getNetIndex();
            int netID = netNdxToNetID[netIndex];
            HierarchyEnumerator.error(netID < 0, "no netID for net");
            netIDs[i2] = netID;
        }
        return netIDs;
    }

    private static int[] getPortNetIDs(Nodable no, PortProto pp, Netlist netlist, int[] netNdxToNetID) {
        int busWidth = pp.getNameKey().busWidth();
        int[] netIDs = new int[busWidth];
        for (int j2 = 0; j2 < busWidth; ++j2) {
            Network net = netlist.getNetwork(no, pp, j2);
            HierarchyEnumerator.error(net == null, "no network for net " + String.valueOf(pp.getNameKey()));
            int netIndex = net.getNetIndex();
            int netID = netNdxToNetID[netIndex];
            HierarchyEnumerator.error(netID < 0, "no netID for net " + String.valueOf(pp.getNameKey()));
            netIDs[j2] = netID;
        }
        return netIDs;
    }

    private static int getPortNetID(Nodable no, Name wireName, Netlist netlist, int[] netNdxToNetID) {
        Network net = netlist.getNetwork(no, wireName);
        HierarchyEnumerator.error(net == null, "no network for net " + String.valueOf(wireName));
        int netIndex = net.getNetIndex();
        int netID = netNdxToNetID[netIndex];
        HierarchyEnumerator.error(netID < 0, "no netID for net " + String.valueOf(wireName));
        return netID;
    }

    private static int[][] buildPortMap(Netlist netlist, Nodable ni, int[] netNdxToNetID) {
        Cell cell = (Cell)ni.getProto();
        int numPorts = cell.getNumPorts();
        int[][] portNdxToNetIDs = new int[numPorts + 1][];
        portNdxToNetIDs[0] = HierarchyEnumerator.getGlobalNetIDs(ni, netlist, netNdxToNetID);
        for (int i2 = 0; i2 < numPorts; ++i2) {
            Export pp = cell.getPort(i2);
            portNdxToNetIDs[i2 + 1] = HierarchyEnumerator.getPortNetIDs(ni, pp, netlist, netNdxToNetID);
        }
        return portNdxToNetIDs;
    }

    private void enumerateCell(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[][] portNdxToNetIDs, FixpTransform xformToRoot, CellInfo parent, Rectangle2D bounds) {
        CellInfo info = this.visitor.newCellInfo();
        int firstNetID = this.curNetId;
        int[] netNdxToNetID = this.numberNets(cell, netlist, portNdxToNetIDs, info);
        int lastNetIDPlusOne = this.curNetId;
        info.init(parentInst, cell, context, netlist, netNdxToNetID, portNdxToNetIDs, xformToRoot, this.netIdToNetDesc, parent);
        boolean enumInsts = this.visitor.enterCell(info);
        if (!enumInsts) {
            return;
        }
        if (bounds != null) {
            it = cell.searchIterator(bounds);
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                for (Nodable no : ni.getNodables()) {
                    this.visitThisNode(no, context, netlist, info, netNdxToNetID, xformToRoot);
                }
            }
        } else {
            it = netlist.getNodables();
            while (it.hasNext()) {
                Nodable ni = (Nodable)it.next();
                this.visitThisNode(ni, context, netlist, info, netNdxToNetID, xformToRoot);
            }
        }
        this.visitor.exitCell(info);
        context.deleteVariableCache();
        for (int i2 = firstNetID; i2 < lastNetIDPlusOne; ++i2) {
            this.netIdToNetDesc.remove(i2);
        }
    }

    private void visitThisNode(Nodable ni, VarContext context, Netlist netlist, CellInfo info, int[] netNdxToNetID, FixpTransform xformToRoot) {
        boolean descend = this.visitor.visitNodeInst(ni, info);
        NodeProto np = ni.getProto();
        if (descend && ni.isCellInstance()) {
            boolean isIcon = ((Cell)np).isIcon();
            if (isIcon && this.visitor.visitIcons()) {
                isIcon = false;
            }
            if (!isIcon) {
                int[][] portNmToNetIDs2 = HierarchyEnumerator.buildPortMap(netlist, ni, netNdxToNetID);
                FixpTransform xformToRoot2 = xformToRoot;
                if (ni instanceof NodeInst) {
                    xformToRoot2 = new FixpTransform(xformToRoot);
                    xformToRoot2.concatenate(((NodeInst)ni).rotateOut());
                    xformToRoot2.concatenate(((NodeInst)ni).translateOut());
                }
                this.enumerateCell(ni, (Cell)np, this.caching ? context.pushCaching(ni) : context.push(ni), netlist.getNetlist(ni), portNmToNetIDs2, xformToRoot2, info, null);
            }
        }
    }

    private void doIt(Cell root, VarContext context, Netlist netlist, Visitor visitor, boolean cache, Rectangle2D bounds) {
        this.visitor = visitor;
        this.caching = cache;
        if (context == null) {
            context = VarContext.globalContext;
        }
        int[][] exportNdxToNetIDs = null;
        this.enumerateCell(null, root, context, netlist, exportNdxToNetIDs, new FixpTransform(), null, bounds);
    }

    public static void enumerateCell(Cell root, VarContext context, Visitor visitor) {
        HierarchyEnumerator.enumerateCell(root, context, visitor, Netlist.ShortResistors.NO);
    }

    public static void enumerateCell(Cell root, VarContext context, Visitor visitor, Rectangle2D bounds) {
        new HierarchyEnumerator().doIt(root, context, root.getNetlist(Netlist.ShortResistors.NO), visitor, false, bounds);
    }

    public static void enumerateCell(Cell root, VarContext context, Visitor visitor, Netlist.ShortResistors shortResistors) {
        HierarchyEnumerator.enumerateCell(root.getNetlist(shortResistors), context, visitor);
    }

    public static void enumerateCell(Netlist rootNetlist, VarContext context, Visitor visitor) {
        HierarchyEnumerator.enumerateCell(rootNetlist, context, visitor, false);
    }

    public static void enumerateCell(Netlist rootNetlist, VarContext context, Visitor visitor, boolean caching) {
        new HierarchyEnumerator().doIt(rootNetlist.getCell(), context, rootNetlist, visitor, caching, null);
    }

    public static int getNumUniqueChildCells(Cell cell) {
        HashMap<Cell, Cell> uniqueChildCells = new HashMap<Cell, Cell>();
        HierarchyEnumerator.hierCellsRecurse(cell, uniqueChildCells);
        return uniqueChildCells.size();
    }

    private static void hierCellsRecurse(Cell cell, HashMap<Cell, Cell> uniqueCells) {
        EDatabase database = cell.getDatabase();
        Iterator<CellUsage> uit = cell.getUsagesIn();
        while (uit.hasNext()) {
            CellUsage u = uit.next();
            Cell subCell = u.getProto(database);
            if (subCell.isIcon()) continue;
            uniqueCells.put(subCell, subCell);
            HierarchyEnumerator.hierCellsRecurse(subCell, uniqueCells);
        }
    }

    public static Network getNetworkInChild(Network parentNet, Nodable childNodable) {
        if (childNodable == null || parentNet == null) {
            return null;
        }
        if (!childNodable.isCellInstance()) {
            return null;
        }
        Cell childCell = (Cell)childNodable.getProto();
        Netlist parentNetlist = parentNet.getNetlist();
        Netlist childNetlist = parentNetlist.getNetlist(childNodable);
        PortProto pp = null;
        int i2 = 0;
        boolean found = false;
        NodeInst ni = childNodable.getNodeInst();
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            pp = pi.getPortProto();
            for (i2 = 0; i2 < pp.getNameKey().busWidth(); ++i2) {
                Network net = parentNetlist.getNetwork(childNodable, pp, i2);
                if (net != parentNet) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            return null;
        }
        if (childCell.contentsView() != null) {
            childCell = childCell.contentsView();
        }
        Export export = childCell.findExport(pp.getNameKey());
        Network childNet = childNetlist.getNetwork(export, i2);
        return childNet;
    }

    public static boolean searchNetworkInParent(Network net, CellInfo info, Network visitorNet) {
        if (visitorNet == net) {
            return true;
        }
        CellInfo cinfo = info;
        while (net != null && cinfo.getParentInst() != null) {
            if (visitorNet == (net = cinfo.getNetworkInParent(net))) {
                return true;
            }
            cinfo = cinfo.getParentInfo();
        }
        return false;
    }

    public static boolean searchInExportNetwork(Network net, CellInfo info, Network visitorNet) {
        boolean found = false;
        Iterator<Export> it = net.getExports();
        while (!found && it.hasNext()) {
            Export exp = it.next();
            Network tmpNet = info.getNetlist().getNetwork(exp, 0);
            found = HierarchyEnumerator.searchNetworkInParent(tmpNet, info, visitorNet);
        }
        return found;
    }

    private static Network getRootNetwork(Network net, CellInfo info) {
        CellInfo cinfo = info;
        Network result = net;
        while (net != null && cinfo.getParentInst() != null) {
            if ((net = cinfo.getNetworkInParent(net)) != null) {
                result = net;
            }
            cinfo = cinfo.getParentInfo();
        }
        return result;
    }

    public static boolean areGeometricsInSameNetwork(Geometric geo1, Network n1, Geometric geo2, Network n2, Cell top) {
        if (n1 == n2) {
            return true;
        }
        NetworkHierarchy search1 = new NetworkHierarchy(geo1, n1);
        HierarchyEnumerator.enumerateCell(top, VarContext.globalContext, (Visitor)search1);
        NetworkHierarchy search2 = new NetworkHierarchy(geo2, n2);
        HierarchyEnumerator.enumerateCell(top, VarContext.globalContext, (Visitor)search2);
        return search1.topNetwork != null && search2.topNetwork != null && search1.topNetwork == search2.topNetwork;
    }

    public static class NetDescription {
        private Network net;
        private CellInfo info;

        NetDescription(Network net, CellInfo info) {
            this.net = net;
            this.info = info;
        }

        public Network getNet() {
            return this.net;
        }

        public CellInfo getCellInfo() {
            return this.info;
        }
    }

    public static class CellInfo {
        private Nodable parentInst;
        private Cell cell;
        private VarContext context;
        private Netlist netlist;
        private int[] netNdxToNetID;
        private int[][] exportNdxToNetIDs;
        private FixpTransform xformToRoot;
        private Map<Integer, NetDescription> netIdToNetDesc;
        private CellInfo parentInfo;

        void init(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[] netToNetID, int[][] exportNdxToNetIDs, FixpTransform xformToRoot, Map<Integer, NetDescription> netIdToNetDesc, CellInfo parentInfo) {
            this.parentInst = parentInst;
            this.cell = cell;
            this.context = context;
            this.netlist = netlist;
            this.netNdxToNetID = netToNetID;
            this.exportNdxToNetIDs = exportNdxToNetIDs;
            this.xformToRoot = xformToRoot;
            this.netIdToNetDesc = netIdToNetDesc;
            this.parentInfo = parentInfo;
        }

        public final Cell getCell() {
            return this.cell;
        }

        public final boolean isRootCell() {
            return this.parentInfo == null;
        }

        public final VarContext getContext() {
            return this.context;
        }

        public final Netlist getNetlist() {
            return this.netlist;
        }

        public final CellInfo getParentInfo() {
            return this.parentInfo;
        }

        public final Nodable getParentInst() {
            return this.parentInst;
        }

        public final CellInfo getRootInfo() {
            CellInfo i2 = this;
            while (i2.getParentInfo() != null) {
                i2 = i2.getParentInfo();
            }
            return i2;
        }

        public final int[] getExportNetIDs(Export e2) {
            if (this.isRootCell()) {
                int width = this.netlist.getBusWidth(e2);
                int[] netIDs = new int[width];
                for (int i2 = 0; i2 < width; ++i2) {
                    netIDs[i2] = this.netlist.getNetwork(e2, i2).getNetIndex();
                }
                return netIDs;
            }
            return this.exportNdxToNetIDs[e2.getPortIndex() + 1];
        }

        public final int getNetID(Network net) {
            return this.getNetID(net.getNetIndex());
        }

        private int getNetID(int netIndex) {
            return this.netNdxToNetID[netIndex];
        }

        public final int[] getPortNetIDs(Nodable no, PortProto pp) {
            return HierarchyEnumerator.getPortNetIDs(no, pp, this.netlist, this.netNdxToNetID);
        }

        public final int getPortNetID(Nodable no, Name wireName) {
            return HierarchyEnumerator.getPortNetID(no, wireName, this.netlist, this.netNdxToNetID);
        }

        public final String getUniqueNetName(Network net, String sep) {
            NetNameProxy proxy = this.getUniqueNetNameProxy(net, sep);
            return proxy.toString();
        }

        public final NetNameProxy getUniqueNetNameProxy(Network net, String sep) {
            return this.getUniqueNetNameProxy(this.getNetID(net), sep);
        }

        public final String getUniqueNetName(int netID, String sep) {
            NetNameProxy proxy = this.getUniqueNetNameProxy(netID, sep);
            return proxy.toString();
        }

        public final NetNameProxy getUniqueNetNameProxy(int netID, String sep) {
            NetDescription ns = this.netIdToNetDesc.get(netID);
            VarContext netContext = ns.getCellInfo().getContext();
            return new NetNameProxy(netContext, sep, ns.getNet());
        }

        public final String getUniqueNodableName(Nodable no, String sep) {
            return this.getUniqueNodableNameProxy(no, sep).toString();
        }

        public final NodableNameProxy getUniqueNodableNameProxy(Nodable no, String sep) {
            return new NodableNameProxy(this.getContext(), sep, no);
        }

        public final NetDescription netIdToNetDescription(int netID) {
            return this.netIdToNetDesc.get(netID);
        }

        public Network getNetworkInParent(Network network) {
            if (this.parentInfo == null) {
                return null;
            }
            if (network == null) {
                return null;
            }
            if (network.getNetlist() != this.netlist) {
                return null;
            }
            return this.parentInfo.getNetlist().getNetwork(this.context.getNodable(), network);
        }

        public FixpTransform getTransformToRoot() {
            return this.xformToRoot;
        }
    }

    public static abstract class Visitor {
        public CellInfo newCellInfo() {
            return new CellInfo();
        }

        public abstract boolean enterCell(CellInfo var1);

        public abstract void exitCell(CellInfo var1);

        public abstract boolean visitNodeInst(Nodable var1, CellInfo var2);

        public boolean visitIcons() {
            return false;
        }
    }

    private static class NetworkHierarchy
    extends Visitor {
        Geometric theGeo;
        Network childNet;
        Network topNetwork;

        NetworkHierarchy(Geometric geo, Network childN) {
            this.theGeo = geo;
            this.childNet = childN;
            this.topNetwork = null;
        }

        @Override
        public boolean enterCell(CellInfo info) {
            Cell cell = info.getCell();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai != this.theGeo) continue;
                this.topNetwork = HierarchyEnumerator.getRootNetwork(this.childNet, info);
                return false;
            }
            return true;
        }

        @Override
        public void exitCell(CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (ni.isCellInstance()) {
                return true;
            }
            if (Generic.isSpecialGenericNode(ni)) {
                return false;
            }
            if (ni == this.theGeo) {
                this.topNetwork = HierarchyEnumerator.getRootNetwork(this.childNet, info);
            }
            return false;
        }
    }

    public static class NodableNameProxy
    extends NameProxy {
        static final long serialVersionUID = 0L;
        private Nodable nodable;

        @Override
        public String leafName() {
            return this.nodable.getName();
        }

        public NodableNameProxy(VarContext context, String sep, Nodable node) {
            super(context, sep);
            this.nodable = node;
        }

        @Override
        public Cell leafCell() {
            return this.nodable.getParent();
        }

        public Nodable getNodable() {
            return this.nodable;
        }
    }

    public static class NetNameProxy
    extends NameProxy {
        static final long serialVersionUID = 0L;
        private Network net;

        @Override
        public String leafName() {
            Iterator<String> it = this.net.getNames();
            if (it.hasNext()) {
                return it.next();
            }
            return "netIndex" + this.net.getNetIndex();
        }

        public Iterator<String> leafNames() {
            return this.net.getNames();
        }

        public NetNameProxy(VarContext context, String sep, Network net) {
            super(context, sep);
            this.net = net;
        }

        @Override
        public Cell leafCell() {
            return this.net.getParent();
        }

        public Network getNet() {
            return this.net;
        }
    }

    public static abstract class NameProxy
    implements Serializable {
        private VarContext context;
        private String sep;

        private String makePath(VarContext context, String sep) {
            Object path = context.getInstPath(sep);
            if (!((String)path).equals("")) {
                path = (String)path + sep;
            }
            return path;
        }

        protected NameProxy(VarContext context, String sep) {
            this.context = context;
            this.sep = sep;
        }

        public abstract String leafName();

        public abstract Cell leafCell();

        public VarContext getContext() {
            return this.context;
        }

        public String toString() {
            return this.makePath(this.context, this.sep) + this.leafName();
        }

        public String toString(int numRemoveParents) {
            VarContext localContext = this.context.removeParentContext(numRemoveParents);
            String ret = this.makePath(localContext, this.sep) + this.leafName();
            return ret;
        }
    }
}

