/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.BusParameters;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class Export
extends ElectricObject
implements PortProto,
Comparable<Export> {
    public static final Export[] NULL_ARRAY = new Export[0];
    public static final Variable.Key EXPORT_NAME = Variable.newKey("EXPORT_name");
    public static final Variable.Key EXPORT_PREFERRED_ARCS = Variable.newKey("EXPORT_preferred_arcs");
    public static final Variable.Key EXPORT_REFERENCE_NAME = Variable.newKey("EXPORT_reference_name");
    private ImmutableExport d;
    private final Cell parent;
    private int portIndex;

    Export(ImmutableExport d2, Cell parent) {
        this.parent = parent;
        this.d = d2;
        assert (d2.exportId.parentId == parent.getId());
    }

    private Object writeReplace() {
        return new ExportKey(this);
    }

    public static Export newInst(Cell parent, PortInst portInst, String protoName, EditingPreferences ep) {
        return Export.newInst(parent, portInst, protoName, ep, null);
    }

    @Deprecated
    public static Export newInst(Cell parent, PortInst portInst, String protoName, PortCharacteristic characteristic) {
        return Export.newInst(parent, portInst, protoName, EditingPreferences.getInstance(), characteristic);
    }

    public static Export newInst(Cell parent, PortInst portInst, String protoName, EditingPreferences ep, PortCharacteristic characteristic) {
        Export export = Export.newInstanceNoIcon(parent, portInst, protoName, ep, characteristic);
        if (export == null) {
            return null;
        }
        protoName = export.getName();
        Cell icon = parent.iconView();
        if (icon != null && icon.findExport(protoName) == null) {
            ERectangle bounds = parent.getBounds();
            double locX = portInst.getPoly().getCenterX();
            double locY = portInst.getPoly().getCenterY();
            ERectangle iconBounds = icon.getBounds();
            EDimension alignmentToGrid = ep.getAlignmentToGrid();
            double newlocX = (locX - ((RectangularShape)bounds).getMinX()) / ((RectangularShape)bounds).getWidth() * ((RectangularShape)iconBounds).getWidth() + ((RectangularShape)iconBounds).getMinX();
            newlocX = DBMath.toNearest(newlocX, alignmentToGrid.getWidth());
            double bodyDX = ep.getIconGenLeadLength();
            double distToXEdge = locX - ((RectangularShape)bounds).getMinX();
            if (locX >= ((RectangularShape)bounds).getCenterX()) {
                bodyDX = -bodyDX;
                distToXEdge = ((RectangularShape)bounds).getMaxX() - locX;
            }
            double newlocY = (locY - ((RectangularShape)bounds).getMinY()) / ((RectangularShape)bounds).getHeight() * ((RectangularShape)iconBounds).getHeight() + ((RectangularShape)iconBounds).getMinY();
            newlocY = DBMath.toNearest(newlocY, alignmentToGrid.getHeight());
            double bodyDY = ep.getIconGenLeadLength();
            double distToYEdge = locY - ((RectangularShape)bounds).getMinY();
            if (locY >= ((RectangularShape)bounds).getCenterY()) {
                bodyDY = -bodyDY;
                distToYEdge = ((RectangularShape)bounds).getMaxY() - locY;
            }
            if (distToXEdge > distToYEdge) {
                bodyDX = 0.0;
            } else {
                bodyDY = 0.0;
            }
            Point2D.Double point = new Point2D.Double(newlocX, newlocY);
            DBMath.gridAlign(point, alignmentToGrid);
            newlocX = ((Point2D)point).getX();
            newlocY = ((Point2D)point).getY();
            int rotation = ViewChanges.iconTextRotation(export, ep);
            if (!IconParameters.makeIconExport(export, ep, 0, newlocX, newlocY, newlocX + bodyDX, newlocY + bodyDY, icon, rotation)) {
                System.out.println("Warning: Failed to create associated export in icon " + icon.describe(true));
            }
        }
        return export;
    }

    public static Export newInstanceNoIcon(Cell parent, PortInst portInst, String protoName, EditingPreferences ep, PortCharacteristic characteristic) {
        PortCharacteristic newCharacteristic;
        ExportId exportId;
        if (protoName == null) {
            return null;
        }
        boolean busNamesAllowed = parent.busNamesAllowed();
        Name protoNameKey = ImmutableExport.validExportName(protoName, busNamesAllowed);
        if (protoNameKey == null && (protoNameKey = ImmutableExport.validExportName(protoName = protoName.replace(':', '_'), busNamesAllowed)) == null) {
            System.out.println("Bad export name " + protoName + " : " + Name.checkName(protoName));
            return null;
        }
        if (parent.findExport(protoName) != null) {
            String oldName = protoName;
            if ((protoName = ElectricObject.uniqueObjectName(protoName, parent, Export.class, false, true)) == null) {
                System.out.println(String.valueOf(parent) + " already has an export named " + oldName + ", export was not created");
                return null;
            }
            System.out.println(String.valueOf(parent) + " already has an export named " + oldName + ", making new export named " + protoName);
            assert (parent.findExport(protoName) == null);
        }
        if ((exportId = parent.getD().cellId.newPortId(protoName)).inDatabase(parent.getDatabase()) != null) {
            exportId = parent.getD().cellId.randomExportId(protoName);
        }
        PortProto originalProto = portInst.getPortProto();
        boolean alwaysDrawn = false;
        boolean bodyOnly = false;
        if (originalProto instanceof Export) {
            Export e2 = (Export)originalProto;
            alwaysDrawn = e2.isAlwaysDrawn();
            bodyOnly = e2.isBodyOnly();
        }
        if ((newCharacteristic = characteristic) == null) {
            newCharacteristic = originalProto.getCharacteristic();
        }
        return Export.newInstanceNoIcon(parent, exportId, protoName, Export.smartPlacement(portInst, ep), portInst, alwaysDrawn, bodyOnly, newCharacteristic, null);
    }

    public static Export newInstanceNoIcon(Cell parent, ExportId exportId, String name, TextDescriptor nameTextDescriptor, PortInst originalPort, boolean alwaysDrawn, boolean bodyOnly, PortCharacteristic characteristic, ErrorLogger errorLogger) {
        assert (parent.isLinked());
        String errorMsg = null;
        if (exportId.inDatabase(parent.getDatabase()) != null) {
            errorMsg = String.valueOf(parent) + " already has exportId " + exportId.externalId;
            System.out.println(errorMsg);
            errorLogger.logError(errorMsg, parent, 1);
            return null;
        }
        if (name == null) {
            name = exportId.externalId;
        }
        if (originalPort == null || !originalPort.isLinked()) {
            System.out.println("Null port on Export " + name + " in " + String.valueOf(parent));
            return null;
        }
        NodeInst originalNode = originalPort.getNodeInst();
        PortProto subpp = originalPort.getPortProto();
        if (originalNode.getParent() != parent || subpp.getParent() != originalNode.getProto()) {
            System.out.println("Bad port on Export " + name + " in " + String.valueOf(parent));
            return null;
        }
        if (ImmutableExport.validExportName(name, parent.busNamesAllowed()) == null) {
            errorMsg = String.valueOf(parent) + " has bad export name " + name + " ";
            String newName = Export.repairExportName(parent, name);
            if (newName == null) {
                newName = Export.repairExportName(parent, "X");
            }
            if (newName == null) {
                errorMsg = errorMsg + " removed ";
                System.out.println(errorMsg);
                errorLogger.logError(errorMsg, parent, 1);
                return null;
            }
            errorMsg = errorMsg + " renamed to " + newName;
            name = newName;
        }
        if (parent.findExport(name) != null) {
            errorMsg = String.valueOf(parent) + " has duplicate export name " + name + " ";
            errorMsg = errorMsg + " removed ";
            System.out.println(errorMsg);
            errorLogger.logError(errorMsg, parent, 1);
            return null;
        }
        if (nameTextDescriptor == null) {
            throw new NullPointerException();
        }
        ImmutableExport d2 = ImmutableExport.newInst(exportId, Name.findName(name), nameTextDescriptor, originalNode.getNodeId(), subpp.getId(), alwaysDrawn, bodyOnly, characteristic);
        Export e2 = parent.addExport(d2);
        assert (e2.getOriginalPort() == originalPort);
        if (errorMsg != null) {
            System.out.println(errorMsg);
            if (errorLogger != null) {
                errorLogger.logError(errorMsg, e2, 1);
            }
        }
        return e2;
    }

    public void kill() {
        this.parent.killExports(Collections.singleton(this));
    }

    public void rename(String newName) {
        Name newNameKey;
        this.checkChanging();
        String dupName = ElectricObject.uniqueObjectName(newName, this.parent, Export.class, false, true);
        if (!dupName.equals(newName)) {
            System.out.println(String.valueOf(this.parent) + " already has an export named " + newName + ", making new export named " + dupName);
            newName = dupName;
        }
        if ((newNameKey = ImmutableExport.validExportName(newName, this.parent.busNamesAllowed())) == null) {
            System.out.println("Bad export name " + newName + " : " + Name.checkName(newName));
            return;
        }
        Name oldName = this.getNameKey();
        this.parent.moveExport(this.portIndex, newName);
        this.setD(this.d.withName(newNameKey), true);
        if (this.parent.getView() == View.SCHEMATIC) {
            block0: for (Cell iconCell : this.parent.getCellsInGroup()) {
                if (iconCell.getView() != View.ICON) continue;
                Iterator<Export> it = iconCell.getExports();
                while (it.hasNext()) {
                    Export pp = it.next();
                    if (!pp.getName().equals(oldName.toString())) continue;
                    pp.rename(newName);
                    continue block0;
                }
            }
        }
    }

    public boolean move(PortInst newPi) {
        this.checkChanging();
        NodeInst newno = newPi.getNodeInst();
        PortProto newsubpt = newPi.getPortProto();
        if (newno.getParent() != this.parent) {
            return true;
        }
        if (newsubpt.getParent() != newno.getProto()) {
            return true;
        }
        if (this.doesntConnect(newsubpt.getBasePort())) {
            return true;
        }
        ImmutableExport oldD = this.d;
        this.lowLevelModify(this.d.withOriginalPort(newno.getNodeId(), newsubpt.getId()));
        Constraints.getCurrent().modifyExport(this, oldD);
        this.changeallports();
        return false;
    }

    public void lowLevelModify(ImmutableExport d2) {
        boolean moved;
        assert (this.isLinked());
        boolean renamed = this.getNameKey() != d2.name;
        boolean bl = moved = this.d.originalNodeId != d2.originalNodeId || this.d.originalPortId != d2.originalPortId;
        if (moved) {
            this.parent.getNodeById(this.d.originalNodeId).redoGeometric();
        }
        if (renamed) {
            this.parent.moveExport(this.portIndex, d2.name.toString());
        }
        this.setD(d2, false);
        if (moved) {
            this.parent.getNodeById(d2.originalNodeId).redoGeometric();
        }
    }

    void setPortIndex(int portIndex) {
        this.portIndex = portIndex;
    }

    public void copyStateBits(Export other) {
        this.setAlwaysDrawn(other.isAlwaysDrawn());
        this.setBodyOnly(other.isBodyOnly());
        this.setCharacteristic(other.getCharacteristic());
    }

    public Poly getNamePoly() {
        Poly poly = this.getPoly();
        double cX = poly.getCenterX();
        double cY = poly.getCenterY();
        TextDescriptor td = this.getTextDescriptor(EXPORT_NAME);
        double offX = td.getXOff();
        double offY = td.getYOff();
        AbstractTextDescriptor.Position pos = td.getPos();
        Poly.Type style = pos.getPolyType();
        PolyBase.Point[] pointList = new PolyBase.Point[1];
        NodeInst ni = this.getOriginalPort().getNodeInst();
        if (!ni.getOrient().equals(Orientation.IDENT)) {
            pointList[0] = Poly.fromLambda(cX, cY);
            FixpTransform trans = ni.rotateIn();
            trans.transform(pointList[0], pointList[0]);
            pointList[0].setLocation(pointList[0].getX() + offX, pointList[0].getY() + offY);
            trans = ni.rotateOut();
            trans.transform(pointList[0], pointList[0]);
        } else {
            pointList[0] = Poly.fromLambda(cX + offX, cY + offY);
        }
        poly = new Poly(pointList);
        poly.setStyle(style);
        poly.setPort(this);
        poly.setString(this.getName());
        poly.setTextDescriptor(td);
        poly.setDisplayedText(new DisplayedText(this, EXPORT_NAME));
        return poly;
    }

    public Poly getPoly() {
        return this.getOriginalPort().getPoly();
    }

    @Override
    public Cell whichCell() {
        return this.parent;
    }

    @Override
    public ImmutableExport getD() {
        return this.d;
    }

    boolean setD(ImmutableExport newD, boolean notify) {
        this.checkChanging();
        ImmutableExport oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        if (this.parent != null) {
            this.parent.setContentsModified();
            this.d = newD;
            if (notify) {
                Constraints.getCurrent().modifyExport(this, oldD);
            }
        } else {
            this.d = newD;
        }
        return true;
    }

    void setDInUndo(ImmutableExport newD) {
        this.checkUndoing();
        this.d = newD;
    }

    @Override
    public void addVar(Variable var) {
        this.setD(this.d.withVariable(var), true);
    }

    @Override
    public void delVar(Variable.Key key) {
        this.setD(this.d.withoutVariable(key), true);
    }

    public void copyVarsFrom(Export other) {
        this.checkChanging();
        Iterator<Variable> it = other.getVariables();
        while (it.hasNext()) {
            this.addVar(it.next());
        }
        if (this.getParent().isIcon()) {
            it = this.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (var.getKey() != BusParameters.EXPORT_BUS_TEMPLATE) continue;
                this.delVar(var.getKey());
                break;
            }
        }
    }

    @Override
    public ExportId getId() {
        return this.d.exportId;
    }

    @Override
    public Cell getParent() {
        return this.parent;
    }

    public int getChronIndex() {
        return this.d.exportId.chronIndex;
    }

    @Override
    public int getPortIndex() {
        return this.portIndex;
    }

    @Override
    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        if (varKey == EXPORT_NAME) {
            return this.d.nameDescriptor;
        }
        return super.getTextDescriptor(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        if (varKey == EXPORT_NAME) {
            this.setD(this.d.withNameDescriptor(td), true);
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == EXPORT_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    private static TextDescriptor smartPlacement(PortInst originalPort, EditingPreferences ep) {
        int smartVertical = ep.getSmartVerticalPlacementExport();
        int smartHorizontal = ep.getSmartHorizontalPlacementExport();
        if (smartVertical == 0 && smartHorizontal == 0) {
            return ep.getExportTextDescriptor();
        }
        double dx = 0.0;
        double dy = 0.0;
        NodeInst ni = originalPort.getNodeInst();
        ERectangle nodeBounds = ni.getBounds();
        Iterator<Connection> it = originalPort.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            ERectangle arcBounds = ai.getBounds();
            dx = ((RectangularShape)arcBounds).getCenterX() - ((RectangularShape)nodeBounds).getCenterX();
            dy = ((RectangularShape)arcBounds).getCenterY() - ((RectangularShape)nodeBounds).getCenterY();
        }
        if (smartHorizontal == 2) {
            dx = -dx;
        } else if (smartHorizontal != 1) {
            dx = 0.0;
        }
        if (smartVertical == 2) {
            dy = -dy;
        } else if (smartVertical != 1) {
            dy = 0.0;
        }
        TextDescriptor td = ep.getExportTextDescriptor();
        return td.withPos(td.getPos().align(Double.compare(dx, 0.0), Double.compare(dy, 0.0)));
    }

    @Override
    public Name getNameKey() {
        return this.d.name;
    }

    @Override
    public String getName() {
        return this.d.name.toString();
    }

    public String getShortName() {
        return Export.getShortName(this.getNameKey().toString());
    }

    public static String getShortName(String name) {
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char ch = name.charAt(i2);
            if (TextUtils.isLetterOrDigit(ch)) continue;
            return name.substring(0, i2);
        }
        return name;
    }

    public static String repairExportName(Cell parent, String name) {
        int openIndex;
        Object newName = null;
        int oldBusWidth = Name.findName(name).busWidth();
        if (!parent.busNamesAllowed()) {
            oldBusWidth = 1;
        }
        if ((openIndex = name.indexOf(91)) >= 0) {
            int lastOpenIndex;
            int afterOpenIndex;
            for (afterOpenIndex = openIndex + 1; afterOpenIndex < name.length() && name.charAt(afterOpenIndex) == '['; ++afterOpenIndex) {
            }
            int closeIndex = name.lastIndexOf(93);
            if (closeIndex < 0 && (lastOpenIndex = name.lastIndexOf(91)) > afterOpenIndex) {
                closeIndex = lastOpenIndex;
            }
            if (afterOpenIndex < closeIndex) {
                newName = name.substring(0, openIndex) + name.substring(closeIndex + 1) + "[" + name.substring(afterOpenIndex, closeIndex) + "]";
            }
        }
        if (Export.validExportName(newName, oldBusWidth) && Export.validExportName((String)(newName = ElectricObject.uniqueObjectName(newName, parent, Export.class, false, true)), oldBusWidth)) {
            return newName;
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (ch == '[' || ch == ']' || ch == ':' || ch == ',' || ch == '@') {
                ch = 'X';
            }
            sb.append(ch);
        }
        newName = sb.toString();
        if (Export.validExportName((String)newName, oldBusWidth) && Export.validExportName((String)(newName = ElectricObject.uniqueObjectName((String)newName, parent, Export.class, false, true)), oldBusWidth)) {
            return newName;
        }
        return null;
    }

    private static boolean validExportName(String name, int busWidth) {
        Name nameKey = ImmutableExport.validExportName(name, true);
        return nameKey != null && nameKey.busWidth() == busWidth;
    }

    @Override
    public int compareTo(Export that) {
        int cmp;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        return this.d.name.toString().compareTo(that.d.name.toString());
    }

    @Override
    public String toString() {
        return "export '" + this.getName() + "'";
    }

    public PortInst getOriginalPort() {
        return this.parent.getPortInst(this.d.originalNodeId, this.d.originalPortId);
    }

    @Override
    public PrimitivePort getBasePort() {
        PortProto pp = this.d.originalPortId.inDatabase(this.getDatabase());
        return pp.getBasePort();
    }

    @Override
    public boolean connectsTo(ArcProto arc) {
        return this.getBasePort().connectsTo(arc);
    }

    @Override
    public PortCharacteristic getCharacteristic() {
        return this.d.characteristic;
    }

    public void setCharacteristic(PortCharacteristic characteristic) {
        this.setD(this.d.withCharacteristic(characteristic), true);
    }

    @Override
    public boolean isPower() {
        return this.getD().isPower();
    }

    @Override
    public boolean isGround() {
        return this.getD().isGround();
    }

    public boolean isGlobalPartition() {
        return this.d.originalPortId.parentId == Schematics.tech().globalPartitionNode.getId();
    }

    public void setAlwaysDrawn(boolean b2) {
        this.setD(this.d.withAlwaysDrawn(b2), true);
    }

    public boolean isAlwaysDrawn() {
        return this.d.alwaysDrawn;
    }

    public void setBodyOnly(boolean b2) {
        this.setD(this.d.withBodyOnly(b2), true);
    }

    public boolean isBodyOnly() {
        return this.d.bodyOnly;
    }

    @Override
    public boolean isLinked() {
        try {
            return this.parent.isLinked() && this.parent.getPort(this.portIndex) == this;
        }
        catch (IndexOutOfBoundsException e2) {
            return false;
        }
    }

    @Override
    public EDatabase getDatabase() {
        return this.parent.getDatabase();
    }

    public Export findEquivalent(Cell otherCell) {
        return this.findEquivalent2(otherCell);
    }

    private Export findEquivalent2(Cell otherCell) {
        Export sameNamedExport = otherCell.findExport(this.getName());
        if (sameNamedExport != null) {
            return sameNamedExport;
        }
        IdentityHashMap exportNames = new IdentityHashMap();
        Name thisBusName = this.getNameKey();
        int wid = thisBusName.busWidth();
        for (int i2 = 0; i2 < wid; ++i2) {
            exportNames.put(thisBusName.subname(i2), null);
        }
        Export bestExport = null;
        int bestDifference = Integer.MAX_VALUE;
        Iterator<Export> eIt = otherCell.getExports();
        block1: while (eIt.hasNext()) {
            Export e2 = eIt.next();
            Name thatBusName = e2.getNameKey();
            int otherWid = thatBusName.busWidth();
            for (int i3 = 0; i3 < otherWid; ++i3) {
                if (!exportNames.containsKey(thatBusName.subname(i3))) continue;
                assert (wid > 0 || otherWid > 1);
                int difference = Math.abs(wid - otherWid);
                if (difference >= bestDifference) continue block1;
                bestExport = e2;
                bestDifference = difference;
                continue block1;
            }
        }
        return bestExport;
    }

    public List<Export> findAllEquivalents(Cell otherCell, boolean mustContain) {
        ArrayList<Export> allEquivalents = new ArrayList<Export>();
        Export sameNamedExport = otherCell.findExport(this.getName());
        if (sameNamedExport != null) {
            allEquivalents.add(sameNamedExport);
            return allEquivalents;
        }
        IdentityHashMap exportNames = new IdentityHashMap();
        Name thisBusName = this.getNameKey();
        int wid = thisBusName.busWidth();
        if (wid <= 1 && !mustContain) {
            return allEquivalents;
        }
        for (int i2 = 0; i2 < wid; ++i2) {
            exportNames.put(thisBusName.subname(i2), null);
        }
        Iterator<Export> eIt = otherCell.getExports();
        block1: while (eIt.hasNext()) {
            Export e2 = eIt.next();
            Name thatBusName = e2.getNameKey();
            int otherWid = thatBusName.busWidth();
            if (mustContain) {
                boolean contains = true;
                for (int i3 = 0; i3 < otherWid; ++i3) {
                    if (exportNames.containsKey(thatBusName.subname(i3))) continue;
                    contains = false;
                    break;
                }
                if (!contains) continue;
                allEquivalents.add(e2);
                continue;
            }
            for (int i4 = 0; i4 < otherWid; ++i4) {
                if (!exportNames.containsKey(thatBusName.subname(i4))) continue;
                allEquivalents.add(e2);
                continue block1;
            }
        }
        return allEquivalents;
    }

    public boolean doesntConnect(PrimitivePort newPP) {
        Connection con = this.doesntConnectCon(newPP);
        if (con == null) {
            return false;
        }
        ArcInst ai = con.getArc();
        System.out.println("Arc " + ai.describe(false) + " in cell " + ai.getParent().describe(false) + " cannot connect to port " + this.getName());
        return true;
    }

    public Connection doesntConnectCon(PrimitivePort newPP) {
        Iterator<NodeInst> it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            PortInst pi = ni.findPortInstFromProto(this);
            Iterator<Connection> cIt = pi.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                if (newPP.connectsTo(con.getArc().getProto())) continue;
                System.out.println(String.valueOf(con.getArc()) + " in " + String.valueOf(ni.getParent()) + " cannot connect to port " + this.getName());
                return con;
            }
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Connection subCon;
                Export oPP = eIt.next();
                if (oPP.getOriginalPort().getPortProto() != this || (subCon = oPP.doesntConnectCon(newPP)) == null) continue;
                return subCon;
            }
        }
        return null;
    }

    private void changeallports() {
        this.recursivelyChangeAllPorts();
        if (this.parent.isIcon()) {
            Cell onp = this.parent.contentsView();
            if (onp != null) {
                List<Export> opps = this.findAllEquivalents(onp, true);
                for (Export opp : opps) {
                    opp.setCharacteristic(this.getCharacteristic());
                    opp.recursivelyChangeAllPorts();
                }
            }
            return;
        }
        Cell onp = this.parent.iconView();
        if (onp != null) {
            List<Export> opps = this.findAllEquivalents(onp, true);
            for (Export opp : opps) {
                opp.setCharacteristic(this.getCharacteristic());
                opp.recursivelyChangeAllPorts();
            }
        }
    }

    private void recursivelyChangeAllPorts() {
        this.parent.recursivelyChangeAllPorts(Collections.singleton(this));
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortProto no = (PortProto)obj;
        if (!this.getNameKey().equals(no.getNameKey())) {
            if (buffer != null) {
                buffer.append("'" + String.valueOf(this) + "' and '" + String.valueOf(no) + "' do not have same name\n");
            }
            return false;
        }
        PortCharacteristic noC = no.getCharacteristic();
        if (!this.getCharacteristic().getName().equals(noC.getName())) {
            if (buffer != null) {
                buffer.append("'" + String.valueOf(this) + "' and '" + String.valueOf(no) + "' do not have same characteristic\n");
            }
            return false;
        }
        return true;
    }

    private static class ExportKey
    extends EObjectInputStream.Key<Export> {
        public ExportKey() {
        }

        private ExportKey(Export export) {
            super(export);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Export export) throws IOException {
            ExportId exportId = export.getId();
            if (export.getDatabase() != out.getDatabase() || !export.isLinked()) {
                throw new NotSerializableException(String.valueOf(export) + " not linked");
            }
            out.writeObject(exportId);
        }

        @Override
        public Export readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            ExportId exportId = (ExportId)in.readObject();
            Export export = exportId.inDatabase(in.getDatabase());
            if (export == null) {
                throw new InvalidObjectException(String.valueOf(exportId) + " not linked");
            }
            return export;
        }
    }
}

