/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import java.util.SortedMap;
import java.util.TreeMap;

public class RadixTrie<V> {
    private final Node root = new Node('\u0000', null);
    private final int[] scores = new int[65535];

    public char guessHierarchySeparator() {
        int best = 0;
        char ret = '\u0000';
        for (int i2 = 0; i2 < this.scores.length; ++i2) {
            if (this.scores[i2] <= best) continue;
            best = this.scores[i2];
            ret = (char)i2;
        }
        return ret;
    }

    public V get(String key) {
        return this.root.get(key);
    }

    public void put(String key, V value) {
        System.out.println("put \"" + key + "\"");
        if (value == null) {
            throw new RuntimeException("deletions not yet implemented");
        }
        this.root.put(key, value);
    }

    private class Node {
        private char firstChar;
        private V entry;
        private TreeMap<String, Node> children = null;

        public Node(char firstChar, V value) {
            this.firstChar = firstChar;
            this.entry = value;
        }

        private String getPrev(String key) {
            if (this.children == null) {
                return null;
            }
            SortedMap<String, Node> prevMap = this.children.headMap(key);
            return prevMap.size() == 0 ? null : prevMap.lastKey();
        }

        public void put(String key, V value) {
            if (key.length() != 0 && this.children == null) {
                this.children = new TreeMap();
            }
            String prev = this.getPrev(key);
            if (key.length() == 0) {
                this.entry = value;
            } else if (this.children.containsKey(key)) {
                this.children.get(key).put("", value);
            } else if (prev != null && key.startsWith(prev)) {
                this.children.get(prev).put(key.substring(prev.length()), value);
            } else if (prev == null || prev.charAt(0) != key.charAt(0)) {
                if (this.children == null) {
                    this.children = new TreeMap();
                }
                this.children.put(key, new Node(key.charAt(0), value));
                int n2 = this.firstChar & 0xFFFF;
                RadixTrie.this.scores[n2] = RadixTrie.this.scores[n2] + 1;
            } else {
                int i2 = 0;
                for (i2 = 0; i2 < Math.min(key.length(), prev.length()) && key.charAt(i2) == prev.charAt(i2); ++i2) {
                }
                Node oldnode = this.children.get(prev);
                this.children.remove(prev);
                int n3 = this.firstChar & 0xFFFF;
                RadixTrie.this.scores[n3] = RadixTrie.this.scores[n3] - 1;
                Node newnode = new Node(key.charAt(i2 - 1), null);
                this.children.put(key.substring(0, i2), newnode);
                int n4 = this.firstChar & 0xFFFF;
                RadixTrie.this.scores[n4] = RadixTrie.this.scores[n4] + 1;
                if (newnode.children == null) {
                    newnode.children = new TreeMap();
                }
                newnode.children.put(key.substring(i2), new Node(key.charAt(key.length() - 1), value));
                int n5 = newnode.firstChar & 0xFFFF;
                RadixTrie.this.scores[n5] = RadixTrie.this.scores[n5] + 1;
                newnode.children.put(prev.substring(i2), oldnode);
                int n6 = newnode.firstChar & 0xFFFF;
                RadixTrie.this.scores[n6] = RadixTrie.this.scores[n6] + 1;
            }
        }

        public V get(String key) {
            String prev;
            if (key.length() == 0) {
                return this.entry;
            }
            if (this.children == null) {
                return null;
            }
            if (this.children.containsKey(key)) {
                return this.children.get(key).get("");
            }
            SortedMap<String, Node> prevMap = this.children.headMap(key);
            String string = prev = prevMap.size() == 0 ? null : prevMap.lastKey();
            if (prev != null && key.startsWith(prev)) {
                return this.children.get(prev).get(key.substring(prev.length()));
            }
            return null;
        }
    }
}

