/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyNodeMerge;
import com.sun.electric.technology.Layer;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PolyQTree
extends GeometryHandler {
    private static int MAX_NUM_CHILDREN = 4;
    private static int MAX_NUM_NODES = 10;
    private Rectangle2D rootBox;

    public PolyQTree(Rectangle2D root) {
        this.rootBox = root;
    }

    public void print() {
        for (Object obj : this.layers.values()) {
            PolyQNode root = (PolyQNode)obj;
            if (root == null) continue;
            root.print();
        }
    }

    public Collection getObjects(Object layer, boolean modified, boolean simple) {
        new Error("This class is being decomissioned");
        HashSet<PolyNode> objSet = new HashSet<PolyNode>();
        PolyQNode root = (PolyQNode)this.layers.get(layer);
        if (root != null) {
            root.getLeafObjects(objSet, modified, simple);
            HashSet<PolyNode> toRemove = new HashSet<PolyNode>();
            HashSet<PolyNode> toAdd = new HashSet<PolyNode>();
            for (PolyNode node : objSet) {
                if (node.isOriginal() || !simple) continue;
                toRemove.add(node);
                toAdd.addAll(node.getSimpleObjects(false));
            }
            objSet.addAll(toAdd);
            objSet.removeAll(toRemove);
        }
        return objSet;
    }

    public void add(Layer layer, Object newObj, boolean fasterAlgorithm) {
        HashSet<PolyNode> removedElems;
        Rectangle2D areaBB;
        PolyNode obj = (PolyNode)newObj;
        PolyQNode root = (PolyQNode)this.layers.get(layer);
        if (root == null) {
            root = new PolyQNode();
            this.layers.put(layer, root);
        }
        if (!root.findAndRemoveObjects(this.rootBox, obj, areaBB = obj.getBounds2D(), fasterAlgorithm, removedElems = new HashSet<PolyNode>())) {
            for (PolyNode node : removedElems) {
                obj.add(node);
            }
            areaBB = obj.getBounds2D();
            root.insert(this.rootBox, obj, areaBB, removedElems);
        }
    }

    @Override
    public void addAll(GeometryHandler subMerge, FixpTransform trans) {
        PolyQTree other = (PolyQTree)subMerge;
        for (Layer layer : other.layers.keySet()) {
            Set set = (Set)other.getObjects(layer, false, false);
            for (PolyNode geo : set) {
                PolyNode clone = new PolyNode(geo);
                if (trans != null) {
                    clone.transform(trans);
                }
                this.add(layer, clone, false);
            }
        }
    }

    private static class PolyQNode {
        private Set<PolyNode> nodes;
        private PolyQNode[] children;

        private PolyQNode() {
        }

        private int getQuadrants(double centerX, double centerY, Rectangle2D box) {
            int loc = 0;
            if (box.getMinY() < centerY) {
                if (box.getMinX() < centerX) {
                    loc |= 1;
                }
                if (box.getMaxX() > centerX) {
                    loc |= 2;
                }
            }
            if (box.getMaxY() > centerY) {
                if (box.getMinX() < centerX) {
                    loc |= 4;
                }
                if (box.getMaxX() > centerX) {
                    loc |= 8;
                }
            }
            return loc;
        }

        private Rectangle2D getBox(double x, double y, double w, double h2, double centerX, double centerY, int loc) {
            if ((loc >> 0 & 1) == 1) {
                x = centerX;
            }
            if ((loc >> 1 & 1) == 1) {
                y = centerY;
            }
            return new Rectangle2D.Double(x, y, w, h2);
        }

        protected void getLeafObjects(Set<PolyNode> set, boolean modified, boolean simple) {
            if (this.nodes != null) {
                for (PolyNode node : this.nodes) {
                    if (modified && (!modified || node.isOriginal())) continue;
                    set.add(node);
                }
            }
            if (this.children == null) {
                return;
            }
            for (int i2 = 0; i2 < MAX_NUM_CHILDREN; ++i2) {
                if (this.children[i2] == null) continue;
                this.children[i2].getLeafObjects(set, modified, simple);
            }
        }

        protected void print() {
            if (this.nodes == null) {
                return;
            }
            Iterator<PolyNode> it = this.nodes.iterator();
            while (it.hasNext()) {
                System.out.println("Area " + String.valueOf(it.next()));
            }
            if (this.children == null) {
                return;
            }
            for (int i2 = 0; i2 < MAX_NUM_CHILDREN; ++i2) {
                if (this.children[i2] == null) continue;
                this.children[i2].print();
            }
        }

        private boolean compact() {
            if (this.children != null) {
                for (int i2 = 0; i2 < MAX_NUM_CHILDREN; ++i2) {
                    if (this.children[i2] == null) continue;
                    return false;
                }
            }
            return this.nodes == null || this.nodes.isEmpty();
        }

        protected boolean findAndRemoveObjects(Rectangle2D box, PolyNode obj, Rectangle2D areaBB, boolean fasterAlgorithm, Set<PolyNode> removedElems) {
            double centerX = box.getCenterX();
            double centerY = box.getCenterY();
            if (this.children != null) {
                int loc = this.getQuadrants(centerX, centerY, areaBB);
                double w = box.getWidth() / 2.0;
                double h2 = box.getHeight() / 2.0;
                double x = box.getX();
                double y = box.getY();
                for (int i2 = 0; i2 < MAX_NUM_CHILDREN; ++i2) {
                    if ((loc >> i2 & 1) != 1) continue;
                    Rectangle2D bb = this.getBox(x, y, w, h2, centerX, centerY, i2);
                    if (this.children[i2] == null) continue;
                    if (this.children[i2].findAndRemoveObjects(bb, obj, areaBB, fasterAlgorithm, removedElems)) {
                        return true;
                    }
                    if (!this.children[i2].compact()) continue;
                    this.children[i2] = null;
                }
            } else if (this.nodes != null) {
                HashSet<PolyNode> deleteSet = new HashSet<PolyNode>();
                for (PolyNode node : this.nodes) {
                    if (node.equals((Object)obj)) {
                        if (removedElems.size() != 0) {
                            System.out.println("I will have problems here!!");
                        }
                        return true;
                    }
                    if (fasterAlgorithm && (!fasterAlgorithm || !node.intersects(obj))) continue;
                    removedElems.add(node);
                    obj.setNotOriginal();
                    deleteSet.add(node);
                }
                this.nodes.removeAll(deleteSet);
                if (this.nodes.size() == 0) {
                    this.nodes.clear();
                    this.nodes = null;
                }
            }
            return false;
        }

        protected boolean insertInAllChildren(Rectangle2D box, double centerX, double centerY, PolyNode obj, Rectangle2D areaBB, Set removedElems) {
            int loc = this.getQuadrants(centerX, centerY, areaBB);
            boolean inserted = false;
            double w = box.getWidth() / 2.0;
            double h2 = box.getHeight() / 2.0;
            double x = box.getX();
            double y = box.getY();
            for (int i2 = 0; i2 < MAX_NUM_CHILDREN; ++i2) {
                if ((loc >> i2 & 1) != 1) continue;
                Rectangle2D bb = this.getBox(x, y, w, h2, centerX, centerY, i2);
                if (this.children[i2] == null) {
                    this.children[i2] = new PolyQNode();
                }
                boolean done = this.children[i2].insert(bb, obj, areaBB, removedElems);
                inserted = inserted ? inserted : done;
            }
            return inserted;
        }

        protected boolean insert(Rectangle2D box, PolyNode obj, Rectangle2D areaBB, Set removedElems) {
            if (!box.intersects(areaBB)) {
                return false;
            }
            double centerX = box.getCenterX();
            double centerY = box.getCenterY();
            if (this.children != null) {
                return this.insertInAllChildren(box, centerX, centerY, obj, areaBB, removedElems);
            }
            if (this.nodes == null) {
                this.nodes = new HashSet<PolyNode>();
            }
            boolean inserted = false;
            if (this.nodes.size() < MAX_NUM_NODES) {
                inserted = this.nodes.add(obj);
                if (removedElems != null) {
                    this.nodes.removeAll(removedElems);
                }
            } else {
                this.children = new PolyQNode[MAX_NUM_CHILDREN];
                double w = box.getWidth() / 2.0;
                double h2 = box.getHeight() / 2.0;
                double x = box.getX();
                double y = box.getY();
                for (int i2 = 0; i2 < MAX_NUM_CHILDREN; ++i2) {
                    this.children[i2] = new PolyQNode();
                    Rectangle2D bb = this.getBox(x, y, w, h2, centerX, centerY, i2);
                    for (PolyNode node : this.nodes) {
                        this.children[i2].insert(bb, node, node.getBounds2D(), removedElems);
                    }
                }
                this.nodes.clear();
                this.nodes = null;
                inserted = this.insertInAllChildren(box, centerX, centerY, obj, areaBB, null);
            }
            return inserted;
        }
    }

    public static class PolyNode
    extends Area
    implements Comparable<PolyNode>,
    PolyNodeMerge {
        private byte original;

        public PolyNode(Shape shape) {
            super(shape);
        }

        @Override
        public int compareTo(PolyNode n1) {
            return (int)(this.getArea() - n1.getArea());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Area)) {
                return obj.equals(this);
            }
            Area a2 = (Area)obj;
            return super.equals(a2);
        }

        @Override
        public PolyBase getPolygon() {
            return new PolyBase(this.getPoints(false));
        }

        public int hasCode() {
            throw new UnsupportedOperationException();
        }

        public double getMaxLength() {
            PolyBase.Point[] points = this.getPoints(false);
            double max = 0.0;
            for (int i2 = 0; i2 < points.length; ++i2) {
                double distance;
                int j2 = i2 - 1;
                if (j2 < 0) {
                    j2 = points.length - 1;
                }
                if (!(max < (distance = ((Point2D)points[i2]).distance(points[j2])))) continue;
                max = distance;
            }
            return max;
        }

        public PolyBase.Point[] getPoints(boolean includeInitialPoint) {
            PathIterator pi = this.getPathIterator(null);
            double[] coords = new double[6];
            ArrayList<PolyBase.Point> pointList = new ArrayList<PolyBase.Point>();
            PolyBase.Point lastMoveTo = null;
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                switch (type) {
                    case 4: {
                        if (includeInitialPoint && lastMoveTo != null) {
                            pointList.add(lastMoveTo);
                        }
                        lastMoveTo = null;
                        break;
                    }
                    default: {
                        PolyBase.Point pt = PolyBase.fromLambda(coords[0], coords[1]);
                        pointList.add(pt);
                        if (type != 0) break;
                        lastMoveTo = pt;
                    }
                }
                pi.next();
            }
            return pointList.toArray(new PolyBase.Point[pointList.size()]);
        }

        public double getPerimeter() {
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            double perimeter = 0.0;
            PathIterator pi = this.getPathIterator(null);
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        for (int i2 = 0; i2 < pointList.size(); ++i2) {
                            int j2 = (i2 + 1) % pointList.size();
                            perimeter += ((Point2D)points[i2]).distance((Point2D)points[j2]);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            return perimeter;
        }

        public boolean doesTouch(PathIterator opi) {
            Point2D.Double pt;
            int j2;
            int i2;
            Object[] points;
            class PolyEdge {
                private Point2D p1;
                private Point2D p2;

                PolyEdge(Point2D a2, Point2D b2) {
                    this.p1 = a2;
                    this.p2 = b2;
                }

                public int hashCode() {
                    return this.p1.hashCode() ^ this.p2.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof PolyEdge)) {
                        return false;
                    }
                    PolyEdge edge = (PolyEdge)obj;
                    return this.p1.equals(edge.p1) && this.p2.equals(edge.p2) || this.p1.equals(edge.p2) && this.p2.equals(edge.p1);
                }
            }
            HashMap<PolyEdge, PolyEdge> edges = new HashMap<PolyEdge, PolyEdge>();
            PathIterator pi = this.getPathIterator(null);
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        points = pointList.toArray();
                        for (i2 = 0; i2 < pointList.size(); ++i2) {
                            j2 = (i2 + 1) % pointList.size();
                            PolyEdge edge = new PolyEdge((Point2D)points[i2], (Point2D)points[j2]);
                            edges.put(edge, edge);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            while (!opi.isDone()) {
                switch (opi.currentSegment(coords)) {
                    case 4: {
                        points = pointList.toArray();
                        for (i2 = 0; i2 < pointList.size(); ++i2) {
                            Point2D p1 = (Point2D)points[i2];
                            j2 = (i2 + 1) % pointList.size();
                            Point2D p2 = (Point2D)points[j2];
                            if (p1.equals(p2)) continue;
                            PolyEdge edge = new PolyEdge(p1, p2);
                            if (edges.containsKey(edge)) {
                                return true;
                            }
                            edges.put(edge, edge);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                opi.next();
            }
            return false;
        }

        public double getArea() {
            if (this.isRectangular()) {
                Rectangle2D bounds = this.getBounds2D();
                return bounds.getHeight() * bounds.getWidth();
            }
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            double area = 0.0;
            PathIterator pi = this.getPathIterator(null);
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        for (int i2 = 0; i2 < pointList.size(); ++i2) {
                            int j2 = (i2 + 1) % pointList.size();
                            area += ((Point2D)points[i2]).getX() * ((Point2D)points[j2]).getY();
                            area -= ((Point2D)points[j2]).getX() * ((Point2D)points[i2]).getY();
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            return (area /= 2.0) < 0.0 ? -area : area;
        }

        public String toString() {
            return "PolyNode " + String.valueOf(this.getBounds());
        }

        public boolean intersects(Area a2) {
            if (a2.isRectangular()) {
                boolean inter = this.intersects(a2.getBounds2D());
                if (inter) {
                    return inter;
                }
                inter = this.doesTouch(a2.getBounds2D().getPathIterator(null));
                return inter;
            }
            if (this.isRectangular()) {
                return a2.intersects(this.getBounds2D());
            }
            Area area = (Area)this.clone();
            area.intersect(a2);
            boolean inter = !area.isEmpty();
            return inter;
        }

        private boolean isOriginal() {
            return (this.original >> 0 & 1) == 0;
        }

        private void setNotOriginal() {
            this.original = (byte)(this.original | 1);
        }

        private Collection<PolyNode> getSimpleObjects(boolean simple) {
            HashSet<PolyNode> set = new HashSet<PolyNode>();
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            PathIterator pi = this.getPathIterator(null);
            ArrayList<GeneralPath> polyList = new ArrayList<GeneralPath>();
            boolean isSingular = this.isSingular();
            ArrayList<GeneralPath> toDelete = new ArrayList<GeneralPath>();
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        GeneralPath simplepath = new GeneralPath();
                        for (int i2 = 0; i2 < pointList.size(); ++i2) {
                            int j2 = (i2 + 1) % pointList.size();
                            Line2D.Double line = new Line2D.Double((Point2D)points[i2], (Point2D)points[j2]);
                            simplepath.append(line, true);
                        }
                        toDelete.clear();
                        if (!simple && !isSingular) {
                            for (GeneralPath pn : polyList) {
                                if (pn.contains((Point2D)pointList.get(0))) {
                                    pn.append(simplepath.getPathIterator(null), true);
                                    simplepath = null;
                                    break;
                                }
                                if (!simplepath.contains(pn.getCurrentPoint())) continue;
                                simplepath.append(pn.getPathIterator(null), true);
                                toDelete.add(pn);
                            }
                        }
                        if (simplepath != null) {
                            polyList.add(simplepath);
                        }
                        polyList.removeAll(toDelete);
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            for (GeneralPath pn : polyList) {
                PolyNode node = new PolyNode(pn);
                set.add(node);
            }
            return set;
        }

        public List getSortedLoops() {
            Collection<PolyNode> set = this.getSimpleObjects(true);
            ArrayList<PolyNode> list = new ArrayList<PolyNode>(set);
            Collections.sort(list);
            return list;
        }
    }
}

