/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SnapshotAnalyze {
    private Map<CellId, Set<ImmutableElectricObject>> added;
    private Map<CellId, Set<ImmutableElectricObject>> removed;
    private Set<CellId> portChanges;
    private Set<CellId> sizeChanges;
    private Set<CellId> cellVariableChanges;
    private List<CellId> deletedCells;
    private Snapshot newSnapshot;

    public SnapshotAnalyze(Snapshot oldSnapshot, Snapshot newSnapshot) {
        this.newSnapshot = newSnapshot;
        this.added = new HashMap<CellId, Set<ImmutableElectricObject>>();
        this.removed = new HashMap<CellId, Set<ImmutableElectricObject>>();
        this.portChanges = new HashSet<CellId>();
        this.sizeChanges = new HashSet<CellId>();
        this.cellVariableChanges = new HashSet<CellId>();
        this.deletedCells = new ArrayList<CellId>();
        block0: for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            ExportId exportId;
            int chronIndex;
            Variable[] newVars;
            Variable[] oldVars;
            CellBackup oldBackup = oldSnapshot.getCell(cellId);
            CellBackup newBackup = newSnapshot.getCell(cellId);
            assert (oldBackup != newBackup);
            if (oldBackup == null) continue;
            if (newBackup == null) {
                this.deletedCells.add(cellId);
                continue;
            }
            CellRevision oldRevision = oldBackup.cellRevision;
            CellRevision newRevision = newBackup.cellRevision;
            Set<ImmutableElectricObject> addedToCell = this.getAddedList(cellId);
            Set<ImmutableElectricObject> removedFromCell = this.getRemovedList(cellId);
            if (!oldSnapshot.getCellBounds(cellId).equals(newSnapshot.getCellBounds(cellId))) {
                this.sizeChanges.add(cellId);
            }
            if ((oldVars = oldRevision.d.getVars()).length != (newVars = newRevision.d.getVars()).length) {
                this.cellVariableChanges.add(cellId);
            } else {
                for (int i2 = 0; i2 < oldVars.length; ++i2) {
                    if (oldVars[i2].equals(newVars[i2])) continue;
                    this.cellVariableChanges.add(cellId);
                    break;
                }
            }
            int maxNodeId = Math.max(oldRevision.getMaxNodeId(), newRevision.getMaxNodeId());
            for (int nodeId = 0; nodeId <= maxNodeId; ++nodeId) {
                ImmutableNodeInst iNiNew;
                ImmutableNodeInst iNiOld = oldRevision.getNodeById(nodeId);
                if (iNiOld == (iNiNew = newRevision.getNodeById(nodeId))) continue;
                if (iNiOld != null) {
                    removedFromCell.add(iNiOld);
                }
                if (iNiNew == null) continue;
                addedToCell.add(iNiNew);
            }
            int maxArcId = Math.max(oldRevision.getMaxArcId(), newRevision.getMaxArcId());
            for (int arcId = 0; arcId <= maxArcId; ++arcId) {
                ImmutableNodeInst ini;
                ImmutableArcInst iAiNew;
                ImmutableArcInst iAiOld = oldRevision.getArcById(arcId);
                if (iAiOld == (iAiNew = newRevision.getArcById(arcId))) continue;
                if (iAiOld != null) {
                    removedFromCell.add(iAiOld);
                    ini = oldRevision.getNodeById(iAiOld.headNodeId);
                    if (ini != null) {
                        removedFromCell.add(ini);
                    }
                    if ((ini = oldRevision.getNodeById(iAiOld.tailNodeId)) != null) {
                        removedFromCell.add(ini);
                    }
                    if (iAiNew == null) {
                        ini = newRevision.getNodeById(iAiOld.headNodeId);
                        if (ini != null) {
                            addedToCell.add(ini);
                        }
                        if ((ini = newRevision.getNodeById(iAiOld.tailNodeId)) != null) {
                            addedToCell.add(ini);
                        }
                    }
                }
                if (iAiNew == null) continue;
                addedToCell.add(iAiNew);
                ini = newRevision.getNodeById(iAiNew.headNodeId);
                if (ini != null) {
                    addedToCell.add(ini);
                }
                if ((ini = newRevision.getNodeById(iAiNew.tailNodeId)) != null) {
                    addedToCell.add(ini);
                }
                if ((ini = oldRevision.getNodeById(iAiNew.headNodeId)) != null) {
                    removedFromCell.add(ini);
                }
                if ((ini = oldRevision.getNodeById(iAiNew.tailNodeId)) == null) continue;
                removedFromCell.add(ini);
            }
            int maxExportChronIndex = Math.max(oldRevision.getMaxExportChronIndex(), newRevision.getMaxExportChronIndex());
            for (chronIndex = 0; chronIndex <= maxExportChronIndex; ++chronIndex) {
                ImmutableExport iExportNew;
                exportId = cellId.getPortId(chronIndex);
                ImmutableExport iExportOld = oldRevision.getExport(exportId);
                if (iExportOld == (iExportNew = newRevision.getExport(exportId))) continue;
                this.portChanges.add(cellId);
                if (iExportOld != null) {
                    CellRevision newParentRevision;
                    ImmutableNodeInst ini;
                    CellBackup newParentBackup;
                    CellBackup oldParentBackup = oldSnapshot.getCell(iExportOld.exportId.getParentId());
                    CellRevision oldParentRevision = oldParentBackup.cellRevision;
                    removedFromCell.add(oldParentRevision.getNodeById(iExportOld.originalNodeId));
                    if (iExportNew == null && (newParentBackup = newSnapshot.getCell(iExportOld.exportId.getParentId())) != null && (ini = (newParentRevision = newParentBackup.cellRevision).getNodeById(iExportOld.originalNodeId)) != null) {
                        addedToCell.add(ini);
                    }
                }
                if (iExportNew != null) {
                    CellBackup newParentBackup = newSnapshot.getCell(iExportNew.exportId.getParentId());
                    CellRevision newParentRevision = newParentBackup.cellRevision;
                    addedToCell.add(newParentRevision.getNodeById(iExportNew.originalNodeId));
                }
                HashSet<CellId> changedParents = new HashSet<CellId>();
                for (int i3 = 0; i3 < cellId.numUsagesOf(); ++i3) {
                    CellUsage cu = cellId.getUsageOf(i3);
                    changedParents.add(cu.parentId);
                }
                for (CellId parentId : changedParents) {
                    CellBackup oldParentBackup = oldSnapshot.getCell(parentId);
                    CellBackup newParentBackup = newSnapshot.getCell(parentId);
                    if (oldParentBackup != null) {
                        Set<ImmutableElectricObject> removedList = this.getRemovedList(parentId);
                        for (ImmutableNodeInst n2 : oldParentBackup.cellRevision.nodes) {
                            if (n2.protoId != cellId) continue;
                            removedList.add(n2);
                        }
                    }
                    if (newParentBackup == null) continue;
                    Set<ImmutableElectricObject> addedList = this.getAddedList(parentId);
                    for (ImmutableNodeInst n2 : newParentBackup.cellRevision.nodes) {
                        if (n2.protoId != cellId) continue;
                        addedList.add(n2);
                    }
                }
            }
            if (this.portChanges.contains(cellId)) continue;
            maxExportChronIndex = newRevision.getMaxExportChronIndex();
            for (chronIndex = 0; chronIndex <= maxExportChronIndex; ++chronIndex) {
                ImmutableNodeInst ini;
                exportId = cellId.getPortId(chronIndex);
                ImmutableExport iExportNew = newRevision.getExport(exportId);
                if (iExportNew == null || !addedToCell.contains(ini = newRevision.getNodeById(iExportNew.originalNodeId))) continue;
                this.portChanges.add(cellId);
                continue block0;
            }
        }
    }

    public Snapshot getNewSnapshot() {
        return this.newSnapshot;
    }

    public Set<CellId> changedCells() {
        HashSet<CellId> cellsToUpdate = new HashSet<CellId>();
        for (CellId cid : this.added.keySet()) {
            cellsToUpdate.add(cid);
        }
        for (CellId cid : this.removed.keySet()) {
            cellsToUpdate.add(cid);
        }
        return cellsToUpdate;
    }

    public Set<CellId> sizeChangedCells() {
        return this.sizeChanges;
    }

    public Set<ImmutableElectricObject> getAdded(CellId cid) {
        return this.added.get(cid);
    }

    public Set<ImmutableElectricObject> getRemoved(CellId cid) {
        return this.removed.get(cid);
    }

    public List<CellId> getDeletedCells() {
        return this.deletedCells;
    }

    public Set<CellId> getChangedExportCells() {
        return this.portChanges;
    }

    public Set<CellId> getChangedVariableCells() {
        return this.cellVariableChanges;
    }

    public void dumpChanges() {
        EDatabase db = EDatabase.currentDatabase();
        System.out.println("++++ SUMMARY OF CHANGES: ++++");
        for (CellId cid : this.removed.keySet()) {
            Set<ImmutableElectricObject> addedSet;
            Cell cell = db.getCell(cid);
            Set<ImmutableElectricObject> removedSet = this.removed.get(cid);
            if (removedSet != null) {
                for (ImmutableElectricObject obj : removedSet) {
                    if (obj instanceof ImmutableNodeInst) {
                        ImmutableNodeInst ini = (ImmutableNodeInst)obj;
                        System.out.println("REMOVED NODE " + SnapshotAnalyze.describeImmutableObject(cell, ini) + " FROM CELL " + cell.describe(false));
                        continue;
                    }
                    ImmutableArcInst iai = (ImmutableArcInst)obj;
                    System.out.println("REMOVED ARC " + SnapshotAnalyze.describeImmutableObject(cell, iai) + " FROM CELL " + cell.describe(false));
                }
            }
            if ((addedSet = this.added.get(cid)) == null) continue;
            for (ImmutableElectricObject obj : addedSet) {
                if (obj instanceof ImmutableNodeInst) {
                    ImmutableNodeInst ini = (ImmutableNodeInst)obj;
                    System.out.println("ADDED NODE " + SnapshotAnalyze.describeImmutableObject(cell, ini) + " TO CELL " + cell.describe(false));
                    continue;
                }
                ImmutableArcInst iai = (ImmutableArcInst)obj;
                System.out.println("ADDED ARC " + SnapshotAnalyze.describeImmutableObject(cell, iai) + " TO CELL " + cell.describe(false));
            }
        }
        for (CellId cid : this.portChanges) {
            System.out.println("EXPORTS CHANGED ON CELL " + String.valueOf(cid));
        }
        for (CellId cid : this.cellVariableChanges) {
            System.out.println("VARIABLES CHANGED ON CELL " + String.valueOf(cid));
        }
        for (CellId cid : this.deletedCells) {
            System.out.println("DELETED CELL " + String.valueOf(cid));
        }
        System.out.println("++++ END OF CHANGE SUMMARY ++++");
    }

    public static String describeImmutableObject(Cell cell, ImmutableElectricObject obj) {
        if (obj instanceof ImmutableNodeInst) {
            ImmutableNodeInst ini = (ImmutableNodeInst)obj;
            NodeInst ni = cell.getNodeById(ini.nodeId);
            if (ni == null) {
                return "***DELETED NODE***";
            }
            return ni.describe(false);
        }
        ImmutableArcInst iai = (ImmutableArcInst)obj;
        ArcInst ai = cell.getArcById(iai.arcId);
        if (ai == null) {
            return "***DELETED ARC***";
        }
        return ai.describe(false);
    }

    private Set<ImmutableElectricObject> getAddedList(CellId cid) {
        Set<ImmutableElectricObject> addedToCell = this.added.get(cid);
        if (addedToCell == null) {
            addedToCell = new HashSet<ImmutableElectricObject>();
            this.added.put(cid, addedToCell);
        }
        return addedToCell;
    }

    private Set<ImmutableElectricObject> getRemovedList(CellId cid) {
        Set<ImmutableElectricObject> removedFromCell = this.removed.get(cid);
        if (removedFromCell == null) {
            removedFromCell = new HashSet<ImmutableElectricObject>();
            this.removed.put(cid, removedFromCell);
        }
        return removedFromCell;
    }
}

