/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.Environment;
import com.sun.electric.database.EquivalentSchematicExports;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNetSchem;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Tool;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ImmutableArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Snapshot {
    public static final boolean CELLNAMES_IGNORE_CASE = false;
    public final IdManager idManager;
    public final int snapshotId;
    public final Tool tool;
    public final ImmutableArrayList<CellTree> cellTrees;
    public final ImmutableArrayList<CellBackup> cellBackups;
    private final int[] cellGroups;
    private final CellId[] groupMainSchematics;
    public final ImmutableArrayList<LibraryBackup> libBackups;
    public final Environment environment;
    public final TechPool techPool;
    final EquivalentSchematicExports[] equivSchemExports;

    private Snapshot(IdManager idManager, int snapshotId, Tool tool, ImmutableArrayList<CellTree> cellTrees, ImmutableArrayList<CellBackup> cellBackups, int[] cellGroups, CellId[] groupMainSchematics, ImmutableArrayList<LibraryBackup> libBackups, Environment environment) {
        this.idManager = idManager;
        this.snapshotId = snapshotId;
        this.tool = tool;
        this.cellTrees = cellTrees;
        this.cellBackups = cellBackups;
        this.cellGroups = cellGroups;
        this.groupMainSchematics = groupMainSchematics;
        this.libBackups = libBackups;
        this.environment = environment;
        this.techPool = environment.techPool;
        this.equivSchemExports = new EquivalentSchematicExports[cellTrees.size()];
    }

    public Snapshot(IdManager idManager) {
        this(idManager, 0, null, CellTree.EMPTY_LIST, CellBackup.EMPTY_LIST, new int[0], new CellId[0], LibraryBackup.EMPTY_LIST, idManager.getInitialEnvironment());
    }

    public Snapshot with(Tool tool, Environment environment, CellBackup[] cellBackupsArray, LibraryBackup[] libBackupsArray) {
        if (environment == null) {
            environment = this.environment;
        }
        CellTree[] cellTreesArray = null;
        if (cellBackupsArray != null) {
            cellTreesArray = this.computeCellTrees(ImmutableArrayList.of(cellBackupsArray), environment.techPool);
        }
        return this.with(tool, environment, cellTreesArray, libBackupsArray);
    }

    public Snapshot with(Tool tool, Environment environment, CellTree[] cellTreesArray, LibraryBackup[] libBackupsArray) {
        if (environment == null) {
            environment = this.environment;
        }
        ImmutableArrayList<CellTree> cellTrees = Snapshot.copyArray(cellTreesArray, this.cellTrees);
        ImmutableArrayList<LibraryBackup> libBackups = Snapshot.copyArray(libBackupsArray, this.libBackups);
        if (this.cellTrees == cellTrees && this.libBackups == libBackups && this.environment == environment) {
            return this;
        }
        TechPool techPool = environment.techPool;
        boolean namesChanged = this.libBackups != libBackups || this.cellTrees.size() != cellTrees.size();
        for (int cellIndex = 0; cellIndex < cellTrees.size(); ++cellIndex) {
            CellTree newTree = (CellTree)cellTrees.get(cellIndex);
            CellTree oldTree = this.getCellTree(cellIndex);
            if (newTree == null) {
                if (oldTree == null) continue;
                namesChanged = true;
                continue;
            }
            CellBackup newBackup = newTree.top;
            ImmutableCell newCell = newBackup.cellRevision.d;
            if (!newBackup.techPool.isRestriction(techPool)) {
                throw new IllegalArgumentException();
            }
            if (newCell.cellId.cellIndex != cellIndex) {
                throw new IllegalArgumentException();
            }
            if (newCell.cellId.idManager != this.idManager) {
                throw new IllegalArgumentException();
            }
            CellTree[] cellTreeArray = newTree.subTrees;
            int n2 = cellTreeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CellTree cellSubTree = cellTreeArray[i2];
                if (cellSubTree == null || cellSubTree == cellTrees.get(cellSubTree.top.cellRevision.d.cellId.cellIndex)) continue;
                throw new IllegalArgumentException();
            }
            CellBackup oldBackup = this.getCell(cellIndex);
            if (oldBackup != null && newCell.groupName == oldBackup.cellRevision.d.groupName && newCell.params == oldBackup.cellRevision.d.params) continue;
            namesChanged = true;
        }
        ImmutableArrayList<CellBackup> cellBackups = this.cellBackups;
        if (this.cellTrees != cellTrees) {
            CellBackup[] cellBackupArray = new CellBackup[cellTrees.size()];
            for (int cellIndex = 0; cellIndex < cellTrees.size(); ++cellIndex) {
                CellTree cellTree = (CellTree)cellTrees.get(cellIndex);
                if (cellTree == null) continue;
                cellBackupArray[cellIndex] = cellTree.top;
            }
            cellBackups = ImmutableArrayList.of(cellBackupArray);
        }
        int[] cellGroups = this.cellGroups;
        Object[] groupMainSchematics = this.groupMainSchematics;
        if (namesChanged) {
            cellGroups = new int[cellBackups.size()];
            Snapshot.checkNames(this.idManager, cellBackups, cellGroups, libBackups);
            if (Arrays.equals(this.cellGroups, cellGroups)) {
                cellGroups = this.cellGroups;
            } else {
                int maxGroup = -1;
                for (Object groupIndex : (ImmutableCell)cellGroups) {
                    maxGroup = Math.max(maxGroup, (int)groupIndex);
                }
                groupMainSchematics = new CellId[maxGroup + 1];
                for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
                    Object mainSchematics;
                    CellId cellId;
                    Object groupIndex;
                    CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
                    if (cellBackup == null || !(cellId = cellBackup.cellRevision.d.cellId).isSchematic() || (mainSchematics = groupMainSchematics[groupIndex = (Object)cellGroups[cellIndex]]) != null && cellId.cellName.compareTo(((CellId)mainSchematics).cellName) >= 0) continue;
                    groupMainSchematics[groupIndex] = cellId;
                }
                if (Arrays.equals(this.groupMainSchematics, groupMainSchematics)) {
                    groupMainSchematics = this.groupMainSchematics;
                }
            }
        }
        Snapshot snapshot = new Snapshot(this.idManager, this.idManager.newSnapshotId(), tool, cellTrees, cellBackups, cellGroups, (CellId[])groupMainSchematics, libBackups, environment);
        for (CellTree cellTree : snapshot.cellTrees) {
            if (cellTree == null) continue;
            this.reuseSchemEq(snapshot, cellTree.top.cellRevision.d.cellId);
        }
        return snapshot;
    }

    private EquivalentSchematicExports reuseSchemEq(Snapshot snapshot, CellId cellId) {
        EquivalentSchematicExports newSchemEq = snapshot.equivSchemExports[cellId.cellIndex];
        if (newSchemEq != null) {
            return newSchemEq;
        }
        CellTree oldCellTree = this.getCellTree(cellId);
        CellTree newCellTree = snapshot.getCellTree(cellId);
        if (newCellTree != oldCellTree) {
            return null;
        }
        newSchemEq = this.equivSchemExports[cellId.cellIndex];
        if (newSchemEq == null) {
            return null;
        }
        assert (cellId.isIcon() || cellId.isSchematic());
        CellId mainSchemId = snapshot.groupMainSchematics[snapshot.cellGroups[cellId.cellIndex]];
        if (mainSchemId != this.groupMainSchematics[this.cellGroups[cellId.cellIndex]]) {
            return null;
        }
        if (mainSchemId != cellId && mainSchemId != null) {
            EquivalentSchematicExports oldMainSchemEq = this.equivSchemExports[mainSchemId.cellIndex];
            if (oldMainSchemEq == null) {
                assert (cellId.isSchematic());
                return null;
            }
            EquivalentSchematicExports newMainSchemEq = this.reuseSchemEq(snapshot, mainSchemId);
            if (newMainSchemEq == null) {
                newMainSchemEq = snapshot.getEquivExports(mainSchemId);
            }
            if (newMainSchemEq != oldMainSchemEq) {
                newSchemEq = null;
            }
        }
        for (CellTree subTree : newCellTree.subTrees) {
            CellId subCellId;
            if (subTree == null || ((subCellId = subTree.top.cellRevision.d.cellId).isIcon() ? cellId.isSchematic() && snapshot.cellGroups[cellId.cellIndex] == snapshot.cellGroups[subCellId.cellIndex] : !subCellId.isSchematic())) continue;
            EquivalentSchematicExports oldSubSchemEq = this.equivSchemExports[subCellId.cellIndex];
            assert (oldSubSchemEq != null);
            EquivalentSchematicExports newSubSchemEq = this.reuseSchemEq(snapshot, subCellId);
            if (newSubSchemEq == null) {
                newSubSchemEq = snapshot.getEquivExports(subCellId);
            }
            if (newSubSchemEq.equals(oldSubSchemEq)) continue;
            newSchemEq = null;
        }
        if (newSchemEq != null) {
            snapshot.equivSchemExports[cellId.cellIndex] = newSchemEq;
        }
        return newSchemEq;
    }

    public Snapshot with(Tool tool, Environment environment) {
        TechPool techPool = environment.techPool;
        CellBackup[] cellBackupArray = new CellBackup[this.cellBackups.size()];
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            cellBackupArray[cellBackup.cellRevision.d.cellId.cellIndex] = cellBackup.withTechPool(techPool);
        }
        return this.with(tool, environment, cellBackupArray, null);
    }

    private static <T> ImmutableArrayList<T> copyArray(T[] newArray, ImmutableArrayList<T> oldList) {
        int l2;
        if (newArray == null) {
            return oldList;
        }
        for (l2 = newArray.length; l2 > 0 && newArray[l2 - 1] == null; --l2) {
        }
        if (l2 == oldList.size()) {
            int i2;
            for (i2 = 0; i2 < oldList.size() && newArray[i2] == oldList.get(i2); ++i2) {
            }
            if (i2 == l2) {
                return oldList;
            }
        }
        return new ImmutableArrayList<T>(newArray, 0, l2);
    }

    private CellTree[] computeCellTrees(ImmutableArrayList<CellBackup> cellBackups, TechPool techPool) {
        CellTree[] result = new CellTree[cellBackups.size()];
        for (int cellIndex = 0; cellIndex < result.length; ++cellIndex) {
            CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
            if (cellBackup == null) continue;
            this.computeCellTrees(cellBackup.cellRevision.d.cellId, cellBackups, techPool, result);
        }
        return result;
    }

    private CellTree computeCellTrees(CellId topCellId, ImmutableArrayList<CellBackup> cellBackups, TechPool techPool, CellTree[] cellTrees) {
        int cellIndex = topCellId.cellIndex;
        CellTree cellTree = cellTrees[cellIndex];
        if (cellTree == null) {
            CellBackup top = (CellBackup)cellBackups.get(cellIndex);
            int[] instCounts = top.cellRevision.getInstCounts();
            CellTree[] subTrees = new CellTree[instCounts.length];
            for (int i2 = 0; i2 < subTrees.length; ++i2) {
                if (instCounts[i2] == 0) continue;
                subTrees[i2] = this.computeCellTrees(topCellId.getUsageIn((int)i2).protoId, cellBackups, techPool, cellTrees);
            }
            cellTree = this.getCellTree(topCellId);
            if (cellTree == null) {
                cellTree = CellTree.newInst(top.cellRevision.d, techPool);
            }
            cellTrees[cellIndex] = cellTree = cellTree.with(top, subTrees, techPool);
        }
        return cellTree;
    }

    /*
     * WARNING - void declaration
     */
    public Snapshot withRenamedIds(IdMapper idMapper, CellId fromGroup, String toGroup) {
        void var6_11;
        int maxCellIndex = -1;
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            maxCellIndex = Math.max(maxCellIndex, idMapper.get((CellId)cellBackup.cellRevision.d.cellId).cellIndex);
        }
        int maxLibIndex = -1;
        for (LibraryBackup libBackup : this.libBackups) {
            if (libBackup == null) continue;
            maxLibIndex = Math.max(maxLibIndex, idMapper.get((LibId)libBackup.d.libId).libIndex);
        }
        CellBackup[] cellBackupArray = new CellBackup[maxCellIndex + 1];
        LibraryBackup[] libBackupsArray = new LibraryBackup[maxLibIndex + 1];
        BitSet cellBackupsChangedInLib = new BitSet();
        BitSet fromGroupCellIds = new BitSet();
        BitSet toGroupCellIds = new BitSet();
        CellName fromGroupName = null;
        CellName toGroupName = null;
        if (fromGroup != null) {
            assert (this.getCell(fromGroup) != null);
            CellId toGroupCellId = idMapper.get(fromGroup);
            assert (toGroupCellId != null);
            assert (this.getCell(toGroupCellId) == null);
            int fromGroupIndex = this.cellGroups[fromGroup.cellIndex];
            assert (fromGroupIndex >= 0);
            int toGroupIndex1 = -1;
            int toGroupIndex2 = -1;
            if (toGroup == null) {
                toGroupIndex2 = fromGroupIndex;
            }
            for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
                CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
                if (cellBackup == null) continue;
                CellId cellId = cellBackup.cellRevision.d.cellId;
                if (cellId.libId != fromGroup.libId) continue;
                if (cellId.cellName.getName().equals(toGroupCellId.cellName.getName())) {
                    toGroupIndex1 = this.cellGroups[cellIndex];
                }
                if (toGroup == null || !cellId.cellName.getName().equals(toGroup)) continue;
                toGroupIndex2 = this.cellGroups[cellIndex];
            }
            ArrayList<CellName> fromCellNames = new ArrayList<CellName>();
            ArrayList<CellName> toCellNames = new ArrayList<CellName>();
            toGroupCellIds.set(toGroupCellId.cellIndex);
            toCellNames.add(toGroupCellId.cellName);
            for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
                CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
                if (cellBackup == null || cellIndex == fromGroup.cellIndex) continue;
                CellId cellId = cellBackup.cellRevision.d.cellId;
                if (this.cellGroups[cellIndex] == fromGroupIndex) {
                    fromGroupCellIds.set(cellIndex);
                    fromCellNames.add(cellId.cellName);
                }
                if (this.cellGroups[cellIndex] != toGroupIndex1 && this.cellGroups[cellIndex] != toGroupIndex2) continue;
                toGroupCellIds.set(cellIndex);
                toCellNames.add(cellId.cellName);
            }
            if (!fromCellNames.isEmpty()) {
                fromGroupName = Snapshot.makeCellGroupName(fromCellNames);
            }
            if (!toCellNames.isEmpty()) {
                toGroupName = Snapshot.makeCellGroupName(toCellNames);
            }
        }
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            CellBackup newCellBackup;
            CellBackup oldCellBackup = (CellBackup)this.cellBackups.get(cellIndex);
            if (oldCellBackup == null) continue;
            CellName newGroupName = oldCellBackup.cellRevision.d.groupName;
            if (fromGroup != null) {
                if (toGroupCellIds.get(cellIndex) || cellIndex == fromGroup.cellIndex) {
                    newGroupName = toGroupName;
                } else if (fromGroupCellIds.get(cellIndex)) {
                    newGroupName = fromGroupName;
                }
            }
            if ((newCellBackup = oldCellBackup.withRenamedIds(idMapper, newGroupName)) != oldCellBackup) {
                cellBackupsChangedInLib.set(newCellBackup.cellRevision.d.cellId.libId.libIndex);
            }
            int newCellIndex = newCellBackup.cellRevision.d.cellId.cellIndex;
            cellBackupArray[newCellIndex] = newCellBackup;
        }
        if (cellBackupsChangedInLib.isEmpty()) {
            Object var6_10 = null;
        }
        boolean libBackupsChanged = false;
        for (int libIndex = 0; libIndex < this.libBackups.size(); ++libIndex) {
            LibraryBackup oldLibBackup = (LibraryBackup)this.libBackups.get(libIndex);
            if (oldLibBackup == null) continue;
            LibraryBackup newLibBackup = oldLibBackup.withRenamedIds(idMapper);
            if (cellBackupsChangedInLib.get(libIndex)) {
                newLibBackup = newLibBackup.withModified();
            }
            if (newLibBackup != oldLibBackup) {
                libBackupsChanged = true;
            }
            libBackupsArray[newLibBackup.d.libId.libIndex] = newLibBackup;
        }
        if (!libBackupsChanged) {
            libBackupsArray = null;
        }
        if (var6_11 == null && this.libBackups == null) {
            return this;
        }
        return this.with(this.tool, null, (CellBackup[])var6_11, libBackupsArray);
    }

    public List<LibId> getChangedLibraries(Snapshot oldSnapshot) {
        if (oldSnapshot == null) {
            oldSnapshot = this.idManager.getInitialSnapshot();
        }
        if (this.idManager != oldSnapshot.idManager) {
            throw new IllegalArgumentException();
        }
        List<LibId> changed = null;
        if (oldSnapshot.libBackups != this.libBackups) {
            int numLibs = Math.max(oldSnapshot.libBackups.size(), this.libBackups.size());
            for (int i2 = 0; i2 < numLibs; ++i2) {
                LibraryBackup newBackup;
                LibraryBackup oldBackup = oldSnapshot.getLib(i2);
                if (oldBackup == (newBackup = this.getLib(i2))) continue;
                if (changed == null) {
                    changed = new ArrayList<LibId>();
                }
                changed.add(this.idManager.getLibId(i2));
            }
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        return changed;
    }

    public List<CellId> getChangedCells(Snapshot oldSnapshot) {
        if (oldSnapshot == null) {
            oldSnapshot = this.idManager.getInitialSnapshot();
        }
        List<CellId> changed = null;
        int numCells = Math.max(oldSnapshot.cellBackups.size(), this.cellBackups.size());
        for (int i2 = 0; i2 < numCells; ++i2) {
            CellBackup newBackup;
            CellBackup oldBackup = oldSnapshot.getCell(i2);
            if (oldBackup == (newBackup = this.getCell(i2))) continue;
            if (changed == null) {
                changed = new ArrayList<CellId>();
            }
            changed.add(this.idManager.getCellId(i2));
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        return changed;
    }

    public Collection<CellId> getCellsDownTop() {
        LinkedHashSet<CellId> order = new LinkedHashSet<CellId>();
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            this.getCellsDownTop(cellBackup.cellRevision.d.cellId, order);
        }
        return order;
    }

    private void getCellsDownTop(CellId root, LinkedHashSet<CellId> order) {
        if (order.contains(root)) {
            return;
        }
        CellBackup cellBackup = this.getCell(root);
        CellRevision cellRevision = cellBackup.cellRevision;
        for (int i2 = 0; i2 < cellRevision.cellUsages.length; ++i2) {
            if (cellRevision.cellUsages[i2] == null) continue;
            CellUsage cu = root.getUsageIn(i2);
            this.getCellsDownTop(cu.protoId, order);
        }
        boolean added = order.add(root);
        assert (added);
    }

    public CellTree getCellTree(CellId cellId) {
        if (cellId.getIdManager() != this.idManager) {
            throw new IllegalArgumentException();
        }
        return this.getCellTree(cellId.cellIndex);
    }

    public CellBackup getCell(CellId cellId) {
        if (cellId.getIdManager() != this.idManager) {
            throw new IllegalArgumentException();
        }
        return this.getCell(cellId.cellIndex);
    }

    public CellRevision getCellRevision(CellId cellId) {
        CellBackup cellBackup = this.getCell(cellId);
        return cellBackup != null ? cellBackup.cellRevision : null;
    }

    public CellTree getCellTree(int cellIndex) {
        return cellIndex < this.cellTrees.size() ? (CellTree)this.cellTrees.get(cellIndex) : null;
    }

    public CellBackup getCell(int cellIndex) {
        return cellIndex < this.cellBackups.size() ? (CellBackup)this.cellBackups.get(cellIndex) : null;
    }

    public CellRevision getCellRevision(int cellIndex) {
        CellBackup cellBackup = this.getCell(cellIndex);
        return cellBackup != null ? cellBackup.cellRevision : null;
    }

    public static CellName makeCellGroupName(Collection<CellName> cellNames) {
        String name;
        if (cellNames.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String groupName = null;
        for (CellName cellName : cellNames) {
            if (!cellName.isSchematic()) continue;
            name = cellName.getName();
            if (groupName != null && TextUtils.STRING_NUMBER_ORDER.compare(name, groupName) >= 0) continue;
            groupName = name;
        }
        if (groupName == null) {
            for (CellName cellName : cellNames) {
                name = cellName.getName();
                if (groupName != null && name.length() >= groupName.length() && (name.length() != groupName.length() || TextUtils.STRING_NUMBER_ORDER.compare(name, groupName) >= 0)) continue;
                groupName = name;
            }
        }
        assert (groupName != null);
        return CellName.parseName(groupName + "{sch}");
    }

    public EquivalentSchematicExports getEquivExports(CellId top) {
        EquivalentSchematicExports eq = this.equivSchemExports[top.cellIndex];
        if (eq == null) {
            ImmutableNetSchem netSchem = new ImmutableNetSchem(this, top);
            this.equivSchemExports[top.cellIndex] = eq = new EquivalentSchematicExports(netSchem);
        }
        return eq;
    }

    public ERectangle getCellBounds(CellId cellId) {
        return this.getCellBounds(cellId.cellIndex);
    }

    public ERectangle getCellBounds(int cellIndex) {
        CellTree cellTree = this.getCellTree(cellIndex);
        return cellTree != null ? cellTree.getBounds() : null;
    }

    public int getCellGroupIndex(CellId cellId) {
        return this.cellGroups[cellId.cellIndex];
    }

    public boolean cellGroupsProbablyChanged(Snapshot that) {
        return this.cellGroups != that.cellGroups;
    }

    public CellId getMainSchematics(CellId cellId) {
        return this.groupMainSchematics[this.cellGroups[cellId.cellIndex]];
    }

    public TechPool getTechPool() {
        return this.techPool;
    }

    public Technology getTech(TechId techId) {
        return this.techPool.getTech(techId);
    }

    public Artwork getArtwork() {
        return this.techPool.getArtwork();
    }

    public Generic getGeneric() {
        return this.techPool.getGeneric();
    }

    public Schematics getSchematics() {
        return this.techPool.getSchematics();
    }

    public Map<Setting, Object> getSettings() {
        return this.environment.getSettings();
    }

    public LibraryBackup getLib(LibId libId) {
        return this.getLib(libId.libIndex);
    }

    private LibraryBackup getLib(int libIndex) {
        return libIndex < this.libBackups.size() ? (LibraryBackup)this.libBackups.get(libIndex) : null;
    }

    public void writeDiffs(IdWriter writer, Snapshot oldSnapshot) throws IOException {
        Object newBackup;
        Object oldBackup;
        int i2;
        writer.writeDiffs();
        writer.writeInt(this.snapshotId);
        writer.writeBoolean(this.tool != null);
        if (this.tool != null) {
            writer.writeTool(this.tool);
        }
        this.environment.writeDiff(writer, oldSnapshot.environment);
        boolean libsChanged = oldSnapshot.libBackups != this.libBackups;
        writer.writeBoolean(libsChanged);
        if (libsChanged) {
            writer.writeInt(this.libBackups.size());
            for (i2 = 0; i2 < this.libBackups.size(); ++i2) {
                oldBackup = oldSnapshot.getLib(i2);
                if (oldBackup == (newBackup = this.getLib(i2))) continue;
                if (oldBackup == null) {
                    writer.writeInt(i2);
                    ((LibraryBackup)newBackup).write(writer);
                    continue;
                }
                if (newBackup == null) {
                    writer.writeInt(~i2);
                    continue;
                }
                writer.writeInt(i2);
                ((LibraryBackup)newBackup).write(writer);
            }
            writer.writeInt(Integer.MAX_VALUE);
        }
        writer.writeInt(this.cellBackups.size());
        for (i2 = 0; i2 < this.cellBackups.size(); ++i2) {
            oldBackup = oldSnapshot.getCell(i2);
            if (oldBackup == (newBackup = this.getCell(i2))) continue;
            if (oldBackup == null) {
                writer.writeInt(i2);
                ((CellBackup)newBackup).write(writer);
                continue;
            }
            if (newBackup == null) {
                writer.writeInt(~i2);
                continue;
            }
            writer.writeInt(i2);
            ((CellBackup)newBackup).write(writer);
        }
        writer.writeInt(Integer.MAX_VALUE);
        boolean cellGroupsChanged = this.cellGroups != oldSnapshot.cellGroups;
        writer.writeBoolean(cellGroupsChanged);
        if (cellGroupsChanged) {
            assert (this.cellGroups.length == this.cellBackups.size());
            for (int cellIndex = 0; cellIndex < this.cellGroups.length; ++cellIndex) {
                writer.writeInt(this.cellGroups[cellIndex]);
            }
            for (int groupIndex = 0; groupIndex < this.groupMainSchematics.length; ++groupIndex) {
                CellId mainSchematics = this.groupMainSchematics[groupIndex];
                writer.writeInt(mainSchematics != null ? mainSchematics.cellIndex : -1);
            }
        }
    }

    public static Snapshot readSnapshot(IdReader reader, Snapshot oldSnapshot) throws IOException {
        int cellIndex;
        assert (reader.idManager == oldSnapshot.idManager);
        reader.readDiffs();
        int snapshotId = reader.readInt();
        boolean hasTool = reader.readBoolean();
        Tool tool = hasTool ? reader.readTool() : null;
        Environment environment = Environment.readEnvironment(reader, oldSnapshot.environment);
        TechPool techPool = environment.techPool;
        boolean technologiesChanged = techPool != oldSnapshot.techPool;
        ImmutableArrayList<LibraryBackup> libBackups = oldSnapshot.libBackups;
        boolean libsChanged = reader.readBoolean();
        if (libsChanged) {
            int libIndex;
            int libLen = reader.readInt();
            LibraryBackup[] libBackupsArray = new LibraryBackup[libLen];
            int numLibs = Math.min(oldSnapshot.libBackups.size(), libLen);
            for (libIndex = 0; libIndex < numLibs; ++libIndex) {
                libBackupsArray[libIndex] = (LibraryBackup)oldSnapshot.libBackups.get(libIndex);
            }
            while ((libIndex = reader.readInt()) != Integer.MAX_VALUE) {
                if (libIndex >= 0) {
                    LibraryBackup newBackup;
                    libBackupsArray[libIndex] = newBackup = LibraryBackup.read(reader);
                    continue;
                }
                assert (libBackupsArray[libIndex ^= 0xFFFFFFFF] != null);
                libBackupsArray[libIndex] = null;
            }
            libBackups = ImmutableArrayList.of(libBackupsArray);
        }
        int cellLen = reader.readInt();
        int cellMax = Math.min(oldSnapshot.cellBackups.size(), cellLen);
        CellBackup[] cellBackupsArray = new CellBackup[cellLen];
        for (cellIndex = 0; cellIndex < cellMax; ++cellIndex) {
            cellBackupsArray[cellIndex] = (CellBackup)oldSnapshot.cellBackups.get(cellIndex);
        }
        if (technologiesChanged) {
            for (cellIndex = 0; cellIndex < cellLen; ++cellIndex) {
                CellBackup cellBackup = cellBackupsArray[cellIndex];
                if (cellBackup == null) continue;
                cellBackupsArray[cellIndex] = cellBackup.withTechPool(techPool);
            }
        }
        while ((cellIndex = reader.readInt()) != Integer.MAX_VALUE) {
            if (cellIndex >= 0) {
                CellBackup newBackup;
                cellBackupsArray[cellIndex] = newBackup = CellBackup.read(reader, techPool);
                continue;
            }
            assert (cellBackupsArray[cellIndex ^= 0xFFFFFFFF] != null);
            cellBackupsArray[cellIndex] = null;
        }
        ImmutableArrayList<CellBackup> cellBackups = ImmutableArrayList.of(cellBackupsArray);
        int[] cellGroups = oldSnapshot.cellGroups;
        CellId[] groupMainSchematics = oldSnapshot.groupMainSchematics;
        boolean cellGroupsChanged = reader.readBoolean();
        if (cellGroupsChanged) {
            cellGroups = new int[cellBackups.size()];
            int maxGroup = -1;
            for (int cellIndex2 = 0; cellIndex2 < cellGroups.length; ++cellIndex2) {
                int groupIndex = reader.readInt();
                maxGroup = Math.max(maxGroup, groupIndex);
                cellGroups[cellIndex2] = groupIndex;
            }
            groupMainSchematics = new CellId[maxGroup + 1];
            for (int groupIndex = 0; groupIndex < groupMainSchematics.length; ++groupIndex) {
                CellId mainSchematics = null;
                int cellIndex3 = reader.readInt();
                if (cellIndex3 >= 0) {
                    mainSchematics = reader.idManager.getCellId(cellIndex3);
                }
                groupMainSchematics[groupIndex] = mainSchematics;
            }
        }
        for (int i2 = 0; i2 < cellBackups.size(); ++i2) {
            assert (cellBackups.get(i2) != null == cellGroups[i2] >= 0);
        }
        CellTree[] cellTreesArray = oldSnapshot.computeCellTrees(cellBackups, environment.techPool);
        ImmutableArrayList<CellTree> cellTrees = ImmutableArrayList.of(cellTreesArray);
        return new Snapshot(oldSnapshot.idManager, snapshotId, tool, cellTrees, cellBackups, cellGroups, groupMainSchematics, libBackups, environment);
    }

    public void check() {
        this.techPool.check();
        this.environment.check();
        assert (this.environment.techPool == this.techPool);
        assert (this.techPool.idManager == this.idManager);
        for (LibraryBackup libBackup : this.libBackups) {
            if (libBackup == null) continue;
            libBackup.check();
        }
        assert (this.cellTrees.size() == this.cellBackups.size());
        for (int cellIndex = 0; cellIndex < this.cellTrees.size(); ++cellIndex) {
            CellTree cellTree = (CellTree)this.cellTrees.get(cellIndex);
            CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
            if (cellTree == null) {
                assert (cellBackup == null);
                continue;
            }
            assert (cellBackup == cellTree.top);
            CellTree[] cellTreeArray = cellTree.subTrees;
            int n2 = cellTreeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CellTree subCellTree = cellTreeArray[i2];
                if (subCellTree == null) continue;
                CellId subCellId = subCellTree.top.cellRevision.d.cellId;
                assert (subCellTree == this.cellTrees.get(subCellId.cellIndex));
            }
            cellTree.check();
            assert (cellTree.techPool.isRestriction(this.techPool));
        }
        if (this.libBackups.size() > 0) assert (this.libBackups.get(this.libBackups.size() - 1) != null);
        if (this.cellTrees.size() > 0) assert (this.cellTrees.get(this.cellTrees.size() - 1) != null);
        Snapshot.checkRecursion(this.cellBackups);
        int[] cellGroups = new int[this.cellBackups.size()];
        Snapshot.checkNames(this.idManager, this.cellBackups, cellGroups, this.libBackups);
        assert (Arrays.equals(this.cellGroups, cellGroups));
        int maxGroup = -1;
        for (Object groupIndex : (CellBackup)cellGroups) {
            maxGroup = Math.max(maxGroup, (int)groupIndex);
        }
        assert (this.groupMainSchematics.length == maxGroup + 1);
        BitSet foundMainSchematics = new BitSet();
        for (CellBackup cellBackup : this.cellBackups) {
            CellId cellId;
            if (cellBackup == null || !(cellId = cellBackup.cellRevision.d.cellId).isSchematic()) continue;
            int groupIndex = cellGroups[cellId.cellIndex];
            int cmp = cellId.cellName.compareTo(this.groupMainSchematics[groupIndex].cellName);
            assert (cmp >= 0);
            if (cmp != 0) continue;
            assert (this.groupMainSchematics[groupIndex] == cellId);
            foundMainSchematics.set(groupIndex);
        }
        for (int groupIndex = 0; groupIndex < this.groupMainSchematics.length; ++groupIndex) {
            assert (foundMainSchematics.get(groupIndex) == (this.groupMainSchematics[groupIndex] != null));
        }
    }

    private static void checkNames(IdManager idManager, ImmutableArrayList<CellBackup> cellBackups, int[] cellGroups, ImmutableArrayList<LibraryBackup> libBackups) {
        CellBackup cellBackup;
        int cellIndex;
        HashSet<String> libNames = new HashSet<String>();
        ArrayList protoNameToGroupName = new ArrayList();
        ArrayList cellNames = new ArrayList();
        ArrayList canonicCellNames = new ArrayList();
        ArrayList groupNameToGroupIndex = new ArrayList();
        for (int libIndex = 0; libIndex < libBackups.size(); ++libIndex) {
            LibraryBackup libBackup = (LibraryBackup)libBackups.get(libIndex);
            if (libBackup == null) {
                protoNameToGroupName.add(null);
                cellNames.add(null);
                canonicCellNames.add(null);
                groupNameToGroupIndex.add(null);
                continue;
            }
            protoNameToGroupName.add(new HashMap());
            cellNames.add(new HashSet());
            canonicCellNames.add(new HashMap());
            groupNameToGroupIndex.add(new HashMap());
            if (libBackup.d.libId != idManager.getLibId(libIndex)) {
                throw new IllegalArgumentException("LibId");
            }
            String libName = libBackup.d.libId.libName;
            if (!libNames.add(libName)) {
                throw new IllegalArgumentException("duplicate libName");
            }
            for (LibId libId : libBackup.referencedLibs) {
                if (libId == ((LibraryBackup)libBackups.get((int)libId.libIndex)).d.libId) continue;
                throw new IllegalArgumentException("LibId in referencedLibs");
            }
        }
        assert (protoNameToGroupName.size() == libBackups.size() && cellNames.size() == libBackups.size() && groupNameToGroupIndex.size() == libBackups.size());
        assert (cellBackups.size() == cellGroups.length);
        Arrays.fill(cellGroups, -1);
        ArrayList<CellId> groupMainSchematics = new ArrayList<CellId>();
        ArrayList<ImmutableCell> groupParamOwners = new ArrayList<ImmutableCell>();
        for (cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            CellId mainSchematics;
            LibId libId;
            cellBackup = (CellBackup)cellBackups.get(cellIndex);
            if (cellBackup == null) continue;
            ImmutableCell d2 = cellBackup.cellRevision.d;
            CellId cellId = d2.cellId;
            if (cellId != idManager.getCellId(cellIndex)) {
                throw new IllegalArgumentException("CellId");
            }
            libId = d2.getLibId();
            int libIndex = libId.libIndex;
            if (libId != ((LibraryBackup)libBackups.get((int)libIndex)).d.libId) {
                throw new IllegalArgumentException("LibId in ImmutableCell");
            }
            HashMap cellNameToGroupNameInLibrary = (HashMap)protoNameToGroupName.get(libIndex);
            HashSet cellNamesInLibrary = (HashSet)cellNames.get(libIndex);
            HashMap canonicCellNamesInLibrary = (HashMap)canonicCellNames.get(libIndex);
            HashMap groupNameToGroupIndexInLibrary = (HashMap)groupNameToGroupIndex.get(libIndex);
            String protoName = cellId.cellName.getName();
            CellName groupName = (CellName)cellNameToGroupNameInLibrary.get(protoName);
            if (groupName == null) {
                groupName = d2.groupName;
                cellNameToGroupNameInLibrary.put(protoName, groupName);
            } else if (!d2.groupName.equals(groupName)) {
                throw new IllegalArgumentException("cells with same proto name in different groups");
            }
            Integer gn = (Integer)groupNameToGroupIndexInLibrary.get(groupName);
            if (gn == null) {
                gn = groupParamOwners.size();
                groupMainSchematics.add(null);
                groupParamOwners.add(null);
                groupNameToGroupIndexInLibrary.put(groupName, gn);
            }
            if (cellId.isSchematic() && ((mainSchematics = (CellId)groupMainSchematics.get(gn)) == null || cellId.cellName.compareTo(mainSchematics.cellName) < 0)) {
                groupMainSchematics.set(gn, cellId);
                groupParamOwners.set(gn, d2);
            }
            cellGroups[cellIndex] = gn;
            if (cellNamesInLibrary.add(cellId.cellName)) continue;
            throw new IllegalArgumentException("duplicate CellName in library");
        }
        for (cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            ImmutableCell d3;
            cellBackup = (CellBackup)cellBackups.get(cellIndex);
            if (cellBackup == null || !(d3 = cellBackup.cellRevision.d).paramsAllowed()) continue;
            int gn = cellGroups[d3.cellId.cellIndex];
            ImmutableCell paramOwner = (ImmutableCell)groupParamOwners.get(gn);
            if (paramOwner != null) {
                d3.checkSimilarParams(paramOwner);
                continue;
            }
            groupParamOwners.set(gn, d3);
        }
    }

    private static void checkRecursion(ImmutableArrayList<CellBackup> cellBackups) {
        BitSet visited = new BitSet();
        BitSet checked = new BitSet();
        for (CellBackup cellBackup : cellBackups) {
            if (cellBackup == null) continue;
            Snapshot.checkRecursion(cellBackup.cellRevision.d.cellId, cellBackups, visited, checked);
        }
        assert (visited.equals(checked));
    }

    private static void checkRecursion(CellId cellId, ImmutableArrayList<CellBackup> cellBackups, BitSet visited, BitSet checked) {
        int cellIndex = cellId.cellIndex;
        if (checked.get(cellIndex)) {
            return;
        }
        assert (!visited.get(cellIndex));
        visited.set(cellIndex);
        CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
        CellRevision cellRevision = cellBackup.cellRevision;
        for (int i2 = 0; i2 < cellRevision.cellUsages.length; ++i2) {
            CellUsageInfo cui = cellRevision.cellUsages[i2];
            if (cui == null) continue;
            CellUsage u = cellId.getUsageIn(i2);
            int subCellIndex = u.protoId.cellIndex;
            if (checked.get(subCellIndex)) continue;
            if (visited.get(subCellIndex)) {
                throw new IllegalArgumentException("Recursive instance of " + String.valueOf(u.protoId) + " in " + String.valueOf(u.parentId));
            }
            Snapshot.checkRecursion(u.protoId, cellBackups, visited, checked);
        }
        checked.set(cellIndex);
    }
}

