/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.util.math.GenMath;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DumpHeap {
    private static final boolean REFERENCES = false;
    private int[] objHash = new int[1];
    private ArrayList<Object> objs = new ArrayList();
    private HashMap<Class, ClassDescriptor> classes;

    private DumpHeap() {
        this.objs.add(null);
        this.classes = new HashMap();
    }

    public static void dump(String fileName) {
        try {
            System.gc();
            DumpHeap dumpHeap = new DumpHeap();
            dumpHeap.handler(ClassLoader.class);
            dumpHeap.sweeps(100);
            try (DataOutputStream s = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));){
                dumpHeap.write(s);
            }
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
    }

    private ClassDescriptor classDescriptorOf(Class cls) {
        ClassDescriptor cd = this.classes.get(cls);
        if (cd == null) {
            cd = new ClassDescriptor(cls);
            this.classes.put(cls, cd);
        }
        return cd;
    }

    private int handler(Object obj) {
        return this.handler(obj, true);
    }

    private int handler0(Object obj) {
        return this.handler(obj, false);
    }

    private int handler(Object obj, boolean create) {
        if (obj == null) {
            return 0;
        }
        int i2 = System.identityHashCode(obj) & Integer.MAX_VALUE;
        i2 %= this.objHash.length;
        int j2 = 1;
        while (this.objHash[i2] != 0) {
            Object o2 = this.objs.get(this.objHash[i2]);
            if (o2 == obj) {
                return this.objHash[i2];
            }
            if ((i2 += j2) >= this.objHash.length) {
                i2 -= this.objHash.length;
            }
            j2 += 2;
        }
        if (!create) {
            return 0;
        }
        if (this.objs.size() * 2 <= this.objHash.length - 3) {
            this.objHash[i2] = this.objs.size();
            this.objs.add(obj);
            return i2;
        }
        this.rehash();
        return this.handler(obj);
    }

    void rehash() {
        int newSize = this.objs.size() * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        int[] newObjHash = new int[GenMath.primeSince(newSize)];
        int k2 = 0;
        while (k2 < this.objs.size()) {
            Object obj = this.objs.get(k2);
            int i2 = System.identityHashCode(obj) & Integer.MAX_VALUE;
            i2 %= newObjHash.length;
            int j2 = 1;
            while (newObjHash[i2] != 0) {
                assert (this.objs.get(newObjHash[i2]) != obj);
                if ((i2 += j2) >= newObjHash.length) {
                    i2 -= newObjHash.length;
                }
                j2 += 2;
            }
            newObjHash[i2] = k2++;
        }
        this.objHash = newObjHash;
    }

    private void sweep() throws SecurityException, IllegalAccessException {
        for (int scanned = 1; scanned < this.objs.size(); ++scanned) {
            Field f2;
            int i2;
            Object obj = this.objs.get(scanned);
            this.handler(obj.getClass());
            if (obj instanceof Object[]) {
                Object[] array = (Object[])obj;
                for (int i3 = 0; i3 < array.length; ++i3) {
                    this.handler(array[i3]);
                }
                continue;
            }
            if (obj instanceof Collection) {
                Collection coll = (Collection)obj;
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    this.handler(it.next());
                }
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    this.handler(entry.getKey());
                    this.handler(entry.getValue());
                }
                continue;
            }
            if (obj instanceof String) continue;
            Class cls = obj.getClass();
            ClassDescriptor cd = this.classDescriptorOf(cls);
            for (i2 = 0; i2 < cd.fields.length; ++i2) {
                f2 = cd.fields[i2];
                this.handler(f2.get(obj));
            }
            if (!(obj instanceof Class)) continue;
            cls = (Class)obj;
            cd = this.classDescriptorOf(cls);
            this.handler(cls.getComponentType());
            this.handler(cls.getSuperclass());
            for (i2 = 0; i2 < cd.staticFields.length; ++i2) {
                f2 = cd.staticFields[i2];
                this.handler(f2.get(null));
            }
        }
    }

    private void sweeps(int maxSweep) throws SecurityException, IllegalAccessException {
        int numObjects;
        int numSweep = 0;
        do {
            numObjects = this.objs.size();
            this.sweep();
        } while (++numSweep < maxSweep && this.objs.size() != numObjects);
        System.out.println(numSweep + " sweeps");
    }

    private void write(DataOutputStream out) throws IOException, IllegalAccessException {
        Object obj;
        int h2;
        Class<?> cls;
        int numObjs = this.objs.size() - 1;
        out.writeInt(numObjs);
        for (ClassDescriptor cd : this.classes.values()) {
            int i2;
            cls = cd.cls;
            int h3 = this.handler0(cd.cls);
            assert (h3 != 0);
            out.writeInt(h3);
            out.writeUTF(cd.cls.getName());
            int mode = cls.isArray() && !cls.getComponentType().isPrimitive() ? 2 : (Collection.class.isAssignableFrom(cls) ? 2 : (Map.class.isAssignableFrom(cls) ? 3 : (cls == String.class ? 1 : (cls == Class.class ? 4 : 0))));
            out.writeByte(mode);
            out.writeInt(cd.staticFields.length);
            for (i2 = 0; i2 < cd.staticFields.length; ++i2) {
                out.writeUTF(cd.staticFields[i2].getName());
            }
            out.writeInt(cd.fields.length);
            for (i2 = 0; i2 < cd.fields.length; ++i2) {
                out.writeUTF(cd.fields[i2].getName());
            }
        }
        out.writeInt(0);
        for (h2 = 1; h2 <= numObjs; ++h2) {
            obj = this.objs.get(h2);
            if (!(obj instanceof String)) continue;
            out.writeInt(h2);
            out.writeUTF((String)obj);
        }
        out.writeInt(0);
        for (h2 = 1; h2 <= numObjs; ++h2) {
            Field f2;
            int i3;
            Iterator<Object> it;
            obj = this.objs.get(h2);
            out.writeInt(this.handler0(obj.getClass()));
            if (obj instanceof Object[]) {
                Object[] array = (Object[])obj;
                out.writeInt(array.length);
                for (int i4 = 0; i4 < array.length; ++i4) {
                    out.writeInt(this.handler0(array[i4]));
                }
                continue;
            }
            if (obj instanceof Collection) {
                Collection coll = (Collection)obj;
                int length = coll.size();
                out.writeInt(length);
                it = coll.iterator();
                for (i3 = 0; i3 < length && it.hasNext(); ++i3) {
                    out.writeInt(this.handler0(it.next()));
                }
                while (i3 < length) {
                    out.writeInt(0);
                }
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                int length = 0;
                out.writeInt(length);
                it = map.entrySet().iterator();
                for (i3 = 0; i3 < length && it.hasNext(); ++i3) {
                    Map.Entry entry = (Map.Entry)it.next();
                    out.writeInt(this.handler0(entry.getKey()));
                    out.writeInt(this.handler0(entry.getValue()));
                }
                while (i3 < length) {
                    out.writeInt(0);
                    out.writeInt(0);
                }
                continue;
            }
            if (obj instanceof String) continue;
            cls = obj.getClass();
            ClassDescriptor cd = this.classDescriptorOf(cls);
            for (i3 = 0; i3 < cd.fields.length; ++i3) {
                f2 = cd.fields[i3];
                out.writeInt(this.handler0(f2.get(obj)));
            }
            if (!(obj instanceof Class)) continue;
            cd = this.classDescriptorOf((Class)obj);
            for (i3 = 0; i3 < cd.staticFields.length; ++i3) {
                f2 = cd.staticFields[i3];
                out.writeInt(this.handler0(f2.get(null)));
            }
        }
        out.writeInt(0);
    }

    private class ClassDescriptor
    implements Serializable {
        private final Class cls;
        private final Field[] fields;
        private final Field[] staticFields;

        private ClassDescriptor(Class cls) {
            Field[] flds;
            this.cls = cls;
            ArrayList<Field> fieldList = new ArrayList<Field>();
            ArrayList<Field> staticFieldList = new ArrayList<Field>();
            Class superCls = cls.getSuperclass();
            if (superCls != null) {
                fieldList.addAll(Arrays.asList(DumpHeap.this.classDescriptorOf(superCls).fields));
            }
            try {
                flds = cls.getDeclaredFields();
            }
            catch (NoClassDefFoundError e2) {
                System.out.println("Can't getDeclaredFields in " + String.valueOf(cls));
                flds = new Field[]{};
            }
            for (int i2 = 0; i2 < flds.length; ++i2) {
                Field f2 = flds[i2];
                Class<?> tf = f2.getType();
                if (tf.isPrimitive() || Reference.class.isAssignableFrom(cls) && f2.getName().equals("referent")) continue;
                f2.setAccessible(true);
                int fm = f2.getModifiers();
                if (Modifier.isStatic(fm)) {
                    staticFieldList.add(f2);
                    continue;
                }
                fieldList.add(f2);
            }
            Field[] NULL_FIELD_ARRAY = new Field[]{};
            this.fields = fieldList.toArray(NULL_FIELD_ARRAY);
            this.staticFields = staticFieldList.toArray(NULL_FIELD_ARRAY);
        }
    }
}

