/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellRevisionProviderDefault;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.collections.ImmutableArrayList;
import com.sun.electric.util.collections.ImmutableList;
import com.sun.electric.util.memory.ObjSize;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CellRevisionConn
extends CellRevision {
    private static final int LOW_BITS = 6;
    private static final int LOW_SIZE = 64;
    private static final int LOW_MASK = 63;
    private static final Object[] emptyBlock = new Object[64];
    private static final Object[][] emptyBlocks = new Object[0][];
    private volatile SoftReference<Object[][]> nodeConnectionsRef = new SoftReference<Object>(null);
    private static final Comparator<ImmutableExport> ExpComparator = new Comparator<ImmutableExport>(){

        @Override
        public int compare(ImmutableExport e1, ImmutableExport e2) {
            assert (e1.originalNodeId == e2.originalNodeId);
            if (e1.originalPortId.chronIndex < e2.originalPortId.chronIndex) {
                return -1;
            }
            if (e1.originalPortId.chronIndex > e2.originalPortId.chronIndex) {
                return 1;
            }
            if (e1.exportId.chronIndex < e2.exportId.chronIndex) {
                return -1;
            }
            if (e1.exportId.chronIndex > e2.exportId.chronIndex) {
                return 1;
            }
            return 0;
        }
    };

    private CellRevisionConn(ImmutableCell d2, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        super(d2, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
    }

    private CellRevisionConn(ImmutableCell d2) {
        this(d2, CellRevision.getProvider().createNodeList(ImmutableNodeInst.NULL_ARRAY, null), CellRevision.getProvider().createArcList(ImmutableArcInst.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY, CellRevision.getProvider().createExportList(ImmutableExport.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY, CellRevision.makeTechUsages(d2.techId), CellRevision.NULL_CELL_USAGE_INFO_ARRAY, CellRevision.EMPTY_BITSET, 0, CellRevision.EMPTY_BITSET);
        if (d2.techId == null) {
            throw new NullPointerException("techId");
        }
    }

    @Override
    public boolean hasConnectionsOnNode(ImmutableNodeInst n2) {
        Object nodeInfo = this.getNodeInfo(n2);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasConnectionsOnNode();
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return true;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).hasConnections();
        }
        return false;
    }

    @Override
    public int getNumConnectionsOnNode(ImmutableNodeInst n2) {
        Object nodeInfo = this.getNodeInfo(n2);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumConnectionsOnNode();
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return 1;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getNumConnections();
        }
        return 0;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnNode(BitSet headEnds, ImmutableNodeInst n2) {
        Object nodeInfo = this.getNodeInfo(n2);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getConnectionsOnNode(headEnds, n2);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            ImmutableArcInst a2 = (ImmutableArcInst)nodeInfo;
            if (headEnds != null) {
                headEnds.clear();
                if (a2.headNodeId == n2.nodeId) {
                    assert (a2.headPortId.externalId.isEmpty());
                    headEnds.set(0);
                } else assert (a2.tailNodeId == n2.nodeId);
            }
            return Collections.singletonList(a2);
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getConnections(headEnds, n2.nodeId, n2.protoId.newPortId(""));
        }
        if (headEnds != null) {
            headEnds.clear();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasConnectionsOnPort(ImmutableNodeInst n2, PortProtoId portId) {
        if (portId.parentId != n2.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(n2);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasConnectionsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return portId.externalId.isEmpty();
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() && ((PortConns)nodeInfo).hasConnections();
        }
        return false;
    }

    @Override
    public int getNumConnectionsOnPort(ImmutableNodeInst n2, PortProtoId portId) {
        if (portId.parentId != n2.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(n2);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumConnectionsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return portId.externalId.isEmpty() ? 1 : 0;
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() ? ((PortConns)nodeInfo).getNumConnections() : 0;
        }
        return 0;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnPort(BitSet headEnds, ImmutableNodeInst n2, PortProtoId portId) {
        if (portId.parentId != n2.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(n2);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getConnectionsOnPort(headEnds, n2.nodeId, portId);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            ImmutableArcInst a2 = (ImmutableArcInst)nodeInfo;
            if (portId.externalId.isEmpty()) {
                if (headEnds != null) {
                    headEnds.clear();
                    if (a2.headNodeId == n2.nodeId) {
                        assert (a2.headPortId == portId);
                        assert (a2.tailNodeId != n2.nodeId);
                        headEnds.set(0);
                    } else {
                        assert (a2.tailNodeId == n2.nodeId);
                        assert (a2.tailPortId == portId);
                        assert (a2.headNodeId != n2.nodeId);
                    }
                }
                return Collections.singletonList(a2);
            }
        } else if (nodeInfo instanceof PortConns) {
            PortConns pc = (PortConns)nodeInfo;
            if (portId.externalId.isEmpty()) {
                return pc.getConnections(headEnds, n2.nodeId, portId);
            }
        }
        if (headEnds != null) {
            headEnds.clear();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExportsOnNode(ImmutableNodeInst originalNode) {
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasExportsOnNode();
        }
        if (nodeInfo instanceof ImmutableExport) {
            return true;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).hasExportsOnPort();
        }
        return false;
    }

    @Override
    public int getNumExportsOnNode(ImmutableNodeInst originalNode) {
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumExportsOnNode();
        }
        if (nodeInfo instanceof ImmutableExport) {
            return 1;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getNumExportsOnPort();
        }
        return 0;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnNode(ImmutableNodeInst originalNode) {
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getExportsOnNode();
        }
        if (nodeInfo instanceof ImmutableExport) {
            return ArrayIterator.singletonIterator((ImmutableExport)nodeInfo);
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getExportsOnPort();
        }
        return ArrayIterator.emptyIterator();
    }

    @Override
    public boolean hasExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        if (portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasExportsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableExport) {
            return portId.externalId.isEmpty();
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() && ((PortConns)nodeInfo).hasExportsOnPort();
        }
        return false;
    }

    @Override
    public int getNumExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        if (portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumExportsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableExport) {
            return portId.externalId.isEmpty() ? 1 : 0;
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() ? ((PortConns)nodeInfo).getNumExportsOnPort() : 0;
        }
        return 0;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        if (portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getExportsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableExport) {
            if (portId.externalId.isEmpty()) {
                return ArrayIterator.singletonIterator((ImmutableExport)nodeInfo);
            }
        } else if (nodeInfo instanceof PortConns && portId.externalId.isEmpty()) {
            return ((PortConns)nodeInfo).getExportsOnPort();
        }
        return ArrayIterator.emptyIterator();
    }

    private Object getNodeInfo(ImmutableNodeInst n2) {
        int nodeId = n2.nodeId;
        if (this.getNodeById(nodeId) != n2) {
            throw new IllegalArgumentException();
        }
        Object[][] connections = this.nodeConnectionsRef.get();
        if (connections != null) {
            return connections[nodeId >> 6][nodeId & 0x3F];
        }
        return this.makeNodeInfo(nodeId);
    }

    private Object makeNodeInfo(int nodeId) {
        BlockBuffer[] blockBuffers = CellRevisionConn.allocBlockBuffers(this.getMaxNodeId());
        for (ImmutableArcInst a2 : this.arcs) {
            CellRevisionConn.newArc(blockBuffers, a2);
        }
        for (ImmutableExport e2 : this.exports) {
            CellRevisionConn.newExport(blockBuffers, e2);
        }
        return this.updateBlocks(null, blockBuffers, this, emptyBlocks)[nodeId >> 6][nodeId & 0x3F];
    }

    private static void putKilled(BlockBuffer[] blockBuffers, Map<Integer, List<ImmutableElectricObject>> killedConnectivity, CellRevisionConn newCellRevision, int nodeId, ImmutableElectricObject obj) {
        if (newCellRevision.getNodeById(nodeId) != null) {
            List<ImmutableElectricObject> list = killedConnectivity.get(nodeId);
            if (list == null) {
                list = new ArrayList<ImmutableElectricObject>();
                killedConnectivity.put(nodeId, list);
            }
            list.add(obj);
            CellRevisionConn.getBuffer((BlockBuffer[])blockBuffers, (int)nodeId).hasKilledObjs = true;
        }
    }

    @Override
    CellRevision lowLevelWith(ImmutableCell d2, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        CellRevisionConn newCellRevision = new CellRevisionConn(d2, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
        Object[][] oldBlocks = this.nodeConnectionsRef.get();
        if (oldBlocks != null && d2.cellId == this.d.cellId) {
            HashMap<Integer, List<ImmutableElectricObject>> killedConnectivity = new HashMap<Integer, List<ImmutableElectricObject>>();
            int maxNodeId = newCellRevision.getMaxNodeId();
            BlockBuffer[] blockBuffers = CellRevisionConn.allocBlockBuffers(maxNodeId);
            int maxArcId = Math.max(this.getMaxArcId(), newCellRevision.getMaxArcId());
            for (int arcId = 0; arcId <= maxArcId; ++arcId) {
                ImmutableArcInst newA;
                ImmutableArcInst oldA = this.getArcById(arcId);
                if (oldA == (newA = newCellRevision.getArcById(arcId))) continue;
                if (oldA != null) {
                    CellRevisionConn.putKilled(blockBuffers, killedConnectivity, newCellRevision, oldA.tailNodeId, oldA);
                    if (oldA.headNodeId != oldA.tailNodeId) {
                        CellRevisionConn.putKilled(blockBuffers, killedConnectivity, newCellRevision, oldA.headNodeId, oldA);
                    }
                }
                CellRevisionConn.newArc(blockBuffers, newA);
            }
            int maxChronIndex = Math.max(this.getMaxExportChronIndex(), newCellRevision.getMaxExportChronIndex());
            CellId cellId = d2.cellId;
            assert (newCellRevision.d.cellId == cellId);
            for (int chronIndex = 0; chronIndex <= maxChronIndex; ++chronIndex) {
                ImmutableExport newE;
                ExportId exportId = cellId.getPortId(chronIndex);
                ImmutableExport oldE = this.getExport(exportId);
                if (oldE == (newE = newCellRevision.getExport(exportId))) continue;
                if (oldE != null) {
                    CellRevisionConn.putKilled(blockBuffers, killedConnectivity, newCellRevision, oldE.originalNodeId, oldE);
                }
                CellRevisionConn.newExport(blockBuffers, newE);
            }
            newCellRevision.updateBlocks(killedConnectivity, blockBuffers, this, oldBlocks);
        }
        return newCellRevision;
    }

    private Object[][] updateBlocks(Map<Integer, List<ImmutableElectricObject>> killedConnectivity, BlockBuffer[] blockBuffers, CellRevision oldCellRevision, Object[][] oldBlocks) {
        Object[][] newBlocks = new Object[blockBuffers.length][];
        for (int bi = 0; bi < newBlocks.length; ++bi) {
            Object[] oldBlock = bi < oldBlocks.length ? oldBlocks[bi] : emptyBlock;
            BlockBuffer bb = blockBuffers[bi];
            if (bb == null) {
                newBlocks[bi] = oldBlock;
                continue;
            }
            Object[] newBlock = new Object[64];
            boolean newBlockIsEmpty = true;
            for (int i2 = 0; i2 < 64; ++i2) {
                HashSet<ImmutableElectricObject> killed;
                ImmutableNodeInst oldN;
                ImmutableNodeInst n2;
                int nodeId = (bi << 6) + i2;
                Object nodeInfo = oldBlock[i2];
                ImmutableList<ImmutableElectricObject> newObjs = bb.newObjs[i2];
                List<ImmutableElectricObject> killedList = null;
                if (bb.hasKilledObjs) {
                    killedList = killedConnectivity.get(nodeId);
                }
                if ((n2 = this.getNodeById(nodeId)) == null) continue;
                ImmutableNodeInst immutableNodeInst = oldN = oldCellRevision != this ? oldCellRevision.getNodeById(nodeId) : n2;
                if (newObjs == null && killedList == null) {
                    if (nodeInfo != null) {
                        assert (oldN.protoId == n2.protoId);
                        newBlockIsEmpty = false;
                    }
                    newBlock[i2] = nodeInfo;
                    continue;
                }
                ArrayList<Integer> newCons = new ArrayList<Integer>();
                ArrayList<ImmutableExport> newExports = new ArrayList<ImmutableExport>();
                HashSet<ImmutableElectricObject> hashSet = killed = killedList != null ? new HashSet<ImmutableElectricObject>(killedList) : Collections.emptySet();
                if (nodeInfo instanceof NodeConnections) {
                    NodeConnections nc = (NodeConnections)nodeInfo;
                    BitSet arcEnds = new BitSet();
                    List<Object> arcs = Collections.emptyList();
                    if (oldN != null) {
                        arcs = nc.getConnectionsOnNode(arcEnds, oldN);
                    }
                    for (int connIndex = 0; connIndex < arcs.size(); ++connIndex) {
                        a = (ImmutableArcInst)arcs.get(connIndex);
                        if (killed.contains(a)) continue;
                        int arcId = a.arcId;
                        newCons.add(arcEnds.get(connIndex) ? arcId << 1 | 1 : arcId << 1);
                    }
                    Iterator<ImmutableExport> eit = nc.getExportsOnNode();
                    while (eit.hasNext()) {
                        ImmutableExport e2 = eit.next();
                        if (killed.contains(e2)) continue;
                        newExports.add(e2);
                    }
                } else if (nodeInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a2 = (ImmutableArcInst)nodeInfo;
                    if (killed.isEmpty()) {
                        int arcId = a2.arcId;
                        boolean end = a2.headNodeId == nodeId && a2.headPortId.externalId.isEmpty();
                        newCons.add(end ? arcId << 1 | 1 : arcId << 1);
                    } else assert (killed.contains(a2) && killed.size() == 1);
                } else if (nodeInfo instanceof ImmutableExport) {
                    ImmutableExport e3 = (ImmutableExport)nodeInfo;
                    if (killed.isEmpty()) {
                        newExports.add(e3);
                    } else assert (killed.contains(e3) && killed.size() == 1);
                } else if (nodeInfo instanceof PortConns) {
                    PortConns pc = (PortConns)nodeInfo;
                    if (pc.hasConnections()) {
                        BitSet arcHeads = new BitSet();
                        List<Object> arcs = Collections.emptyList();
                        if (oldN != null) {
                            arcs = pc.getConnections(arcHeads, nodeId, oldN.protoId.newPortId(""));
                        }
                        for (int connIndex = 0; connIndex < arcs.size(); ++connIndex) {
                            a = (ImmutableArcInst)arcs.get(connIndex);
                            if (killed.contains(a)) continue;
                            int arcId = a.arcId;
                            newCons.add(arcHeads.get(connIndex) ? arcId << 1 | 1 : arcId << 1);
                        }
                    }
                    if (pc.hasExportsOnPort()) {
                        Iterator<ImmutableExport> eit = pc.getExportsOnPort();
                        while (eit.hasNext()) {
                            ImmutableExport e4 = eit.next();
                            if (killed.contains(e4)) continue;
                            newExports.add(e4);
                        }
                    }
                } else assert (nodeInfo == null);
                if (oldN == null || oldN.protoId != n2.protoId) assert (newCons.isEmpty() && newExports.isEmpty());
                while (newObjs != null) {
                    ImmutableElectricObject o2 = newObjs.getFirst();
                    if (o2 instanceof ImmutableArcInst) {
                        ImmutableArcInst a3 = (ImmutableArcInst)o2;
                        if (a3.tailNodeId == nodeId) {
                            newCons.add(a3.arcId << 1);
                        }
                        if (a3.headNodeId == nodeId) {
                            newCons.add(a3.arcId << 1 | 1);
                        }
                    } else if (o2 instanceof ImmutableExport) {
                        newExports.add((ImmutableExport)o2);
                    }
                    newObjs = newObjs.getTail();
                }
                int maxChronIndex = -1;
                boolean onEmptyPort = true;
                boolean withoutLoops = true;
                Object newNodeInfo = null;
                if (!newCons.isEmpty() || !newExports.isEmpty()) {
                    ImmutableExport[] bExports;
                    BitSet bArcHeads;
                    ImmutableArcInst[] bArcs;
                    newBlockIsEmpty = false;
                    if (newCons.isEmpty()) {
                        bArcs = ImmutableArcInst.NULL_ARRAY;
                        bArcHeads = CellRevision.EMPTY_BITSET;
                    } else if (newCons.size() == 1) {
                        int con = (Integer)newCons.get(0);
                        ImmutableArcInst a4 = this.getArcById(con >> 1);
                        boolean bl = withoutLoops = withoutLoops && (a4.tailNodeId != a4.headNodeId || a4.tailPortId != a4.headPortId);
                        if ((con & 1) != 0) {
                            maxChronIndex = Math.max(maxChronIndex, a4.headPortId.chronIndex);
                            onEmptyPort = onEmptyPort && a4.headPortId.externalId.isEmpty();
                            bArcHeads = new BitSet();
                            bArcHeads.set(0);
                            bArcs = new ImmutableArcInst[]{a4};
                        } else {
                            maxChronIndex = Math.max(maxChronIndex, a4.tailPortId.chronIndex);
                            onEmptyPort = onEmptyPort && a4.tailPortId.externalId.isEmpty();
                            bArcs = new ImmutableArcInst[]{a4};
                            bArcHeads = CellRevision.EMPTY_BITSET;
                        }
                    } else {
                        Collections.sort(newCons, new ConComparator());
                        ImmutableArcInst[] arr = new ImmutableArcInst[newCons.size()];
                        BitSet bs = new BitSet();
                        for (int j2 = 0; j2 < newCons.size(); ++j2) {
                            ImmutableArcInst a5;
                            int con = (Integer)newCons.get(j2);
                            arr[j2] = a5 = this.getArcById(con >> 1);
                            boolean bl = withoutLoops = withoutLoops && (a5.tailNodeId != a5.headNodeId || a5.tailPortId != a5.headPortId);
                            if ((con & 1) != 0) {
                                maxChronIndex = Math.max(maxChronIndex, a5.headPortId.chronIndex);
                                onEmptyPort = onEmptyPort && a5.headPortId.externalId.isEmpty();
                                bs.set(j2);
                                continue;
                            }
                            maxChronIndex = Math.max(maxChronIndex, a5.tailPortId.chronIndex);
                            onEmptyPort = onEmptyPort && a5.tailPortId.externalId.isEmpty();
                        }
                        bArcs = arr;
                        BitSet bitSet = bArcHeads = bs.isEmpty() ? CellRevision.EMPTY_BITSET : bs;
                    }
                    if (newExports.isEmpty()) {
                        bExports = ImmutableExport.NULL_ARRAY;
                    } else if (newExports.size() == 1) {
                        ImmutableExport e5 = (ImmutableExport)newExports.get(0);
                        maxChronIndex = Math.max(maxChronIndex, e5.originalPortId.chronIndex);
                        onEmptyPort = onEmptyPort && e5.originalPortId.externalId.isEmpty();
                        bExports = new ImmutableExport[]{e5};
                    } else {
                        Collections.sort(newExports, ExpComparator);
                        for (ImmutableExport e6 : newExports) {
                            maxChronIndex = Math.max(maxChronIndex, e6.originalPortId.chronIndex);
                            onEmptyPort = onEmptyPort && e6.originalPortId.externalId.isEmpty();
                        }
                        bExports = newExports.toArray(ImmutableExport.NULL_ARRAY);
                    }
                    if (!onEmptyPort) {
                        Object[] portsInfo = new Object[maxChronIndex + 1];
                        int conI = 0;
                        int expI = 0;
                        for (int chronIndex = 0; chronIndex < portsInfo.length; ++chronIndex) {
                            Object newPortInfo;
                            int expJ;
                            int conJ;
                            boolean withoutLoopsP = true;
                            for (conJ = conI; conJ < bArcs.length && (bArcHeads.get((int)conJ) ? bArcs[conJ].headPortId : bArcs[conJ].tailPortId).chronIndex == chronIndex; ++conJ) {
                                ImmutableArcInst a6 = bArcs[conJ];
                                if (a6.headNodeId != a6.tailNodeId || a6.headPortId != a6.tailPortId) continue;
                                withoutLoopsP = false;
                            }
                            for (expJ = expI; expJ < bExports.length && bExports[expJ].originalPortId.chronIndex == chronIndex; ++expJ) {
                            }
                            if (withoutLoopsP) {
                                block0 : switch (expJ - expI) {
                                    case 0: {
                                        switch (conJ - conI) {
                                            case 0: {
                                                newPortInfo = null;
                                                break block0;
                                            }
                                            case 1: {
                                                newPortInfo = bArcs[conI];
                                                break block0;
                                            }
                                            case 2: {
                                                newPortInfo = new PortConA2E0(bArcs[conI], bArcs[conI + 1]);
                                                break block0;
                                            }
                                            case 3: {
                                                newPortInfo = new PortConA3E0(bArcs[conI], bArcs[conI + 1], bArcs[conI + 2]);
                                                break block0;
                                            }
                                        }
                                        newPortInfo = new PortConANE0(Arrays.copyOfRange(bArcs, conI, conJ));
                                        break;
                                    }
                                    case 1: {
                                        switch (conJ - conI) {
                                            case 0: {
                                                newPortInfo = bExports[expI];
                                                break block0;
                                            }
                                            case 1: {
                                                newPortInfo = new PortConA1E1(bArcs[conI], bExports[expI]);
                                                break block0;
                                            }
                                            case 2: {
                                                newPortInfo = new PortConA2E1(bArcs[conI], bArcs[conI + 1], bExports[expI]);
                                                break block0;
                                            }
                                            case 3: {
                                                newPortInfo = new PortConA3E1(bArcs[conI], bArcs[conI + 1], bArcs[conI + 2], bExports[expI]);
                                                break block0;
                                            }
                                        }
                                        newPortInfo = new PortConANE1(Arrays.copyOfRange(bArcs, conI, conJ), bExports[expI]);
                                        break;
                                    }
                                    default: {
                                        pArcs = conI < conJ ? Arrays.copyOfRange(bArcs, conI, conJ) : ImmutableArcInst.NULL_ARRAY;
                                        ImmutableExport[] pExports = expI < expJ ? Arrays.copyOfRange(bExports, expI, expJ) : ImmutableExport.NULL_ARRAY;
                                        newPortInfo = new PortConANEN(pArcs, pExports);
                                        break;
                                    }
                                }
                            } else {
                                pArcs = conI < conJ ? Arrays.copyOfRange(bArcs, conI, conJ) : ImmutableArcInst.NULL_ARRAY;
                                BitSet pArcHeads = new BitSet();
                                for (int c2 = conI; c2 < conJ; ++c2) {
                                    pArcHeads.set(c2 - conI, bArcHeads.get(c2));
                                }
                                if (pArcHeads.isEmpty()) {
                                    pArcHeads = EMPTY_BITSET;
                                }
                                ImmutableExport[] pExports = expI < expJ ? Arrays.copyOfRange(bExports, expI, expJ) : ImmutableExport.NULL_ARRAY;
                                newPortInfo = new PortConALEN(pArcs, pArcHeads, pExports);
                            }
                            portsInfo[chronIndex] = newPortInfo;
                            conI = conJ;
                            expI = expJ;
                        }
                        newNodeInfo = new NodeConnections(portsInfo, n2);
                    } else if (withoutLoops) {
                        block16 : switch (bExports.length) {
                            case 0: {
                                switch (bArcs.length) {
                                    case 1: {
                                        newNodeInfo = bArcs[0];
                                        break block16;
                                    }
                                    case 2: {
                                        newNodeInfo = new PortConA2E0(bArcs[0], bArcs[1]);
                                        break block16;
                                    }
                                    case 3: {
                                        newNodeInfo = new PortConA3E0(bArcs[0], bArcs[1], bArcs[2]);
                                        break block16;
                                    }
                                }
                                newNodeInfo = new PortConANE0(bArcs);
                                break;
                            }
                            case 1: {
                                switch (bArcs.length) {
                                    case 0: {
                                        newNodeInfo = bExports[0];
                                        break block16;
                                    }
                                    case 1: {
                                        newNodeInfo = new PortConA1E1(bArcs[0], bExports[0]);
                                        break block16;
                                    }
                                    case 2: {
                                        newNodeInfo = new PortConA2E1(bArcs[0], bArcs[1], bExports[0]);
                                        break block16;
                                    }
                                    case 3: {
                                        newNodeInfo = new PortConA3E1(bArcs[0], bArcs[1], bArcs[2], bExports[0]);
                                        break block16;
                                    }
                                }
                                newNodeInfo = new PortConANE1(bArcs, bExports[0]);
                                break;
                            }
                            default: {
                                newNodeInfo = new PortConANEN(bArcs, bExports);
                                break;
                            }
                        }
                    } else {
                        newNodeInfo = new PortConALEN(bArcs, bArcHeads, bExports);
                    }
                }
                newBlock[i2] = newNodeInfo;
            }
            newBlocks[bi] = newBlockIsEmpty ? emptyBlock : newBlock;
        }
        this.nodeConnectionsRef = new SoftReference<Object[][]>(newBlocks);
        return newBlocks;
    }

    private static BlockBuffer[] allocBlockBuffers(int maxNodeId) {
        return new BlockBuffer[(maxNodeId >> 6) + 1];
    }

    private static void newArc(BlockBuffer[] blockBuffers, ImmutableArcInst newA) {
        if (newA != null) {
            CellRevisionConn.getBuffer(blockBuffers, newA.tailNodeId).putObj(newA.tailNodeId, newA);
            if (newA.headNodeId != newA.tailNodeId) {
                CellRevisionConn.getBuffer(blockBuffers, newA.headNodeId).putObj(newA.headNodeId, newA);
            }
        }
    }

    private static void newExport(BlockBuffer[] blockBuffers, ImmutableExport newE) {
        if (newE != null) {
            CellRevisionConn.getBuffer(blockBuffers, newE.originalNodeId).putObj(newE.originalNodeId, newE);
        }
    }

    private static BlockBuffer getBuffer(BlockBuffer[] blockBuffers, int nodeId) {
        BlockBuffer newB;
        int bi = nodeId >> 6;
        BlockBuffer b2 = blockBuffers[bi];
        if (b2 != null) {
            return b2;
        }
        blockBuffers[bi] = newB = new BlockBuffer();
        return newB;
    }

    @Override
    public long getConnectivityMemorySize(ObjSize objSize, boolean restore) {
        Object[][] connections;
        long s = 0L;
        if (restore && !this.nodes.isEmpty()) {
            this.makeNodeInfo(0);
        }
        if ((connections = this.nodeConnectionsRef.get()) != null) {
            s += objSize.sizeOf(connections);
            for (Object[] block : connections) {
                if (block == emptyBlock) continue;
                s += objSize.sizeOf(block);
                for (Object nodeInfo : block) {
                    if (nodeInfo instanceof NodeConnections) {
                        s += ((NodeConnections)nodeInfo).getMemorySize(objSize);
                        continue;
                    }
                    if (!(nodeInfo instanceof PortConns)) continue;
                    s += ((PortConns)nodeInfo).getMemorySize(objSize);
                }
            }
        }
        return s;
    }

    @Override
    public void check() {
        super.check();
        Object[][] blocks = this.nodeConnectionsRef.get();
        if (blocks == null) {
            return;
        }
        assert (blocks.length == (this.getMaxNodeId() >> 6) + 1);
        for (int bi = 0; bi < blocks.length; ++bi) {
            Object[] b2 = blocks[bi];
            if (b2 == emptyBlock) continue;
            boolean nonNull = false;
            for (int i2 = 0; i2 < 64; ++i2) {
                Object nodeInfo = b2[i2];
                if (nodeInfo == null) continue;
                int nodeId = (bi << 6) + i2;
                ImmutableNodeInst n2 = this.getNodeById(nodeId);
                assert (n2 != null);
                nonNull = true;
                if (nodeInfo instanceof NodeConnections) {
                    NodeConnections nc = (NodeConnections)nodeInfo;
                    nc.check(n2);
                    continue;
                }
                if (nodeInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a2 = (ImmutableArcInst)nodeInfo;
                    assert (a2.tailNodeId == nodeId && a2.headNodeId != nodeId && a2.tailPortId.parentId == n2.protoId && a2.tailPortId.externalId.isEmpty() || a2.headNodeId == nodeId && a2.tailNodeId != nodeId && a2.headPortId.parentId == n2.protoId && a2.headPortId.externalId.isEmpty());
                    continue;
                }
                if (nodeInfo instanceof ImmutableExport) {
                    ImmutableExport e2 = (ImmutableExport)nodeInfo;
                    assert (e2.originalNodeId == nodeId && e2.originalPortId.parentId == n2.protoId && e2.originalPortId.externalId.isEmpty());
                    continue;
                }
                if (nodeInfo instanceof PortConns) {
                    PortConns pc = (PortConns)nodeInfo;
                    pc.check(n2, n2.protoId.newPortId(""));
                    continue;
                }
                assert (false);
            }
            assert (nonNull);
        }
        this.checkConnectivity();
    }

    private static void checkArcs(ImmutableArcInst[] arcs, BitSet arcEnds, ImmutableNodeInst n2, PortProtoId checkPortId) {
        if (checkPortId != null) assert (checkPortId.parentId == n2.protoId);
        for (int connIndex = 0; connIndex < arcs.length; ++connIndex) {
            PortProtoId oldPortId;
            PortProtoId portId;
            ImmutableArcInst a2 = arcs[connIndex];
            boolean end = arcEnds.get(connIndex);
            if (end) {
                assert (a2.headNodeId == n2.nodeId);
                portId = a2.headPortId;
            } else {
                assert (a2.tailNodeId == n2.nodeId);
                portId = a2.tailPortId;
            }
            assert (checkPortId == null ? portId.parentId == n2.protoId : portId == checkPortId);
            if (connIndex <= 0) continue;
            ImmutableArcInst oldA = arcs[connIndex - 1];
            boolean oldEnd = arcEnds.get(connIndex - 1);
            PortProtoId portProtoId = oldPortId = oldEnd ? oldA.headPortId : oldA.tailPortId;
            assert (oldPortId.chronIndex <= portId.chronIndex);
            if (oldPortId.chronIndex != portId.chronIndex) continue;
            assert (oldA.arcId <= a2.arcId);
            if (oldA.arcId == a2.arcId) assert (!oldEnd && end);
        }
    }

    private static class NodeConnections {
        private final Object[] portsInfo;
        private final int numCon;
        private final int numExp;

        private NodeConnections(Object[] portsInfo, ImmutableNodeInst n2) {
            this.portsInfo = portsInfo;
            int conI = 0;
            int expI = 0;
            for (int chronIndex = 0; chronIndex < portsInfo.length; ++chronIndex) {
                Object portInfo = portsInfo[chronIndex];
                if (portInfo instanceof ImmutableArcInst) {
                    PortProtoId portId;
                    boolean end;
                    ImmutableArcInst a2 = (ImmutableArcInst)portInfo;
                    boolean bl = end = a2.headNodeId == n2.nodeId && a2.headPortId.chronIndex == chronIndex;
                    assert ((end ? a2.headNodeId : a2.tailNodeId) == n2.nodeId);
                    PortProtoId portProtoId = portId = end ? a2.headPortId : a2.tailPortId;
                    assert (portId.parentId == n2.protoId);
                    assert (portId.chronIndex == chronIndex);
                    ++conI;
                    continue;
                }
                if (portInfo instanceof ImmutableExport) {
                    ImmutableExport e2 = (ImmutableExport)portInfo;
                    assert (e2.originalNodeId == n2.nodeId);
                    assert (e2.originalPortId.parentId == n2.protoId);
                    assert (e2.originalPortId.chronIndex == chronIndex);
                    ++expI;
                    continue;
                }
                if (!(portInfo instanceof PortConns)) continue;
                PortConns pc = (PortConns)portInfo;
                BitSet pArcEnds = new BitSet();
                List<ImmutableArcInst> pArcs = pc.getConnections(pArcEnds, n2.nodeId, n2.protoId.getPortId(chronIndex));
                for (int i2 = 0; i2 < pArcs.size(); ++i2) {
                    PortProtoId portId;
                    boolean end;
                    ImmutableArcInst a3 = pArcs.get(i2);
                    boolean bl = end = a3.headNodeId == n2.nodeId && a3.headPortId.chronIndex == chronIndex;
                    if (end && a3.tailNodeId == n2.nodeId && a3.tailPortId.chronIndex == chronIndex && i2 + 1 < pArcs.size() && pArcs.get(i2 + 1) == a3) {
                        end = false;
                    }
                    assert (pArcEnds.get(i2) == end);
                    assert ((end ? a3.headNodeId : a3.tailNodeId) == n2.nodeId);
                    PortProtoId portProtoId = portId = end ? a3.headPortId : a3.tailPortId;
                    assert (portId.parentId == n2.protoId);
                    assert (portId.chronIndex == chronIndex);
                    ++conI;
                }
                Iterator<ImmutableExport> eit = pc.getExportsOnPort();
                while (eit.hasNext()) {
                    ImmutableExport e3 = eit.next();
                    assert (e3.originalNodeId == n2.nodeId);
                    assert (e3.originalPortId.parentId == n2.protoId);
                    assert (e3.originalPortId.chronIndex == chronIndex);
                    ++expI;
                }
            }
            this.numCon = conI;
            this.numExp = expI;
        }

        private boolean hasConnectionsOnNode() {
            return this.numCon != 0;
        }

        private int getNumConnectionsOnNode() {
            return this.numCon;
        }

        private List<ImmutableArcInst> getConnectionsOnNode(BitSet arcEnds, ImmutableNodeInst n2) {
            if (arcEnds != null) {
                arcEnds.clear();
            }
            if (this.numCon == 0) {
                return Collections.emptyList();
            }
            ImmutableArcInst[] arcs = new ImmutableArcInst[this.numCon];
            int conI = 0;
            for (int chronIndex = 0; chronIndex < this.portsInfo.length; ++chronIndex) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a2;
                    arcs[conI] = a2 = (ImmutableArcInst)portInfo;
                    if (arcEnds != null && a2.headNodeId == n2.nodeId && a2.headPortId.chronIndex == chronIndex) {
                        arcEnds.set(conI);
                    }
                    ++conI;
                    continue;
                }
                if (!(portInfo instanceof PortConns)) continue;
                PortConns pc = (PortConns)portInfo;
                BitSet arcEndsP = arcEnds != null ? new BitSet() : null;
                List<ImmutableArcInst> arcsP = pc.getConnections(arcEndsP, n2.nodeId, n2.protoId.getPortId(chronIndex));
                for (int i2 = 0; i2 < arcsP.size(); ++i2) {
                    arcs[conI] = arcsP.get(i2);
                    if (arcEnds != null) {
                        arcEnds.set(conI, arcEndsP.get(i2));
                    }
                    ++conI;
                }
            }
            assert (conI == this.numCon);
            return ImmutableArrayList.of(arcs);
        }

        private boolean hasConnectionsOnPort(PortProtoId portId) {
            int chronIndex = portId.chronIndex;
            if (chronIndex < this.portsInfo.length) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableArcInst) {
                    return true;
                }
                if (portInfo instanceof PortConns) {
                    return ((PortConns)portInfo).hasConnections();
                }
            }
            return false;
        }

        private int getNumConnectionsOnPort(PortProtoId portId) {
            int chronIndex = portId.chronIndex;
            if (chronIndex < this.portsInfo.length) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableArcInst) {
                    return 1;
                }
                if (portInfo instanceof PortConns) {
                    return ((PortConns)portInfo).getNumConnections();
                }
            }
            return 0;
        }

        private List<ImmutableArcInst> getConnectionsOnPort(BitSet arcEnds, int nodeId, PortProtoId portId) {
            int chronIndex;
            if (arcEnds != null) {
                arcEnds.clear();
            }
            if ((chronIndex = portId.chronIndex) < this.portsInfo.length) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a2 = (ImmutableArcInst)portInfo;
                    if (arcEnds != null) {
                        arcEnds.set(0, a2.headNodeId == nodeId && a2.headPortId == portId);
                    }
                    return Collections.singletonList(a2);
                }
                if (portInfo instanceof PortConns) {
                    return ((PortConns)portInfo).getConnections(arcEnds, nodeId, portId);
                }
            }
            return Collections.emptyList();
        }

        private boolean hasExportsOnNode() {
            return this.numExp != 0;
        }

        private int getNumExportsOnNode() {
            return this.numExp;
        }

        private Iterator<ImmutableExport> getExportsOnNode() {
            if (this.numExp == 0) {
                return ArrayIterator.emptyIterator();
            }
            ImmutableExport[] exports = new ImmutableExport[this.numExp];
            int expI = 0;
            for (int chronIndex = 0; chronIndex < this.portsInfo.length; ++chronIndex) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableExport) {
                    exports[expI] = (ImmutableExport)portInfo;
                    ++expI;
                    continue;
                }
                if (!(portInfo instanceof PortConns)) continue;
                PortConns pc = (PortConns)portInfo;
                Iterator<ImmutableExport> eit = pc.getExportsOnPort();
                while (eit.hasNext()) {
                    exports[expI] = eit.next();
                    ++expI;
                }
            }
            assert (expI == this.numExp);
            return ArrayIterator.iterator(exports);
        }

        private boolean hasExportsOnPort(PortProtoId portId) {
            int chronIndex = portId.chronIndex;
            if (chronIndex < this.portsInfo.length) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableExport) {
                    return true;
                }
                if (portInfo instanceof PortConns) {
                    return ((PortConns)portInfo).hasExportsOnPort();
                }
            }
            return false;
        }

        private int getNumExportsOnPort(PortProtoId portId) {
            int chronIndex = portId.chronIndex;
            if (chronIndex < this.portsInfo.length) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableExport) {
                    return 1;
                }
                if (portInfo instanceof PortConns) {
                    return ((PortConns)portInfo).getNumExportsOnPort();
                }
            }
            return 0;
        }

        private Iterator<ImmutableExport> getExportsOnPort(PortProtoId portId) {
            int chronIndex = portId.chronIndex;
            if (chronIndex < this.portsInfo.length) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableExport) {
                    return ArrayIterator.singletonIterator((ImmutableExport)portInfo);
                }
                if (portInfo instanceof PortConns) {
                    return ((PortConns)portInfo).getExportsOnPort();
                }
            }
            return ArrayIterator.emptyIterator();
        }

        private long getMemorySize(ObjSize objSize) {
            long s = objSize.sizeOf(this);
            assert (this.portsInfo.length > 0);
            s += objSize.sizeOf(this.portsInfo);
            for (Object portInfo : this.portsInfo) {
                if (!(portInfo instanceof PortConns)) continue;
                s += ((PortConns)portInfo).getMemorySize(objSize);
            }
            return s;
        }

        private void check(ImmutableNodeInst n2) {
            for (int chronIndex = 0; chronIndex < this.portsInfo.length; ++chronIndex) {
                Object portInfo = this.portsInfo[chronIndex];
                if (portInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a2 = (ImmutableArcInst)portInfo;
                    if (a2.headNodeId == n2.nodeId && a2.headPortId.chronIndex == chronIndex) {
                        assert (a2.headNodeId == n2.nodeId);
                        assert (a2.headPortId.parentId == n2.protoId);
                        assert (a2.headPortId.chronIndex == chronIndex);
                        assert (a2.tailNodeId != n2.nodeId || a2.tailPortId.chronIndex != chronIndex);
                        continue;
                    }
                    assert (a2.tailNodeId == n2.nodeId);
                    assert (a2.tailPortId.parentId == n2.protoId);
                    assert (a2.tailPortId.chronIndex == chronIndex);
                    assert (a2.headNodeId != n2.nodeId || a2.headPortId.chronIndex != chronIndex);
                    continue;
                }
                if (portInfo instanceof ImmutableExport) {
                    ImmutableExport e2 = (ImmutableExport)portInfo;
                    assert (e2.originalNodeId == n2.nodeId);
                    assert (e2.originalPortId.parentId == n2.protoId);
                    assert (e2.originalPortId.chronIndex == chronIndex);
                    continue;
                }
                if (!(portInfo instanceof PortConns)) continue;
                PortConns pc = (PortConns)portInfo;
                pc.check(n2, n2.protoId.getPortId(chronIndex));
            }
        }
    }

    private static abstract class PortConns {
        private PortConns() {
        }

        List<ImmutableArcInst> getConnections(BitSet headEnds, int nodeId, PortProtoId portId) {
            List<ImmutableArcInst> list = this.getConnections();
            if (headEnds != null) {
                headEnds.clear();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    ImmutableArcInst a2 = list.get(i2);
                    if (a2.headNodeId == nodeId && a2.headPortId == portId) {
                        assert (a2.headNodeId == nodeId);
                        assert (a2.headPortId == portId);
                        assert (a2.tailNodeId != nodeId || a2.tailPortId != portId);
                        headEnds.set(i2);
                        continue;
                    }
                    assert (a2.tailNodeId == nodeId);
                    assert (a2.tailPortId == portId);
                    assert (a2.headNodeId != nodeId || a2.headPortId != portId);
                }
            }
            return list;
        }

        abstract List<ImmutableArcInst> getConnections();

        abstract boolean hasConnections();

        abstract int getNumConnections();

        abstract boolean hasExportsOnPort();

        abstract int getNumExportsOnPort();

        abstract Iterator<ImmutableExport> getExportsOnPort();

        long getMemorySize(ObjSize objSize) {
            return objSize.sizeOf(this);
        }

        private void check(ImmutableNodeInst n2, PortProtoId portId) {
            this.checkArcs(n2, portId);
            this.checkExports(n2, portId);
        }

        void checkArcs(ImmutableNodeInst n2, PortProtoId portId) {
            int nodeId = n2.nodeId;
            ImmutableArcInst oldA = null;
            for (ImmutableArcInst a2 : this.getConnections()) {
                if (a2.headNodeId == nodeId && a2.headPortId == portId) {
                    assert (a2.headNodeId == nodeId);
                    assert (a2.headPortId == portId);
                    assert (a2.tailNodeId != nodeId || a2.tailPortId.chronIndex != portId.chronIndex);
                } else {
                    assert (a2.tailNodeId == nodeId);
                    assert (a2.tailPortId == portId);
                    assert (a2.headNodeId != nodeId || a2.headPortId.chronIndex != portId.chronIndex);
                }
                if (oldA != null) assert (oldA.arcId < a2.arcId);
                oldA = a2;
            }
        }

        private void checkExports(ImmutableNodeInst n2, PortProtoId portId) {
            ImmutableExport oldE = null;
            Iterator<ImmutableExport> eit = this.getExportsOnPort();
            while (eit.hasNext()) {
                ImmutableExport e2 = eit.next();
                assert (e2.originalNodeId == n2.nodeId);
                assert (e2.originalPortId == portId);
                if (oldE != null) assert (oldE.exportId.chronIndex < e2.exportId.chronIndex);
                oldE = e2;
            }
        }
    }

    private static class BlockBuffer {
        private boolean hasKilledObjs = false;
        private final ImmutableList<ImmutableElectricObject>[] newObjs = new ImmutableList[64];

        private BlockBuffer() {
        }

        private void putObj(int nodeId, ImmutableElectricObject obj) {
            int lowId = nodeId & 0x3F;
            this.newObjs[lowId] = ImmutableList.addFirst(this.newObjs[lowId], obj);
        }
    }

    private class ConComparator
    implements Comparator<Integer> {
        private ConComparator() {
        }

        @Override
        public int compare(Integer con1, Integer con2) {
            PortProtoId portId2;
            int nodeId2;
            ImmutableArcInst a1 = CellRevisionConn.this.getArcById(con1 >> 1);
            ImmutableArcInst a2 = CellRevisionConn.this.getArcById(con2 >> 1);
            boolean end1 = (con1 & 1) != 0;
            boolean end2 = (con2 & 1) != 0;
            int nodeId1 = end1 ? a1.headNodeId : a1.tailNodeId;
            int n2 = nodeId2 = end2 ? a2.headNodeId : a2.tailNodeId;
            assert (nodeId1 == nodeId2);
            PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
            PortProtoId portProtoId = portId2 = end2 ? a2.headPortId : a2.tailPortId;
            if (portId1.chronIndex < portId2.chronIndex) {
                return -1;
            }
            if (portId1.chronIndex > portId2.chronIndex) {
                return 1;
            }
            if (con1 < con2) {
                return -1;
            }
            if (con1 > con2) {
                return 1;
            }
            return 0;
        }
    }

    private static class PortConA2E0
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;

        PortConA2E0(ImmutableArcInst a0, ImmutableArcInst a1) {
            this.a0 = a0;
            this.a1 = a1;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 2;
        }

        @Override
        boolean hasExportsOnPort() {
            return false;
        }

        @Override
        int getNumExportsOnPort() {
            return 0;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.emptyIterator();
        }
    }

    private static class PortConA3E0
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;
        private final ImmutableArcInst a2;

        PortConA3E0(ImmutableArcInst a0, ImmutableArcInst a1, ImmutableArcInst a2) {
            this.a0 = a0;
            this.a1 = a1;
            this.a2 = a2;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1, this.a2});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 3;
        }

        @Override
        boolean hasExportsOnPort() {
            return false;
        }

        @Override
        int getNumExportsOnPort() {
            return 0;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.emptyIterator();
        }
    }

    private static class PortConANE0
    extends PortConns {
        private final ImmutableArcInst[] arcs;

        PortConANE0(ImmutableArcInst[] arcs) {
            assert (arcs.length > 0);
            this.arcs = arcs;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return false;
        }

        @Override
        int getNumExportsOnPort() {
            return 0;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.emptyIterator();
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            assert (this.arcs.length > 0);
            return super.getMemorySize(objSize) + objSize.sizeOf(this.arcs);
        }
    }

    private static class PortConA1E1
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableExport e;

        private PortConA1E1(ImmutableArcInst a0, ImmutableExport e2) {
            this.a0 = a0;
            this.e = e2;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return Collections.singletonList(this.a0);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 1;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }
    }

    private static class PortConA2E1
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;
        private final ImmutableExport e;

        private PortConA2E1(ImmutableArcInst a0, ImmutableArcInst a1, ImmutableExport e2) {
            this.a0 = a0;
            this.a1 = a1;
            this.e = e2;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 2;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }
    }

    private static class PortConA3E1
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;
        private final ImmutableArcInst a2;
        private final ImmutableExport e;

        private PortConA3E1(ImmutableArcInst a0, ImmutableArcInst a1, ImmutableArcInst a2, ImmutableExport e2) {
            this.a0 = a0;
            this.a1 = a1;
            this.a2 = a2;
            this.e = e2;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1, this.a2});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 3;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }
    }

    private static class PortConANE1
    extends PortConns {
        private final ImmutableArcInst[] arcs;
        private final ImmutableExport e;

        private PortConANE1(ImmutableArcInst[] arcs, ImmutableExport e2) {
            assert (arcs.length > 0);
            this.arcs = arcs;
            this.e = e2;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            assert (this.arcs.length > 0);
            return super.getMemorySize(objSize) + objSize.sizeOf(this.arcs);
        }
    }

    private static class PortConANEN
    extends PortConns {
        private final ImmutableArcInst[] arcs;
        private final ImmutableExport[] exports;

        private PortConANEN(ImmutableArcInst[] arcs, ImmutableExport[] exports) {
            assert (exports.length > 0);
            this.arcs = arcs;
            this.exports = exports;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return this.arcs.length > 0;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return this.exports.length;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.iterator(this.exports);
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            long s = super.getMemorySize(objSize);
            if (this.arcs != ImmutableArcInst.NULL_ARRAY) {
                s += objSize.sizeOf(this.arcs);
            }
            if (this.exports != ImmutableExport.NULL_ARRAY) {
                s += objSize.sizeOf(this.exports);
            }
            return s;
        }
    }

    private static class PortConALEN
    extends PortConns {
        private final ImmutableArcInst[] arcs;
        private final BitSet arcEnds;
        private final ImmutableExport[] exports;

        private PortConALEN(ImmutableArcInst[] arcs, BitSet arcEnds, ImmutableExport[] exports) {
            assert (arcs.length > 0);
            this.arcs = arcs;
            this.arcEnds = arcEnds;
            this.exports = exports;
        }

        @Override
        List<ImmutableArcInst> getConnections(BitSet headEnds, int nodeId, PortProtoId portId) {
            if (headEnds != null) {
                headEnds.clear();
                headEnds.or(this.arcEnds);
            }
            return this.getConnections();
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return this.exports.length != 0;
        }

        @Override
        int getNumExportsOnPort() {
            return this.exports.length;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.iterator(this.exports);
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            long s = super.getMemorySize(objSize);
            if (this.arcs != ImmutableArcInst.NULL_ARRAY) {
                s += objSize.sizeOf(this.arcs);
            }
            s += CellRevision.sizeOfBitSet(objSize, this.arcEnds);
            if (this.exports != ImmutableExport.NULL_ARRAY) {
                s += objSize.sizeOf(this.exports);
            }
            return s;
        }

        @Override
        void checkArcs(ImmutableNodeInst n2, PortProtoId portId) {
            CellRevisionConn.checkArcs(this.arcs, this.arcEnds, n2, portId);
        }
    }

    public static class CellRevisionProvider
    extends CellRevisionProviderDefault {
        @Override
        public CellRevision createCellRevision(ImmutableCell c2) {
            return new CellRevisionConn(c2);
        }
    }
}

