/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.launcher;

import com.sun.electric.api.minarea.LayoutCell;
import com.sun.electric.api.minarea.MinAreaChecker;
import com.sun.electric.api.minarea.errorLogging.AbstractErrorLogger;
import com.sun.electric.api.minarea.errorLogging.ErrorLoggerFactory;
import com.sun.electric.api.minarea.launcher.ElapseTimer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.ServiceLoader;

public class Launcher {
    private static void help() {
        System.out.println("Usage: file.lay minarea errorLogger [algorithm.properties]");
        System.out.println("    file.lay             - file with serialized layout");
        System.out.println("    minarea              - minarea threashold");
        System.out.println("    errorLogger          - error logger type: {stdout, electric, csv}");
        System.out.println("    algorithm.properties - optional file with algorithm properties");
    }

    public static void main(String[] args) {
        ErrorLoggerFactory.LoggerTypes errorLoggerType;
        if (args.length < 3) {
            Launcher.help();
            System.exit(0);
        }
        String layoutFileName = args[0];
        long minarea = 0L;
        try {
            minarea = Long.valueOf(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new Error("Parameter minarea must be of type long.");
        }
        try {
            errorLoggerType = ErrorLoggerFactory.LoggerTypes.valueOf(args[2]);
        }
        catch (IllegalArgumentException ex) {
            throw new Error("Parameter errorLogger must be a constant of LoggerTypes.");
        }
        String algorithmPropertiesFileName = args.length > 3 ? args[3] : null;
        try {
            InputStream is;
            File layoutFile = new File(layoutFileName);
            if (layoutFile.canRead()) {
                is = new FileInputStream(layoutFileName);
                System.out.println("file " + layoutFileName);
            } else {
                is = Launcher.class.getResourceAsStream(layoutFileName);
                System.out.println("resource " + layoutFileName);
            }
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(is));
            LayoutCell topCell = (LayoutCell)in.readObject();
            in.close();
            ServiceLoader<MinAreaChecker> minAreaCheckerServiceLoader = ServiceLoader.load(MinAreaChecker.class);
            for (MinAreaChecker checker : minAreaCheckerServiceLoader) {
                System.out.println("Min area checker implementation '" + checker.getAlgorithmName() + "'");
                System.out.println("topCell " + topCell.getName() + " [" + topCell.getBoundingMinX() + ".." + topCell.getBoundingMaxX() + "]x[" + topCell.getBoundingMinY() + ".." + topCell.getBoundingMaxY() + "] minarea=" + minarea);
                Properties parameters = checker.getDefaultParameters();
                if (algorithmPropertiesFileName != null) {
                    FileInputStream propertiesIn = new FileInputStream(algorithmPropertiesFileName);
                    parameters.load(propertiesIn);
                    ((InputStream)propertiesIn).close();
                }
                AbstractErrorLogger logger = ErrorLoggerFactory.createErrorLogger(errorLoggerType, topCell.getName());
                System.out.println("algorithm " + checker.getAlgorithmName() + " parameters:" + String.valueOf(parameters) + " errorLogger:" + String.valueOf((Object)errorLoggerType));
                ElapseTimer timer = ElapseTimer.createInstance().start();
                checker.check(topCell, minarea, parameters, logger);
                timer.end();
                logger.printReports(timer.getTime());
                System.out.println("Elapsed time for min-area checking: " + String.valueOf(timer));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (ClassNotFoundException e3) {
            e3.printStackTrace();
        }
    }

    public static String getPID() throws IOException {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }
}

