/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.geometry;

import com.sun.electric.api.minarea.geometry.Edge;
import com.sun.electric.api.minarea.geometry.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Polygon
implements Serializable {
    protected List<Point> points;

    public Polygon(Point ... points) {
        this.points = Arrays.asList(points);
    }

    public Rectangle getBoundingBox() {
        int lx = Integer.MAX_VALUE;
        int ly = Integer.MAX_VALUE;
        int hx = Integer.MIN_VALUE;
        int hy = Integer.MIN_VALUE;
        for (Point pt : this.points) {
            if (pt.getX() < lx) {
                lx = pt.getX();
            }
            if (pt.getY() < ly) {
                ly = pt.getY();
            }
            if (pt.getX() > hx) {
                hx = pt.getX();
            }
            if (pt.getY() <= hy) continue;
            hy = pt.getY();
        }
        return new Rectangle(new Point(lx, ly), new Point(hx, hy));
    }

    public List<Edge> extractEdges() {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            result.add(new Edge(this.points.get(i2), this.points.get((i2 + 1) % this.points.size())));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Polygon = (\n");
        for (Point pt : this.points) {
            builder.append("   ");
            builder.append(pt.toString());
        }
        builder.append(")");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.points == null ? 0 : this.points.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        return !(this.points == null ? other.points != null : !this.points.equals(other.points));
    }

    public static class Rectangle
    extends Polygon
    implements Serializable {
        public Rectangle(Point min, Point max) {
            super(new Point[0]);
            if (min.getX() >= max.getX() || min.getY() >= max.getY()) {
                throw new IllegalArgumentException();
            }
            this.points = Arrays.asList(min, max);
        }

        public Rectangle(int minX, int minY, int maxX, int maxY) {
            this(new Point(minX, minY), new Point(maxX, maxY));
        }

        public Point getMin() {
            return (Point)this.points.get(0);
        }

        public Point getMax() {
            return (Point)this.points.get(1);
        }

        public int width() {
            return Math.abs(((Point)this.points.get(1)).getX() - ((Point)this.points.get(0)).getX());
        }

        public int height() {
            return Math.abs(((Point)this.points.get(1)).getY() - ((Point)this.points.get(0)).getY());
        }

        @Override
        public List<Edge> extractEdges() {
            return this.transformToPolygon().extractEdges();
        }

        public Polygon transformToPolygon() {
            Point top = new Point(this.getMax().getX(), this.getMin().getY());
            Point bottom = new Point(this.getMin().getX(), this.getMax().getY());
            return new Polygon(this.getMin(), bottom, this.getMax(), top);
        }

        public int[] toArray() {
            return new int[]{this.getMin().getX(), this.getMin().getY(), this.getMax().getX(), this.getMax().getY()};
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Rectangle = (\n");
            builder.append("  ");
            for (Point pt : this.points) {
                builder.append(" ");
                builder.append(pt.toString());
                builder.append(" ");
                builder.append("x");
            }
            builder.replace(builder.length() - 2, builder.length(), "");
            builder.append(")");
            return builder.toString();
        }
    }

    public static class PolygonHole
    extends Polygon
    implements Serializable {
        public PolygonHole(Point ... points) {
            super(points);
        }
    }

    public static interface PolygonIntersectStrategy {
        public Polygon intersect(Polygon var1, Polygon var2);

        public boolean intersectionTest(Polygon var1, Polygon var2);
    }

    public static interface PolygonUnionStrategy {
        public Polygon union(Polygon var1, Polygon var2);
    }
}

