/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea;

import java.awt.geom.AffineTransform;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ManhattanOrientation {
    R0{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
        }
    }
    ,
    R90{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int x = coords[offset + i2 * 2 + 0];
                int y = coords[offset + i2 * 2 + 1];
                coords[offset + i2 * 2 + 0] = -y;
                coords[offset + i2 * 2 + 1] = x;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int lx = coords[offset + i2 * 4 + 0];
                int ly = coords[offset + i2 * 4 + 1];
                int hx = coords[offset + i2 * 4 + 2];
                int hy = coords[offset + i2 * 4 + 3];
                coords[offset + i2 * 4 + 0] = -hy;
                coords[offset + i2 * 4 + 1] = lx;
                coords[offset + i2 * 4 + 2] = -ly;
                coords[offset + i2 * 4 + 3] = hx;
            }
        }
    }
    ,
    R180{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int x = coords[offset + i2 * 2 + 0];
                int y = coords[offset + i2 * 2 + 1];
                coords[offset + i2 * 2 + 0] = -x;
                coords[offset + i2 * 2 + 1] = -y;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int lx = coords[offset + i2 * 4 + 0];
                int ly = coords[offset + i2 * 4 + 1];
                int hx = coords[offset + i2 * 4 + 2];
                int hy = coords[offset + i2 * 4 + 3];
                coords[offset + i2 * 4 + 0] = -hx;
                coords[offset + i2 * 4 + 1] = -hy;
                coords[offset + i2 * 4 + 2] = -lx;
                coords[offset + i2 * 4 + 3] = -ly;
            }
        }
    }
    ,
    R270{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int y;
                int x = coords[offset + i2 * 2 + 0];
                coords[offset + i2 * 2 + 0] = y = coords[offset + i2 * 2 + 1];
                coords[offset + i2 * 2 + 1] = -x;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int lx = coords[offset + i2 * 4 + 0];
                int ly = coords[offset + i2 * 4 + 1];
                int hx = coords[offset + i2 * 4 + 2];
                int hy = coords[offset + i2 * 4 + 3];
                coords[offset + i2 * 4 + 0] = ly;
                coords[offset + i2 * 4 + 1] = -hx;
                coords[offset + i2 * 4 + 2] = hy;
                coords[offset + i2 * 4 + 3] = -lx;
            }
        }
    }
    ,
    MY{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int x = coords[offset + i2 * 2 + 0];
                coords[offset + i2 * 2 + 0] = -x;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int lx = coords[offset + i2 * 4 + 0];
                int hx = coords[offset + i2 * 4 + 2];
                coords[offset + i2 * 4 + 0] = -hx;
                coords[offset + i2 * 4 + 2] = -lx;
            }
        }
    }
    ,
    MYR90{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int x = coords[offset + i2 * 2 + 0];
                int y = coords[offset + i2 * 2 + 1];
                coords[offset + i2 * 2 + 0] = -y;
                coords[offset + i2 * 2 + 1] = -x;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int lx = coords[offset + i2 * 4 + 0];
                int ly = coords[offset + i2 * 4 + 1];
                int hx = coords[offset + i2 * 4 + 2];
                int hy = coords[offset + i2 * 4 + 3];
                coords[offset + i2 * 4 + 0] = -hy;
                coords[offset + i2 * 4 + 1] = -hx;
                coords[offset + i2 * 4 + 2] = -ly;
                coords[offset + i2 * 4 + 3] = -lx;
            }
        }
    }
    ,
    MX{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int y = coords[offset + i2 * 2 + 1];
                coords[offset + i2 * 2 + 1] = -y;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int ly = coords[offset + i2 * 4 + 1];
                int hy = coords[offset + i2 * 4 + 3];
                coords[offset + i2 * 4 + 1] = -hy;
                coords[offset + i2 * 4 + 3] = -ly;
            }
        }
    }
    ,
    MXR90{

        @Override
        public AffineTransform affineTransform() {
            return new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void transformPoints(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int y;
                int x = coords[offset + i2 * 2 + 0];
                coords[offset + i2 * 2 + 0] = y = coords[offset + i2 * 2 + 1];
                coords[offset + i2 * 2 + 1] = x;
            }
        }

        @Override
        public void transformRects(int[] coords, int offset, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                int lx = coords[offset + i2 * 4 + 0];
                int ly = coords[offset + i2 * 4 + 1];
                int hx = coords[offset + i2 * 4 + 2];
                int hy = coords[offset + i2 * 4 + 3];
                coords[offset + i2 * 4 + 0] = ly;
                coords[offset + i2 * 4 + 1] = lx;
                coords[offset + i2 * 4 + 2] = hy;
                coords[offset + i2 * 4 + 3] = hx;
            }
        }
    };

    private static final ManhattanOrientation[] concatenate;

    public abstract AffineTransform affineTransform();

    public abstract void transformPoints(int[] var1, int var2, int var3);

    public abstract void transformRects(int[] var1, int var2, int var3);

    public ManhattanOrientation concatenate(ManhattanOrientation other) {
        return concatenate[this.ordinal() * 8 + other.ordinal()];
    }

    static {
        concatenate = new ManhattanOrientation[]{R0, R90, R180, R270, MY, MYR90, MX, MXR90, R90, R180, R270, R0, MYR90, MX, MXR90, MY, R180, R270, R0, R90, MX, MXR90, MY, MYR90, R270, R0, R90, R180, MXR90, MY, MYR90, MX, MY, MXR90, MX, MYR90, R0, R270, R180, R90, MYR90, MY, MXR90, MX, R90, R0, R270, R180, MX, MYR90, MY, MXR90, R180, R90, R0, R270, MXR90, MX, MYR90, MY, R270, R180, R90, R0};
    }
}

