/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.sun.electric.Electric;
import com.sun.electric.StartupPrefs;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.UserInterfaceInitial;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.SimulationData;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.SimpleWorker;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.ThreadPool;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.UsageFormatter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public final class Main {
    private static final Mode DEFAULT_MODE = Mode.FULL_SCREEN_SAFE;
    private static Mode runMode;

    private Main() {
    }

    public static boolean isBatch() {
        return runMode == Mode.BATCH;
    }

    public static boolean useUnstableFeatures() {
        return Boolean.getBoolean("electric.unstable");
    }

    public static void main(String[] args) {
        double screenScaling;
        String serverMachineName;
        String loggingFilePath;
        String loggingUsage;
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            argsList.add(args[i2]);
        }
        if (Main.hasCommandLineOption(argsList, "-v")) {
            System.out.println(Version.getVersion());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-version")) {
            System.out.println(Version.getApplicationInformation());
            System.out.println("\t" + Version.getVersionInformation());
            System.out.println("\t" + Version.getCopyrightInformation());
            System.out.println("\t" + Version.getWarrantyInformation());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-help")) {
            System.out.println("Usage (without plugins):");
            System.out.println("\tjava -jar electric.jar [electric-options] [electric-libraries]");
            System.out.println("\t\twhere [electric-libraries] is list of library files to read");
            System.out.println("Usage (with plugins):");
            System.out.println("\tjava -classpath electric.jar[electric-plugins] com.sun.electric.Electric [electric-options] [electric-libraries]");
            System.out.println("\t\twhere [electric-plugins] is list of JAR files separated by OS-dependant separator (colon or semicolon)");
            System.out.println("\nElectric-options:");
            System.out.println("\t-batch: batch mode implies 'no GUI', and nothing more");
            System.out.println("\t-client <machine name>: replay trace of snapshots");
            System.out.println("\t-debug: debug mode. Extra information is available");
            System.out.println("\t-help: this message");
            System.out.println("\t-logging <filePath>: log server events in a binary file");
            System.out.println("\t-logusage <local path>: local path to log usage");
            System.out.println("\t-mdi: multiple document interface mode");
            System.out.println("\t-NOMINMEM: ignore minimum memory provided for JVM");
            System.out.println("\t-s <script name>: bean shell script to execute");
            System.out.println("\t-sdi: single document interface mode");
            System.out.println("\t-server: dump trace of snapshots");
            System.out.println("\t-socket <socket>: socket port for client/server interaction");
            System.out.println("\t-threads <numThreads>: recommended size of thread pool for Job execution.");
            System.out.println("\t-version: version information");
            System.out.println("\t-v: brief version information");
            System.exit(0);
        }
        runMode = DEFAULT_MODE;
        ArrayList<String> pipeOptions = new ArrayList<String>();
        if (Main.hasCommandLineOption(argsList, "-debug")) {
            pipeOptions.add(" -debug");
            Job.setDebug(true);
        }
        if (Main.hasCommandLineOption(argsList, "-extraDebug")) {
            pipeOptions.add("-extraDebug");
            Job.LOCALDEBUGFLAG = true;
        }
        String numThreadsString = Main.getCommandLineOption(argsList, "-threads");
        int numThreads = 0;
        if (numThreadsString != null) {
            numThreads = TextUtils.atoi(numThreadsString);
            if (numThreads > 0) {
                pipeOptions.add("-threads");
                pipeOptions.add(String.valueOf(numThreads));
            } else {
                System.out.println("Invalid option -threads " + numThreadsString);
            }
        }
        if ((loggingUsage = Main.getCommandLineOption(argsList, "-logusage")) != null) {
            UsageFormatter.logUsage("Electric-" + UsageFormatter.getUser() + ".txt", loggingUsage, false, "");
        }
        if ((loggingFilePath = Main.getCommandLineOption(argsList, "-logging")) != null) {
            pipeOptions.add("-logging");
            pipeOptions.add(loggingFilePath);
        }
        String socketString = Main.getCommandLineOption(argsList, "-socket");
        int socketPort = 0;
        if (socketString != null) {
            socketPort = TextUtils.atoi(socketString);
            if (socketPort > 0) {
                pipeOptions.add("-socket");
                pipeOptions.add(String.valueOf(socketPort));
            } else {
                System.out.println("Invalid option -socket " + socketString);
            }
        }
        Main.hasCommandLineOption(argsList, "-NOMINMEM");
        if (Main.hasCommandLineOption(argsList, "-pipeserver")) {
            ActivityLogger.initialize("electricserver", true, true, true, true, false);
            Job.pipeServer(numThreads, loggingFilePath, socketPort);
            return;
        }
        ActivityLogger.initialize("electric", true, true, true, User.isEnableLog(), User.isMultipleLog());
        if (Main.hasCommandLineOption(argsList, "-batch")) {
            runMode = Mode.BATCH;
        }
        if (Main.hasCommandLineOption(argsList, "-server")) {
            if (runMode != DEFAULT_MODE) {
                System.out.println("Conflicting thread modes: " + String.valueOf((Object)runMode) + " and " + String.valueOf((Object)Mode.SERVER));
            }
            runMode = Mode.SERVER;
        }
        if ((serverMachineName = Main.getCommandLineOption(argsList, "-client")) != null) {
            if (runMode != DEFAULT_MODE) {
                System.out.println("Conflicting thread modes: " + String.valueOf((Object)runMode) + " and " + String.valueOf((Object)Mode.CLIENT));
            }
            runMode = Mode.CLIENT;
        }
        boolean pipe = false;
        boolean pipedebug = false;
        if (Main.hasCommandLineOption(argsList, "-pipe")) {
            if (runMode != DEFAULT_MODE) {
                System.out.println("Conflicting thread modes: " + String.valueOf((Object)runMode) + " and " + String.valueOf((Object)Mode.CLIENT));
            }
            runMode = Mode.CLIENT;
            pipe = true;
        }
        if (Main.hasCommandLineOption(argsList, "-pipedebug")) {
            if (runMode != DEFAULT_MODE) {
                System.out.println("Conflicting thread modes: " + String.valueOf((Object)runMode) + " and " + String.valueOf((Object)Mode.CLIENT));
            }
            runMode = Mode.CLIENT;
            pipe = true;
            pipedebug = true;
        }
        if ((screenScaling = StartupPrefs.getScreenScaling()) > 0.0) {
            System.setProperty("sun.java2d.uiScale", "" + screenScaling);
        }
        UserInterfaceMain.Mode mode = null;
        if (Main.hasCommandLineOption(argsList, "-mdi")) {
            mode = UserInterfaceMain.Mode.MDI;
        }
        if (Main.hasCommandLineOption(argsList, "-sdi")) {
            mode = UserInterfaceMain.Mode.SDI;
        }
        final AbstractUserInterface ui = runMode == Mode.FULL_SCREEN_SAFE || runMode == Mode.CLIENT ? new UserInterfaceMain(argsList, mode, true) : new UserInterfaceDummy();
        MessagesStream.getMessagesStream();
        TextDescriptor.cacheSize();
        Tool.initAllTools();
        Pref.lockCreation();
        EDatabase serverDatabase = null;
        EDatabase clientDatabase = null;
        InitDatabase initJob = null;
        switch (runMode.ordinal()) {
            case 0: {
                serverDatabase = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "serverDB");
                EDatabase.setServerDatabase(serverDatabase);
                clientDatabase = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "clientDB");
                EDatabase.setClientDatabase(clientDatabase);
                Job.setUserInterface(new UserInterfaceInitial(clientDatabase));
                initJob = new InitDatabase(argsList);
                EDatabase.setCheckExamine();
                Job.initJobManager(numThreads, loggingFilePath, socketPort, ui, initJob);
                break;
            }
            case 3: {
                clientDatabase = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "clientDB");
                EDatabase.setClientDatabase(clientDatabase);
                Job.setUserInterface(new UserInterfaceInitial(clientDatabase));
                initJob = new InitDatabase(argsList);
                IdManager.stdIdManager.setReadOnly();
                if (pipe) {
                    try {
                        Process process = Main.invokePipeserver(pipeOptions, pipedebug);
                        Job.pipeClient(process, ui, initJob, false);
                    }
                    catch (IOException e2) {
                        System.exit(1);
                    }
                    break;
                }
                Job.socketClient(serverMachineName, socketPort, ui, new InitClient(argsList));
                break;
            }
            case 2: {
                serverDatabase = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "serverDB");
                EDatabase.setServerDatabase(serverDatabase);
                Job.setUserInterface(new UserInterfaceInitial(serverDatabase));
                initJob = new InitDatabase(argsList);
                Job.initJobManager(numThreads, loggingFilePath, socketPort, ui, initJob);
                break;
            }
            case 1: {
                serverDatabase = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "serverDB");
                EDatabase.setServerDatabase(serverDatabase);
                Job.setUserInterface(new UserInterfaceInitial(serverDatabase));
                EditingPreferences.lowLevelSetThreadLocalEditingPreferences(new EditingPreferences(true, null));
                initJob = new InitDatabase(argsList);
                Job.initJobManager(numThreads, loggingFilePath, socketPort, ui, initJob);
            }
        }
        ThreadPool.PoolWorkerStrategyFactory.userDefinedStrategy = new SimpleWorker(null){

            @Override
            public void execute() {
                try {
                    Job.setUserInterface(ui);
                    Environment.setThreadEnvironment(ui.getDatabase().getEnvironment());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.execute();
            }
        };
    }

    private static Process invokePipeserver(List<String> electricOptions, boolean withDebugger) throws IOException {
        ArrayList<String> javaOptions = new ArrayList<String>();
        javaOptions.add("-Xss2m");
        int maxMemWanted = StartupPrefs.getMemorySize();
        javaOptions.add("-Xmx" + maxMemWanted + "m");
        long maxPermWanted = StartupPrefs.getPermSpace();
        if (maxPermWanted > 0L) {
            javaOptions.add("-XX:MaxPermSize=" + maxPermWanted + "m");
        }
        if (withDebugger) {
            javaOptions.add("-Xdebug");
            javaOptions.add("-Xrunjdwp:transport=dt_socket,server=n,address=localhost:35856");
        }
        return Electric.invokePipeserver(javaOptions, electricOptions);
    }

    private static boolean hasCommandLineOption(List<String> argsList, String option) {
        for (int i2 = 0; i2 < argsList.size(); ++i2) {
            if (!argsList.get(i2).equals(option)) continue;
            argsList.remove(i2);
            return true;
        }
        return false;
    }

    private static String getCommandLineOption(List<String> argsList, String option) {
        for (int i2 = 0; i2 < argsList.size() - 1; ++i2) {
            if (!argsList.get(i2).equals(option)) continue;
            argsList.remove(i2);
            if (argsList.get(i2).startsWith("-")) {
                System.out.println("Bad command line option: " + option + " " + argsList.get(i2 + 1));
                return null;
            }
            return argsList.remove(i2);
        }
        return null;
    }

    public static void openCommandLineLibs(List<String> argsList) {
        for (int i2 = 0; i2 < argsList.size(); ++i2) {
            String arg = argsList.get(i2);
            if (arg.startsWith("-")) {
                System.out.println("Command line option " + arg + " not understood, ignoring.");
                continue;
            }
            URL url = TextUtils.makeURLToFile(arg);
            if (url == null) continue;
            if (!Main.isBatch()) {
                User.setWorkingDirectory(TextUtils.getFilePath(url));
            }
            FileType.JELIB.setGroupPath(User.getWorkingDirectory());
            if (arg.indexOf(46) != -1 && SimulationData.isKnownSimulationFormatExtension(arg.substring(arg.lastIndexOf(46) + 1))) {
                SimulationData.plot(null, url, null);
                continue;
            }
            boolean alreadyThere = false;
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                URL lURL = lib.getLibFile();
                if (lURL == null || !lURL.equals(url)) continue;
                alreadyThere = true;
                break;
            }
            if (alreadyThere) continue;
            FileMenu.openLibraryCommand(url);
        }
    }

    private static enum Mode {
        FULL_SCREEN_SAFE,
        BATCH,
        SERVER,
        CLIENT;

    }

    public static class UserInterfaceDummy
    extends AbstractUserInterface {
        public static final PrintStream stdout = System.out;
        private PrintWriter printWriter = null;

        @Override
        public void startProgressDialog(String type, String filePath) {
        }

        @Override
        public void stopProgressDialog() {
        }

        @Override
        public void setProgressValue(int pct) {
        }

        @Override
        public void setProgressNote(String message) {
        }

        @Override
        public String getProgressNote() {
            return null;
        }

        @Override
        public EDatabase getDatabase() {
            return EDatabase.clientDatabase();
        }

        @Override
        public EditWindow_ getCurrentEditWindow_() {
            return null;
        }

        @Override
        public EditWindow_ needCurrentEditWindow_() {
            System.out.println("Batch mode Electric has no needed windows");
            return null;
        }

        @Override
        public Cell getCurrentCell() {
            throw new IllegalStateException("Batch mode Electric has no current Cell");
        }

        @Override
        public Cell needCurrentCell() {
            throw new IllegalStateException("Batch mode Electric has no current Cell");
        }

        @Override
        public void repaintAllWindows() {
        }

        @Override
        public void adjustReferencePoint(Cell cell, double cX, double cY) {
        }

        @Override
        public int getDefaultTextSize() {
            return 14;
        }

        @Override
        public EditWindow_ displayCell(Cell cell) {
            return null;
        }

        @Override
        public void termLogging(ErrorLogger logger, boolean explain, boolean terminate) {
            System.out.println(logger.getInfo());
        }

        @Override
        public String reportLog(ErrorLogger.MessageLog log, boolean showhigh, boolean separateWindow, int position) {
            return log.getMessageString();
        }

        @Override
        public void showErrorMessage(String message, String title) {
            System.out.println(message);
        }

        public void showErrorMessage(String[] message, String title) {
            System.out.println(message);
        }

        @Override
        public void showInformationMessage(String message, String title) {
            System.out.println(message);
        }

        @Override
        public void showInformationMessage(JFrame frame, String message, String title) {
            this.showInformationMessage(message, title);
        }

        @Override
        public void printMessage(String message, boolean newLine) {
            if (newLine) {
                stdout.println(message);
                if (this.printWriter != null) {
                    this.printWriter.println(message);
                }
            } else {
                stdout.print(message);
                if (this.printWriter != null) {
                    this.printWriter.print(message);
                }
            }
        }

        @Override
        public void saveMessages(String filePath) {
            try {
                if (this.printWriter != null) {
                    this.printWriter.close();
                    this.printWriter = null;
                }
                if (filePath == null) {
                    return;
                }
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            }
            catch (IOException e2) {
                System.err.println("Error creating " + filePath);
                System.out.println("Error creating " + filePath);
                return;
            }
            System.out.println("Messages will be saved to " + filePath);
        }

        @Override
        public boolean confirmMessage(Object message) {
            return true;
        }

        @Override
        public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
            System.out.println(message + " CHOOSING " + defaultChoice);
            for (int i2 = 0; i2 < choices.length; ++i2) {
                if (!choices[i2].equals(defaultChoice)) continue;
                return i2;
            }
            return 0;
        }

        @Override
        public String askForInput(Object message, String title, String def) {
            return def;
        }

        @Override
        protected void terminateJob(Job.Key jobKey, String jobName, Tool tool, Job.Type jobType, byte[] serializedJob, boolean doItOk, byte[] serializedResult, Snapshot newSnapshot) {
            this.printMessage("Job " + String.valueOf(jobKey), true);
            if (!jobType.isExamine()) {
                this.endChanging();
            }
        }

        @Override
        protected void showJobQueue(Job.Inform[] jobQueue) {
            this.printMessage("JobQueue: ", false);
            for (Job.Inform jobInfo : jobQueue) {
                this.printMessage(" " + String.valueOf(jobInfo), false);
            }
            this.printMessage("", true);
        }

        @Override
        protected void addEvent(Client.ServerEvent serverEvent) {
            serverEvent.run();
        }
    }

    private static class InitDatabase
    extends Job {
        private Map<String, Object> paramValuesByXmlPath = Technology.getParamValuesByXmlPath();
        private List<String> argsList;
        private Library mainLib;

        private InitDatabase(List<String> argsList) {
            super("Init database", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.argsList = argsList;
        }

        @Override
        public boolean doIt() throws JobException {
            Technology.initPreinstalledTechnologies(this.getDatabase(), this.paramValuesByXmlPath);
            Library clipLib = Library.newInst("Clipboard!!", null);
            clipLib.setHidden();
            Cell clipCell = Cell.newInst(clipLib, "Clipboard!!;1{}");
            assert (clipCell.getId().cellIndex == 0);
            clipCell.setTechnology(this.getTechPool().getGeneric());
            this.mainLib = Library.newInst("noname", null);
            if (this.mainLib == null) {
                return false;
            }
            this.fieldVariableChanged("mainLib");
            this.mainLib.clearChanged();
            if (Main.isBatch()) {
                String beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
                Main.openCommandLineLibs(this.argsList);
                if (beanShellScript != null) {
                    EvalJavaBsh.runScript(beanShellScript);
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            new InitProjectSettings(this.argsList).startJobOnMyResult();
            User.setCurrentLibrary(this.mainLib);
        }

        @Override
        public void terminateFail(Throwable jobException) {
            System.out.println("Initialization failed");
            System.exit(1);
        }
    }

    private static class InitClient
    extends Job {
        List<String> argsList;

        private InitClient(List<String> argsList) {
            super("Init project preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.argsList = argsList;
        }

        @Override
        public boolean doIt() throws JobException {
            return true;
        }

        @Override
        public void terminateOK() {
            Job.getExtendedUserInterface().finishInitialization();
            String beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
            Main.openCommandLineLibs(this.argsList);
            if (beanShellScript != null) {
                EvalJavaBsh.runScript(beanShellScript);
            }
        }

        static {
            new Setting.SettingChangeBatch();
        }
    }

    private static class InitProjectSettings
    extends Job {
        private Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        List<String> argsList;

        private InitProjectSettings(List<String> argsList) {
            super("Init project preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            Preferences prefRoot = Pref.getPrefRoot();
            for (Map.Entry<Setting, Object> e2 : this.getDatabase().getSettings().entrySet()) {
                Setting setting = e2.getKey();
                Object value = setting.getValueFromPreferences(prefRoot);
                if (value.equals(e2.getValue())) continue;
                this.changeBatch.add(setting, value);
            }
            this.argsList = argsList;
        }

        @Override
        public boolean doIt() throws JobException {
            this.getDatabase().implementSettingChanges(this.changeBatch);
            return true;
        }

        @Override
        public void terminateOK() {
            Job.getExtendedUserInterface().finishInitialization();
            String beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
            Main.openCommandLineLibs(this.argsList);
            if (beanShellScript != null) {
                EvalJavaBsh.runScript(beanShellScript);
            }
        }
    }
}

