/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.util.Bitfield;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jogamp.opengl.Debug;

public class Texture {
    private int target;
    private int imageTarget;
    private int texID;
    private int texWidth;
    private int texHeight;
    private int imgWidth;
    private int imgHeight;
    private float aspectRatio;
    private boolean mustFlipVertically;
    private boolean usingAutoMipmapGeneration;
    private TextureCoords coords;
    private int estimatedMemorySize;
    private static final boolean DEBUG = Debug.debug("Texture");
    private static final boolean VERBOSE = Debug.verbose();
    private static final boolean disableNPOT = Debug.isPropertyDefined("jogl.texture.nonpot", true);
    private static final boolean disableTexRect = Debug.isPropertyDefined("jogl.texture.notexrect", true);

    public String toString() {
        String string = this.target == this.imageTarget ? Integer.toHexString(this.target) : Integer.toHexString(this.target) + " - image " + Integer.toHexString(this.imageTarget);
        return "Texture[target " + string + ", name " + this.texID + ", " + this.imgWidth + "/" + this.texWidth + " x " + this.imgHeight + "/" + this.texHeight + ", y-flip " + this.mustFlipVertically + ", " + this.estimatedMemorySize + " bytes]";
    }

    public Texture(GL gL, TextureData textureData) throws GLException {
        this.texID = 0;
        this.target = 0;
        this.imageTarget = 0;
        this.updateImage(gL, textureData);
    }

    public Texture(int n2) {
        this.texID = 0;
        this.target = n2;
        this.imageTarget = n2;
    }

    public Texture(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.texID = n2;
        this.target = n3;
        this.imageTarget = n3;
        this.mustFlipVertically = bl;
        this.texWidth = n4;
        this.texHeight = n5;
        this.aspectRatio = (float)n6 / (float)n7;
        this.imgWidth = n6;
        this.imgHeight = n7;
        this.updateTexCoords();
    }

    public void enable(GL gL) throws GLException {
        if (!gL.isGLcore() && 36197 != this.target) {
            gL.glEnable(this.target);
        }
    }

    public void disable(GL gL) throws GLException {
        if (!gL.isGLcore() && 36197 != this.target) {
            gL.glDisable(this.target);
        }
    }

    public void bind(GL gL) throws GLException {
        this.validateTexID(gL, true);
        gL.glBindTexture(this.target, this.texID);
    }

    public void destroy(GL gL) throws GLException {
        if (0 != this.texID) {
            gL.glDeleteTextures(1, new int[]{this.texID}, 0);
            this.texID = 0;
        }
    }

    public int getTarget() {
        return this.target;
    }

    public int getImageTarget() {
        return this.imageTarget;
    }

    public int getWidth() {
        return this.texWidth;
    }

    public int getHeight() {
        return this.texHeight;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public TextureCoords getImageTexCoords() {
        return this.coords;
    }

    public TextureCoords getSubImageTexCoords(int n2, int n3, int n4, int n5) {
        if (34037 == this.imageTarget) {
            if (this.mustFlipVertically) {
                return new TextureCoords(n2, this.texHeight - n3, n4, this.texHeight - n5);
            }
            return new TextureCoords(n2, n3, n4, n5);
        }
        float f2 = (float)n2 / (float)this.texWidth;
        float f3 = (float)n3 / (float)this.texHeight;
        float f4 = (float)n4 / (float)this.texWidth;
        float f5 = (float)n5 / (float)this.texHeight;
        if (this.mustFlipVertically) {
            float f6 = (float)this.imgHeight / (float)this.texHeight;
            return new TextureCoords(f2, f6 - f3, f4, f6 - f5);
        }
        return new TextureCoords(f2, f3, f4, f5);
    }

    public void updateImage(GL gL, TextureData textureData) throws GLException {
        this.updateImage(gL, textureData, 0);
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    public void setMustFlipVertically(boolean bl) {
        if (bl != this.mustFlipVertically) {
            this.mustFlipVertically = bl;
            this.updateTexCoords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(GL gL, TextureData textureData, int n2) throws GLException {
        int n3;
        Object[] objectArray;
        boolean bl;
        this.validateTexID(gL, true);
        this.imgWidth = textureData.getWidth();
        this.imgHeight = textureData.getHeight();
        this.aspectRatio = (float)this.imgWidth / (float)this.imgHeight;
        this.mustFlipVertically = textureData.getMustFlipVertically();
        int n4 = 0;
        int n5 = this.target;
        boolean bl2 = gL.isExtensionAvailable("GL_VERSION_1_4") || gL.isExtensionAvailable("GL_SGIS_generate_mipmap");
        textureData.setHaveEXTABGR(gL.isExtensionAvailable("GL_EXT_abgr"));
        textureData.setHaveGL12(gL.isExtensionAvailable("GL_VERSION_1_2"));
        boolean bl3 = bl = Bitfield.Util.isPowerOf2(this.imgWidth) && Bitfield.Util.isPowerOf2(this.imgHeight);
        if (!bl && !Texture.haveNPOT(gL)) {
            bl2 = false;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (textureData.getMipmap() && !bl2) {
            this.imgWidth = Bitfield.Util.roundToPowerOf2(this.imgWidth);
            this.imgHeight = Bitfield.Util.roundToPowerOf2(this.imgHeight);
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n4 = 3553;
            bl5 = true;
        }
        if (!(bl5 || !Texture.preferTexRect(gL) || bl || !Texture.haveTexRect(gL) || textureData.isDataCompressed() || gL.isGL3() || gL.isGLES())) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle preferentially on this hardware");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n4 = 34037;
            bl5 = true;
        }
        if (!bl5 && (bl || Texture.haveNPOT(gL))) {
            if (DEBUG) {
                if (bl) {
                    System.err.println("Power-of-two texture");
                } else {
                    System.err.println("Using GL_ARB_texture_non_power_of_two");
                }
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n4 = 3553;
            bl5 = true;
        }
        if (!(bl5 || !Texture.haveTexRect(gL) || textureData.isDataCompressed() || gL.isGL3() || gL.isGLES())) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n4 = 34037;
            bl5 = true;
        }
        if (!bl5) {
            if (textureData.isDataCompressed()) {
                if (textureData.getMipmapData() != null) {
                    throw new GLException("Mipmapped non-power-of-two compressed textures only supported on OpenGL 2.0 hardware (GL_ARB_texture_non_power_of_two)");
                }
                bl4 = true;
            }
            if (DEBUG) {
                System.err.println("Expanding texture to power-of-two dimensions");
            }
            if (textureData.getBorder() != 0) {
                throw new RuntimeException("Scaling up a non-power-of-two texture which has a border won't work");
            }
            this.texWidth = Bitfield.Util.roundToPowerOf2(this.imgWidth);
            this.texHeight = Bitfield.Util.roundToPowerOf2(this.imgHeight);
            n4 = 3553;
        }
        n5 = n4;
        this.imageTarget = n4;
        this.updateTexCoords();
        if (n2 != 0) {
            if (this.target == 0) {
                throw new GLException("Override of target failed; no target specified yet");
            }
            n4 = n2;
            n5 = this.target;
            gL.glBindTexture(n5, this.texID);
        } else {
            gL.glBindTexture(n4, this.texID);
        }
        if (textureData.getMipmap() && !bl2) {
            objectArray = new int[1];
            gL.glGetIntegerv(3317, (int[])objectArray, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (textureData.isDataCompressed()) {
                throw new GLException("May not request mipmap generation for compressed textures");
            }
            try {
                GLU gLU = GLU.createGLU(gL);
                gLU.gluBuild2DMipmaps(n4, textureData.getInternalFormat(), textureData.getWidth(), textureData.getHeight(), textureData.getPixelFormat(), textureData.getPixelType(), textureData.getBuffer());
            }
            finally {
                gL.glPixelStorei(3317, objectArray[0]);
            }
        } else {
            this.checkCompressedTextureExtensions(gL, textureData);
            objectArray = textureData.getMipmapData();
            if (objectArray != null) {
                int n6 = this.texWidth;
                int n7 = this.texHeight;
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    if (textureData.isDataCompressed()) {
                        gL.glCompressedTexImage2D(n4, i2, textureData.getInternalFormat(), n6, n7, textureData.getBorder(), objectArray[i2].remaining(), (Buffer)objectArray[i2]);
                    } else {
                        gL.glTexImage2D(n4, i2, textureData.getInternalFormat(), n6, n7, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                        this.updateSubImageImpl(gL, textureData, n4, i2, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                    }
                    n6 = Math.max(n6 / 2, 1);
                    n7 = Math.max(n7 / 2, 1);
                }
            } else if (textureData.isDataCompressed()) {
                if (!bl4) {
                    gL.glCompressedTexImage2D(n4, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getBuffer().capacity(), textureData.getBuffer());
                } else {
                    ByteBuffer byteBuffer = DDSImage.allocateBlankBuffer(this.texWidth, this.texHeight, textureData.getInternalFormat());
                    gL.glCompressedTexImage2D(n4, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), byteBuffer.capacity(), byteBuffer);
                    this.updateSubImageImpl(gL, textureData, n4, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                }
            } else {
                if (textureData.getMipmap() && bl2 && gL.isGL2ES1()) {
                    gL.glTexParameteri(n5, 33169, 1);
                    this.usingAutoMipmapGeneration = true;
                }
                gL.glTexImage2D(n4, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                this.updateSubImageImpl(gL, textureData, n4, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
            }
        }
        int n8 = textureData.getMipmap() ? 9987 : 9729;
        int n9 = n3 = gL.isExtensionAvailable("GL_VERSION_1_2") || !gL.isGL2() ? 33071 : 10496;
        if (n4 != 34037) {
            gL.glTexParameteri(n5, 10241, n8);
            gL.glTexParameteri(n5, 10240, 9729);
            gL.glTexParameteri(n5, 10242, n3);
            gL.glTexParameteri(n5, 10243, n3);
            if (this.target == 34067) {
                gL.glTexParameteri(n5, 32882, n3);
            }
        }
        if (this.target == 0 || this.target == 3553 || this.target == 34037) {
            this.target = n4;
        }
        this.estimatedMemorySize = textureData.getEstimatedMemorySize();
    }

    public void updateSubImage(GL gL, TextureData textureData, int n2, int n3, int n4) throws GLException {
        if (this.usingAutoMipmapGeneration && n2 != 0) {
            return;
        }
        this.bind(gL);
        this.updateSubImageImpl(gL, textureData, this.target, n2, n3, n4, 0, 0, textureData.getWidth(), textureData.getHeight());
    }

    public void updateSubImage(GL gL, TextureData textureData, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws GLException {
        if (textureData.isDataCompressed()) {
            throw new GLException("updateSubImage specifying a sub-rectangle is not supported for compressed TextureData");
        }
        if (this.usingAutoMipmapGeneration && n2 != 0) {
            return;
        }
        this.bind(gL);
        this.updateSubImageImpl(gL, textureData, this.target, n2, n3, n4, n5, n6, n7, n8);
    }

    public void setTexParameterf(GL gL, int n2, float f2) {
        this.bind(gL);
        gL.glTexParameterf(this.target, n2, f2);
    }

    public void setTexParameterfv(GL gL, int n2, FloatBuffer floatBuffer) {
        this.bind(gL);
        gL.glTexParameterfv(this.target, n2, floatBuffer);
    }

    public void setTexParameterfv(GL gL, int n2, float[] fArray, int n3) {
        this.bind(gL);
        gL.glTexParameterfv(this.target, n2, fArray, n3);
    }

    public void setTexParameteri(GL gL, int n2, int n3) {
        this.bind(gL);
        gL.glTexParameteri(this.target, n2, n3);
    }

    public void setTexParameteriv(GL gL, int n2, IntBuffer intBuffer) {
        this.bind(gL);
        gL.glTexParameteriv(this.target, n2, intBuffer);
    }

    public void setTexParameteriv(GL gL, int n2, int[] nArray, int n3) {
        this.bind(gL);
        gL.glTexParameteriv(this.target, n2, nArray, n3);
    }

    public int getTextureObject(GL gL) {
        this.validateTexID(gL, false);
        return this.texID;
    }

    public int getTextureObject() {
        return this.texID;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public boolean isUsingAutoMipmapGeneration() {
        return this.usingAutoMipmapGeneration;
    }

    private void updateTexCoords() {
        this.coords = 34037 == this.imageTarget ? (this.mustFlipVertically ? new TextureCoords(0.0f, this.imgHeight, this.imgWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, this.imgWidth, this.imgHeight)) : (this.mustFlipVertically ? new TextureCoords(0.0f, (float)this.imgHeight / (float)this.texHeight, (float)this.imgWidth / (float)this.texWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, (float)this.imgWidth / (float)this.texWidth, (float)this.imgHeight / (float)this.texHeight));
    }

    private void updateSubImageImpl(GL gL, TextureData textureData, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws GLException {
        textureData.setHaveEXTABGR(gL.isExtensionAvailable("GL_EXT_abgr"));
        textureData.setHaveGL12(gL.isExtensionAvailable("GL_VERSION_1_2"));
        Buffer buffer = textureData.getBuffer();
        if (buffer == null && textureData.getMipmapData() == null) {
            return;
        }
        int n10 = textureData.getRowLength();
        int n11 = textureData.getWidth();
        int n12 = textureData.getHeight();
        if (textureData.getMipmapData() != null) {
            for (int i2 = 0; i2 < n3; ++i2) {
                n8 = Math.max(n8 / 2, 1);
                n9 = Math.max(n9 / 2, 1);
                n11 = Math.max(n11 / 2, 1);
                n12 = Math.max(n12 / 2, 1);
            }
            n10 = 0;
            buffer = textureData.getMipmapData()[n3];
        }
        if (n6 < 0) {
            n8 += n6;
            n6 = 0;
        }
        if (n7 < 0) {
            n9 += n7;
            n7 = 0;
        }
        if (n4 < 0) {
            n8 += n4;
            n4 = 0;
        }
        if (n5 < 0) {
            n9 += n5;
            n5 = 0;
        }
        if (n6 + n8 > n11) {
            n8 = n11 - n6;
        }
        if (n7 + n9 > n12) {
            n9 = n12 - n7;
        }
        if (n4 + n8 > this.texWidth) {
            n8 = this.texWidth - n4;
        }
        if (n5 + n9 > this.texHeight) {
            n9 = this.texHeight - n5;
        }
        this.checkCompressedTextureExtensions(gL, textureData);
        if (textureData.isDataCompressed()) {
            gL.glCompressedTexSubImage2D(n2, n3, n4, n5, n8, n9, textureData.getInternalFormat(), buffer.remaining(), buffer);
        } else {
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            int[] nArray3 = new int[]{0};
            int[] nArray4 = new int[]{0};
            gL.glGetIntegerv(3317, nArray, 0);
            if (gL.isGL2GL3()) {
                gL.glGetIntegerv(3314, nArray2, 0);
                gL.glGetIntegerv(3315, nArray3, 0);
                gL.glGetIntegerv(3316, nArray4, 0);
            }
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (DEBUG && VERBOSE) {
                System.out.println("Row length  = " + n10);
                System.out.println("skip pixels = " + n6);
                System.out.println("skip rows   = " + n7);
                System.out.println("dstx        = " + n4);
                System.out.println("dsty        = " + n5);
                System.out.println("width       = " + n8);
                System.out.println("height      = " + n9);
            }
            if (gL.isGL2GL3()) {
                gL.glPixelStorei(3314, n10);
                gL.glPixelStorei(3315, n7);
                gL.glPixelStorei(3316, n6);
            } else if (n10 != 0 && n10 != n8 && n7 != 0 && n6 != 0) {
                throw new GLException("rowlen and/or x/y offset only available for GL2");
            }
            gL.glTexSubImage2D(n2, n3, n4, n5, n8, n9, textureData.getPixelFormat(), textureData.getPixelType(), buffer);
            gL.glPixelStorei(3317, nArray[0]);
            if (gL.isGL2GL3()) {
                gL.glPixelStorei(3314, nArray2[0]);
                gL.glPixelStorei(3315, nArray3[0]);
                gL.glPixelStorei(3316, nArray4[0]);
            }
        }
    }

    private void checkCompressedTextureExtensions(GL gL, TextureData textureData) {
        if (textureData.isDataCompressed()) {
            switch (textureData.getInternalFormat()) {
                case 33776: 
                case 33777: 
                case 33778: 
                case 33779: {
                    if (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc")) break;
                    throw new GLException("DXTn compressed textures not supported by this graphics card");
                }
            }
        }
    }

    private boolean validateTexID(GL gL, boolean bl) {
        if (0 == this.texID) {
            if (null != gL) {
                int[] nArray = new int[1];
                gL.glGenTextures(1, nArray, 0);
                this.texID = nArray[0];
                if (0 == this.texID && bl) {
                    throw new GLException("Create texture ID invalid: texID " + this.texID + ", glerr 0x" + Integer.toHexString(gL.glGetError()));
                }
            } else if (bl) {
                throw new GLException("No GL context given, can't create texture ID");
            }
        }
        return 0 != this.texID;
    }

    private static boolean haveNPOT(GL gL) {
        return !disableNPOT && gL.isNPOTTextureAvailable();
    }

    private static boolean haveTexRect(GL gL) {
        return !disableTexRect && TextureIO.isTexRectEnabled() && gL.isExtensionAvailable("GL_ARB_texture_rectangle");
    }

    private static boolean preferTexRect(GL gL) {
        String string;
        return ".macosx" == NativeWindowFactory.getNativeWindowType(false) && (string = gL.glGetString(7936)) != null && string.startsWith("ATI");
    }
}

