/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.packrect;

import com.jogamp.opengl.util.packrect.Level;

public class Rect {
    private int x;
    private int y;
    private int w;
    private int h;
    private Level level;
    private Object userData;
    private Rect nextLocation;

    public Rect() {
        this(null);
    }

    public Rect(Object object) {
        this(0, 0, 0, 0, object);
    }

    public Rect(int n2, int n3, int n4, int n5, Object object) {
        this.setPosition(n2, n3);
        this.setSize(n4, n5);
        this.setUserData(object);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public Object getUserData() {
        return this.userData;
    }

    public Rect getNextLocation() {
        return this.nextLocation;
    }

    public void setPosition(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative x");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Negative y");
        }
        this.x = n2;
        this.y = n3;
    }

    public void setSize(int n2, int n3) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative width");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Negative height");
        }
        this.w = n2;
        this.h = n3;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public void setNextLocation(Rect rect) {
        this.nextLocation = rect;
    }

    public int maxX() {
        if (this.w() < 1) {
            return -1;
        }
        return this.x() + this.w() - 1;
    }

    public int maxY() {
        if (this.h() < 1) {
            return -1;
        }
        return this.y() + this.h() - 1;
    }

    public boolean canContain(Rect rect) {
        return this.w() >= rect.w() && this.h() >= rect.h();
    }

    public String toString() {
        return "[Rect x: " + this.x() + " y: " + this.y() + " w: " + this.w() + " h: " + this.h() + "]";
    }
}

