/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.awt;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageUtil {
    private ImageUtil() {
    }

    public static void flipImageVertically(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = null;
        Object object2 = null;
        for (int i2 = 0; i2 < bufferedImage.getHeight() / 2; ++i2) {
            object = writableRaster.getDataElements(0, i2, bufferedImage.getWidth(), 1, object);
            object2 = writableRaster.getDataElements(0, bufferedImage.getHeight() - i2 - 1, bufferedImage.getWidth(), 1, object2);
            writableRaster.setDataElements(0, i2, bufferedImage.getWidth(), 1, object2);
            writableRaster.setDataElements(0, bufferedImage.getHeight() - i2 - 1, bufferedImage.getWidth(), 1, object);
        }
    }

    public static BufferedImage createCompatibleImage(int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(n2, n3);
    }

    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n2) {
        if (n2 > bufferedImage.getWidth()) {
            throw new IllegalArgumentException("Thumbnail width must be greater than image width");
        }
        if (n2 == bufferedImage.getWidth()) {
            return bufferedImage;
        }
        float f2 = (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight();
        int n3 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = bufferedImage;
        do {
            if ((n3 /= 2) < n2) {
                n3 = n2;
            }
            BufferedImage bufferedImage3 = ImageUtil.createCompatibleImage(n3, (int)((float)n3 / f2));
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight(), null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n3 != n2);
        return bufferedImage2;
    }
}

