/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRendererBase;

public class RandomTileRenderer
extends TileRendererBase {
    private boolean tileRectSet = false;

    @Override
    public final int getParam(int n2) {
        switch (n2) {
            case 1: {
                return this.imageSize.getWidth();
            }
            case 2: {
                return this.imageSize.getHeight();
            }
            case 3: {
                return this.currentTileXPos;
            }
            case 4: {
                return this.currentTileYPos;
            }
            case 5: {
                return this.currentTileWidth;
            }
            case 6: {
                return this.currentTileHeight;
            }
        }
        throw new IllegalArgumentException("Invalid pname: " + n2);
    }

    public void setTileRect(int n2, int n3, int n4, int n5) throws IllegalStateException, IllegalArgumentException {
        if (0 > n2 || 0 > n3) {
            throw new IllegalArgumentException("Tile pos must be >= 0/0");
        }
        if (0 >= n4 || 0 >= n5) {
            throw new IllegalArgumentException("Tile size must be > 0x0");
        }
        this.currentTileXPos = n2;
        this.currentTileYPos = n3;
        this.currentTileWidth = n4;
        this.currentTileHeight = n5;
        this.tileRectSet = true;
    }

    @Override
    public final boolean isSetup() {
        return 0 < this.imageSize.getWidth() && 0 < this.imageSize.getHeight() && this.tileRectSet;
    }

    @Override
    public final boolean eot() {
        return false;
    }

    @Override
    public final void reset() {
    }

    @Override
    public final void beginTile(GL gL) throws IllegalStateException, GLException {
        if (0 >= this.imageSize.getWidth() || 0 >= this.imageSize.getHeight()) {
            throw new IllegalStateException("Image size has not been set");
        }
        if (!this.tileRectSet) {
            throw new IllegalStateException("tileRect has not been set");
        }
        this.validateGL(gL);
        gL.glViewport(0, 0, this.currentTileWidth, this.currentTileHeight);
        if (DEBUG) {
            System.err.println("TileRenderer.begin.X: " + this.toString());
        }
        this.beginCalled = true;
    }

    @Override
    public void endTile(GL gL) throws IllegalStateException, GLException {
        int n2;
        int n3;
        int n4;
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes;
        int n5;
        GL2ES3 gL2ES3;
        if (!this.beginCalled) {
            throw new IllegalStateException("beginTile(..) has not been called");
        }
        this.validateGL(gL);
        gL.glFlush();
        this.psm.setPackAlignment(gL, 1);
        if (gL.isGL2ES3()) {
            gL2ES3 = gL.getGL2ES3();
            n5 = gL2ES3.getDefaultReadBuffer();
            gL2ES3.glReadBuffer(n5);
        } else {
            gL2ES3 = null;
            n5 = 0;
        }
        if (DEBUG) {
            System.err.println("TileRenderer.end.0: readBuffer 0x" + Integer.toHexString(n5) + ", " + this.toString());
        }
        int[] nArray = new int[1];
        if (this.tileBuffer != null) {
            gLPixelAttributes = this.tileBuffer.pixelAttributes;
            n4 = this.currentTileWidth;
            n3 = this.currentTileHeight;
            n2 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n4, n3, 1, true);
            this.tileBuffer.clear();
            if (this.tileBuffer.requiresNewBuffer(gL, n4, n3, n2)) {
                throw new IndexOutOfBoundsException("Required " + n2 + " bytes of buffer, only had " + this.tileBuffer);
            }
            gL.glReadPixels(0, 0, n4, n3, gLPixelAttributes.format, gLPixelAttributes.type, this.tileBuffer.buffer);
            gL.glFlush();
            this.tileBuffer.position(n2);
            this.tileBuffer.flip();
        }
        if (this.imageBuffer != null) {
            gLPixelAttributes = this.imageBuffer.pixelAttributes;
            n4 = this.currentTileWidth;
            n3 = this.currentTileHeight;
            n2 = this.imageSize.getWidth();
            this.psm.setPackRowLength(gL2ES3, n2);
            int n6 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n4, n3, 1, true);
            int n7 = (this.currentTileXPos + this.currentTileYPos * n2) * gLPixelAttributes.pfmt.comp.bytesPerPixel();
            int n8 = n7 + n6;
            this.imageBuffer.clear();
            if (this.imageBuffer.requiresNewBuffer(gL, n4, n3, n6)) {
                throw new IndexOutOfBoundsException("Required " + n8 + " bytes of buffer, only had " + this.imageBuffer);
            }
            this.imageBuffer.position(n7);
            gL.glReadPixels(0, 0, n4, n3, gLPixelAttributes.format, gLPixelAttributes.type, this.imageBuffer.buffer);
            gL.glFlush();
            this.imageBuffer.position(n8);
            this.imageBuffer.flip();
        }
        this.psm.restore(gL);
        this.beginCalled = false;
    }

    public void display(int n2, int n3, int n4, int n5) throws IllegalStateException {
        this.setTileRect(n2, n3, n4, n5);
        this.display();
    }
}

