/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandler;
import jogamp.opengl.util.glsl.GLSLArrayHandler;

public class GLArrayDataClient
extends GLArrayDataWrapper
implements GLArrayDataEditable {
    private boolean isValidated = false;
    protected boolean sealed;
    protected boolean bufferEnabled;
    protected boolean bufferWritten;
    protected boolean enableBufferAlways;
    protected int initialElementCount;
    protected GLArrayHandler glArrayHandler;
    protected boolean usesGLSL;
    protected ShaderState shaderState;

    public static GLArrayDataClient createFixed(int n2, int n3, int n4, boolean bl, int n5) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(null, n2, n3, n4, bl, 0, null, n5, 0, false, gLFixedArrayHandler, 0, 0L, 0, 0, false);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createFixed(int n2, int n3, int n4, boolean bl, int n5, Buffer buffer) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(null, n2, n3, n4, bl, n5, buffer, n3 * n3, 0, false, gLFixedArrayHandler, 0, 0L, 0, 0, false);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createGLSL(String string, int n2, int n3, boolean bl, int n4) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, -1, n2, n3, bl, 0, null, n4, 0, true, gLSLArrayHandler, 0, 0L, 0, 0, true);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createGLSL(String string, int n2, int n3, boolean bl, int n4, Buffer buffer) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, -1, n2, n3, bl, n4, buffer, n2 * n2, 0, true, gLSLArrayHandler, 0, 0L, 0, 0, true);
        return gLArrayDataClient;
    }

    @Override
    public void associate(Object object, boolean bl) {
        if (object instanceof ShaderState) {
            this.shaderState = bl ? (ShaderState)object : null;
        }
    }

    @Override
    public final boolean isVBOWritten() {
        return this.bufferWritten;
    }

    @Override
    public final boolean sealed() {
        return this.sealed;
    }

    @Override
    public final boolean enabled() {
        return this.bufferEnabled;
    }

    @Override
    public final void setVBOWritten(boolean bl) {
        this.bufferWritten = 0 == this.mappedElementCount ? bl : true;
    }

    @Override
    public void destroy(GL gL) {
        this.reset(gL);
        super.destroy(gL);
    }

    @Override
    public void reset(GL gL) {
        this.enableBuffer(gL, false);
        this.reset();
    }

    @Override
    public void seal(GL gL, boolean bl) {
        this.seal(bl);
        this.enableBuffer(gL, bl);
    }

    @Override
    public void enableBuffer(GL gL, boolean bl) {
        if (this.enableBufferAlways || this.bufferEnabled != bl) {
            if (bl) {
                this.checkSeal(true);
                this.init_vbo(gL);
            }
            this.glArrayHandler.enableState(gL, bl, this.usesGLSL ? this.shaderState : null);
            this.bufferEnabled = bl;
        }
    }

    @Override
    public boolean bindBuffer(GL gL, boolean bl) {
        if (bl) {
            this.checkSeal(true);
            this.init_vbo(gL);
        }
        return this.glArrayHandler.bindBuffer(gL, bl);
    }

    @Override
    public void setEnableAlways(boolean bl) {
        this.enableBufferAlways = bl;
    }

    @Override
    public void reset() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.sealed = false;
        this.bufferEnabled = false;
        this.bufferWritten = 0 != this.mappedElementCount;
    }

    @Override
    public void seal(boolean bl) {
        if (this.sealed == bl) {
            return;
        }
        this.sealed = bl;
        boolean bl2 = this.bufferWritten = 0 != this.mappedElementCount;
        if (bl) {
            if (null != this.buffer) {
                this.buffer.flip();
            }
        } else if (null != this.buffer) {
            this.buffer.position(this.buffer.limit());
            this.buffer.limit(this.buffer.capacity());
        }
    }

    @Override
    public void rewind() {
        if (this.buffer != null) {
            this.buffer.rewind();
        }
    }

    @Override
    public void padding(int n2) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        while (n2 < this.strideB) {
            Buffers.putb(this.buffer, (byte)0);
            ++n2;
        }
    }

    @Override
    public void put(Buffer buffer) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(buffer.remaining());
        Buffers.put(this.buffer, buffer);
    }

    @Override
    public void putb(byte by) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.putb(this.buffer, by);
    }

    @Override
    public void puts(short s) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.puts(this.buffer, s);
    }

    @Override
    public void puti(int n2) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.puti(this.buffer, n2);
    }

    @Override
    public void putx(int n2) {
        this.puti(n2);
    }

    @Override
    public void putf(float f2) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.putf(this.buffer, f2);
    }

    @Override
    public String toString() {
        return "GLArrayDataClient[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", usesGLSL " + this.usesGLSL + ", usesShaderState " + (null != this.shaderState) + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.componentsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c, mappedElementCount " + this.mappedElementCount + ", initialElementCount " + this.initialElementCount + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + ", alive " + this.alive + "]";
    }

    protected final boolean growBufferIfNecessary(int n2) {
        if (this.buffer == null || this.buffer.remaining() < n2) {
            if (0 != this.mappedElementCount) {
                throw new GLException("Mapped buffer can't grow. Insufficient storage size: Needed " + n2 + " components, mappedElementCount " + this.mappedElementCount + ", has mapped buffer " + this.buffer + "; " + this);
            }
            this.growBuffer(Math.max(this.initialElementCount, (n2 + this.componentsPerElement - 1) / this.componentsPerElement));
            return true;
        }
        return false;
    }

    protected final void growBuffer(int n2) {
        if (!this.alive || this.sealed) {
            throw new GLException("Invalid state: " + this);
        }
        n2 += n2 / this.componentsPerElement * (this.strideL - this.componentsPerElement);
        int n3 = this.buffer != null ? this.buffer.capacity() : 0;
        int n4 = n3 + n2 * this.componentsPerElement;
        Buffer buffer = this.buffer;
        if (this.componentClazz == ByteBuffer.class) {
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n4);
            if (this.buffer != null) {
                this.buffer.flip();
                byteBuffer.put((ByteBuffer)this.buffer);
            }
            this.buffer = byteBuffer;
        } else if (this.componentClazz == ShortBuffer.class) {
            ShortBuffer shortBuffer = Buffers.newDirectShortBuffer(n4);
            if (this.buffer != null) {
                this.buffer.flip();
                shortBuffer.put((ShortBuffer)this.buffer);
            }
            this.buffer = shortBuffer;
        } else if (this.componentClazz == IntBuffer.class) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(n4);
            if (this.buffer != null) {
                this.buffer.flip();
                intBuffer.put((IntBuffer)this.buffer);
            }
            this.buffer = intBuffer;
        } else if (this.componentClazz == FloatBuffer.class) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(n4);
            if (this.buffer != null) {
                this.buffer.flip();
                floatBuffer.put((FloatBuffer)this.buffer);
            }
            this.buffer = floatBuffer;
        } else {
            throw new GLException("Given Buffer Class not supported: " + this.componentClazz + ":\n\t" + this);
        }
        if (DEBUG) {
            System.err.println("*** Grow: comps: " + this.componentsPerElement + ", " + n3 / this.componentsPerElement + "/" + n3 + " -> " + n4 / this.componentsPerElement + "/" + n4 + "; " + buffer + " -> " + this.buffer + "; " + this);
        }
    }

    protected final void checkSeal(boolean bl) throws GLException {
        if (!this.alive) {
            throw new GLException("Invalid state: " + this);
        }
        if (this.sealed != bl) {
            if (bl) {
                throw new GLException("Not Sealed yet, seal first:\n\t" + this);
            }
            throw new GLException("Already Sealed, can't modify VBO:\n\t" + this);
        }
    }

    protected void init(String string, int n2, int n3, int n4, boolean bl, int n5, Buffer buffer, int n6, int n7, boolean bl2, GLArrayHandler gLArrayHandler, int n8, long l2, int n9, int n10, boolean bl3) throws GLException {
        super.init(string, n2, n3, n4, bl, n5, buffer, n7, bl2, n8, l2, n9, n10);
        if (0 < n7 && 0 < n6) {
            throw new IllegalArgumentException("mappedElementCount:=" + n7 + " specified, but passing non zero initialElementSize");
        }
        this.initialElementCount = n6;
        this.glArrayHandler = gLArrayHandler;
        this.usesGLSL = bl3;
        this.sealed = false;
        this.bufferEnabled = false;
        this.enableBufferAlways = false;
        boolean bl4 = this.bufferWritten = 0 != n7;
        if (null == this.buffer && n6 > 0) {
            this.growBuffer(n6);
        }
    }

    protected void init_vbo(GL gL) {
        if (!this.isValidated) {
            this.isValidated = true;
            this.validate(gL.getGLProfile(), true);
        }
    }

    protected GLArrayDataClient() {
    }

    public GLArrayDataClient(GLArrayDataClient gLArrayDataClient) {
        super(gLArrayDataClient);
        this.isValidated = gLArrayDataClient.isValidated;
        this.sealed = gLArrayDataClient.sealed;
        this.bufferEnabled = gLArrayDataClient.bufferEnabled;
        this.bufferWritten = gLArrayDataClient.bufferWritten;
        this.enableBufferAlways = gLArrayDataClient.enableBufferAlways;
        this.initialElementCount = gLArrayDataClient.initialElementCount;
        if (null != gLArrayDataClient.glArrayHandler) {
            Class<?> clazz = gLArrayDataClient.glArrayHandler.getClass();
            try {
                Constructor<?> constructor = clazz.getConstructor(GLArrayDataEditable.class);
                this.glArrayHandler = (GLArrayHandler)constructor.newInstance(this);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not ctor " + clazz.getName() + "(" + this.getClass().getName() + ")", exception);
            }
        } else {
            this.glArrayHandler = null;
        }
        this.usesGLSL = gLArrayDataClient.usesGLSL;
        this.shaderState = gLArrayDataClient.shaderState;
    }
}

