/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.util.AnimatorBase;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

class AWTAnimatorImpl
implements AnimatorBase.AnimatorImpl {
    private final List<JComponent> lightweights = new ArrayList<JComponent>();
    private final Map<RepaintManager, RepaintManager> repaintManagers = new IdentityHashMap<RepaintManager, RepaintManager>();
    private final Map<JComponent, Rectangle> dirtyRegions = new IdentityHashMap<JComponent, Rectangle>();
    private final Runnable drawWithRepaintManagerRunnable = new Runnable(){

        @Override
        public void run() {
            Object object;
            Object object2;
            for (JComponent jComponent : AWTAnimatorImpl.this.lightweights) {
                object2 = RepaintManager.currentManager(jComponent);
                ((RepaintManager)object2).markCompletelyDirty(jComponent);
                AWTAnimatorImpl.this.repaintManagers.put(object2, object2);
                object = jComponent.getVisibleRect();
                int n2 = ((Rectangle)object).x;
                int n3 = ((Rectangle)object).y;
                while (jComponent != null) {
                    n2 += jComponent.getX();
                    n3 += jComponent.getY();
                    Container container = jComponent.getParent();
                    if (container == null || !(container instanceof JComponent)) {
                        jComponent = null;
                        continue;
                    }
                    jComponent = (JComponent)container;
                    if (jComponent.isOptimizedDrawingEnabled()) continue;
                    object2 = RepaintManager.currentManager(jComponent);
                    AWTAnimatorImpl.this.repaintManagers.put(object2, object2);
                    Rectangle rectangle = (Rectangle)AWTAnimatorImpl.this.dirtyRegions.get(jComponent);
                    if (rectangle == null) {
                        rectangle = new Rectangle(n2, n3, ((Rectangle)object).width, ((Rectangle)object).height);
                        AWTAnimatorImpl.this.dirtyRegions.put(jComponent, rectangle);
                        continue;
                    }
                    rectangle.add(new Rectangle(n2, n3, ((Rectangle)object).width, ((Rectangle)object).height));
                }
            }
            for (JComponent jComponent : AWTAnimatorImpl.this.dirtyRegions.keySet()) {
                object2 = (Rectangle)AWTAnimatorImpl.this.dirtyRegions.get(jComponent);
                object = RepaintManager.currentManager(jComponent);
                ((RepaintManager)object).addDirtyRegion(jComponent, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            }
            Iterator<Object> iterator = AWTAnimatorImpl.this.repaintManagers.keySet().iterator();
            while (iterator.hasNext()) {
                ((RepaintManager)iterator.next()).paintDirtyRegions();
            }
            AWTAnimatorImpl.this.dirtyRegions.clear();
            AWTAnimatorImpl.this.repaintManagers.clear();
        }
    };

    AWTAnimatorImpl() {
    }

    @Override
    public void display(ArrayList<GLAutoDrawable> arrayList, boolean bl, boolean bl2) throws AnimatorBase.UncaughtAnimatorException {
        boolean bl3 = false;
        for (int i2 = 0; !bl3 && i2 < arrayList.size(); ++i2) {
            GLAutoDrawable gLAutoDrawable = null;
            boolean bl4 = true;
            try {
                gLAutoDrawable = arrayList.get(i2);
                bl4 = false;
                if (gLAutoDrawable instanceof JComponent) {
                    this.lightweights.add((JComponent)((Object)gLAutoDrawable));
                    continue;
                }
                gLAutoDrawable.display();
                continue;
            }
            catch (Throwable throwable) {
                if (bl4 && throwable instanceof IndexOutOfBoundsException) {
                    bl3 = true;
                    continue;
                }
                if (bl) {
                    if (!bl2) continue;
                    throwable.printStackTrace();
                    continue;
                }
                throw new AnimatorBase.UncaughtAnimatorException(gLAutoDrawable, throwable);
            }
        }
        if (this.lightweights.size() > 0) {
            try {
                SwingUtilities.invokeAndWait(this.drawWithRepaintManagerRunnable);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.lightweights.clear();
        }
    }

    @Override
    public boolean blockUntilDone(Thread thread2) {
        return Thread.currentThread() != thread2 && !EventQueue.isDispatchThread();
    }
}

