/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;

public class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;
    public static final float ALLOWED_DEVIANCE = 1.0E-6f;

    public Quaternion() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(float f2, float f3, float f4, float f5) {
        this.set(f2, f3, f4, f5);
    }

    public final float magnitudeSquared() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float magnitude() {
        float f2 = this.magnitudeSquared();
        if (FloatUtil.isZero(f2, 1.1920929E-7f)) {
            return 0.0f;
        }
        if (FloatUtil.isEqual(1.0f, f2, 1.1920929E-7f)) {
            return 1.0f;
        }
        return FloatUtil.sqrt(f2);
    }

    public final float getW() {
        return this.w;
    }

    public final void setW(float f2) {
        this.w = f2;
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f2) {
        this.x = f2;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f2) {
        this.y = f2;
    }

    public final float getZ() {
        return this.z;
    }

    public final void setZ(float f2) {
        this.z = f2;
    }

    public final float dot(float f2, float f3, float f4, float f5) {
        return this.x * f2 + this.y * f3 + this.z * f4 + this.w * f5;
    }

    public final float dot(Quaternion quaternion) {
        return this.dot(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getW());
    }

    public final boolean isIdentity() {
        return FloatUtil.isEqual(1.0f, this.w, 1.1920929E-7f) && VectorUtil.isZero(this.x, this.y, this.z, 1.1920929E-7f);
    }

    public final Quaternion setIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public final Quaternion normalize() {
        float f2 = this.magnitude();
        if (FloatUtil.isZero(f2, 1.1920929E-7f)) {
            this.setIdentity();
        } else {
            float f3 = 1.0f / f2;
            this.w *= f3;
            this.x *= f3;
            this.y *= f3;
            this.z *= f3;
        }
        return this;
    }

    public Quaternion conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final Quaternion invert() {
        float f2 = this.magnitudeSquared();
        if (FloatUtil.isEqual(1.0f, f2, 1.1920929E-7f)) {
            this.conjugate();
        } else {
            float f3 = 1.0f / f2;
            this.w *= f3;
            this.x = -this.x * f3;
            this.y = -this.y * f3;
            this.z = -this.z * f3;
        }
        return this;
    }

    public final Quaternion set(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        return this;
    }

    public final Quaternion set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
        return this;
    }

    public final Quaternion add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public final Quaternion subtract(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
        return this;
    }

    public final Quaternion mult(Quaternion quaternion) {
        return this.set(this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y, this.w * quaternion.y - this.x * quaternion.z + this.y * quaternion.w + this.z * quaternion.x, this.w * quaternion.z + this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.w, this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z);
    }

    public final Quaternion scale(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
        return this;
    }

    public Quaternion rotateByAngleNormalAxis(float f2, float f3, float f4, float f5) {
        if (VectorUtil.isZero(f3, f4, f5, 1.1920929E-7f)) {
            return this;
        }
        float f6 = 0.5f * f2;
        float f7 = FloatUtil.sin(f6);
        float f8 = FloatUtil.cos(f6);
        float f9 = f7 * f3;
        float f10 = f7 * f4;
        float f11 = f7 * f5;
        return this.set(this.x * f8 + this.y * f11 - this.z * f10 + this.w * f9, -this.x * f11 + this.y * f8 + this.z * f9 + this.w * f10, this.x * f10 - this.y * f9 + this.z * f8 + this.w * f11, -this.x * f9 - this.y * f10 - this.z * f11 + this.w * f8);
    }

    public Quaternion rotateByAngleX(float f2) {
        float f3 = 0.5f * f2;
        float f4 = FloatUtil.sin(f3);
        float f5 = FloatUtil.cos(f3);
        return this.set(this.x * f5 + this.w * f4, this.y * f5 + this.z * f4, -this.y * f4 + this.z * f5, -this.x * f4 + this.w * f5);
    }

    public Quaternion rotateByAngleY(float f2) {
        float f3 = 0.5f * f2;
        float f4 = FloatUtil.sin(f3);
        float f5 = FloatUtil.cos(f3);
        return this.set(this.x * f5 - this.z * f4, this.y * f5 + this.w * f4, this.x * f4 + this.z * f5, -this.y * f4 + this.w * f5);
    }

    public Quaternion rotateByAngleZ(float f2) {
        float f3 = 0.5f * f2;
        float f4 = FloatUtil.sin(f3);
        float f5 = FloatUtil.cos(f3);
        return this.set(this.x * f5 + this.y * f4, -this.x * f4 + this.y * f5, this.z * f5 + this.w * f4, -this.z * f4 + this.w * f5);
    }

    public final Quaternion rotateByEuler(float[] fArray) {
        return this.rotateByEuler(fArray[0], fArray[1], fArray[2]);
    }

    public final Quaternion rotateByEuler(float f2, float f3, float f4) {
        if (VectorUtil.isZero(f2, f3, f4, 1.1920929E-7f)) {
            return this;
        }
        return this.rotateByAngleY(f3).rotateByAngleZ(f4).rotateByAngleX(f2).normalize();
    }

    public final float[] rotateVector(float[] fArray, int n2, float[] fArray2, int n3) {
        if (VectorUtil.isVec3Zero(fArray2, n3, 1.1920929E-7f)) {
            fArray[0 + n2] = 0.0f;
            fArray[1 + n2] = 0.0f;
            fArray[2 + n2] = 0.0f;
        } else {
            float f2 = fArray2[0 + n3];
            float f3 = fArray2[1 + n3];
            float f4 = fArray2[2 + n3];
            float f5 = this.x * this.x;
            float f6 = this.y * this.y;
            float f7 = this.z * this.z;
            float f8 = this.w * this.w;
            fArray[0 + n2] = f8 * f2 + f5 * f2 - f7 * f2 - f6 * f2 + 2.0f * (this.y * this.w * f4 - this.z * this.w * f3 + this.y * this.x * f3 + this.z * this.x * f4);
            fArray[1 + n2] = f6 * f3 - f7 * f3 + f8 * f3 - f5 * f3 + 2.0f * (this.x * this.y * f2 + this.z * this.y * f4 + this.w * this.z * f2 - this.x * this.w * f4);
            fArray[2 + n2] = f7 * f4 - f6 * f4 - f5 * f4 + f8 * f4 + 2.0f * (this.x * this.z * f2 + this.y * this.z * f3 - this.w * this.y * f2 + this.w * this.x * f3);
        }
        return fArray;
    }

    public final Quaternion setSlerp(Quaternion quaternion, Quaternion quaternion2, float f2) {
        if (f2 == 0.0f) {
            this.set(quaternion);
        } else if (f2 == 1.0f) {
            this.set(quaternion2);
        } else {
            float f3;
            float f4;
            float f5 = quaternion2.x;
            float f6 = quaternion2.y;
            float f7 = quaternion2.z;
            float f8 = quaternion2.w;
            float f9 = quaternion.x * f5 + quaternion.y * f6 + quaternion.z * f7 + quaternion.w * f8;
            if (f9 >= 0.95f) {
                f4 = 1.0f - f2;
                f3 = f2;
            } else if (f9 <= -0.99f) {
                f4 = 0.5f;
                f3 = 0.5f;
            } else {
                if (f9 <= -1.1920929E-7f) {
                    f5 *= -1.0f;
                    f6 *= -1.0f;
                    f7 *= -1.0f;
                    f8 *= -1.0f;
                    f9 *= -1.0f;
                }
                float f10 = FloatUtil.acos(f9);
                float f11 = FloatUtil.sqrt(1.0f - f9 * f9);
                if (Math.abs(f11) < 0.001f) {
                    f4 = 0.5f;
                    f3 = 0.5f;
                } else {
                    f4 = FloatUtil.sin((1.0f - f2) * f10) / f11;
                    f3 = FloatUtil.sin(f2 * f10) / f11;
                }
            }
            this.x = quaternion.x * f4 + f5 * f3;
            this.y = quaternion.y * f4 + f6 * f3;
            this.z = quaternion.z * f4 + f7 * f3;
            this.w = quaternion.w * f4 + f8 * f3;
        }
        return this;
    }

    public Quaternion setLookAt(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        VectorUtil.normalizeVec3(fArray5, fArray);
        VectorUtil.normalizeVec3(fArray4, fArray2);
        VectorUtil.crossVec3(fArray3, fArray4, fArray5);
        VectorUtil.normalizeVec3(fArray3);
        VectorUtil.crossVec3(fArray4, fArray5, fArray3);
        VectorUtil.normalizeVec3(fArray4);
        return this.setFromAxes(fArray3, fArray4, fArray5).normalize();
    }

    public final Quaternion setFromVectors(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f2 = VectorUtil.normVec3(fArray) * VectorUtil.normVec3(fArray2);
        if (FloatUtil.isZero(f2, 1.1920929E-7f)) {
            return this.setIdentity();
        }
        float f3 = VectorUtil.dotVec3(fArray, fArray2) / f2;
        float f4 = FloatUtil.acos(Math.max(-1.0f, Math.min(f3, 1.0f)));
        VectorUtil.crossVec3(fArray3, fArray, fArray2);
        if (f3 < 0.0f && FloatUtil.isZero(VectorUtil.normVec3(fArray3), 1.1920929E-7f)) {
            int n2 = Math.abs(fArray[0]) > Math.abs(fArray[1]) ? (Math.abs(fArray[0]) > Math.abs(fArray[2]) ? 0 : 2) : (Math.abs(fArray[1]) > Math.abs(fArray[2]) ? 1 : 2);
            fArray3[n2] = -fArray[(n2 + 1) % 3];
            fArray3[(n2 + 1) % 3] = fArray[n2];
            fArray3[(n2 + 2) % 3] = 0.0f;
        }
        return this.setFromAngleAxis(f4, fArray3, fArray4);
    }

    public final Quaternion setFromNormalVectors(float[] fArray, float[] fArray2, float[] fArray3) {
        float f2 = VectorUtil.normVec3(fArray) * VectorUtil.normVec3(fArray2);
        if (FloatUtil.isZero(f2, 1.1920929E-7f)) {
            return this.setIdentity();
        }
        float f3 = VectorUtil.dotVec3(fArray, fArray2) / f2;
        float f4 = FloatUtil.acos(Math.max(-1.0f, Math.min(f3, 1.0f)));
        VectorUtil.crossVec3(fArray3, fArray, fArray2);
        if (f3 < 0.0f && FloatUtil.isZero(VectorUtil.normVec3(fArray3), 1.1920929E-7f)) {
            int n2 = Math.abs(fArray[0]) > Math.abs(fArray[1]) ? (Math.abs(fArray[0]) > Math.abs(fArray[2]) ? 0 : 2) : (Math.abs(fArray[1]) > Math.abs(fArray[2]) ? 1 : 2);
            fArray3[n2] = -fArray[(n2 + 1) % 3];
            fArray3[(n2 + 1) % 3] = fArray[n2];
            fArray3[(n2 + 2) % 3] = 0.0f;
        }
        return this.setFromAngleNormalAxis(f4, fArray3);
    }

    public final Quaternion setFromAngleAxis(float f2, float[] fArray, float[] fArray2) {
        VectorUtil.normalizeVec3(fArray2, fArray);
        return this.setFromAngleNormalAxis(f2, fArray2);
    }

    public final Quaternion setFromAngleNormalAxis(float f2, float[] fArray) {
        if (VectorUtil.isVec3Zero(fArray, 0, 1.1920929E-7f)) {
            this.setIdentity();
        } else {
            float f3 = f2 * 0.5f;
            float f4 = FloatUtil.sin(f3);
            this.x = fArray[0] * f4;
            this.y = fArray[1] * f4;
            this.z = fArray[2] * f4;
            this.w = FloatUtil.cos(f3);
        }
        return this;
    }

    public final float toAngleAxis(float[] fArray) {
        float f2;
        float f3 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (FloatUtil.isZero(f3, 1.1920929E-7f)) {
            f2 = 0.0f;
            fArray[0] = 1.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        } else {
            f2 = FloatUtil.acos(this.w) * 2.0f;
            float f4 = 1.0f / FloatUtil.sqrt(f3);
            fArray[0] = this.x * f4;
            fArray[1] = this.y * f4;
            fArray[2] = this.z * f4;
        }
        return f2;
    }

    public final Quaternion setFromEuler(float[] fArray) {
        return this.setFromEuler(fArray[0], fArray[1], fArray[2]);
    }

    public final Quaternion setFromEuler(float f2, float f3, float f4) {
        if (VectorUtil.isZero(f2, f3, f4, 1.1920929E-7f)) {
            return this.setIdentity();
        }
        float f5 = f3 * 0.5f;
        float f6 = FloatUtil.sin(f5);
        float f7 = FloatUtil.cos(f5);
        f5 = f4 * 0.5f;
        float f8 = FloatUtil.sin(f5);
        float f9 = FloatUtil.cos(f5);
        f5 = f2 * 0.5f;
        float f10 = FloatUtil.sin(f5);
        float f11 = FloatUtil.cos(f5);
        float f12 = f7 * f9;
        float f13 = f6 * f8;
        float f14 = f7 * f8;
        float f15 = f6 * f9;
        this.w = f12 * f11 - f13 * f10;
        this.x = f12 * f10 + f13 * f11;
        this.y = f15 * f11 + f14 * f10;
        this.z = f14 * f11 - f15 * f10;
        return this.normalize();
    }

    public float[] toEuler(float[] fArray) {
        float f2 = this.x * this.y + this.z * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.w * this.w;
        float f7 = f3 + f4 + f5 + f6;
        if (f2 > 0.499f * f7) {
            fArray[0] = 0.0f;
            fArray[1] = 2.0f * FloatUtil.atan2(this.x, this.w);
            fArray[2] = 1.5707964f;
        } else if (f2 < -0.499f * f7) {
            fArray[0] = 0.0f;
            fArray[1] = -2.0f * FloatUtil.atan2(this.x, this.w);
            fArray[2] = -1.5707964f;
        } else {
            fArray[0] = FloatUtil.atan2(2.0f * this.x * this.w - 2.0f * this.y * this.z, -f3 + f4 - f5 + f6);
            fArray[1] = FloatUtil.atan2(2.0f * this.y * this.w - 2.0f * this.x * this.z, f3 - f4 - f5 + f6);
            fArray[2] = FloatUtil.asin(2.0f * f2 / f7);
        }
        return fArray;
    }

    public final Quaternion setFromMatrix(float[] fArray, int n2) {
        return this.setFromMatrix(fArray[0 + n2], fArray[4 + n2], fArray[8 + n2], fArray[1 + n2], fArray[5 + n2], fArray[9 + n2], fArray[2 + n2], fArray[6 + n2], fArray[10 + n2]);
    }

    public Quaternion setFromMatrix(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f2 + f6 + f10 + 1.0f;
        if (f11 > 0.0f) {
            float f12 = 0.5f / FloatUtil.sqrt(f11);
            this.w = 0.25f / f12;
            this.x = (f9 - f7) * f12;
            this.y = (f4 - f8) * f12;
            this.z = (f5 - f3) * f12;
        } else if (f2 > f6 && f2 > f10) {
            float f13 = 0.5f / FloatUtil.sqrt(1.0f + f2 - f6 - f10);
            this.w = (f9 - f7) * f13;
            this.x = 0.25f / f13;
            this.y = (f5 + f3) * f13;
            this.z = (f4 + f8) * f13;
        } else if (f6 > f10) {
            float f14 = 0.5f / FloatUtil.sqrt(1.0f + f6 - f2 - f10);
            this.w = (f4 - f8) * f14;
            this.x = (f8 + f3) * f14;
            this.y = 0.25f / f14;
            this.z = (f9 + f7) * f14;
        } else {
            float f15 = 0.5f / FloatUtil.sqrt(1.0f + f10 - f2 - f6);
            this.w = (f5 - f3) * f15;
            this.x = (f4 + f8) * f15;
            this.y = (f9 + f7) * f15;
            this.z = 0.25f / f15;
        }
        return this;
    }

    public final float[] toMatrix(float[] fArray, int n2) {
        float f2 = this.magnitudeSquared();
        if (FloatUtil.isZero(f2, 1.1920929E-7f)) {
            return FloatUtil.makeIdentity(fArray, n2);
        }
        float f3 = FloatUtil.isEqual(1.0f, f2, 1.1920929E-7f) ? 2.0f : 2.0f / f2;
        float f4 = f3 * this.x;
        float f5 = f3 * this.y;
        float f6 = f3 * this.z;
        float f7 = this.x * f4;
        float f8 = this.x * f5;
        float f9 = this.x * f6;
        float f10 = f4 * this.w;
        float f11 = this.y * f5;
        float f12 = this.y * f6;
        float f13 = f5 * this.w;
        float f14 = this.z * f6;
        float f15 = f6 * this.w;
        fArray[0 + n2] = 1.0f - (f11 + f14);
        fArray[4 + n2] = f8 - f15;
        fArray[8 + n2] = f9 + f13;
        fArray[12 + n2] = 0.0f;
        fArray[1 + n2] = f8 + f15;
        fArray[5 + n2] = 1.0f - (f7 + f14);
        fArray[9 + n2] = f12 - f10;
        fArray[13 + n2] = 0.0f;
        fArray[2 + n2] = f9 - f13;
        fArray[6 + n2] = f12 + f10;
        fArray[10 + n2] = 1.0f - (f7 + f11);
        fArray[14 + n2] = 0.0f;
        fArray[3 + n2] = 0.0f;
        fArray[7 + n2] = 0.0f;
        fArray[11 + n2] = 0.0f;
        fArray[15 + n2] = 1.0f;
        return fArray;
    }

    public float[] copyMatrixColumn(int n2, float[] fArray, int n3) {
        float f2 = this.magnitudeSquared();
        float f3 = FloatUtil.isZero(f2, 1.1920929E-7f) ? 0.0f : (FloatUtil.isEqual(1.0f, f2, 1.1920929E-7f) ? 2.0f : 2.0f / f2);
        float f4 = this.x * f3;
        float f5 = this.y * f3;
        float f6 = this.z * f3;
        float f7 = this.x * f4;
        float f8 = this.x * f5;
        float f9 = this.x * f6;
        float f10 = this.w * f4;
        float f11 = this.y * f5;
        float f12 = this.y * f6;
        float f13 = this.w * f5;
        float f14 = this.z * f6;
        float f15 = this.w * f6;
        switch (n2) {
            case 0: {
                fArray[0 + n3] = 1.0f - (f11 + f14);
                fArray[1 + n3] = f8 + f15;
                fArray[2 + n3] = f9 - f13;
                break;
            }
            case 1: {
                fArray[0 + n3] = f8 - f15;
                fArray[1 + n3] = 1.0f - (f7 + f14);
                fArray[2 + n3] = f12 + f10;
                break;
            }
            case 2: {
                fArray[0 + n3] = f9 + f13;
                fArray[1 + n3] = f12 - f10;
                fArray[2 + n3] = 1.0f - (f7 + f11);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index. " + n2);
            }
        }
        return fArray;
    }

    public final Quaternion setFromAxes(float[] fArray, float[] fArray2, float[] fArray3) {
        return this.setFromMatrix(fArray[0], fArray2[0], fArray3[0], fArray[1], fArray2[1], fArray3[1], fArray[2], fArray2[2], fArray3[2]);
    }

    public void toAxes(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.toMatrix(fArray4, 0);
        FloatUtil.copyMatrixColumn(fArray4, 0, 2, fArray3, 0);
        FloatUtil.copyMatrixColumn(fArray4, 0, 1, fArray2, 0);
        FloatUtil.copyMatrixColumn(fArray4, 0, 0, fArray, 0);
    }

    public final boolean isRotationMatrix3f(float[] fArray) {
        if (FloatUtil.abs(fArray[0] * fArray[3] + fArray[3] * fArray[4] + fArray[6] * fArray[7]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[0] * fArray[2] + fArray[3] * fArray[5] + fArray[6] * fArray[8]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[1] * fArray[2] + fArray[4] * fArray[5] + fArray[7] * fArray[8]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[0] * fArray[0] + fArray[3] * fArray[3] + fArray[6] * fArray[6] - 1.0f) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[1] * fArray[1] + fArray[4] * fArray[4] + fArray[7] * fArray[7] - 1.0f) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[2] * fArray[2] + fArray[5] * fArray[5] + fArray[8] * fArray[8] - 1.0f) > 0.01f) {
            return false;
        }
        return FloatUtil.abs(this.determinant3f(fArray) - 1.0f) < 0.01f;
    }

    private final float determinant3f(float[] fArray) {
        return fArray[0] * fArray[4] * fArray[8] + fArray[3] * fArray[7] * fArray[2] + fArray[6] * fArray[1] * fArray[5] - fArray[0] * fArray[7] * fArray[5] - fArray[3] * fArray[1] * fArray[8] - fArray[6] * fArray[4] * fArray[2];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        return Math.abs(this.x - quaternion.getX()) <= 1.0E-6f && Math.abs(this.y - quaternion.getY()) <= 1.0E-6f && Math.abs(this.z - quaternion.getZ()) <= 1.0E-6f && Math.abs(this.w - quaternion.getW()) <= 1.0E-6f;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public String toString() {
        return "Quaternion[x " + this.x + ", y " + this.y + ", z " + this.z + ", w " + this.w + "]";
    }
}

