/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.Binary32;
import com.jogamp.opengl.math.Binary64;

public final class Binary16 {
    public static final char NEGATIVE_INFINITY = (char)64512;
    public static final char POSITIVE_INFINITY = (char)31744;
    public static final char POSITIVE_ZERO = '\u0000';
    public static final char NEGATIVE_ZERO = (char)32768;
    public static final int BIAS = 15;
    private static final int MASK_SIGN = 32768;
    private static final int MASK_EXPONENT = 31744;
    private static final int MASK_SIGNIFICAND = 1023;

    public static char exampleNaN() {
        int n2 = Binary16.packSetExponentUnbiasedUnchecked(16) | Binary16.packSetSignificandUnchecked(1);
        char c2 = (char)n2;
        return c2;
    }

    public static boolean isInfinite(char c2) {
        return Binary16.unpackGetExponentUnbiased(c2) == 16 && Binary16.unpackGetSignificand(c2) == 0;
    }

    public static boolean isNaN(char c2) {
        int n2 = Binary16.unpackGetExponentUnbiased(c2);
        int n3 = Binary16.unpackGetSignificand(c2);
        return n2 == 16 && n3 > 0;
    }

    public static char packDouble(double d2) {
        if (Double.isNaN(d2)) {
            return Binary16.exampleNaN();
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Double.doubleToLongBits(d2) == Binary64.NEGATIVE_ZERO_BITS) {
            return NEGATIVE_ZERO;
        }
        if (d2 == 0.0) {
            return POSITIVE_ZERO;
        }
        long l2 = Binary64.unpackGetExponentUnbiased(d2);
        long l3 = Binary64.unpackGetSign(d2);
        long l4 = Binary64.unpackGetSignificand(d2);
        char c2 = Binary16.packSetSignUnchecked((int)l3);
        int n2 = (int)(l2 & 0x1FL);
        char c3 = Binary16.packSetExponentUnbiasedUnchecked(n2);
        long l5 = l4 & 0xFFC0000000000L;
        long l6 = l5 >> 42;
        char c4 = Binary16.packSetSignificandUnchecked((int)l6);
        return (char)(c2 | c3 | c4);
    }

    public static char packFloat(float f2) {
        if (Float.isNaN(f2)) {
            return Binary16.exampleNaN();
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Float.floatToIntBits(f2) == Binary32.NEGATIVE_ZERO_BITS) {
            return NEGATIVE_ZERO;
        }
        if ((double)f2 == 0.0) {
            return POSITIVE_ZERO;
        }
        long l2 = Binary32.unpackGetExponentUnbiased(f2);
        long l3 = Binary32.unpackGetSign(f2);
        long l4 = Binary32.unpackGetSignificand(f2);
        char c2 = Binary16.packSetSignUnchecked((int)l3);
        int n2 = (int)(l2 & 0x1FL);
        char c3 = Binary16.packSetExponentUnbiasedUnchecked(n2);
        long l5 = l4 & 0x7FE000L;
        long l6 = l5 >> 13;
        char c4 = Binary16.packSetSignificandUnchecked((int)l6);
        return (char)(c2 | c3 | c4);
    }

    public static char packSetExponentUnbiasedUnchecked(int n2) {
        int n3 = n2 + BIAS;
        int n4 = n3 << 10;
        int n5 = n4 & MASK_EXPONENT;
        return (char)n5;
    }

    public static char packSetSignificandUnchecked(int n2) {
        int n3 = n2 & MASK_SIGNIFICAND;
        return (char)n3;
    }

    public static char packSetSignUnchecked(int n2) {
        int n3 = n2 << 15;
        int n4 = n3 & MASK_SIGN;
        return (char)n4;
    }

    public static String toRawBinaryString(char n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n2;
        for (int i2 = 0; i2 < 16; ++i2) {
            if ((n3 & '\u0001') == 1) {
                stringBuilder.insert(0, "1");
            } else {
                stringBuilder.insert(0, "0");
            }
            n3 >>= 1;
        }
        return stringBuilder.toString();
    }

    public static double unpackDouble(char c2) {
        if (Binary16.isNaN(c2)) {
            return Double.NaN;
        }
        if (c2 == POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (c2 == NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (c2 == NEGATIVE_ZERO) {
            return -0.0;
        }
        if (c2 == POSITIVE_ZERO) {
            return 0.0;
        }
        long l2 = Binary16.unpackGetExponentUnbiased(c2);
        long l3 = Binary16.unpackGetSign(c2);
        long l4 = Binary16.unpackGetSignificand(c2);
        long l5 = l3 << 63;
        long l6 = l2 + Binary64.BIAS;
        long l7 = l6 << 52;
        long l8 = l4 << 42;
        return Double.longBitsToDouble(l5 | l7 | l8);
    }

    public static float unpackFloat(char c2) {
        if (Binary16.isNaN(c2)) {
            return Float.NaN;
        }
        if (c2 == POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        if (c2 == NEGATIVE_INFINITY) {
            return Float.NEGATIVE_INFINITY;
        }
        if (c2 == NEGATIVE_ZERO) {
            return -0.0f;
        }
        if (c2 == POSITIVE_ZERO) {
            return 0.0f;
        }
        int n2 = Binary16.unpackGetExponentUnbiased(c2);
        int n3 = Binary16.unpackGetSign(c2);
        int n4 = Binary16.unpackGetSignificand(c2);
        int n5 = n3 << 31;
        int n6 = n2 + Binary32.BIAS;
        int n7 = n6 << 23;
        int n8 = n4 << 13;
        return Float.intBitsToFloat(n5 | n7 | n8);
    }

    public static int unpackGetExponentUnbiased(char c2) {
        int n2 = c2 & MASK_EXPONENT;
        int n3 = n2 >> 10;
        return n3 - BIAS;
    }

    public static int unpackGetSign(char c2) {
        return (c2 & MASK_SIGN) >> 15;
    }

    public static int unpackGetSignificand(char c2) {
        return c2 & MASK_SIGNIFICAND;
    }

    private Binary16() {
        throw new AssertionError((Object)"Unreachable code, report this bug!");
    }
}

