/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;

public class GLRendererQuirks {
    public static final int NoDoubleBufferedPBuffer = 0;
    public static final int NoDoubleBufferedBitmap = 1;
    public static final int NoSetSwapInterval = 2;
    public static final int NoOffscreenBitmap = 3;
    public static final int NoSetSwapIntervalPostRetarget = 4;
    public static final int GLSLBuggyDiscard = 5;
    public static final int GL3CompatNonCompliant = 6;
    public static final int GLFlushBeforeRelease = 7;
    public static final int DontCloseX11Display = 8;
    public static final int NeedCurrCtx4ARBPixFmtQueries = 9;
    public static final int NeedCurrCtx4ARBCreateContext = 10;
    public static final int NoFullFBOSupport = 11;
    public static final int GLSLNonCompliant = 12;
    public static final int GL4NeedsGL3Request = 13;
    public static final int GLSharedContextBuggy = 14;
    public static final int GLES3ViaEGLES2Config = 15;
    public static final int SingletonEGLDisplayOnly = 16;
    public static final int NoMultiSamplingBuffers = 17;
    public static final int BuggyColorRenderbuffer = 18;
    public static final int NoPBufferWithAccum = 19;
    public static final int NeedSharedObjectSync = 20;
    public static final int NoARBCreateContext = 21;
    public static final int NoSurfacelessCtx = 22;
    public static final int NoFBOSupport = 23;
    public static final int DontChooseFBConfigBestMatch = 24;
    public static final int No10BitColorCompOffscreen = 25;
    private static final String[] _names;
    private static final IdentityHashMap<String, GLRendererQuirks> stickyDeviceQuirks;
    private static int _bitmaskOverrideForce;
    private static int _bitmaskOverrideIgnore;
    private int _bitmask = 0;

    public static final int getCount() {
        return 26;
    }

    public static GLRendererQuirks getStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLRendererQuirks gLRendererQuirks;
        String string = abstractGraphicsDevice.getUniqueID();
        GLRendererQuirks gLRendererQuirks2 = stickyDeviceQuirks.get(string);
        if (null == gLRendererQuirks2) {
            gLRendererQuirks = new GLRendererQuirks();
            stickyDeviceQuirks.put(string, gLRendererQuirks);
        } else {
            gLRendererQuirks = gLRendererQuirks2;
        }
        return gLRendererQuirks;
    }

    public static boolean areSameStickyDevice(AbstractGraphicsDevice abstractGraphicsDevice, AbstractGraphicsDevice abstractGraphicsDevice2) {
        return abstractGraphicsDevice.getUniqueID() == abstractGraphicsDevice2.getUniqueID();
    }

    public static void addStickyDeviceQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n2) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks.addQuirk(n2);
    }

    public static void addStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks2 = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks2.addQuirks(gLRendererQuirks);
    }

    public static boolean existStickyDeviceQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n2) {
        return GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice).exist(n2);
    }

    public static void pushStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks) {
        gLRendererQuirks.addQuirks(GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice));
    }

    public static final Override getOverride(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        if (0 != (1 << n2 & _bitmaskOverrideForce)) {
            return Override.FORCE;
        }
        if (0 != (1 << n2 & _bitmaskOverrideIgnore)) {
            return Override.IGNORE;
        }
        return Override.NONE;
    }

    private static int _queryQuirkMaskOfPropertyList(String string, Override override) {
        String string2 = PropertyAccess.getProperty(string, true);
        if (null == string2) {
            return 0;
        }
        int n2 = 0;
        String[] stringArray = string2.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2].trim();
            try {
                Field field = GLRendererQuirks.class.getField(string3);
                int n3 = field.getInt(null);
                Override override2 = GLRendererQuirks.getOverride(n3);
                if (Override.NONE != override2) {
                    System.err.println("Warning: Quirk '" + string3 + "' bit " + n3 + " skipped for override " + (Object)((Object)override) + " mask, already set for override " + (Object)((Object)override2) + ". Has been included in given property " + string);
                    continue;
                }
                n2 |= 1 << n3;
                System.err.println("Info: Quirk '" + string3 + "' bit " + n3 + " has been added to Override." + (Object)((Object)override) + " mask as included in given property " + string);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.err.println("Warning: Failed to match given property " + string + "'s quirk '" + string3 + "' with any supported quirk! " + noSuchFieldException.getMessage());
                continue;
            }
            catch (IllegalAccessException | SecurityException exception) {
                System.err.println("Warning: Failed to access given property " + string + "'s quirk '" + string3 + "' bit value! " + exception.getMessage());
            }
        }
        return n2;
    }

    public final void addQuirk(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        this._bitmask |= 1 << n2;
    }

    public final void addQuirks(GLRendererQuirks gLRendererQuirks) {
        this._bitmask |= gLRendererQuirks._bitmask;
    }

    public final boolean exist(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        return 0 != (1 << n2 & (~_bitmaskOverrideIgnore & (this._bitmask | _bitmaskOverrideForce)));
    }

    public static boolean exist(GLRendererQuirks gLRendererQuirks, int n2) throws IllegalArgumentException {
        return null != gLRendererQuirks && gLRendererQuirks.exist(n2);
    }

    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        boolean bl = true;
        for (int i2 = 0; i2 < GLRendererQuirks.getCount(); ++i2) {
            if (0 == (1 << i2 & (this._bitmask | _bitmaskOverrideForce))) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(GLRendererQuirks.toString(i2));
            Override override = GLRendererQuirks.getOverride(i2);
            if (Override.NONE != override) {
                stringBuilder.append("(").append(override.name().toLowerCase()).append("d)");
            }
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public final String toString() {
        return this.toString(null).toString();
    }

    public static void validateQuirk(int n2) throws IllegalArgumentException {
        if (0 > n2 || n2 >= GLRendererQuirks.getCount()) {
            throw new IllegalArgumentException("Quirks must be in range [0.." + GLRendererQuirks.getCount() + "[, but quirk: " + n2);
        }
    }

    public static final String toString(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        return _names[n2];
    }

    static {
        int n2;
        _names = new String[]{"NoDoubleBufferedPBuffer", "NoDoubleBufferedBitmap", "NoSetSwapInterval", "NoOffscreenBitmap", "NoSetSwapIntervalPostRetarget", "GLSLBuggyDiscard", "GL3CompatNonCompliant", "GLFlushBeforeRelease", "DontCloseX11Display", "NeedCurrCtx4ARBPixFmtQueries", "NeedCurrCtx4ARBCreateContext", "NoFullFBOSupport", "GLSLNonCompliant", "GL4NeedsGL3Request", "GLSharedContextBuggy", "GLES3ViaEGLES2Config", "SingletonEGLDisplayOnly", "NoMultiSamplingBuffers", "BuggyColorRenderbuffer", "NoPBufferWithAccum", "NeedSharedObjectSync", "NoARBCreateContext", "NoSurfacelessCtx", "NoFBOSupport", "DontChooseFBConfigBestMatch", "No10BitColorCompOffscreen"};
        stickyDeviceQuirks = new IdentityHashMap();
        _bitmaskOverrideForce = 0;
        _bitmaskOverrideIgnore = 0;
        _bitmaskOverrideForce = GLRendererQuirks._queryQuirkMaskOfPropertyList("jogl.quirks.force", Override.FORCE);
        _bitmaskOverrideIgnore = GLRendererQuirks._queryQuirkMaskOfPropertyList("jogl.quirks.ignore", Override.IGNORE);
        if (0 != (_bitmaskOverrideForce & 0x12)) {
            _bitmaskOverrideForce |= 0xB;
        }
        if (0 != (n2 = _bitmaskOverrideForce & _bitmaskOverrideIgnore)) {
            throw new InternalError("Override properties force 0x" + Integer.toHexString(_bitmaskOverrideForce) + " and ignore 0x" + Integer.toHexString(_bitmaskOverrideIgnore) + " have intersecting bits 0x" + Integer.toHexString(n2) + " " + Integer.toBinaryString(n2));
        }
    }

    public static enum Override {
        NONE,
        FORCE,
        IGNORE;

    }
}

