/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.GLContext;

public class GLDebugMessage {
    final GLContext source;
    final long when;
    final int dbgSource;
    final int dbgType;
    final int dbgId;
    final int dbgSeverity;
    final String dbgMsg;

    public GLDebugMessage(GLContext gLContext, long l2, int n2, int n3, int n4, int n5, String string) {
        this.source = gLContext;
        this.when = l2;
        this.dbgSource = n2;
        this.dbgType = n3;
        this.dbgId = n4;
        this.dbgSeverity = n5;
        this.dbgMsg = string;
    }

    public static GLDebugMessage translateAMDEvent(GLContext gLContext, long l2, int n2, int n3, int n4, String string) {
        int n5;
        int n6;
        switch (n3) {
            case 37193: {
                n6 = 33350;
                n5 = 33356;
                break;
            }
            case 37194: {
                n6 = 33351;
                n5 = 33361;
                break;
            }
            case 37198: {
                n6 = 33352;
                n5 = 33361;
                break;
            }
            case 37199: {
                n6 = 33354;
                n5 = 33361;
                break;
            }
            case 37195: {
                n6 = 33355;
                n5 = 33357;
                break;
            }
            case 37196: {
                n6 = 33355;
                n5 = 33358;
                break;
            }
            case 37197: {
                n6 = 33355;
                n5 = 33360;
                break;
            }
            default: {
                n6 = 33355;
                n5 = 33361;
            }
        }
        return new GLDebugMessage(gLContext, l2, n6, n5, n2, n4, string);
    }

    public static int translateARB2AMDCategory(int n2, int n3) {
        switch (n2) {
            case 33351: {
                return 37194;
            }
            case 33352: {
                return 37198;
            }
            case 33354: {
                return 37199;
            }
        }
        switch (n3) {
            case 33357: {
                return 37195;
            }
            case 33358: {
                return 37196;
            }
            case 33360: {
                return 37197;
            }
        }
        return 37200;
    }

    public GLContext getSource() {
        return this.source;
    }

    public long getWhen() {
        return this.when;
    }

    public int getDbgSource() {
        return this.dbgSource;
    }

    public int getDbgType() {
        return this.dbgType;
    }

    public int getDbgId() {
        return this.dbgId;
    }

    public int getDbgSeverity() {
        return this.dbgSeverity;
    }

    public String getDbgMsg() {
        return this.dbgMsg;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        String string = Platform.getNewline() + "\t";
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("GLDebugEvent[ id ");
        GLDebugMessage.toHexString(stringBuilder, this.dbgId).append(string).append("type ").append(GLDebugMessage.getDbgTypeString(this.dbgType)).append(string).append("severity ").append(GLDebugMessage.getDbgSeverityString(this.dbgSeverity)).append(string).append("source ").append(GLDebugMessage.getDbgSourceString(this.dbgSource)).append(string).append("msg ").append(this.dbgMsg).append(string).append("when ").append(this.when);
        if (null != this.source) {
            stringBuilder.append(string).append("source ").append(this.source.getGLVersion()).append(" - hash 0x").append(Integer.toHexString(this.source.hashCode()));
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public static String getDbgSourceString(int n2) {
        switch (n2) {
            case 33350: {
                return "GL API";
            }
            case 33352: {
                return "GLSL or extension compiler";
            }
            case 33351: {
                return "Native Windowing binding";
            }
            case 33353: {
                return "Third party";
            }
            case 33354: {
                return "Application";
            }
            case 33355: {
                return "generic";
            }
        }
        return "Unknown (" + GLDebugMessage.toHexString(n2) + ")";
    }

    public static String getDbgTypeString(int n2) {
        switch (n2) {
            case 33356: {
                return "Error";
            }
            case 33357: {
                return "Warning: marked for deprecation";
            }
            case 33358: {
                return "Warning: undefined behavior";
            }
            case 33360: {
                return "Warning: implementation dependent performance";
            }
            case 33359: {
                return "Warning: vendor-specific extension use";
            }
            case 33361: {
                return "Warning: generic";
            }
        }
        return "Unknown (" + GLDebugMessage.toHexString(n2) + ")";
    }

    public static String getDbgSeverityString(int n2) {
        switch (n2) {
            case 37190: {
                return "High: dangerous undefined behavior";
            }
            case 37191: {
                return "Medium: Severe performance/deprecation/other warnings";
            }
            case 37192: {
                return "Low: Performance warnings (redundancy/undefined)";
            }
        }
        return "Unknown (" + GLDebugMessage.toHexString(n2) + ")";
    }

    public static StringBuilder toHexString(StringBuilder stringBuilder, int n2) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        return stringBuilder.append("0x").append(Integer.toHexString(n2));
    }

    public static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }
}

