/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.llb.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.util.LongLongHashMap;
import com.jogamp.opencl.CLErrorHandler;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.llb.CL20;
import com.jogamp.opencl.llb.impl.BuildProgramCallback;
import com.jogamp.opencl.llb.impl.CLDynamicLibraryBundleInfo;
import com.jogamp.opencl.llb.impl.CLEventCallback;
import com.jogamp.opencl.llb.impl.CLImageDescImpl;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import com.jogamp.opencl.llb.impl.CLMemObjectDestructorCallback;
import com.jogamp.opencl.llb.impl.CLProcAddressTable20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CLImpl20
implements CL20 {
    protected static final CLProcAddressTable20 addressTable = new CLProcAddressTable20();
    static final DynamicLibraryBundle dynamicLookupHelper = AccessController.doPrivileged(new PrivilegedAction<DynamicLibraryBundle>(){

        @Override
        public DynamicLibraryBundle run() {
            DynamicLibraryBundle dynamicLibraryBundle = new DynamicLibraryBundle(new CLDynamicLibraryBundleInfo());
            if (!dynamicLibraryBundle.isToolLibLoaded()) {
                return null;
            }
            if (!dynamicLibraryBundle.isLibComplete()) {
                System.err.println("Couln't load native CL/JNI glue library");
                return null;
            }
            addressTable.reset(dynamicLibraryBundle);
            return dynamicLibraryBundle;
        }
    });
    private final LongLongHashMap contextCallbackMap = new LongLongHashMap();

    @Override
    public int clGetPlatformIDs(int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"platforms\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"num_platforms\" is not a direct buffer");
        }
        long l2 = CLImpl20.addressTable._addressof_clGetPlatformIDs;
        if (l2 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetPlatformIDs"));
        }
        return this.dispatch_clGetPlatformIDs0(n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l2);
    }

    private native int dispatch_clGetPlatformIDs0(int var1, Object var2, int var3, Object var4, int var5, long var6);

    @Override
    public int clGetPlatformInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetPlatformInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetPlatformInfo"));
        }
        return this.dispatch_clGetPlatformInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetPlatformInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clGetDeviceIDs(long l2, long l3, int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"devices\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"num_devices\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetDeviceIDs;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetDeviceIDs"));
        }
        return this.dispatch_clGetDeviceIDs0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l4);
    }

    private native int dispatch_clGetDeviceIDs0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clGetDeviceInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetDeviceInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetDeviceInfo"));
        }
        return this.dispatch_clGetDeviceInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetDeviceInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clCreateSubDevices(long l2, PointerBuffer pointerBuffer, int n2, PointerBuffer pointerBuffer2, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer2);
        boolean bl3 = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateSubDevices;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSubDevices"));
        }
        return this.dispatch_clCreateSubDevices1(l2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, n2, bl2 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl2, bl3 ? intBuffer : Buffers.getArray(intBuffer), bl3 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl3, l3);
    }

    private native int dispatch_clCreateSubDevices1(long var1, Object var3, int var4, boolean var5, int var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public int clCreateSubDevices(long l2, PointerBuffer pointerBuffer, int n2, PointerBuffer pointerBuffer2, int[] nArray, int n3) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer2);
        if (nArray != null && nArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"num_devices_ret_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateSubDevices;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSubDevices"));
        }
        return this.dispatch_clCreateSubDevices1(l2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, n2, bl2 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl2, nArray, 4 * n3, false, l3);
    }

    @Override
    public int clRetainDevice(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainDevice;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainDevice"));
        }
        return this.dispatch_clRetainDevice1(l2, l3);
    }

    private native int dispatch_clRetainDevice1(long var1, long var3);

    @Override
    public int clReleaseDevice(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseDevice;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseDevice"));
        }
        return this.dispatch_clReleaseDevice1(l2, l3);
    }

    private native int dispatch_clReleaseDevice1(long var1, long var3);

    @Override
    public int clRetainContext(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainContext;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainContext"));
        }
        return this.dispatch_clRetainContext1(l2, l3);
    }

    private native int dispatch_clRetainContext1(long var1, long var3);

    @Override
    public int clGetContextInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetContextInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetContextInfo"));
        }
        return this.dispatch_clGetContextInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetContextInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public long clCreateCommandQueueWithProperties(long l2, long l3, LongBuffer longBuffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(longBuffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateCommandQueueWithProperties;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateCommandQueueWithProperties"));
        }
        return this.dispatch_clCreateCommandQueueWithProperties1(l2, l3, bl ? longBuffer : Buffers.getArray(longBuffer), bl ? Buffers.getDirectBufferByteOffset(longBuffer) : Buffers.getIndirectBufferByteOffset(longBuffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l4);
    }

    private native long dispatch_clCreateCommandQueueWithProperties1(long var1, long var3, Object var5, int var6, boolean var7, Object var8, int var9, boolean var10, long var11);

    @Override
    public long clCreateCommandQueueWithProperties(long l2, long l3, long[] lArray, int n2, int[] nArray, int n3) {
        if (lArray != null && lArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"properties_offset\" (" + n2 + ") equals or exceeds array length (" + lArray.length + ")");
        }
        if (nArray != null && nArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateCommandQueueWithProperties;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateCommandQueueWithProperties"));
        }
        return this.dispatch_clCreateCommandQueueWithProperties1(l2, l3, lArray, 8 * n2, false, nArray, 4 * n3, false, l4);
    }

    @Override
    public int clRetainCommandQueue(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainCommandQueue;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainCommandQueue"));
        }
        return this.dispatch_clRetainCommandQueue1(l2, l3);
    }

    private native int dispatch_clRetainCommandQueue1(long var1, long var3);

    @Override
    public int clReleaseCommandQueue(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseCommandQueue;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseCommandQueue"));
        }
        return this.dispatch_clReleaseCommandQueue1(l2, l3);
    }

    private native int dispatch_clReleaseCommandQueue1(long var1, long var3);

    @Override
    public int clGetCommandQueueInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetCommandQueueInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetCommandQueueInfo"));
        }
        return this.dispatch_clGetCommandQueueInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetCommandQueueInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public long clCreateBuffer(long l2, long l3, long l4, Buffer buffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l5 = CLImpl20.addressTable._addressof_clCreateBuffer;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateBuffer"));
        }
        return this.dispatch_clCreateBuffer1(l2, l3, l4, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l5);
    }

    private native long dispatch_clCreateBuffer1(long var1, long var3, long var5, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public long clCreateBuffer(long l2, long l3, long l4, Buffer buffer, int[] nArray, int n2) {
        boolean bl = Buffers.isDirect(buffer);
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l5 = CLImpl20.addressTable._addressof_clCreateBuffer;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateBuffer"));
        }
        return this.dispatch_clCreateBuffer1(l2, l3, l4, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, nArray, 4 * n2, false, l5);
    }

    @Override
    public long clCreateSubBuffer(long l2, long l3, int n2, Buffer buffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateSubBuffer;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSubBuffer"));
        }
        return this.dispatch_clCreateSubBuffer1(l2, l3, n2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l4);
    }

    private native long dispatch_clCreateSubBuffer1(long var1, long var3, int var5, Object var6, int var7, boolean var8, Object var9, int var10, boolean var11, long var12);

    @Override
    public long clCreateSubBuffer(long l2, long l3, int n2, Buffer buffer, int[] nArray, int n3) {
        boolean bl = Buffers.isDirect(buffer);
        if (nArray != null && nArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateSubBuffer;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSubBuffer"));
        }
        return this.dispatch_clCreateSubBuffer1(l2, l3, n2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, nArray, 4 * n3, false, l4);
    }

    @Override
    public long clCreateImage(long l2, long l3, CLImageFormatImpl cLImageFormatImpl, CLImageDescImpl cLImageDescImpl, Buffer buffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateImage;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateImage"));
        }
        return this.dispatch_clCreateImage1(l2, l3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), cLImageDescImpl == null ? null : cLImageDescImpl.getBuffer(), bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l4);
    }

    private native long dispatch_clCreateImage1(long var1, long var3, ByteBuffer var5, ByteBuffer var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public long clCreateImage(long l2, long l3, CLImageFormatImpl cLImageFormatImpl, CLImageDescImpl cLImageDescImpl, Buffer buffer, int[] nArray, int n2) {
        boolean bl = Buffers.isDirect(buffer);
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateImage;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateImage"));
        }
        return this.dispatch_clCreateImage1(l2, l3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), cLImageDescImpl == null ? null : cLImageDescImpl.getBuffer(), bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, nArray, 4 * n2, false, l4);
    }

    @Override
    public long clCreatePipe(long l2, long l3, int n2, int n3, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreatePipe;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreatePipe"));
        }
        return this.dispatch_clCreatePipe1(l2, l3, n2, n3, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l4);
    }

    private native long dispatch_clCreatePipe1(long var1, long var3, int var5, int var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public long clCreatePipe(long l2, long l3, int n2, int n3, PointerBuffer pointerBuffer, int[] nArray, int n4) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        if (nArray != null && nArray.length <= n4) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n4 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreatePipe;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreatePipe"));
        }
        return this.dispatch_clCreatePipe1(l2, l3, n2, n3, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, nArray, 4 * n4, false, l4);
    }

    @Override
    public int clRetainMemObject(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainMemObject;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainMemObject"));
        }
        return this.dispatch_clRetainMemObject1(l2, l3);
    }

    private native int dispatch_clRetainMemObject1(long var1, long var3);

    @Override
    public int clReleaseMemObject(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseMemObject;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseMemObject"));
        }
        return this.dispatch_clReleaseMemObject1(l2, l3);
    }

    private native int dispatch_clReleaseMemObject1(long var1, long var3);

    @Override
    public int clGetSupportedImageFormats(long l2, long l3, int n2, int n3, CLImageFormatImpl cLImageFormatImpl, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clGetSupportedImageFormats;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetSupportedImageFormats"));
        }
        return this.dispatch_clGetSupportedImageFormats1(l2, l3, n2, n3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native int dispatch_clGetSupportedImageFormats1(long var1, long var3, int var5, int var6, ByteBuffer var7, Object var8, int var9, boolean var10, long var11);

    @Override
    public int clGetSupportedImageFormats(long l2, long l3, int n2, int n3, CLImageFormatImpl cLImageFormatImpl, int[] nArray, int n4) {
        if (nArray != null && nArray.length <= n4) {
            throw new IllegalArgumentException("array offset argument \"num_image_formats_offset\" (" + n4 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetSupportedImageFormats;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetSupportedImageFormats"));
        }
        return this.dispatch_clGetSupportedImageFormats1(l2, l3, n2, n3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), nArray, 4 * n4, false, l4);
    }

    @Override
    public int clGetMemObjectInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetMemObjectInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetMemObjectInfo"));
        }
        return this.dispatch_clGetMemObjectInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetMemObjectInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clGetImageInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetImageInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetImageInfo"));
        }
        return this.dispatch_clGetImageInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetImageInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clGetPipeInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        long l4 = CLImpl20.addressTable._addressof_clGetPipeInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetPipeInfo"));
        }
        return this.dispatch_clGetPipeInfo1(l2, n2, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, l4);
    }

    private native int dispatch_clGetPipeInfo1(long var1, int var3, long var4, Object var6, int var7, boolean var8, Object var9, int var10, boolean var11, long var12);

    @Override
    public ByteBuffer clSVMAlloc(long l2, long l3, long l4, int n2) {
        long l5 = CLImpl20.addressTable._addressof_clSVMAlloc;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clSVMAlloc"));
        }
        ByteBuffer byteBuffer = this.dispatch_clSVMAlloc1(l2, l3, l4, n2, l5);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    private native ByteBuffer dispatch_clSVMAlloc1(long var1, long var3, long var5, int var7, long var8);

    @Override
    public void clSVMFree(long l2, Buffer buffer) {
        boolean bl = Buffers.isDirect(buffer);
        long l3 = CLImpl20.addressTable._addressof_clSVMFree;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clSVMFree"));
        }
        this.dispatch_clSVMFree1(l2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, l3);
    }

    private native void dispatch_clSVMFree1(long var1, Object var3, int var4, boolean var5, long var6);

    @Override
    public long clCreateSamplerWithProperties(long l2, LongBuffer longBuffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(longBuffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateSamplerWithProperties;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSamplerWithProperties"));
        }
        return this.dispatch_clCreateSamplerWithProperties1(l2, bl ? longBuffer : Buffers.getArray(longBuffer), bl ? Buffers.getDirectBufferByteOffset(longBuffer) : Buffers.getIndirectBufferByteOffset(longBuffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l3);
    }

    private native long dispatch_clCreateSamplerWithProperties1(long var1, Object var3, int var4, boolean var5, Object var6, int var7, boolean var8, long var9);

    @Override
    public long clCreateSamplerWithProperties(long l2, long[] lArray, int n2, int[] nArray, int n3) {
        if (lArray != null && lArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"normalized_coords_offset\" (" + n2 + ") equals or exceeds array length (" + lArray.length + ")");
        }
        if (nArray != null && nArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateSamplerWithProperties;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSamplerWithProperties"));
        }
        return this.dispatch_clCreateSamplerWithProperties1(l2, lArray, 8 * n2, false, nArray, 4 * n3, false, l3);
    }

    @Override
    public int clRetainSampler(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainSampler;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainSampler"));
        }
        return this.dispatch_clRetainSampler1(l2, l3);
    }

    private native int dispatch_clRetainSampler1(long var1, long var3);

    @Override
    public int clReleaseSampler(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseSampler;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseSampler"));
        }
        return this.dispatch_clReleaseSampler1(l2, l3);
    }

    private native int dispatch_clReleaseSampler1(long var1, long var3);

    @Override
    public int clGetSamplerInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetSamplerInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetSamplerInfo"));
        }
        return this.dispatch_clGetSamplerInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetSamplerInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public long clCreateProgramWithSource(long l2, int n2, String[] stringArray, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"lengths\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"errcode_ret\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateProgramWithSource;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateProgramWithSource"));
        }
        return this.dispatch_clCreateProgramWithSource0(l2, n2, stringArray, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l3);
    }

    private native long dispatch_clCreateProgramWithSource0(long var1, int var3, String[] var4, Object var5, int var6, Object var7, int var8, long var9);

    @Override
    public long clCreateProgramWithBinary(long l2, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"device_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"lengths\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"binaries\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"binary_status\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer2)) {
            throw new IllegalArgumentException("Argument \"errcode_ret\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateProgramWithBinary;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateProgramWithBinary"));
        }
        return this.dispatch_clCreateProgramWithBinary0(l2, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), intBuffer2, Buffers.getDirectBufferByteOffset(intBuffer2), l3);
    }

    private native long dispatch_clCreateProgramWithBinary0(long var1, int var3, Object var4, int var5, Object var6, int var7, Object var8, int var9, Object var10, int var11, Object var12, int var13, long var14);

    @Override
    public long clCreateProgramWithBuiltInKernels(long l2, int n2, PointerBuffer pointerBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(byteBuffer);
        boolean bl3 = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateProgramWithBuiltInKernels;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateProgramWithBuiltInKernels"));
        }
        return this.dispatch_clCreateProgramWithBuiltInKernels1(l2, n2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, bl2 ? byteBuffer : Buffers.getArray(byteBuffer), bl2 ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl2, bl3 ? intBuffer : Buffers.getArray(intBuffer), bl3 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl3, l3);
    }

    private native long dispatch_clCreateProgramWithBuiltInKernels1(long var1, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public long clCreateProgramWithBuiltInKernels(long l2, int n2, PointerBuffer pointerBuffer, byte[] byArray, int n3, int[] nArray, int n4) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        if (byArray != null && byArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"kernel_names_offset\" (" + n3 + ") equals or exceeds array length (" + byArray.length + ")");
        }
        if (nArray != null && nArray.length <= n4) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n4 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateProgramWithBuiltInKernels;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateProgramWithBuiltInKernels"));
        }
        return this.dispatch_clCreateProgramWithBuiltInKernels1(l2, n2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, byArray, n3, false, nArray, 4 * n4, false, l3);
    }

    @Override
    public int clRetainProgram(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainProgram;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainProgram"));
        }
        return this.dispatch_clRetainProgram1(l2, l3);
    }

    private native int dispatch_clRetainProgram1(long var1, long var3);

    @Override
    public int clReleaseProgram(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseProgram;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseProgram"));
        }
        return this.dispatch_clReleaseProgram1(l2, l3);
    }

    private native int dispatch_clReleaseProgram1(long var1, long var3);

    @Override
    public int clUnloadPlatformCompiler(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clUnloadPlatformCompiler;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clUnloadPlatformCompiler"));
        }
        return this.dispatch_clUnloadPlatformCompiler1(l2, l3);
    }

    private native int dispatch_clUnloadPlatformCompiler1(long var1, long var3);

    @Override
    public int clGetProgramInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetProgramInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetProgramInfo"));
        }
        return this.dispatch_clGetProgramInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetProgramInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clGetProgramBuildInfo(long l2, long l3, int n2, long l4, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l5 = CLImpl20.addressTable._addressof_clGetProgramBuildInfo;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetProgramBuildInfo"));
        }
        return this.dispatch_clGetProgramBuildInfo0(l2, l3, n2, l4, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l5);
    }

    private native int dispatch_clGetProgramBuildInfo0(long var1, long var3, int var5, long var6, Object var8, int var9, Object var10, int var11, long var12);

    @Override
    public long clCreateKernel(long l2, String string, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateKernel;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateKernel"));
        }
        return this.dispatch_clCreateKernel1(l2, string, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l3);
    }

    private native long dispatch_clCreateKernel1(long var1, String var3, Object var4, int var5, boolean var6, long var7);

    @Override
    public long clCreateKernel(long l2, String string, int[] nArray, int n2) {
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateKernel;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateKernel"));
        }
        return this.dispatch_clCreateKernel1(l2, string, nArray, 4 * n2, false, l3);
    }

    @Override
    public int clCreateKernelsInProgram(long l2, int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"kernels\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"num_kernels_ret\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateKernelsInProgram;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateKernelsInProgram"));
        }
        return this.dispatch_clCreateKernelsInProgram0(l2, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l3);
    }

    private native int dispatch_clCreateKernelsInProgram0(long var1, int var3, Object var4, int var5, Object var6, int var7, long var8);

    @Override
    public int clRetainKernel(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainKernel;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainKernel"));
        }
        return this.dispatch_clRetainKernel1(l2, l3);
    }

    private native int dispatch_clRetainKernel1(long var1, long var3);

    @Override
    public int clReleaseKernel(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseKernel;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseKernel"));
        }
        return this.dispatch_clReleaseKernel1(l2, l3);
    }

    private native int dispatch_clReleaseKernel1(long var1, long var3);

    @Override
    public int clSetKernelArg(long l2, int n2, long l3, Buffer buffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"arg_value\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clSetKernelArg;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clSetKernelArg"));
        }
        return this.dispatch_clSetKernelArg0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), l4);
    }

    private native int dispatch_clSetKernelArg0(long var1, int var3, long var4, Object var6, int var7, long var8);

    @Override
    public int clSetKernelArgSVMPointer(long l2, int n2, Buffer buffer) {
        boolean bl = Buffers.isDirect(buffer);
        long l3 = CLImpl20.addressTable._addressof_clSetKernelArgSVMPointer;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clSetKernelArgSVMPointer"));
        }
        return this.dispatch_clSetKernelArgSVMPointer1(l2, n2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, l3);
    }

    private native int dispatch_clSetKernelArgSVMPointer1(long var1, int var3, Object var4, int var5, boolean var6, long var7);

    @Override
    public int clSetKernelExecInfo(long l2, int n2, long l3, Buffer buffer) {
        boolean bl = Buffers.isDirect(buffer);
        long l4 = CLImpl20.addressTable._addressof_clSetKernelExecInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clSetKernelExecInfo"));
        }
        return this.dispatch_clSetKernelExecInfo1(l2, n2, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, l4);
    }

    private native int dispatch_clSetKernelExecInfo1(long var1, int var3, long var4, Object var6, int var7, boolean var8, long var9);

    @Override
    public int clGetKernelInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetKernelInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetKernelInfo"));
        }
        return this.dispatch_clGetKernelInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetKernelInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clGetKernelArgInfo(long l2, int n2, int n3, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        long l4 = CLImpl20.addressTable._addressof_clGetKernelArgInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetKernelArgInfo"));
        }
        return this.dispatch_clGetKernelArgInfo1(l2, n2, n3, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, l4);
    }

    private native int dispatch_clGetKernelArgInfo1(long var1, int var3, int var4, long var5, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public int clGetKernelWorkGroupInfo(long l2, long l3, int n2, long l4, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l5 = CLImpl20.addressTable._addressof_clGetKernelWorkGroupInfo;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetKernelWorkGroupInfo"));
        }
        return this.dispatch_clGetKernelWorkGroupInfo0(l2, l3, n2, l4, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l5);
    }

    private native int dispatch_clGetKernelWorkGroupInfo0(long var1, long var3, int var5, long var6, Object var8, int var9, Object var10, int var11, long var12);

    @Override
    public int clWaitForEvents(int n2, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_list\" is not a direct buffer");
        }
        long l2 = CLImpl20.addressTable._addressof_clWaitForEvents;
        if (l2 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clWaitForEvents"));
        }
        return this.dispatch_clWaitForEvents0(n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l2);
    }

    private native int dispatch_clWaitForEvents0(int var1, Object var2, int var3, long var4);

    @Override
    public int clGetEventInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetEventInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetEventInfo"));
        }
        return this.dispatch_clGetEventInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetEventInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public long clCreateUserEvent(long l2, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateUserEvent;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateUserEvent"));
        }
        return this.dispatch_clCreateUserEvent1(l2, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l3);
    }

    private native long dispatch_clCreateUserEvent1(long var1, Object var3, int var4, boolean var5, long var6);

    @Override
    public long clCreateUserEvent(long l2, int[] nArray, int n2) {
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateUserEvent;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateUserEvent"));
        }
        return this.dispatch_clCreateUserEvent1(l2, nArray, 4 * n2, false, l3);
    }

    @Override
    public int clRetainEvent(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainEvent;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainEvent"));
        }
        return this.dispatch_clRetainEvent1(l2, l3);
    }

    private native int dispatch_clRetainEvent1(long var1, long var3);

    @Override
    public int clReleaseEvent(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseEvent;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseEvent"));
        }
        return this.dispatch_clReleaseEvent1(l2, l3);
    }

    private native int dispatch_clReleaseEvent1(long var1, long var3);

    @Override
    public int clSetUserEventStatus(long l2, int n2) {
        long l3 = CLImpl20.addressTable._addressof_clSetUserEventStatus;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clSetUserEventStatus"));
        }
        return this.dispatch_clSetUserEventStatus1(l2, n2, l3);
    }

    private native int dispatch_clSetUserEventStatus1(long var1, int var3, long var4);

    @Override
    public int clGetEventProfilingInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clGetEventProfilingInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetEventProfilingInfo"));
        }
        return this.dispatch_clGetEventProfilingInfo0(l2, n2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l4);
    }

    private native int dispatch_clGetEventProfilingInfo0(long var1, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clFlush(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clFlush;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clFlush"));
        }
        return this.dispatch_clFlush1(l2, l3);
    }

    private native int dispatch_clFlush1(long var1, long var3);

    @Override
    public int clFinish(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clFinish;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clFinish"));
        }
        return this.dispatch_clFinish1(l2, l3);
    }

    private native int dispatch_clFinish1(long var1, long var3);

    @Override
    public int clEnqueueReadBuffer(long l2, long l3, int n2, long l4, long l5, Buffer buffer, int n3, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueReadBuffer;
        if (l6 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueReadBuffer"));
        }
        return this.dispatch_clEnqueueReadBuffer0(l2, l3, n2, l4, l5, buffer, Buffers.getDirectBufferByteOffset(buffer), n3, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l6);
    }

    private native int dispatch_clEnqueueReadBuffer0(long var1, long var3, int var5, long var6, long var8, Object var10, int var11, int var12, Object var13, int var14, Object var15, int var16, long var17);

    @Override
    public int clEnqueueReadBufferRect(long l2, long l3, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, long l4, long l5, long l6, long l7, Buffer buffer, int n3, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"buffer_offset\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"host_offset\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"region\" is not a direct buffer");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer5)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l8 = CLImpl20.addressTable._addressof_clEnqueueReadBufferRect;
        if (l8 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueReadBufferRect"));
        }
        return this.dispatch_clEnqueueReadBufferRect0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), l4, l5, l6, l7, buffer, Buffers.getDirectBufferByteOffset(buffer), n3, pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), pointerBuffer5 != null ? pointerBuffer5.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer5), l8);
    }

    private native int dispatch_clEnqueueReadBufferRect0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, Object var10, int var11, long var12, long var14, long var16, long var18, Object var20, int var21, int var22, Object var23, int var24, Object var25, int var26, long var27);

    @Override
    public int clEnqueueWriteBuffer(long l2, long l3, int n2, long l4, long l5, Buffer buffer, int n3, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueWriteBuffer;
        if (l6 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueWriteBuffer"));
        }
        return this.dispatch_clEnqueueWriteBuffer0(l2, l3, n2, l4, l5, buffer, Buffers.getDirectBufferByteOffset(buffer), n3, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l6);
    }

    private native int dispatch_clEnqueueWriteBuffer0(long var1, long var3, int var5, long var6, long var8, Object var10, int var11, int var12, Object var13, int var14, Object var15, int var16, long var17);

    @Override
    public int clEnqueueWriteBufferRect(long l2, long l3, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, long l4, long l5, long l6, long l7, Buffer buffer, int n3, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"buffer_offset\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"host_offset\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"region\" is not a direct buffer");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer5)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l8 = CLImpl20.addressTable._addressof_clEnqueueWriteBufferRect;
        if (l8 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueWriteBufferRect"));
        }
        return this.dispatch_clEnqueueWriteBufferRect0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), l4, l5, l6, l7, buffer, Buffers.getDirectBufferByteOffset(buffer), n3, pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), pointerBuffer5 != null ? pointerBuffer5.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer5), l8);
    }

    private native int dispatch_clEnqueueWriteBufferRect0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, Object var10, int var11, long var12, long var14, long var16, long var18, Object var20, int var21, int var22, Object var23, int var24, Object var25, int var26, long var27);

    @Override
    public int clEnqueueFillBuffer(long l2, long l3, Buffer buffer, long l4, long l5, long l6, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        boolean bl3 = Buffers.isDirect(pointerBuffer2);
        long l7 = CLImpl20.addressTable._addressof_clEnqueueFillBuffer;
        if (l7 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueFillBuffer"));
        }
        return this.dispatch_clEnqueueFillBuffer1(l2, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, l4, l5, l6, n2, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, bl3 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl3, l7);
    }

    private native int dispatch_clEnqueueFillBuffer1(long var1, long var3, Object var5, int var6, boolean var7, long var8, long var10, long var12, int var14, Object var15, int var16, boolean var17, Object var18, int var19, boolean var20, long var21);

    @Override
    public int clEnqueueCopyBuffer(long l2, long l3, long l4, long l5, long l6, long l7, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l8 = CLImpl20.addressTable._addressof_clEnqueueCopyBuffer;
        if (l8 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueCopyBuffer"));
        }
        return this.dispatch_clEnqueueCopyBuffer0(l2, l3, l4, l5, l6, l7, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l8);
    }

    private native int dispatch_clEnqueueCopyBuffer0(long var1, long var3, long var5, long var7, long var9, long var11, int var13, Object var14, int var15, Object var16, int var17, long var18);

    @Override
    public int clEnqueueCopyBufferRect(long l2, long l3, long l4, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, long l5, long l6, long l7, long l8, int n2, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"src_origin\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"dst_origin\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"region\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer5)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l9 = CLImpl20.addressTable._addressof_clEnqueueCopyBufferRect;
        if (l9 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueCopyBufferRect"));
        }
        return this.dispatch_clEnqueueCopyBufferRect0(l2, l3, l4, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), l5, l6, l7, l8, n2, pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), pointerBuffer5 != null ? pointerBuffer5.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer5), l9);
    }

    private native int dispatch_clEnqueueCopyBufferRect0(long var1, long var3, long var5, Object var7, int var8, Object var9, int var10, Object var11, int var12, long var13, long var15, long var17, long var19, int var21, Object var22, int var23, Object var24, int var25, long var26);

    @Override
    public int clEnqueueReadImage(long l2, long l3, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l4, long l5, Buffer buffer, int n3, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"arg3\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"arg4\" is not a direct buffer");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueReadImage;
        if (l6 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueReadImage"));
        }
        return this.dispatch_clEnqueueReadImage0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l4, l5, buffer, Buffers.getDirectBufferByteOffset(buffer), n3, pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), l6);
    }

    private native int dispatch_clEnqueueReadImage0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, long var10, long var12, Object var14, int var15, int var16, Object var17, int var18, Object var19, int var20, long var21);

    @Override
    public int clEnqueueWriteImage(long l2, long l3, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l4, long l5, Buffer buffer, int n3, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"arg3\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"arg4\" is not a direct buffer");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueWriteImage;
        if (l6 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueWriteImage"));
        }
        return this.dispatch_clEnqueueWriteImage0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l4, l5, buffer, Buffers.getDirectBufferByteOffset(buffer), n3, pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), l6);
    }

    private native int dispatch_clEnqueueWriteImage0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, long var10, long var12, Object var14, int var15, int var16, Object var17, int var18, Object var19, int var20, long var21);

    @Override
    public int clEnqueueFillImage(long l2, long l3, Buffer buffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, int n2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        boolean bl3 = Buffers.isDirect(pointerBuffer2);
        boolean bl4 = Buffers.isDirect(pointerBuffer3);
        boolean bl5 = Buffers.isDirect(pointerBuffer4);
        long l4 = CLImpl20.addressTable._addressof_clEnqueueFillImage;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueFillImage"));
        }
        return this.dispatch_clEnqueueFillImage1(l2, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, bl3 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl3, n2, bl4 ? (pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null) : Buffers.getArray(pointerBuffer3), bl4 ? Buffers.getDirectBufferByteOffset(pointerBuffer3) : Buffers.getIndirectBufferByteOffset(pointerBuffer3), bl4, bl5 ? (pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null) : Buffers.getArray(pointerBuffer4), bl5 ? Buffers.getDirectBufferByteOffset(pointerBuffer4) : Buffers.getIndirectBufferByteOffset(pointerBuffer4), bl5, l4);
    }

    private native int dispatch_clEnqueueFillImage1(long var1, long var3, Object var5, int var6, boolean var7, Object var8, int var9, boolean var10, Object var11, int var12, boolean var13, int var14, Object var15, int var16, boolean var17, Object var18, int var19, boolean var20, long var21);

    @Override
    public int clEnqueueCopyImage(long l2, long l3, long l4, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, int n2, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"arg3\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"arg4\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"arg5\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer5)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l5 = CLImpl20.addressTable._addressof_clEnqueueCopyImage;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueCopyImage"));
        }
        return this.dispatch_clEnqueueCopyImage0(l2, l3, l4, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), n2, pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), pointerBuffer5 != null ? pointerBuffer5.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer5), l5);
    }

    private native int dispatch_clEnqueueCopyImage0(long var1, long var3, long var5, Object var7, int var8, Object var9, int var10, Object var11, int var12, int var13, Object var14, int var15, Object var16, int var17, long var18);

    @Override
    public int clEnqueueCopyImageToBuffer(long l2, long l3, long l4, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, long l5, int n2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"arg3\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"arg4\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueCopyImageToBuffer;
        if (l6 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueCopyImageToBuffer"));
        }
        return this.dispatch_clEnqueueCopyImageToBuffer0(l2, l3, l4, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l5, n2, pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), l6);
    }

    private native int dispatch_clEnqueueCopyImageToBuffer0(long var1, long var3, long var5, Object var7, int var8, Object var9, int var10, long var11, int var13, Object var14, int var15, Object var16, int var17, long var18);

    @Override
    public int clEnqueueCopyBufferToImage(long l2, long l3, long l4, long l5, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, int n2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"arg4\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"arg5\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueCopyBufferToImage;
        if (l6 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueCopyBufferToImage"));
        }
        return this.dispatch_clEnqueueCopyBufferToImage0(l2, l3, l4, l5, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), n2, pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), l6);
    }

    private native int dispatch_clEnqueueCopyBufferToImage0(long var1, long var3, long var5, long var7, Object var9, int var10, Object var11, int var12, int var13, Object var14, int var15, Object var16, int var17, long var18);

    @Override
    public ByteBuffer clEnqueueMapBuffer(long l2, long l3, int n2, long l4, long l5, long l6, int n3, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, IntBuffer intBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"errcode_ret\" is not a direct buffer");
        }
        long l7 = CLImpl20.addressTable._addressof_clEnqueueMapBuffer;
        if (l7 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueMapBuffer"));
        }
        ByteBuffer byteBuffer = this.dispatch_clEnqueueMapBuffer0(l2, l3, n2, l4, l5, l6, n3, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l7);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    private native ByteBuffer dispatch_clEnqueueMapBuffer0(long var1, long var3, int var5, long var6, long var8, long var10, int var12, Object var13, int var14, Object var15, int var16, Object var17, int var18, long var19);

    @Override
    public int clEnqueueUnmapMemObject(long l2, long l3, Buffer buffer, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"mapped_ptr\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clEnqueueUnmapMemObject;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueUnmapMemObject"));
        }
        return this.dispatch_clEnqueueUnmapMemObject0(l2, l3, buffer, Buffers.getDirectBufferByteOffset(buffer), n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l4);
    }

    private native int dispatch_clEnqueueUnmapMemObject0(long var1, long var3, Object var5, int var6, int var7, Object var8, int var9, Object var10, int var11, long var12);

    @Override
    public int clEnqueueMigrateMemObjects(long l2, int n2, PointerBuffer pointerBuffer, long l3, int n3, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer2);
        boolean bl3 = Buffers.isDirect(pointerBuffer3);
        long l4 = CLImpl20.addressTable._addressof_clEnqueueMigrateMemObjects;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueMigrateMemObjects"));
        }
        return this.dispatch_clEnqueueMigrateMemObjects1(l2, n2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, l3, n3, bl2 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl2, bl3 ? (pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null) : Buffers.getArray(pointerBuffer3), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer3) : Buffers.getIndirectBufferByteOffset(pointerBuffer3), bl3, l4);
    }

    private native int dispatch_clEnqueueMigrateMemObjects1(long var1, int var3, Object var4, int var5, boolean var6, long var7, int var9, Object var10, int var11, boolean var12, Object var13, int var14, boolean var15, long var16);

    @Override
    public int clEnqueueNDRangeKernel(long l2, long l3, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, int n3, PointerBuffer pointerBuffer4, PointerBuffer pointerBuffer5) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"global_work_offset\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"global_work_size\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"local_work_size\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer4)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer5)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clEnqueueNDRangeKernel;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueNDRangeKernel"));
        }
        return this.dispatch_clEnqueueNDRangeKernel0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), n3, pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), pointerBuffer5 != null ? pointerBuffer5.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer5), l4);
    }

    private native int dispatch_clEnqueueNDRangeKernel0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, Object var10, int var11, int var12, Object var13, int var14, Object var15, int var16, long var17);

    @Override
    public int clEnqueueMarkerWithWaitList(long l2, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer2);
        long l3 = CLImpl20.addressTable._addressof_clEnqueueMarkerWithWaitList;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueMarkerWithWaitList"));
        }
        return this.dispatch_clEnqueueMarkerWithWaitList1(l2, n2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, bl2 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl2, l3);
    }

    private native int dispatch_clEnqueueMarkerWithWaitList1(long var1, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, long var10);

    @Override
    public int clEnqueueBarrierWithWaitList(long l2, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer2);
        long l3 = CLImpl20.addressTable._addressof_clEnqueueBarrierWithWaitList;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueBarrierWithWaitList"));
        }
        return this.dispatch_clEnqueueBarrierWithWaitList1(l2, n2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, bl2 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl2, l3);
    }

    private native int dispatch_clEnqueueBarrierWithWaitList1(long var1, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, long var10);

    @Override
    public int clEnqueueSVMFree(long l2, int n2, PointerBuffer pointerBuffer, Buffer buffer, Buffer buffer2, int n3, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        boolean bl = Buffers.isDirect(pointerBuffer);
        boolean bl2 = Buffers.isDirect(buffer);
        boolean bl3 = Buffers.isDirect(buffer2);
        boolean bl4 = Buffers.isDirect(pointerBuffer2);
        boolean bl5 = Buffers.isDirect(pointerBuffer3);
        long l3 = CLImpl20.addressTable._addressof_clEnqueueSVMFree;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueSVMFree"));
        }
        return this.dispatch_clEnqueueSVMFree1(l2, n2, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, bl2 ? buffer : Buffers.getArray(buffer), bl2 ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl2, bl3 ? buffer2 : Buffers.getArray(buffer2), bl3 ? Buffers.getDirectBufferByteOffset(buffer2) : Buffers.getIndirectBufferByteOffset(buffer2), bl3, n3, bl4 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl4 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl4, bl5 ? (pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null) : Buffers.getArray(pointerBuffer3), bl5 ? Buffers.getDirectBufferByteOffset(pointerBuffer3) : Buffers.getIndirectBufferByteOffset(pointerBuffer3), bl5, l3);
    }

    private native int dispatch_clEnqueueSVMFree1(long var1, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, int var13, Object var14, int var15, boolean var16, Object var17, int var18, boolean var19, long var20);

    @Override
    public int clEnqueueSVMMemcpy(long l2, int n2, Buffer buffer, Buffer buffer2, long l3, int n3, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(buffer2);
        boolean bl3 = Buffers.isDirect(pointerBuffer);
        boolean bl4 = Buffers.isDirect(pointerBuffer2);
        long l4 = CLImpl20.addressTable._addressof_clEnqueueSVMMemcpy;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueSVMMemcpy"));
        }
        return this.dispatch_clEnqueueSVMMemcpy1(l2, n2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? buffer2 : Buffers.getArray(buffer2), bl2 ? Buffers.getDirectBufferByteOffset(buffer2) : Buffers.getIndirectBufferByteOffset(buffer2), bl2, l3, n3, bl3 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl3, bl4 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl4 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl4, l4);
    }

    private native int dispatch_clEnqueueSVMMemcpy1(long var1, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, long var10, int var12, Object var13, int var14, boolean var15, Object var16, int var17, boolean var18, long var19);

    @Override
    public int clEnqueueSVMMemFill(long l2, Buffer buffer, Buffer buffer2, long l3, long l4, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(buffer2);
        boolean bl3 = Buffers.isDirect(pointerBuffer);
        boolean bl4 = Buffers.isDirect(pointerBuffer2);
        long l5 = CLImpl20.addressTable._addressof_clEnqueueSVMMemFill;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueSVMMemFill"));
        }
        return this.dispatch_clEnqueueSVMMemFill1(l2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? buffer2 : Buffers.getArray(buffer2), bl2 ? Buffers.getDirectBufferByteOffset(buffer2) : Buffers.getIndirectBufferByteOffset(buffer2), bl2, l3, l4, n2, bl3 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl3, bl4 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl4 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl4, l5);
    }

    private native int dispatch_clEnqueueSVMMemFill1(long var1, Object var3, int var4, boolean var5, Object var6, int var7, boolean var8, long var9, long var11, int var13, Object var14, int var15, boolean var16, Object var17, int var18, boolean var19, long var20);

    @Override
    public int clEnqueueSVMMap(long l2, int n2, long l3, Buffer buffer, long l4, int n3, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        boolean bl3 = Buffers.isDirect(pointerBuffer2);
        long l5 = CLImpl20.addressTable._addressof_clEnqueueSVMMap;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueSVMMap"));
        }
        return this.dispatch_clEnqueueSVMMap1(l2, n2, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, l4, n3, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, bl3 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl3, l5);
    }

    private native int dispatch_clEnqueueSVMMap1(long var1, int var3, long var4, Object var6, int var7, boolean var8, long var9, int var11, Object var12, int var13, boolean var14, Object var15, int var16, boolean var17, long var18);

    @Override
    public int clEnqueueSVMUnmap(long l2, Buffer buffer, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        boolean bl3 = Buffers.isDirect(pointerBuffer2);
        long l3 = CLImpl20.addressTable._addressof_clEnqueueSVMUnmap;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueSVMUnmap"));
        }
        return this.dispatch_clEnqueueSVMUnmap1(l2, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, n2, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, bl3 ? (pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null) : Buffers.getArray(pointerBuffer2), bl3 ? Buffers.getDirectBufferByteOffset(pointerBuffer2) : Buffers.getIndirectBufferByteOffset(pointerBuffer2), bl3, l3);
    }

    private native int dispatch_clEnqueueSVMUnmap1(long var1, Object var3, int var4, boolean var5, int var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public ByteBuffer clGetExtensionFunctionAddressForPlatform(long l2, ByteBuffer byteBuffer) {
        boolean bl = Buffers.isDirect(byteBuffer);
        long l3 = CLImpl20.addressTable._addressof_clGetExtensionFunctionAddressForPlatform;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetExtensionFunctionAddressForPlatform"));
        }
        ByteBuffer byteBuffer2 = this.dispatch_clGetExtensionFunctionAddressForPlatform1(l2, bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl, l3);
        if (byteBuffer2 == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer2);
        return byteBuffer2;
    }

    private native ByteBuffer dispatch_clGetExtensionFunctionAddressForPlatform1(long var1, Object var3, int var4, boolean var5, long var6);

    @Override
    public ByteBuffer clGetExtensionFunctionAddressForPlatform(long l2, byte[] byArray, int n2) {
        if (byArray != null && byArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"func_name_offset\" (" + n2 + ") equals or exceeds array length (" + byArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clGetExtensionFunctionAddressForPlatform;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetExtensionFunctionAddressForPlatform"));
        }
        ByteBuffer byteBuffer = this.dispatch_clGetExtensionFunctionAddressForPlatform1(l2, byArray, n2, false, l3);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    @Override
    public long clCreateImage2D(long l2, long l3, CLImageFormatImpl cLImageFormatImpl, long l4, long l5, long l6, Buffer buffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l7 = CLImpl20.addressTable._addressof_clCreateImage2D;
        if (l7 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateImage2D"));
        }
        return this.dispatch_clCreateImage2D1(l2, l3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), l4, l5, l6, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l7);
    }

    private native long dispatch_clCreateImage2D1(long var1, long var3, ByteBuffer var5, long var6, long var8, long var10, Object var12, int var13, boolean var14, Object var15, int var16, boolean var17, long var18);

    @Override
    public long clCreateImage2D(long l2, long l3, CLImageFormatImpl cLImageFormatImpl, long l4, long l5, long l6, Buffer buffer, int[] nArray, int n2) {
        boolean bl = Buffers.isDirect(buffer);
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l7 = CLImpl20.addressTable._addressof_clCreateImage2D;
        if (l7 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateImage2D"));
        }
        return this.dispatch_clCreateImage2D1(l2, l3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), l4, l5, l6, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, nArray, 4 * n2, false, l7);
    }

    @Override
    public long clCreateImage3D(long l2, long l3, CLImageFormatImpl cLImageFormatImpl, long l4, long l5, long l6, long l7, long l8, Buffer buffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(intBuffer);
        long l9 = CLImpl20.addressTable._addressof_clCreateImage3D;
        if (l9 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateImage3D"));
        }
        return this.dispatch_clCreateImage3D1(l2, l3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), l4, l5, l6, l7, l8, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? intBuffer : Buffers.getArray(intBuffer), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl2, l9);
    }

    private native long dispatch_clCreateImage3D1(long var1, long var3, ByteBuffer var5, long var6, long var8, long var10, long var12, long var14, Object var16, int var17, boolean var18, Object var19, int var20, boolean var21, long var22);

    @Override
    public long clCreateImage3D(long l2, long l3, CLImageFormatImpl cLImageFormatImpl, long l4, long l5, long l6, long l7, long l8, Buffer buffer, int[] nArray, int n2) {
        boolean bl = Buffers.isDirect(buffer);
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l9 = CLImpl20.addressTable._addressof_clCreateImage3D;
        if (l9 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateImage3D"));
        }
        return this.dispatch_clCreateImage3D1(l2, l3, cLImageFormatImpl == null ? null : cLImageFormatImpl.getBuffer(), l4, l5, l6, l7, l8, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, nArray, 4 * n2, false, l9);
    }

    @Override
    public int clEnqueueMarker(long l2, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clEnqueueMarker;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueMarker"));
        }
        return this.dispatch_clEnqueueMarker0(l2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l3);
    }

    private native int dispatch_clEnqueueMarker0(long var1, Object var3, int var4, long var5);

    @Override
    public int clEnqueueWaitForEvents(long l2, int n2, PointerBuffer pointerBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_list\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clEnqueueWaitForEvents;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueWaitForEvents"));
        }
        return this.dispatch_clEnqueueWaitForEvents0(l2, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l3);
    }

    private native int dispatch_clEnqueueWaitForEvents0(long var1, int var3, Object var4, int var5, long var6);

    @Override
    public int clEnqueueBarrier(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clEnqueueBarrier;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueBarrier"));
        }
        return this.dispatch_clEnqueueBarrier0(l2, l3);
    }

    private native int dispatch_clEnqueueBarrier0(long var1, long var3);

    @Override
    public int clUnloadCompiler() {
        long l2 = CLImpl20.addressTable._addressof_clUnloadCompiler;
        if (l2 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clUnloadCompiler"));
        }
        return this.dispatch_clUnloadCompiler1(l2);
    }

    private native int dispatch_clUnloadCompiler1(long var1);

    @Override
    public long clCreateCommandQueue(long l2, long l3, long l4, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l5 = CLImpl20.addressTable._addressof_clCreateCommandQueue;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateCommandQueue"));
        }
        return this.dispatch_clCreateCommandQueue1(l2, l3, l4, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l5);
    }

    private native long dispatch_clCreateCommandQueue1(long var1, long var3, long var5, Object var7, int var8, boolean var9, long var10);

    @Override
    public long clCreateCommandQueue(long l2, long l3, long l4, int[] nArray, int n2) {
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l5 = CLImpl20.addressTable._addressof_clCreateCommandQueue;
        if (l5 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateCommandQueue"));
        }
        return this.dispatch_clCreateCommandQueue1(l2, l3, l4, nArray, 4 * n2, false, l5);
    }

    @Override
    public long clCreateSampler(long l2, int n2, int n3, int n4, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateSampler;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSampler"));
        }
        return this.dispatch_clCreateSampler1(l2, n2, n3, n4, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l3);
    }

    private native long dispatch_clCreateSampler1(long var1, int var3, int var4, int var5, Object var6, int var7, boolean var8, long var9);

    @Override
    public long clCreateSampler(long l2, int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray != null && nArray.length <= n5) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n5 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateSampler;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSampler"));
        }
        return this.dispatch_clCreateSampler1(l2, n2, n3, n4, nArray, 4 * n5, false, l3);
    }

    @Override
    public int clEnqueueTask(long l2, long l3, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l4 = CLImpl20.addressTable._addressof_clEnqueueTask;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueTask"));
        }
        return this.dispatch_clEnqueueTask0(l2, l3, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l4);
    }

    private native int dispatch_clEnqueueTask0(long var1, long var3, int var5, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public int clIcdGetPlatformIDsKHR(int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"arg1\" is not a direct buffer");
        }
        if (!Buffers.isDirect(intBuffer)) {
            throw new IllegalArgumentException("Argument \"arg2\" is not a direct buffer");
        }
        long l2 = CLImpl20.addressTable._addressof_clIcdGetPlatformIDsKHR;
        if (l2 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clIcdGetPlatformIDsKHR"));
        }
        return this.dispatch_clIcdGetPlatformIDsKHR0(n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l2);
    }

    private native int dispatch_clIcdGetPlatformIDsKHR0(int var1, Object var2, int var3, Object var4, int var5, long var6);

    @Override
    public int clTerminateContextKHR(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clTerminateContextKHR;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clTerminateContextKHR"));
        }
        return this.dispatch_clTerminateContextKHR1(l2, l3);
    }

    private native int dispatch_clTerminateContextKHR1(long var1, long var3);

    @Override
    public int clReleaseDeviceEXT(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clReleaseDeviceEXT;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clReleaseDeviceEXT"));
        }
        return this.dispatch_clReleaseDeviceEXT1(l2, l3);
    }

    private native int dispatch_clReleaseDeviceEXT1(long var1, long var3);

    @Override
    public int clRetainDeviceEXT(long l2) {
        long l3 = CLImpl20.addressTable._addressof_clRetainDeviceEXT;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clRetainDeviceEXT"));
        }
        return this.dispatch_clRetainDeviceEXT1(l2, l3);
    }

    private native int dispatch_clRetainDeviceEXT1(long var1, long var3);

    @Override
    public int clCreateSubDevicesEXT(long l2, LongBuffer longBuffer, int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(longBuffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        boolean bl3 = Buffers.isDirect(intBuffer);
        long l3 = CLImpl20.addressTable._addressof_clCreateSubDevicesEXT;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSubDevicesEXT"));
        }
        return this.dispatch_clCreateSubDevicesEXT1(l2, bl ? longBuffer : Buffers.getArray(longBuffer), bl ? Buffers.getDirectBufferByteOffset(longBuffer) : Buffers.getIndirectBufferByteOffset(longBuffer), bl, n2, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, bl3 ? intBuffer : Buffers.getArray(intBuffer), bl3 ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl3, l3);
    }

    private native int dispatch_clCreateSubDevicesEXT1(long var1, Object var3, int var4, boolean var5, int var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12, long var13);

    @Override
    public int clCreateSubDevicesEXT(long l2, long[] lArray, int n2, int n3, PointerBuffer pointerBuffer, int[] nArray, int n4) {
        if (lArray != null && lArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"arg1_offset\" (" + n2 + ") equals or exceeds array length (" + lArray.length + ")");
        }
        boolean bl = Buffers.isDirect(pointerBuffer);
        if (nArray != null && nArray.length <= n4) {
            throw new IllegalArgumentException("array offset argument \"arg4_offset\" (" + n4 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateSubDevicesEXT;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateSubDevicesEXT"));
        }
        return this.dispatch_clCreateSubDevicesEXT1(l2, lArray, 8 * n2, false, n3, bl ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl, nArray, 4 * n4, false, l3);
    }

    @Override
    public long clCreateFromGLBuffer(long l2, long l3, int n2, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLBuffer;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLBuffer"));
        }
        return this.dispatch_clCreateFromGLBuffer1(l2, l3, n2, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native long dispatch_clCreateFromGLBuffer1(long var1, long var3, int var5, Object var6, int var7, boolean var8, long var9);

    @Override
    public long clCreateFromGLBuffer(long l2, long l3, int n2, int[] nArray, int n3) {
        if (nArray != null && nArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLBuffer;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLBuffer"));
        }
        return this.dispatch_clCreateFromGLBuffer1(l2, l3, n2, nArray, 4 * n3, false, l4);
    }

    @Override
    public long clCreateFromGLTexture(long l2, long l3, int n2, int n3, int n4, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLTexture;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLTexture"));
        }
        return this.dispatch_clCreateFromGLTexture1(l2, l3, n2, n3, n4, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native long dispatch_clCreateFromGLTexture1(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, boolean var10, long var11);

    @Override
    public long clCreateFromGLTexture(long l2, long l3, int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray != null && nArray.length <= n5) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n5 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLTexture;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLTexture"));
        }
        return this.dispatch_clCreateFromGLTexture1(l2, l3, n2, n3, n4, nArray, 4 * n5, false, l4);
    }

    @Override
    public long clCreateFromGLRenderbuffer(long l2, long l3, int n2, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLRenderbuffer;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLRenderbuffer"));
        }
        return this.dispatch_clCreateFromGLRenderbuffer1(l2, l3, n2, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native long dispatch_clCreateFromGLRenderbuffer1(long var1, long var3, int var5, Object var6, int var7, boolean var8, long var9);

    @Override
    public long clCreateFromGLRenderbuffer(long l2, long l3, int n2, int[] nArray, int n3) {
        if (nArray != null && nArray.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLRenderbuffer;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLRenderbuffer"));
        }
        return this.dispatch_clCreateFromGLRenderbuffer1(l2, l3, n2, nArray, 4 * n3, false, l4);
    }

    @Override
    public int clGetGLObjectInfo(long l2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        boolean bl = Buffers.isDirect(intBuffer);
        boolean bl2 = Buffers.isDirect(intBuffer2);
        long l3 = CLImpl20.addressTable._addressof_clGetGLObjectInfo;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetGLObjectInfo"));
        }
        return this.dispatch_clGetGLObjectInfo1(l2, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, bl2 ? intBuffer2 : Buffers.getArray(intBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(intBuffer2) : Buffers.getIndirectBufferByteOffset(intBuffer2), bl2, l3);
    }

    private native int dispatch_clGetGLObjectInfo1(long var1, Object var3, int var4, boolean var5, Object var6, int var7, boolean var8, long var9);

    @Override
    public int clGetGLObjectInfo(long l2, int[] nArray, int n2, int[] nArray2, int n3) {
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"gl_object_type_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        if (nArray2 != null && nArray2.length <= n3) {
            throw new IllegalArgumentException("array offset argument \"gl_object_name_offset\" (" + n3 + ") equals or exceeds array length (" + nArray2.length + ")");
        }
        long l3 = CLImpl20.addressTable._addressof_clGetGLObjectInfo;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetGLObjectInfo"));
        }
        return this.dispatch_clGetGLObjectInfo1(l2, nArray, 4 * n2, false, nArray2, 4 * n3, false, l3);
    }

    @Override
    public int clGetGLTextureInfo(long l2, int n2, long l3, Buffer buffer, PointerBuffer pointerBuffer) {
        boolean bl = Buffers.isDirect(buffer);
        boolean bl2 = Buffers.isDirect(pointerBuffer);
        long l4 = CLImpl20.addressTable._addressof_clGetGLTextureInfo;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetGLTextureInfo"));
        }
        return this.dispatch_clGetGLTextureInfo1(l2, n2, l3, bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, bl2 ? (pointerBuffer != null ? pointerBuffer.getBuffer() : null) : Buffers.getArray(pointerBuffer), bl2 ? Buffers.getDirectBufferByteOffset(pointerBuffer) : Buffers.getIndirectBufferByteOffset(pointerBuffer), bl2, l4);
    }

    private native int dispatch_clGetGLTextureInfo1(long var1, int var3, long var4, Object var6, int var7, boolean var8, Object var9, int var10, boolean var11, long var12);

    @Override
    public int clEnqueueAcquireGLObjects(long l2, int n2, PointerBuffer pointerBuffer, int n3, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"mem_objects\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clEnqueueAcquireGLObjects;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueAcquireGLObjects"));
        }
        return this.dispatch_clEnqueueAcquireGLObjects0(l2, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), n3, pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), l3);
    }

    private native int dispatch_clEnqueueAcquireGLObjects0(long var1, int var3, Object var4, int var5, int var6, Object var7, int var8, Object var9, int var10, long var11);

    @Override
    public int clEnqueueReleaseGLObjects(long l2, int n2, PointerBuffer pointerBuffer, int n3, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"mem_objects\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"event_wait_list\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer3)) {
            throw new IllegalArgumentException("Argument \"event\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clEnqueueReleaseGLObjects;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clEnqueueReleaseGLObjects"));
        }
        return this.dispatch_clEnqueueReleaseGLObjects0(l2, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), n3, pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), l3);
    }

    private native int dispatch_clEnqueueReleaseGLObjects0(long var1, int var3, Object var4, int var5, int var6, Object var7, int var8, Object var9, int var10, long var11);

    @Override
    public long clCreateFromGLTexture2D(long l2, long l3, int n2, int n3, int n4, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLTexture2D;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLTexture2D"));
        }
        return this.dispatch_clCreateFromGLTexture2D1(l2, l3, n2, n3, n4, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native long dispatch_clCreateFromGLTexture2D1(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, boolean var10, long var11);

    @Override
    public long clCreateFromGLTexture2D(long l2, long l3, int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray != null && nArray.length <= n5) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n5 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLTexture2D;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLTexture2D"));
        }
        return this.dispatch_clCreateFromGLTexture2D1(l2, l3, n2, n3, n4, nArray, 4 * n5, false, l4);
    }

    @Override
    public long clCreateFromGLTexture3D(long l2, long l3, int n2, int n3, int n4, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLTexture3D;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLTexture3D"));
        }
        return this.dispatch_clCreateFromGLTexture3D1(l2, l3, n2, n3, n4, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native long dispatch_clCreateFromGLTexture3D1(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, boolean var10, long var11);

    @Override
    public long clCreateFromGLTexture3D(long l2, long l3, int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray != null && nArray.length <= n5) {
            throw new IllegalArgumentException("array offset argument \"errcode_ret_offset\" (" + n5 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateFromGLTexture3D;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateFromGLTexture3D"));
        }
        return this.dispatch_clCreateFromGLTexture3D1(l2, l3, n2, n3, n4, nArray, 4 * n5, false, l4);
    }

    @Override
    public int clGetGLContextInfoKHR(PointerBuffer pointerBuffer, int n2, long l2, Buffer buffer, PointerBuffer pointerBuffer2) {
        if (!Buffers.isDirect(pointerBuffer)) {
            throw new IllegalArgumentException("Argument \"properties\" is not a direct buffer");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Argument \"param_value\" is not a direct buffer");
        }
        if (!Buffers.isDirect(pointerBuffer2)) {
            throw new IllegalArgumentException("Argument \"param_value_size_ret\" is not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clGetGLContextInfoKHR;
        if (l3 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clGetGLContextInfoKHR"));
        }
        return this.dispatch_clGetGLContextInfoKHR0(pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), n2, l2, buffer, Buffers.getDirectBufferByteOffset(buffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), l3);
    }

    private native int dispatch_clGetGLContextInfoKHR0(Object var1, int var2, int var3, long var4, Object var6, int var7, Object var8, int var9, long var10);

    @Override
    public long clCreateEventFromGLsyncKHR(long l2, long l3, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        long l4 = CLImpl20.addressTable._addressof_clCreateEventFromGLsyncKHR;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateEventFromGLsyncKHR"));
        }
        return this.dispatch_clCreateEventFromGLsyncKHR1(l2, l3, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl, l4);
    }

    private native long dispatch_clCreateEventFromGLsyncKHR1(long var1, long var3, Object var5, int var6, boolean var7, long var8);

    @Override
    public long clCreateEventFromGLsyncKHR(long l2, long l3, int[] nArray, int n2) {
        if (nArray != null && nArray.length <= n2) {
            throw new IllegalArgumentException("array offset argument \"arg2_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        long l4 = CLImpl20.addressTable._addressof_clCreateEventFromGLsyncKHR;
        if (l4 == 0L) {
            throw new UnsupportedOperationException(String.format("Method \"%s\" not available", "clCreateEventFromGLsyncKHR"));
        }
        return this.dispatch_clCreateEventFromGLsyncKHR1(l2, l3, nArray, 4 * n2, false, l4);
    }

    public static CLProcAddressTable20 getAddressTable() {
        return addressTable;
    }

    public CLImpl20() {
        this.init();
    }

    protected void init() {
        this.contextCallbackMap.setKeyNotFoundValue(0L);
    }

    public static boolean isAvailable() {
        return dynamicLookupHelper != null;
    }

    static long clGetExtensionFunctionAddress(long l2, String string) {
        if (l2 == 0L) {
            throw new RuntimeException("Passed null pointer for method \"clGetExtensionFunctionAddress\"");
        }
        return CLImpl20.dispatch_clGetExtensionFunctionAddressStatic(string, l2);
    }

    long clGetExtensionFunctionAddress(String string) {
        long l2 = CLImpl20.addressTable._addressof_clGetExtensionFunctionAddress;
        if (l2 == 0L) {
            throw new UnsupportedOperationException("Method \"clGetExtensionFunctionAddress\" not available");
        }
        return CLImpl20.dispatch_clGetExtensionFunctionAddressStatic(string, l2);
    }

    private static native long dispatch_clGetExtensionFunctionAddressStatic(String var0, long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clCreateContext(PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, CLErrorHandler cLErrorHandler, IntBuffer intBuffer) {
        if (pointerBuffer != null && !pointerBuffer.isDirect()) {
            throw new RuntimeException("Argument \"properties\" was not a direct buffer");
        }
        if (intBuffer != null && !intBuffer.isDirect()) {
            throw new RuntimeException("Argument \"errcode_ret\" was not a direct buffer");
        }
        long l2 = CLImpl20.addressTable._addressof_clCreateContext;
        if (l2 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        long[] lArray = new long[1];
        long l3 = this.clCreateContext0(pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.remaining() : 0, pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), cLErrorHandler, lArray, intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l2);
        if (cLErrorHandler != null && lArray[0] != 0L) {
            LongLongHashMap longLongHashMap = this.contextCallbackMap;
            synchronized (longLongHashMap) {
                this.contextCallbackMap.put(l3, lArray[0]);
            }
        }
        return l3;
    }

    private native long clCreateContext0(Object var1, int var2, int var3, Object var4, int var5, Object var6, long[] var7, Object var8, int var9, long var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clCreateContextFromType(PointerBuffer pointerBuffer, long l2, CLErrorHandler cLErrorHandler, IntBuffer intBuffer) {
        if (pointerBuffer != null && !pointerBuffer.isDirect()) {
            throw new RuntimeException("Argument \"properties\" was not a direct buffer");
        }
        if (intBuffer != null && !intBuffer.isDirect()) {
            throw new RuntimeException("Argument \"errcode_ret\" was not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clCreateContextFromType;
        if (l3 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        long[] lArray = new long[1];
        long l4 = this.clCreateContextFromType0(pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), l2, cLErrorHandler, lArray, intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l3);
        if (cLErrorHandler != null && lArray[0] != 0L) {
            LongLongHashMap longLongHashMap = this.contextCallbackMap;
            synchronized (longLongHashMap) {
                this.contextCallbackMap.put(l4, lArray[0]);
            }
        }
        return l4;
    }

    private native long clCreateContextFromType0(Object var1, int var2, long var3, Object var5, long[] var6, Object var7, int var8, long var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clReleaseContext(long l2) {
        long l3 = 0L;
        LongLongHashMap longLongHashMap = this.contextCallbackMap;
        synchronized (longLongHashMap) {
            l3 = this.contextCallbackMap.remove(l2);
        }
        long l4 = CLImpl20.addressTable._addressof_clReleaseContext;
        if (l4 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clReleaseContextImpl(l2, l3, l4);
    }

    public native int clReleaseContextImpl(long var1, long var3, long var5);

    @Override
    public int clBuildProgram(long l2, int n2, PointerBuffer pointerBuffer, String string, BuildProgramCallback buildProgramCallback) {
        if (pointerBuffer != null && !pointerBuffer.isDirect()) {
            throw new RuntimeException("Argument \"properties\" was not a direct buffer");
        }
        long l3 = CLImpl20.addressTable._addressof_clBuildProgram;
        if (l3 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clBuildProgram0(l2, n2, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), string, buildProgramCallback, l3);
    }

    private native int clBuildProgram0(long var1, int var3, Object var4, int var5, String var6, BuildProgramCallback var7, long var8);

    @Override
    public int clSetEventCallback(long l2, int n2, CLEventCallback cLEventCallback) {
        long l3 = CLImpl20.addressTable._addressof_clSetEventCallback;
        if (l3 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clSetEventCallback0(l2, n2, cLEventCallback, l3);
    }

    private native int clSetEventCallback0(long var1, int var3, CLEventCallback var4, long var5);

    @Override
    public int clSetMemObjectDestructorCallback(long l2, CLMemObjectDestructorCallback cLMemObjectDestructorCallback) {
        long l3 = CLImpl20.addressTable._addressof_clSetMemObjectDestructorCallback;
        if (l3 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clSetMemObjectDestructorCallback0(l2, cLMemObjectDestructorCallback, l3);
    }

    private native int clSetMemObjectDestructorCallback0(long var1, CLMemObjectDestructorCallback var3, long var4);

    @Override
    public ByteBuffer clEnqueueMapImage(long l2, long l3, int n2, long l4, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, PointerBuffer pointerBuffer4, int n3, PointerBuffer pointerBuffer5, PointerBuffer pointerBuffer6, IntBuffer intBuffer) {
        if (pointerBuffer != null && !pointerBuffer.isDirect()) {
            throw new CLException("Argument \"origin\" was not a direct buffer");
        }
        if (pointerBuffer2 != null && !pointerBuffer2.isDirect()) {
            throw new CLException("Argument \"range\" was not a direct buffer");
        }
        if (pointerBuffer3 != null && !pointerBuffer3.isDirect()) {
            throw new CLException("Argument \"image_row_pitch\" was not a direct buffer");
        }
        if (pointerBuffer4 != null && !pointerBuffer4.isDirect()) {
            throw new CLException("Argument \"image_slice_pitch\" was not a direct buffer");
        }
        if (pointerBuffer5 != null && !pointerBuffer5.isDirect()) {
            throw new CLException("Argument \"event_wait_list\" was not a direct buffer");
        }
        if (pointerBuffer6 != null && !pointerBuffer6.isDirect()) {
            throw new CLException("Argument \"event\" was not a direct buffer");
        }
        if (intBuffer != null && !intBuffer.isDirect()) {
            throw new CLException("Argument \"errcode_ret\" was not a direct buffer");
        }
        long l5 = CLImpl20.addressTable._addressof_clGetImageInfo;
        if (l5 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        long l6 = CLImpl20.addressTable._addressof_clEnqueueMapImage;
        if (l6 == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        ByteBuffer byteBuffer = this.clEnqueueMapImage0(l2, l3, n2, l4, pointerBuffer != null ? pointerBuffer.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer), pointerBuffer2 != null ? pointerBuffer2.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer2), pointerBuffer3 != null ? pointerBuffer3.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer3), pointerBuffer4 != null ? pointerBuffer4.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer4), n3, pointerBuffer5 != null ? pointerBuffer5.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer5), pointerBuffer6 != null ? pointerBuffer6.getBuffer() : null, Buffers.getDirectBufferByteOffset(pointerBuffer6), intBuffer, Buffers.getDirectBufferByteOffset(intBuffer), l5, l6);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    private native ByteBuffer clEnqueueMapImage0(long var1, long var3, int var5, long var6, Object var8, int var9, Object var10, int var11, Object var12, int var13, Object var14, int var15, int var16, Object var17, int var18, Object var19, int var20, Object var21, int var22, long var23, long var25);
}

