/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.Bitstream;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class CLTLInfoAccessor
implements CLInfoAccessor {
    private static final int BB_SIZE = 512;
    protected static final ThreadLocal<ByteBuffer> localBB = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return Buffers.newDirectByteBuffer(512);
        }
    };
    protected static final ThreadLocal<PointerBuffer> localNSB = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return PointerBuffer.allocateDirect(1);
        }
    };

    @Override
    public final long getUInt32Long(int n2) {
        ByteBuffer byteBuffer = this.getBB(4).putInt(0, 0);
        int n3 = this.getInfo(n2, 4L, byteBuffer, null);
        CLException.checkForError(n3, "error while asking for info value");
        return Bitstream.toUInt32Long(byteBuffer.getInt(0));
    }

    @Override
    public final long getLong(int n2) {
        ByteBuffer byteBuffer = this.getBB(8).putLong(0, 0L);
        int n3 = this.getInfo(n2, 8L, byteBuffer, null);
        CLException.checkForError(n3, "error while asking for info value");
        return byteBuffer.getLong(0);
    }

    @Override
    public final String getString(int n2) {
        PointerBuffer pointerBuffer = this.getNSB();
        int n3 = this.getInfo(n2, 0L, null, pointerBuffer);
        CLException.checkForError(n3, "error while asking for info string");
        int n4 = (int)pointerBuffer.get(0);
        ByteBuffer byteBuffer = this.getBB(n4);
        n3 = this.getInfo(n2, byteBuffer.capacity(), byteBuffer, null);
        CLException.checkForError(n3, "error while asking for info string");
        byte[] byArray = new byte[n4];
        byteBuffer.get(byArray).rewind();
        return CLUtil.clString2JavaString(byArray, n4);
    }

    @Override
    public final int[] getInts(int n2, int n3) {
        ByteBuffer byteBuffer = this.getBB(n3 * (Platform.is32Bit() ? 4 : 8));
        int n4 = this.getInfo(n2, byteBuffer.capacity(), byteBuffer, null);
        CLException.checkForError(n4, "error while asking for info value");
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Platform.is32Bit() ? byteBuffer.getInt() : (int)byteBuffer.getLong();
        }
        byteBuffer.rewind();
        return nArray;
    }

    protected ByteBuffer getBB(int n2) {
        if (n2 > 512) {
            return Buffers.newDirectByteBuffer(n2);
        }
        return localBB.get();
    }

    protected PointerBuffer getNSB() {
        return localNSB.get();
    }

    protected abstract int getInfo(int var1, long var2, Buffer var4, PointerBuffer var5);
}

