/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class CLTLAccessorFactory
implements CLAccessorFactory {
    @Override
    public CLInfoAccessor createDeviceInfoAccessor(CL cL, long l2) {
        return new CLDeviceInfoAccessor(cL, l2);
    }

    @Override
    public CLPlatformInfoAccessor createPlatformInfoAccessor(CL cL, long l2) {
        return new CLTLPlatformInfoAccessor(cL, l2);
    }

    private static final class CLDeviceInfoAccessor
    extends CLTLInfoAccessor {
        private final CL cl;
        private final long ID;

        private CLDeviceInfoAccessor(CL cL, long l2) {
            this.cl = cL;
            this.ID = l2;
        }

        @Override
        public int getInfo(int n2, long l2, Buffer buffer, PointerBuffer pointerBuffer) {
            return this.cl.clGetDeviceInfo(this.ID, n2, l2, buffer, pointerBuffer);
        }
    }

    private static final class CLTLPlatformInfoAccessor
    extends CLTLInfoAccessor
    implements CLPlatformInfoAccessor {
        private final long ID;
        private final CL cl;

        private CLTLPlatformInfoAccessor(CL cL, long l2) {
            this.ID = l2;
            this.cl = cL;
        }

        @Override
        public int getInfo(int n2, long l2, Buffer buffer, PointerBuffer pointerBuffer) {
            return this.cl.clGetPlatformInfo(this.ID, n2, l2, buffer, pointerBuffer);
        }

        @Override
        public long[] getDeviceIDs(long l2) {
            IntBuffer intBuffer = this.getBB(4).asIntBuffer();
            int n2 = this.cl.clGetDeviceIDs(this.ID, l2, 0, null, intBuffer);
            int n3 = intBuffer.get(0);
            if (n2 == -1 || n3 == 0) {
                return new long[0];
            }
            CLException.checkForError(n2, "error while enumerating devices");
            PointerBuffer pointerBuffer = PointerBuffer.wrap(this.getBB(n3 * PointerBuffer.ELEMENT_SIZE));
            n2 = this.cl.clGetDeviceIDs(this.ID, l2, n3, pointerBuffer, null);
            CLException.checkForError(n2, "error while enumerating devices");
            long[] lArray = new long[n3];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = pointerBuffer.get(i2);
            }
            return lArray;
        }
    }
}

