/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLProgramBuilder;
import com.jogamp.opencl.InternalBufferUtil;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.BuildProgramCallback;
import com.jogamp.opencl.util.CLBuildListener;
import com.jogamp.opencl.util.CLProgramConfiguration;
import com.jogamp.opencl.util.CLUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;

public class CLProgram
extends CLObjectResource {
    private static final Semaphore buildLock = new Semaphore(1, true);
    private final CL binding;
    private final Set<CLKernel> kernels = new HashSet<CLKernel>();
    private Map<CLDevice, Status> buildStatusMap;
    private boolean executable;
    private boolean released;
    private boolean noSource;

    private CLProgram(CLContext cLContext, long l2) {
        super(cLContext, l2);
        this.binding = cLContext.getPlatform().getCLBinding();
    }

    static CLProgram create(CLContext cLContext, String string) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1).put(0, string.length());
        String[] stringArray = new String[]{string};
        CL cL = cLContext.getPlatform().getCLBinding();
        long l2 = cL.clCreateProgramWithSource(cLContext.ID, 1, stringArray, pointerBuffer, intBuffer);
        int n2 = intBuffer.get();
        if (n2 != 0) {
            throw CLException.newException(n2, "can not create program with source on " + cLContext);
        }
        return new CLProgram(cLContext, l2);
    }

    static CLProgram create(CLContext cLContext, Map<CLDevice, byte[]> map) {
        Set<Map.Entry<CLDevice, byte[]>> set = map.entrySet();
        int n2 = 0;
        for (Map.Entry<CLDevice, byte[]> entry : set) {
            n2 += entry.getValue().length;
        }
        int n3 = PointerBuffer.ELEMENT_SIZE;
        int n4 = map.size();
        CachedBufferFactory cachedBufferFactory = CachedBufferFactory.create(n2 + n3 * n4 * 3 + 4, true);
        PointerBuffer pointerBuffer = PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(n4 * n3));
        PointerBuffer pointerBuffer2 = PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(n4 * n3));
        PointerBuffer pointerBuffer3 = PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(n4 * n3));
        int n5 = 0;
        for (Map.Entry<CLDevice, byte[]> object2 : set) {
            byte[] l2 = object2.getValue();
            CLDevice cLDevice = object2.getKey();
            pointerBuffer.put(cLDevice.ID);
            pointerBuffer3.put(l2.length);
            pointerBuffer2.referenceBuffer(n5, cachedBufferFactory.newDirectByteBuffer(l2));
            ++n5;
        }
        pointerBuffer.rewind();
        pointerBuffer3.rewind();
        IntBuffer intBuffer = cachedBufferFactory.newDirectIntBuffer(1);
        CL cL = cLContext.getPlatform().getCLBinding();
        long l2 = cL.clCreateProgramWithBinary(cLContext.ID, pointerBuffer.capacity(), pointerBuffer, pointerBuffer3, pointerBuffer2, null, intBuffer);
        int n6 = intBuffer.get();
        if (n6 != 0) {
            throw CLException.newException(n6, "can not create program on " + cLContext + " with binaries " + map);
        }
        return new CLProgram(cLContext, l2);
    }

    private void initBuildStatus() {
        if (this.buildStatusMap == null) {
            CLDevice[] cLDeviceArray;
            HashMap<CLDevice, Status> hashMap = new HashMap<CLDevice, Status>();
            for (CLDevice cLDevice : cLDeviceArray = this.getCLDevices()) {
                Status status = this.getBuildStatus(cLDevice);
                if (status == Status.BUILD_SUCCESS) {
                    this.executable = true;
                }
                hashMap.put(cLDevice, status);
            }
            this.buildStatusMap = Collections.unmodifiableMap(hashMap);
        }
    }

    private String getBuildInfoString(CLDevice cLDevice, int n2) {
        if (this.released) {
            return "";
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1);
        int n3 = this.binding.clGetProgramBuildInfo(this.ID, cLDevice.ID, n2, 0L, null, pointerBuffer);
        if (n3 != 0) {
            throw CLException.newException(n3, "on clGetProgramBuildInfo with " + cLDevice);
        }
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)pointerBuffer.get(0));
        n3 = this.binding.clGetProgramBuildInfo(this.ID, cLDevice.ID, n2, byteBuffer.capacity(), byteBuffer, null);
        if (n3 != 0) {
            throw CLException.newException(n3, "on clGetProgramBuildInfo with " + cLDevice);
        }
        return CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer.get(0));
    }

    private String getProgramInfoString(int n2) {
        if (this.released) {
            return "";
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1);
        int n3 = this.binding.clGetProgramInfo(this.ID, n2, 0L, null, pointerBuffer);
        CLException.checkForError(n3, "on clGetProgramInfo");
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)pointerBuffer.get(0));
        n3 = this.binding.clGetProgramInfo(this.ID, n2, byteBuffer.capacity(), byteBuffer, null);
        CLException.checkForError(n3, "on clGetProgramInfo");
        return CLUtil.clString2JavaString(byteBuffer, (int)pointerBuffer.get(0));
    }

    private int getBuildInfoInt(CLDevice cLDevice, int n2) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        int n3 = this.binding.clGetProgramBuildInfo(this.ID, cLDevice.ID, n2, byteBuffer.capacity(), byteBuffer, null);
        CLException.checkForError(n3, "error on clGetProgramBuildInfo");
        return byteBuffer.getInt();
    }

    public CLProgram build() {
        this.build(null, (String)null, (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLBuildListener cLBuildListener) {
        this.build(cLBuildListener, (String)null, (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLDevice ... cLDeviceArray) {
        this.build(null, (String)null, cLDeviceArray);
        return this;
    }

    public CLProgram build(CLBuildListener cLBuildListener, CLDevice ... cLDeviceArray) {
        this.build(cLBuildListener, (String)null, cLDeviceArray);
        return this;
    }

    public CLProgram build(String string) {
        this.build(null, string, (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLBuildListener cLBuildListener, String string) {
        this.build(cLBuildListener, string, (CLDevice[])null);
        return this;
    }

    public CLProgram build(String ... stringArray) {
        this.build(null, CLProgram.optionsOf(stringArray), (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLBuildListener cLBuildListener, String ... stringArray) {
        this.build(cLBuildListener, CLProgram.optionsOf(stringArray), (CLDevice[])null);
        return this;
    }

    public CLProgram build(String string, CLDevice ... cLDeviceArray) {
        this.build(null, string, cLDeviceArray);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLProgram build(final CLBuildListener cLBuildListener, String string, CLDevice ... cLDeviceArray) {
        if (this.released) {
            throw new CLException("can not build a released program");
        }
        if (!this.kernels.isEmpty()) {
            this.releaseKernels();
        }
        PointerBuffer pointerBuffer = null;
        int n2 = 0;
        if (cLDeviceArray != null && cLDeviceArray.length != 0) {
            pointerBuffer = PointerBuffer.allocateDirect(cLDeviceArray.length);
            for (int i2 = 0; i2 < cLDeviceArray.length; ++i2) {
                pointerBuffer.put(i2, cLDeviceArray[i2].ID);
            }
            pointerBuffer.rewind();
            n2 = cLDeviceArray.length;
        }
        if (string != null && string.trim().isEmpty()) {
            string = null;
        }
        this.buildStatusMap = null;
        this.executable = false;
        BuildProgramCallback buildProgramCallback = null;
        if (cLBuildListener != null) {
            buildProgramCallback = new BuildProgramCallback(){

                @Override
                public void buildFinished(long l2) {
                    buildLock.release();
                    cLBuildListener.buildFinished(CLProgram.this);
                }
            };
        }
        int n3 = 0;
        try {
            buildLock.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw CLException.newException(n3, "\nInterrupted while waiting to get build lock");
        }
        boolean bl = true;
        try {
            n3 = this.binding.clBuildProgram(this.ID, n2, pointerBuffer, string, buildProgramCallback);
            bl = false;
        }
        finally {
            if (buildProgramCallback == null || bl) {
                buildLock.release();
            }
        }
        if (n3 != 0) {
            throw CLException.newException(n3, "\n" + this.getBuildLog());
        }
        return this;
    }

    public CLProgramConfiguration prepare() {
        return CLProgramBuilder.createConfiguration(this);
    }

    public CLKernel createCLKernel(String string) {
        if (this.released) {
            return null;
        }
        int[] nArray = new int[1];
        long l2 = this.binding.clCreateKernel(this.ID, string, nArray, 0);
        if (nArray[0] != 0) {
            throw CLException.newException(nArray[0], "unable to create Kernel with name: " + string);
        }
        CLKernel cLKernel = new CLKernel(this, string, l2);
        this.kernels.add(cLKernel);
        return cLKernel;
    }

    public Map<String, CLKernel> createCLKernels() {
        if (this.released) {
            return Collections.emptyMap();
        }
        HashMap<String, CLKernel> hashMap = new HashMap<String, CLKernel>();
        IntBuffer intBuffer = Buffers.newDirectByteBuffer(4).asIntBuffer();
        int n2 = this.binding.clCreateKernelsInProgram(this.ID, 0, null, intBuffer);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not create kernels for " + this);
        }
        if (intBuffer.get(0) > 0) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
            n2 = this.binding.clCreateKernelsInProgram(this.ID, pointerBuffer.capacity(), pointerBuffer, null);
            if (n2 != 0) {
                throw CLException.newException(n2, "can not create " + pointerBuffer.capacity() + " kernels for " + this);
            }
            for (int i2 = 0; i2 < pointerBuffer.capacity(); ++i2) {
                CLKernel cLKernel = new CLKernel(this, pointerBuffer.get(i2));
                this.kernels.add(cLKernel);
                hashMap.put(cLKernel.name, cLKernel);
            }
        } else {
            this.initBuildStatus();
            if (!this.isExecutable()) {
                throw CLException.newException(-45, "can not initialize kernels, program is not executable. status: " + this.buildStatusMap);
            }
        }
        return hashMap;
    }

    void onKernelReleased(CLKernel cLKernel) {
        this.kernels.remove(cLKernel);
    }

    @Override
    public void release() {
        super.release();
        this.releaseKernels();
        this.executable = false;
        this.released = true;
        this.buildStatusMap = null;
        int n2 = this.binding.clReleaseProgram(this.ID);
        this.context.onProgramReleased(this);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not release " + this);
        }
    }

    private void releaseKernels() {
        if (!this.kernels.isEmpty()) {
            CLKernel[] cLKernelArray;
            for (CLKernel cLKernel : cLKernelArray = this.kernels.toArray(new CLKernel[this.kernels.size()])) {
                cLKernel.release();
            }
        }
    }

    public CLDevice[] getCLDevices() {
        if (this.released) {
            return new CLDevice[0];
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1);
        int n2 = this.binding.clGetProgramInfo(this.ID, 4451, 0L, null, pointerBuffer);
        if (n2 != 0) {
            throw CLException.newException(n2, "on clGetProgramInfo of " + this);
        }
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)pointerBuffer.get(0));
        n2 = this.binding.clGetProgramInfo(this.ID, 4451, byteBuffer.capacity(), byteBuffer, null);
        if (n2 != 0) {
            throw CLException.newException(n2, "on clGetProgramInfo of " + this);
        }
        int n3 = byteBuffer.capacity() / (Platform.is32Bit() ? 4 : 8);
        CLDevice[] cLDeviceArray = new CLDevice[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cLDeviceArray[i2] = this.context.getDevice(Platform.is32Bit() ? (long)byteBuffer.getInt() : byteBuffer.getLong());
        }
        return cLDeviceArray;
    }

    public String getBuildLog() {
        if (this.released) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        CLDevice[] cLDeviceArray = this.getCLDevices();
        for (int i2 = 0; i2 < cLDeviceArray.length; ++i2) {
            CLDevice cLDevice = cLDeviceArray[i2];
            stringBuilder.append(cLDevice).append(" build log:\n");
            String string = this.getBuildLog(cLDevice).trim();
            stringBuilder.append(string.isEmpty() ? "    <empty>" : string);
            if (i2 == cLDeviceArray.length - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<CLDevice, Status> getBuildStatus() {
        if (this.released) {
            return Collections.emptyMap();
        }
        this.initBuildStatus();
        return this.buildStatusMap;
    }

    public boolean isExecutable() {
        if (this.released) {
            return false;
        }
        this.initBuildStatus();
        return this.executable;
    }

    public String getBuildLog(CLDevice cLDevice) {
        return this.getBuildInfoString(cLDevice, 4483);
    }

    public Status getBuildStatus(CLDevice cLDevice) {
        if (this.released) {
            return Status.BUILD_NONE;
        }
        int n2 = this.getBuildInfoInt(cLDevice, 4481);
        return Status.valueOf(n2);
    }

    public void setNoSource() {
        this.noSource = true;
    }

    public String getSource() {
        if (this.noSource) {
            return "";
        }
        try {
            return this.getProgramInfoString(4452);
        }
        catch (CLException.CLInvalidValueException cLInvalidValueException) {
            return "";
        }
    }

    public Map<CLDevice, byte[]> getBinaries() {
        if (!this.isExecutable()) {
            return Collections.emptyMap();
        }
        CLDevice[] cLDeviceArray = this.getCLDevices();
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(cLDeviceArray.length);
        int n2 = this.binding.clGetProgramInfo(this.ID, 4453, pointerBuffer.capacity() * pointerBuffer.elementSize(), pointerBuffer.getBuffer(), null);
        if (n2 != 0) {
            throw CLException.newException(n2, "on clGetProgramInfo(CL_PROGRAM_BINARY_SIZES) of " + this);
        }
        int n3 = 0;
        while (pointerBuffer.remaining() != 0) {
            int n4 = (int)pointerBuffer.get();
            n3 += n4;
        }
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n3);
        long l2 = InternalBufferUtil.getDirectBufferAddress(byteBuffer);
        PointerBuffer pointerBuffer2 = PointerBuffer.allocateDirect(pointerBuffer.capacity());
        pointerBuffer.rewind();
        while (pointerBuffer.remaining() != 0) {
            pointerBuffer2.put(l2);
            l2 += pointerBuffer.get();
        }
        pointerBuffer2.rewind();
        n2 = this.binding.clGetProgramInfo(this.ID, 4454, pointerBuffer2.capacity() * pointerBuffer2.elementSize(), pointerBuffer2.getBuffer(), null);
        if (n2 != 0) {
            throw CLException.newException(n2, "on clGetProgramInfo(CL_PROGRAM_BINARIES) of " + this);
        }
        LinkedHashMap<CLDevice, byte[]> linkedHashMap = new LinkedHashMap<CLDevice, byte[]>();
        pointerBuffer.rewind();
        for (int i2 = 0; i2 < cLDeviceArray.length; ++i2) {
            byte[] byArray = new byte[(int)pointerBuffer.get()];
            byteBuffer.get(byArray);
            linkedHashMap.put(cLDeviceArray[i2], byArray);
        }
        return linkedHashMap;
    }

    public static String optionsOf(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 24);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String define(String string) {
        return "-D " + string;
    }

    public static String define(String string, Object object) {
        return "-D " + string + "=" + object;
    }

    @Override
    public String toString() {
        return "CLProgram [id: " + this.ID + " status: " + this.getBuildStatus() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLProgram cLProgram = (CLProgram)object;
        if (this.ID != cLProgram.ID) {
            return false;
        }
        return this.context.equals(cLProgram.context);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 37 * n2 + (this.context != null ? this.context.hashCode() : 0);
        n2 = 37 * n2 + (int)(this.ID ^ this.ID >>> 32);
        return n2;
    }

    public static enum Status {
        BUILD_SUCCESS(0),
        BUILD_NONE(-1),
        BUILD_IN_PROGRESS(-3),
        BUILD_ERROR(-2);

        public final int STATUS;

        private Status(int n3) {
            this.STATUS = n3;
        }

        public static Status valueOf(int n2) {
            switch (n2) {
                case 0: {
                    return BUILD_SUCCESS;
                }
                case -1: {
                    return BUILD_NONE;
                }
                case -3: {
                    return BUILD_IN_PROGRESS;
                }
                case -2: {
                    return BUILD_ERROR;
                }
            }
            return null;
        }
    }

    public static interface CompilerOptions {
        public static final String SINGLE_PRECISION_CONSTANTS = "-cl-single-precision-constant";
        public static final String DENORMS_ARE_ZERO = "-cl-denorms-are-zero";
        public static final String DISABLE_OPT = "-cl-opt-disable";
        public static final String STRICT_ALIASING = "-cl-strict-aliasing";
        public static final String ENABLE_MAD = "-cl-mad-enable";
        public static final String NO_SIGNED_ZEROS = "-cl-no-signed-zeros";
        public static final String UNSAFE_MATH = "-cl-unsafe-math-optimizations";
        public static final String FINITE_MATH_ONLY = "-cl-finite-math-only";
        public static final String FAST_RELAXED_MATH = "-cl-fast-relaxed-math";
        public static final String DISABLE_WARNINGS = "-w";
        public static final String WARNINGS_ARE_ERRORS = "-Werror";
    }
}

