/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemObjectListener;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLMemObjectDestructorCallback;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.EnumSet;

public abstract class CLMemory<B extends Buffer>
extends CLObjectResource {
    B buffer;
    protected final int FLAGS;
    protected long size;
    protected int elementSize;
    protected int clCapacity;
    private final CL binding;

    protected <Buffer> CLMemory(CLContext cLContext, long l2, long l3, int n2) {
        this(cLContext, null, l2, l3, n2);
    }

    protected CLMemory(CLContext cLContext, B b2, long l2, long l3, int n2) {
        super(cLContext, l3);
        this.buffer = b2;
        this.FLAGS = n2;
        this.size = l2;
        this.binding = cLContext.getPlatform().getCLBinding();
        this.initElementSize();
        this.initCLCapacity();
    }

    private void initElementSize() {
        this.elementSize = this.buffer == null ? 1 : Buffers.sizeOfBufferElem(this.buffer);
    }

    protected final void initCLCapacity() {
        this.clCapacity = (int)(this.size / (long)this.elementSize);
    }

    protected static boolean isHostPointerFlag(int n2) {
        return (n2 & 0x20) != 0 || (n2 & 8) != 0;
    }

    protected static long getSizeImpl(CLContext cLContext, long l2) {
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1);
        CL cL = cLContext.getPlatform().getCLBinding();
        int n2 = cL.clGetMemObjectInfo(l2, 4354, pointerBuffer.elementSize(), pointerBuffer.getBuffer(), null);
        CLException.checkForError(n2, "can not obtain buffer info");
        return pointerBuffer.get();
    }

    protected static CL getCL(CLContext cLContext) {
        return cLContext.getCL();
    }

    public void registerDestructorCallback(final CLMemObjectListener cLMemObjectListener) {
        this.binding.clSetMemObjectDestructorCallback(this.ID, new CLMemObjectDestructorCallback(){

            @Override
            public void memoryDeallocated(long l2) {
                cLMemObjectListener.memoryDeallocated(CLMemory.this);
            }
        });
    }

    public abstract <T extends Buffer> CLMemory<T> cloneWith(T var1);

    public CLMemory<B> use(B b2) {
        if (this.buffer != null && b2 != null && this.buffer.getClass() != b2.getClass()) {
            throw new IllegalArgumentException("expected a Buffer of class " + this.buffer.getClass() + " but got " + b2.getClass());
        }
        this.buffer = b2;
        this.initElementSize();
        this.initCLCapacity();
        return this;
    }

    public B getBuffer() {
        return this.buffer;
    }

    public int getNIOCapacity() {
        if (this.buffer == null) {
            return 0;
        }
        return ((Buffer)this.buffer).capacity();
    }

    public int getNIOSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.getElementSize() * ((Buffer)this.buffer).capacity();
    }

    public long getCLSize() {
        return this.size;
    }

    public int getCLCapacity() {
        return this.clCapacity;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public EnumSet<Mem> getConfig() {
        return Mem.valuesOf(this.FLAGS);
    }

    public int getMapCount() {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        int n2 = this.binding.clGetMemObjectInfo(this.ID, 4356, 4L, intBuffer, null);
        CLException.checkForError(n2, "can not obtain buffer map count.");
        return intBuffer.get();
    }

    public boolean isReadOnly() {
        return (Mem.READ_ONLY.CONFIG & this.FLAGS) != 0;
    }

    public boolean isWriteOnly() {
        return (Mem.WRITE_ONLY.CONFIG & this.FLAGS) != 0;
    }

    public boolean isReadWrite() {
        return (Mem.READ_WRITE.CONFIG & this.FLAGS) != 0;
    }

    @Override
    public void release() {
        super.release();
        int n2 = this.binding.clReleaseMemObject(this.ID);
        this.context.onMemoryReleased(this);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not release " + this);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLMemory cLMemory = (CLMemory)object;
        if (this.ID != cLMemory.ID) {
            return false;
        }
        return this.context == cLMemory.context || this.context != null && this.context.equals(cLMemory.context);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 83 * n2 + (int)(this.ID ^ this.ID >>> 32);
        n2 = 83 * n2 + (this.context != null ? this.context.hashCode() : 0);
        return n2;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " buffer: " + this.buffer + "]";
    }

    public static enum Mem {
        READ_WRITE(1),
        WRITE_ONLY(2),
        READ_ONLY(4),
        USE_BUFFER(8),
        ALLOCATE_BUFFER(16),
        COPY_BUFFER(32);

        public final int CONFIG;

        private Mem(int n3) {
            this.CONFIG = n3;
        }

        public static Mem valueOf(int n2) {
            switch (n2) {
                case 1: {
                    return READ_WRITE;
                }
                case 4: {
                    return READ_ONLY;
                }
                case 2: {
                    return WRITE_ONLY;
                }
                case 8: {
                    return USE_BUFFER;
                }
                case 16: {
                    return ALLOCATE_BUFFER;
                }
                case 32: {
                    return COPY_BUFFER;
                }
            }
            return null;
        }

        public static EnumSet<Mem> valuesOf(int n2) {
            Mem[] memArray;
            ArrayList<Mem> arrayList = new ArrayList<Mem>();
            for (Mem mem : memArray = Mem.values()) {
                if ((mem.CONFIG & n2) == 0) continue;
                arrayList.add(mem);
            }
            if (arrayList.isEmpty()) {
                return EnumSet.noneOf(Mem.class);
            }
            return EnumSet.copyOf(arrayList);
        }

        public static int flagsToInt(Mem[] memArray) {
            int n2 = 0;
            if (memArray != null) {
                for (int i2 = 0; i2 < memArray.length; ++i2) {
                    n2 |= memArray[i2].CONFIG;
                }
            }
            if (n2 == 0) {
                n2 = 1;
            }
            return n2;
        }
    }

    public static enum GLObjectType {
        GL_OBJECT_BUFFER(8192),
        GL_OBJECT_TEXTURE2D(8193),
        GL_OBJECT_TEXTURE3D(8194),
        GL_OBJECT_RENDERBUFFER(8195);

        public final int TYPE;

        private GLObjectType(int n3) {
            this.TYPE = n3;
        }

        public static GLObjectType valueOf(int n2) {
            if (n2 == 8192) {
                return GL_OBJECT_BUFFER;
            }
            if (n2 == 8193) {
                return GL_OBJECT_TEXTURE2D;
            }
            if (n2 == 8194) {
                return GL_OBJECT_TEXTURE3D;
            }
            if (n2 == 8195) {
                return GL_OBJECT_RENDERBUFFER;
            }
            return null;
        }
    }

    public static enum Map {
        READ_WRITE(3),
        WRITE(2),
        READ(1);

        public final int FLAGS;

        private Map(int n3) {
            this.FLAGS = n3;
        }

        public Map valueOf(int n2) {
            if (n2 == Map.WRITE.FLAGS) {
                return WRITE;
            }
            if (n2 == Map.READ.FLAGS) {
                return READ;
            }
            if (n2 == Map.READ_WRITE.FLAGS) {
                return READ_WRITE;
            }
            return null;
        }
    }
}

