/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.llb.CL;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class CLImage3d<B extends Buffer>
extends CLImage<B> {
    public final int depth;

    private CLImage3d(CLContext cLContext, B b2, CLImageFormat cLImageFormat, int n2, int n3, int n4, long l2, int n5) {
        super(cLContext, b2, cLImageFormat, n2, n3, l2, n5);
        this.depth = n4;
    }

    protected CLImage3d(CLContext cLContext, B b2, CLImageFormat cLImageFormat, CLImage.CLImageInfoAccessor cLImageInfoAccessor, int n2, int n3, int n4, long l2, int n5) {
        super(cLContext, b2, cLImageFormat, cLImageInfoAccessor, n2, n3, l2, n5);
        this.depth = n4;
    }

    static <B extends Buffer> CLImage3d<B> createImage(CLContext cLContext, B b2, int n2, int n3, int n4, int n5, int n6, CLImageFormat cLImageFormat, int n7) {
        CL cL = cLContext.getPlatform().getCLBinding();
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        Buffer buffer = null;
        if (CLImage3d.isHostPointerFlag(n7)) {
            buffer = b2;
        }
        long l2 = cL.clCreateImage3D(cLContext.ID, n7, cLImageFormat.getFormatImpl(), n2, n3, n4, n5, n6, buffer, intBuffer);
        CLException.checkForError(intBuffer.get(), "can not create 2d image");
        return new CLImage3d<B>(cLContext, b2, cLImageFormat, n2, n3, n4, l2, n7);
    }

    @Override
    public <T extends Buffer> CLImage3d<T> cloneWith(T t) {
        return new CLImage3d<T>(this.context, t, this.format, this.width, this.height, this.depth, this.ID, this.FLAGS);
    }

    public int getSlicePitch() {
        return (int)this.imageInfo.getLong(4371);
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        return "CLImage3d [id: " + this.ID + " width: " + this.width + " height: " + this.height + " depth: " + this.depth + "]";
    }
}

