/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

public class CLException
extends RuntimeException {
    private static final long serialVersionUID = 6573520735486076436L;
    public final int errorcode;
    public final String error;

    public CLException(String string) {
        super(string);
        this.errorcode = 0;
        this.error = "none";
    }

    private CLException(int n2, String string, String string2) {
        super(string2 + " [error: " + string + "]");
        this.error = string;
        this.errorcode = n2;
    }

    public static void checkForError(int n2, String string) {
        if (n2 != 0) {
            CLException cLException = CLException.newException(n2, string);
            cLException.fillInStackTrace();
            throw cLException;
        }
    }

    public static CLException newException(int n2, String string) {
        CLException cLException = CLException.createSpecificException(n2, string);
        if (cLException != null) {
            cLException.fillInStackTrace();
            return cLException;
        }
        return new CLException(n2, "unknown", "unknown cause: code " + n2);
    }

    public String getCLErrorString() {
        return this.error;
    }

    public static String resolveErrorCode(int n2) {
        switch (n2) {
            case -1: {
                return "CL_DEVICE_NOT_FOUND";
            }
            case -2: {
                return "CL_DEVICE_NOT_AVAILABLE";
            }
            case -3: {
                return "CL_COMPILER_NOT_AVAILABLE";
            }
            case -4: {
                return "CL_MEM_OBJECT_ALLOCATION_FAILURE";
            }
            case -5: {
                return "CL_OUT_OF_RESOURCES";
            }
            case -6: {
                return "CL_OUT_OF_HOST_MEMORY";
            }
            case -7: {
                return "CL_PROFILING_INFO_NOT_AVAILABLE";
            }
            case -8: {
                return "CL_MEM_COPY_OVERLAP";
            }
            case -9: {
                return "CL_IMAGE_FORMAT_MISMATCH";
            }
            case -10: {
                return "CL_IMAGE_FORMAT_NOT_SUPPORTED";
            }
            case -11: {
                return "CL_BUILD_PROGRAM_FAILURE";
            }
            case -12: {
                return "CL_MAP_FAILURE";
            }
            case -30: {
                return "CL_INVALID_VALUE";
            }
            case -31: {
                return "CL_INVALID_DEVICE_TYPE";
            }
            case -32: {
                return "CL_INVALID_PLATFORM";
            }
            case -33: {
                return "CL_INVALID_DEVICE";
            }
            case -34: {
                return "CL_INVALID_CONTEXT";
            }
            case -35: {
                return "CL_INVALID_QUEUE_PROPERTIES";
            }
            case -36: {
                return "CL_INVALID_COMMAND_QUEUE";
            }
            case -37: {
                return "CL_INVALID_HOST_PTR";
            }
            case -38: {
                return "CL_INVALID_MEM_OBJECT";
            }
            case -39: {
                return "CL_INVALID_IMAGE_FORMAT_DESCRIPTOR";
            }
            case -40: {
                return "CL_INVALID_IMAGE_SIZE";
            }
            case -41: {
                return "CL_INVALID_SAMPLER";
            }
            case -42: {
                return "CL_INVALID_BINARY";
            }
            case -43: {
                return "CL_INVALID_BUILD_OPTIONS";
            }
            case -44: {
                return "CL_INVALID_PROGRAM";
            }
            case -45: {
                return "CL_INVALID_PROGRAM_EXECUTABLE";
            }
            case -46: {
                return "CL_INVALID_KERNEL_NAME";
            }
            case -47: {
                return "CL_INVALID_KERNEL_DEFINITION";
            }
            case -48: {
                return "CL_INVALID_KERNEL";
            }
            case -49: {
                return "CL_INVALID_ARG_INDEX";
            }
            case -50: {
                return "CL_INVALID_ARG_VALUE";
            }
            case -51: {
                return "CL_INVALID_ARG_SIZE";
            }
            case -52: {
                return "CL_INVALID_KERNEL_ARGS";
            }
            case -53: {
                return "CL_INVALID_WORK_DIMENSION";
            }
            case -54: {
                return "CL_INVALID_WORK_GROUP_SIZE";
            }
            case -55: {
                return "CL_INVALID_WORK_ITEM_SIZE";
            }
            case -56: {
                return "CL_INVALID_GLOBAL_OFFSET";
            }
            case -57: {
                return "CL_INVALID_EVENT_WAIT_LIST";
            }
            case -58: {
                return "CL_INVALID_EVENT";
            }
            case -59: {
                return "CL_INVALID_OPERATION";
            }
            case -61: {
                return "CL_INVALID_BUFFER_SIZE";
            }
            case -62: {
                return "CL_INVALID_MIP_LEVEL";
            }
            case -63: {
                return "CL_INVALID_GLOBAL_WORK_SIZE";
            }
            case -64: {
                return "CL_INVALID_PROPERTY";
            }
            case -1001: {
                return "CL_PLATFORM_NOT_FOUND_KHR";
            }
            case -13: {
                return "CL_MISALIGNED_SUB_BUFFER_OFFSET";
            }
            case -14: {
                return "CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST";
            }
            case -60: {
                return "CL_INVALID_GL_OBJECT";
            }
            case -1000: {
                return "CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR";
            }
        }
        return null;
    }

    private static CLException createSpecificException(int n2, String string) {
        switch (n2) {
            case -1: {
                return new CLDeviceNotFoundException(string);
            }
            case -2: {
                return new CLDeviceNotAvailableException(string);
            }
            case -3: {
                return new CLCompilerNotAvailableException(string);
            }
            case -4: {
                return new CLMemObjectAllocationFailureException(string);
            }
            case -5: {
                return new CLOutOfResourcesException(string);
            }
            case -6: {
                return new CLOutOfHostMemoryException(string);
            }
            case -7: {
                return new CLProfilingInfoNotAvailableException(string);
            }
            case -8: {
                return new CLMemCopyOverlapException(string);
            }
            case -9: {
                return new CLImageFormatMismatchException(string);
            }
            case -10: {
                return new CLImageFormatNotSupportedException(string);
            }
            case -11: {
                return new CLBuildProgramFailureException(string);
            }
            case -12: {
                return new CLMapFailureException(string);
            }
            case -30: {
                return new CLInvalidValueException(string);
            }
            case -31: {
                return new CLInvalidDeviceTypeException(string);
            }
            case -32: {
                return new CLInvalidPlatformException(string);
            }
            case -33: {
                return new CLInvalidDeviceException(string);
            }
            case -34: {
                return new CLInvalidContextException(string);
            }
            case -35: {
                return new CLInvalidQueuePropertiesException(string);
            }
            case -36: {
                return new CLInvalidCommandQueueException(string);
            }
            case -37: {
                return new CLInvalidHostPtrException(string);
            }
            case -38: {
                return new CLInvalidMemObjectException(string);
            }
            case -39: {
                return new CLInvalidImageFormatDescriptorException(string);
            }
            case -40: {
                return new CLInvalidImageSizeException(string);
            }
            case -41: {
                return new CLInvalidSamplerException(string);
            }
            case -42: {
                return new CLInvalidBinaryException(string);
            }
            case -43: {
                return new CLInvalidBuildOptionsException(string);
            }
            case -44: {
                return new CLInvalidProgramException(string);
            }
            case -45: {
                return new CLInvalidProgramExecutableException(string);
            }
            case -46: {
                return new CLInvalidKernelNameException(string);
            }
            case -47: {
                return new CLInvalidKernelDefinitionException(string);
            }
            case -48: {
                return new CLInvalidKernelException(string);
            }
            case -49: {
                return new CLInvalidArgIndexException(string);
            }
            case -50: {
                return new CLInvalidArgValueException(string);
            }
            case -51: {
                return new CLInvalidArgSizeException(string);
            }
            case -52: {
                return new CLInvalidKernelArgsException(string);
            }
            case -53: {
                return new CLInvalidWorkDimensionException(string);
            }
            case -54: {
                return new CLInvalidWorkGroupSizeException(string);
            }
            case -55: {
                return new CLInvalidWorkItemSizeException(string);
            }
            case -56: {
                return new CLInvalidGlobalOffsetException(string);
            }
            case -57: {
                return new CLInvalidEventWaitListException(string);
            }
            case -58: {
                return new CLInvalidEventException(string);
            }
            case -59: {
                return new CLInvalidOperationException(string);
            }
            case -61: {
                return new CLInvalidBufferSizeException(string);
            }
            case -62: {
                return new CLInvalidMipLevelException(string);
            }
            case -63: {
                return new CLInvalidGlobalWorkSizeException(string);
            }
            case -64: {
                return new CLInvalidPropertyException(string);
            }
            case -1001: {
                return new CLPlatformNotFoundKhrException(string);
            }
            case -13: {
                return new CLMisalignedSubBufferOffsetException(string);
            }
            case -14: {
                return new CLExecStatusErrorForEventsInWaitListException(string);
            }
            case -60: {
                return new CLInvalidGLObjectException(string);
            }
            case -1000: {
                return new CLInvalidGLSharegroupReferenceKhrException(string);
            }
        }
        return null;
    }

    public static final class CLDeviceNotFoundException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076435L;

        public CLDeviceNotFoundException(String string) {
            super(-1, "CL_DEVICE_NOT_FOUND", string);
        }
    }

    public static final class CLDeviceNotAvailableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076434L;

        public CLDeviceNotAvailableException(String string) {
            super(-2, "CL_DEVICE_NOT_AVAILABLE", string);
        }
    }

    public static final class CLCompilerNotAvailableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076433L;

        public CLCompilerNotAvailableException(String string) {
            super(-3, "CL_COMPILER_NOT_AVAILABLE", string);
        }
    }

    public static final class CLMemObjectAllocationFailureException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076432L;

        public CLMemObjectAllocationFailureException(String string) {
            super(-4, "CL_MEM_OBJECT_ALLOCATION_FAILURE", string);
        }
    }

    public static final class CLOutOfResourcesException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076431L;

        public CLOutOfResourcesException(String string) {
            super(-5, "CL_OUT_OF_RESOURCES", string);
        }
    }

    public static final class CLOutOfHostMemoryException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076430L;

        public CLOutOfHostMemoryException(String string) {
            super(-6, "CL_OUT_OF_HOST_MEMORY", string);
        }
    }

    public static final class CLProfilingInfoNotAvailableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076429L;

        public CLProfilingInfoNotAvailableException(String string) {
            super(-7, "CL_PROFILING_INFO_NOT_AVAILABLE", string);
        }
    }

    public static final class CLMemCopyOverlapException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076428L;

        public CLMemCopyOverlapException(String string) {
            super(-8, "CL_MEM_COPY_OVERLAP", string);
        }
    }

    public static final class CLImageFormatMismatchException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076427L;

        public CLImageFormatMismatchException(String string) {
            super(-9, "CL_IMAGE_FORMAT_MISMATCH", string);
        }
    }

    public static final class CLImageFormatNotSupportedException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076426L;

        public CLImageFormatNotSupportedException(String string) {
            super(-10, "CL_IMAGE_FORMAT_NOT_SUPPORTED", string);
        }
    }

    public static final class CLBuildProgramFailureException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076425L;

        public CLBuildProgramFailureException(String string) {
            super(-11, "CL_BUILD_PROGRAM_FAILURE", string);
        }
    }

    public static final class CLMapFailureException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076424L;

        public CLMapFailureException(String string) {
            super(-12, "CL_MAP_FAILURE", string);
        }
    }

    public static final class CLInvalidValueException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076406L;

        public CLInvalidValueException(String string) {
            super(-30, "CL_INVALID_VALUE", string);
        }
    }

    public static final class CLInvalidDeviceTypeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076405L;

        public CLInvalidDeviceTypeException(String string) {
            super(-31, "CL_INVALID_DEVICE_TYPE", string);
        }
    }

    public static final class CLInvalidPlatformException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076404L;

        public CLInvalidPlatformException(String string) {
            super(-32, "CL_INVALID_PLATFORM", string);
        }
    }

    public static final class CLInvalidDeviceException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076403L;

        public CLInvalidDeviceException(String string) {
            super(-33, "CL_INVALID_DEVICE", string);
        }
    }

    public static final class CLInvalidContextException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076402L;

        public CLInvalidContextException(String string) {
            super(-34, "CL_INVALID_CONTEXT", string);
        }
    }

    public static final class CLInvalidQueuePropertiesException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076401L;

        public CLInvalidQueuePropertiesException(String string) {
            super(-35, "CL_INVALID_QUEUE_PROPERTIES", string);
        }
    }

    public static final class CLInvalidCommandQueueException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076400L;

        public CLInvalidCommandQueueException(String string) {
            super(-36, "CL_INVALID_COMMAND_QUEUE", string);
        }
    }

    public static final class CLInvalidHostPtrException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076399L;

        public CLInvalidHostPtrException(String string) {
            super(-37, "CL_INVALID_HOST_PTR", string);
        }
    }

    public static final class CLInvalidMemObjectException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076398L;

        public CLInvalidMemObjectException(String string) {
            super(-38, "CL_INVALID_MEM_OBJECT", string);
        }
    }

    public static final class CLInvalidImageFormatDescriptorException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076397L;

        public CLInvalidImageFormatDescriptorException(String string) {
            super(-39, "CL_INVALID_IMAGE_FORMAT_DESCRIPTOR", string);
        }
    }

    public static final class CLInvalidImageSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076396L;

        public CLInvalidImageSizeException(String string) {
            super(-40, "CL_INVALID_IMAGE_SIZE", string);
        }
    }

    public static final class CLInvalidSamplerException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076395L;

        public CLInvalidSamplerException(String string) {
            super(-41, "CL_INVALID_SAMPLER", string);
        }
    }

    public static final class CLInvalidBinaryException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076394L;

        public CLInvalidBinaryException(String string) {
            super(-42, "CL_INVALID_BINARY", string);
        }
    }

    public static final class CLInvalidBuildOptionsException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076393L;

        public CLInvalidBuildOptionsException(String string) {
            super(-43, "CL_INVALID_BUILD_OPTIONS", string);
        }
    }

    public static final class CLInvalidProgramException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076392L;

        public CLInvalidProgramException(String string) {
            super(-44, "CL_INVALID_PROGRAM", string);
        }
    }

    public static final class CLInvalidProgramExecutableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076391L;

        public CLInvalidProgramExecutableException(String string) {
            super(-45, "CL_INVALID_PROGRAM_EXECUTABLE", string);
        }
    }

    public static final class CLInvalidKernelNameException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076390L;

        public CLInvalidKernelNameException(String string) {
            super(-46, "CL_INVALID_KERNEL_NAME", string);
        }
    }

    public static final class CLInvalidKernelDefinitionException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076389L;

        public CLInvalidKernelDefinitionException(String string) {
            super(-47, "CL_INVALID_KERNEL_DEFINITION", string);
        }
    }

    public static final class CLInvalidKernelException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076388L;

        public CLInvalidKernelException(String string) {
            super(-48, "CL_INVALID_KERNEL", string);
        }
    }

    public static final class CLInvalidArgIndexException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076387L;

        public CLInvalidArgIndexException(String string) {
            super(-49, "CL_INVALID_ARG_INDEX", string);
        }
    }

    public static final class CLInvalidArgValueException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076386L;

        public CLInvalidArgValueException(String string) {
            super(-50, "CL_INVALID_ARG_VALUE", string);
        }
    }

    public static final class CLInvalidArgSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076385L;

        public CLInvalidArgSizeException(String string) {
            super(-51, "CL_INVALID_ARG_SIZE", string);
        }
    }

    public static final class CLInvalidKernelArgsException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076384L;

        public CLInvalidKernelArgsException(String string) {
            super(-52, "CL_INVALID_KERNEL_ARGS", string);
        }
    }

    public static final class CLInvalidWorkDimensionException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076383L;

        public CLInvalidWorkDimensionException(String string) {
            super(-53, "CL_INVALID_WORK_DIMENSION", string);
        }
    }

    public static final class CLInvalidWorkGroupSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076382L;

        public CLInvalidWorkGroupSizeException(String string) {
            super(-54, "CL_INVALID_WORK_GROUP_SIZE", string);
        }
    }

    public static final class CLInvalidWorkItemSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076381L;

        public CLInvalidWorkItemSizeException(String string) {
            super(-55, "CL_INVALID_WORK_ITEM_SIZE", string);
        }
    }

    public static final class CLInvalidGlobalOffsetException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076380L;

        public CLInvalidGlobalOffsetException(String string) {
            super(-56, "CL_INVALID_GLOBAL_OFFSET", string);
        }
    }

    public static final class CLInvalidEventWaitListException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076379L;

        public CLInvalidEventWaitListException(String string) {
            super(-57, "CL_INVALID_EVENT_WAIT_LIST", string);
        }
    }

    public static final class CLInvalidEventException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076378L;

        public CLInvalidEventException(String string) {
            super(-58, "CL_INVALID_EVENT", string);
        }
    }

    public static final class CLInvalidOperationException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076377L;

        public CLInvalidOperationException(String string) {
            super(-59, "CL_INVALID_OPERATION", string);
        }
    }

    public static final class CLInvalidBufferSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076375L;

        public CLInvalidBufferSizeException(String string) {
            super(-61, "CL_INVALID_BUFFER_SIZE", string);
        }
    }

    public static final class CLInvalidMipLevelException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076374L;

        public CLInvalidMipLevelException(String string) {
            super(-62, "CL_INVALID_MIP_LEVEL", string);
        }
    }

    public static final class CLInvalidGlobalWorkSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076373L;

        public CLInvalidGlobalWorkSizeException(String string) {
            super(-63, "CL_INVALID_GLOBAL_WORK_SIZE", string);
        }
    }

    public static final class CLInvalidPropertyException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076372L;

        public CLInvalidPropertyException(String string) {
            super(-64, "CL_INVALID_PROPERTY", string);
        }
    }

    public static final class CLPlatformNotFoundKhrException
    extends CLException {
        private static final long serialVersionUID = 6573520735486075435L;

        public CLPlatformNotFoundKhrException(String string) {
            super(-1001, "CL_PLATFORM_NOT_FOUND_KHR", string);
        }
    }

    public static final class CLMisalignedSubBufferOffsetException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076423L;

        public CLMisalignedSubBufferOffsetException(String string) {
            super(-13, "CL_MISALIGNED_SUB_BUFFER_OFFSET", string);
        }
    }

    public static final class CLExecStatusErrorForEventsInWaitListException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076422L;

        public CLExecStatusErrorForEventsInWaitListException(String string) {
            super(-14, "CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST", string);
        }
    }

    public static final class CLInvalidGLObjectException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076376L;

        public CLInvalidGLObjectException(String string) {
            super(-60, "CL_INVALID_GL_OBJECT", string);
        }
    }

    public static final class CLInvalidGLSharegroupReferenceKhrException
    extends CLException {
        private static final long serialVersionUID = 6573520735486075436L;

        public CLInvalidGLSharegroupReferenceKhrException(String string) {
            super(-1000, "CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR", string);
        }
    }
}

