/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.AutoCloseable;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLResource;
import java.util.Iterator;

public final class CLEventList
implements CLResource,
AutoCloseable,
Iterable<CLEvent> {
    private final CLEvent[] events;
    final PointerBuffer IDs;
    final PointerBuffer IDsView;
    int size;

    public CLEventList(int n2) {
        this(null, n2);
    }

    public CLEventList(CLEvent ... cLEventArray) {
        this((CachedBufferFactory)null, cLEventArray);
    }

    public CLEventList(CachedBufferFactory cachedBufferFactory, int n2) {
        this.events = new CLEvent[n2];
        this.IDs = this.initIDBuffer(cachedBufferFactory, n2);
        this.IDsView = this.IDs.duplicate();
    }

    public CLEventList(CachedBufferFactory cachedBufferFactory, CLEvent ... cLEventArray) {
        this.events = cLEventArray;
        this.IDs = this.initIDBuffer(cachedBufferFactory, cLEventArray.length);
        this.IDsView = this.IDs.duplicate();
        for (CLEvent cLEvent : cLEventArray) {
            if (cLEvent == null) {
                throw new IllegalArgumentException("event list containes null element.");
            }
            this.IDs.put(cLEvent.ID);
        }
        this.IDs.rewind();
        this.size = cLEventArray.length;
    }

    private PointerBuffer initIDBuffer(CachedBufferFactory cachedBufferFactory, int n2) {
        if (cachedBufferFactory == null) {
            return PointerBuffer.allocateDirect(n2);
        }
        return PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(n2 * PointerBuffer.ELEMENT_SIZE));
    }

    void createEvent(CLContext cLContext) {
        if (this.events[this.size] != null) {
            this.events[this.size].release();
        }
        this.events[this.size] = new CLEvent(cLContext, this.IDs.get());
        ++this.size;
    }

    PointerBuffer getEventBuffer(int n2) {
        return (PointerBuffer)this.IDs.duplicate().position(n2);
    }

    public void waitForEvents() {
        if (this.size > 0) {
            this.events[0].getPlatform().getCLBinding().clWaitForEvents(this.size, this.IDsView);
        }
    }

    public void waitForEvents(int n2, int n3) {
        if (n2 + n3 < this.size || n3 <= 0) {
            throw new IndexOutOfBoundsException("args: [start: " + n2 + " range: " + n3 + "], eventcount: " + this.size);
        }
        PointerBuffer pointerBuffer = this.getEventBuffer(n2);
        this.getEvent(n2).getPlatform().getCLBinding().clWaitForEvents(n3, pointerBuffer);
    }

    public void waitForEvent(int n2) {
        PointerBuffer pointerBuffer = this.getEventBuffer(n2);
        this.getEvent(n2).getPlatform().getCLBinding().clWaitForEvents(1, pointerBuffer);
    }

    @Override
    public void release() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.events[i2].release();
            this.events[i2] = null;
        }
        this.size = 0;
        this.IDs.rewind();
    }

    @Override
    @Deprecated
    public final void close() {
        this.release();
    }

    public CLEvent getEvent(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("list contains " + this.size + " events, can not return event with index " + n2);
        }
        return this.events[n2];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.events.length;
    }

    @Override
    public boolean isReleased() {
        return this.size == 0;
    }

    @Override
    public Iterator<CLEvent> iterator() {
        return new EventIterator(this.events, this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName()).append('[');
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuilder.append(this.events[i2].toString());
            if (i2 + 1 == this.size) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(']').toString();
    }

    private static class EventIterator
    implements Iterator<CLEvent> {
        private final CLEvent[] events;
        private final int size;
        private int index;

        private EventIterator(CLEvent[] cLEventArray, int n2) {
            this.events = cLEventArray;
            this.size = n2;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public CLEvent next() {
            if (this.hasNext()) {
                return this.events[this.index++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported.");
        }
    }
}

