/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.util.Bitstream;
import com.jogamp.openal.ALException;
import com.jogamp.openal.util.WAVData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class WAVLoader {
    private static final int RIFF = 1380533830;
    private static final int RIFX = 1380533848;
    private static final int WAVE = 1463899717;
    private static final int FACT = 1717658484;
    private static final int FMT = 1718449184;
    private static final int DATA = 1684108385;

    public static WAVData loadFromFile(String string) throws ALException, IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        return WAVLoader.loadFromStreamImpl(fileInputStream);
    }

    public static WAVData loadFromStream(InputStream inputStream) throws ALException, IOException {
        return WAVLoader.loadFromStreamImpl(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WAVData loadFromStreamImpl(InputStream inputStream) throws ALException, IOException {
        Bitstream.ByteInputStream byteInputStream = new Bitstream.ByteInputStream(inputStream);
        bitstream.setThrowIOExceptionOnEOF(true);
        try (Bitstream<InputStream> bitstream = new Bitstream<InputStream>(byteInputStream, false);){
            int n2;
            int n3;
            boolean bl;
            long l2 = bitstream.readUInt32(true);
            if (1380533830L == l2) {
                bl = false;
            } else if (1380533848L == l2) {
                bl = true;
            } else {
                throw new ALException("Invalid RIF header: 0x" + Integer.toHexString((int)l2) + ", " + bitstream);
            }
            long l3 = bitstream.readUInt32(bl);
            int n4 = Bitstream.uint32LongToInt(l3);
            long l4 = bitstream.readUInt32(true);
            if (1463899717L != l4) {
                throw new ALException("Invalid WAV header: 0x" + Integer.toHexString((int)l4) + ", " + bitstream);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            int n5 = 0;
            int n6 = 0;
            long l5 = 0L;
            long l6 = 0L;
            int n7 = 0;
            block8: while (!bl3) {
                n3 = (int)bitstream.readUInt32(true);
                l6 = bitstream.readUInt32(bl);
                switch (n3) {
                    case 1718449184: {
                        bl2 = true;
                        n2 = bitstream.readUInt16(bl);
                        n5 = (short)bitstream.readUInt16(bl);
                        l5 = bitstream.readUInt32(bl);
                        long l7 = bitstream.readUInt32(bl);
                        short s = (short)bitstream.readUInt16(bl);
                        n6 = (short)bitstream.readUInt16(bl);
                        bitstream.skip(8L * (l6 - 16L));
                        continue block8;
                    }
                    case 1717658484: {
                        bitstream.skip(8L * l6);
                        continue block8;
                    }
                    case 1684108385: {
                        if (!bl2) {
                            throw new ALException("WAV fmt chunks must be before data chunks: " + bitstream);
                        }
                        bl3 = true;
                        n7 = Bitstream.uint32LongToInt(l6);
                        continue block8;
                    }
                }
                bitstream.skip(8L * l6);
            }
            n3 = n5;
            n2 = n6;
            float f2 = l5;
            WAVData wAVData = WAVData.loadFromStream(bitstream.getSubStream(), n7, n3, n2, Math.round(f2), bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN, false, n7);
            return wAVData;
        }
    }
}

